/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.atlas.service.impl;

import com.geoway.landteam.landcloud.service.customtask.atlas.service.Datasource;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.Hdfs;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.HdfsFactory;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.HdfsPool;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.HdfsPoolConfig;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="datasource_hdfs")
public class DatasourceHdfs
implements Datasource {
    GiLoger logger = GwLoger.getLoger(DatasourceHdfs.class);
    @Autowired
    HdfsFactory hdfsFactory;
    @Autowired
    HdfsPoolConfig hdfsPoolConfig;
    HdfsPool hdfsPool;

    @PostConstruct
    public void initPoll() {
        this.hdfsPool = new HdfsPool(this.hdfsFactory, this.hdfsPoolConfig);
    }

    @Override
    public boolean testConnection(String connectionString, String user, String password) {
        try {
            boolean isOk;
            Hdfs hdfs = (Hdfs)this.hdfsPool.borrowObject(connectionString, 20000L);
            boolean bl = isOk = hdfs.isConnected();
            return bl;
        }
        catch (Exception e) {
            this.logger.error("hdfs\u6570\u636e\u6e90\u9519\u8bef", new Object[]{e});
            throw new RuntimeException("hdfs\u6570\u636e\u6e90\u9519\u8bef" + connectionString, e);
        }
        finally {
            this.hdfsPool.clear(connectionString);
        }
    }

    @Override
    public boolean startConnectionPool(String connectionString, String user, String password) {
        String connString = connectionString;
        try {
            if (this.hdfsPool.borrowObject(connString) != null) {
                return true;
            }
            this.hdfsPool.addObject(connectionString);
            return ((Hdfs)this.hdfsPool.borrowObject(connString)).isConnected();
        }
        catch (Exception e) {
            this.logger.error("hdfs\u6570\u636e\u6e90\u9519\u8bef", new Object[]{e});
            throw new RuntimeException("hdfs\u6570\u636e\u6e90\u9519\u8bef" + connString, e);
        }
    }

    @Override
    @PreDestroy
    public void destroyConnectionPool() {
        this.hdfsPool.clear();
    }

    @Override
    public Hdfs getDaoObject(String connectionString, String user, String password) {
        try {
            return (Hdfs)this.hdfsPool.borrowObject(connectionString);
        }
        catch (Exception e) {
            throw new RuntimeException("hdfs\u6570\u636e\u6e90\u83b7\u53d6\u9519\u8bef");
        }
    }

    public void destroyConnectionPoolByKey(String key) {
        this.hdfsPool.clear(key);
    }

    public void returnDaoObject(String key, Hdfs fs) {
        try {
            this.hdfsPool.returnObject(key, fs);
        }
        catch (Exception e) {
            throw new RuntimeException("hdfs\u6570\u636e\u6e90\u83b7\u53d6\u9519\u8bef");
        }
    }
}

