/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.atlas.service.impl;

import com.geoway.landteam.landcloud.service.customtask.atlas.service.Datasource;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="datasource_postgresql")
public class DatasourcePostgresql
implements Datasource {
    GiLoger logger = GwLoger.getLoger(DatasourcePostgresql.class);
    private final String jdbcProtocol = "jdbc:postgresql://";
    private final String jdbcDriver = "org.postgresql.Driver";
    private ConcurrentHashMap<String, JdbcTemplate> dbConnections = new ConcurrentHashMap();

    @Override
    @PreDestroy
    public void destroyConnectionPool() {
        for (String ms : this.dbConnections.keySet()) {
            ((ComboPooledDataSource)this.dbConnections.get(ms).getDataSource()).close();
        }
        this.dbConnections.clear();
    }

    @Override
    public boolean testConnection(String connectionString, String user, String password) {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            conn = DriverManager.getConnection(this.jdbcProtocol + connectionString, user, password);
            String sql = "select 1";
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            rs.close();
            stmt.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("postgresql\u6570\u636e\u6e90\u9519\u8bef", new Object[]{e});
            throw new RuntimeException("postgresql\u6570\u636e\u6e90\u9519\u8bef", e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startConnectionPool(String connectionString, String user, String password) {
        String key = connectionString + ";" + user + ";" + password;
        if (this.dbConnections.containsKey(key)) {
            return true;
        }
        try {
            ConcurrentHashMap<String, JdbcTemplate> concurrentHashMap = this.dbConnections;
            synchronized (concurrentHashMap) {
                Class.forName("org.postgresql.Driver");
                ComboPooledDataSource dataSource = new ComboPooledDataSource();
                dataSource.setDriverClass("org.postgresql.Driver");
                dataSource.setJdbcUrl(this.jdbcProtocol + connectionString);
                dataSource.setUser(user);
                dataSource.setPassword(password);
                String sql = "select 1";
                dataSource.setPreferredTestQuery(sql);
                dataSource.setMaxPoolSize(50);
                dataSource.setMinPoolSize(10);
                dataSource.setMaxIdleTime(1800);
                JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
                jdbcTemplate.queryForRowSet(sql);
                this.dbConnections.put(key, jdbcTemplate);
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5173\u7cfb\u6570\u636e\u5e93\u6570\u636e\u6e90\u9519\u8bef", new Object[]{e});
            throw new RuntimeException("\u5173\u7cfb\u6570\u636e\u5e93\u65e0\u6cd5\u8fde\u63a5" + connectionString, e);
        }
    }

    public JdbcTemplate getDaoObject(String connectionString, String user, String password) {
        this.startConnectionPool(connectionString, user, password);
        String key = connectionString + ";" + user + ";" + password;
        return this.dbConnections.get(key);
    }
}

