/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.atlas.service.impl;

import com.alibaba.fastjson.JSON;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.FileInfo;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.Hdfs;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.LocalFSytemImpl;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.SmbFSystemImpl;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.SrcFileSystem;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsUtils.FSPathUtils;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsUtils.IOCopyUtils;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsUtils.MessageLog;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.stream.Collectors;
import jcifs.smb.SmbException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileSystem;
import org.springframework.stereotype.Service;

@Service
public class HdfsHandleImpl {
    private final GiLoger logger = GwLoger.getLoger(this.getClass());

    public String uploadshp(Hdfs fs, String fsname, String shpname, String srcp, String hdfsp, String isparentdir, String ismultishape) {
        block20: {
            SrcFileSystem srcFileSystem = HdfsHandleImpl.getFS(fsname);
            try {
                Throwable var9 = null;
                try {
                    List<String> filepaths;
                    if ("0".equals(isparentdir)) {
                        List<String> filepaths2;
                        if ("0".equals(ismultishape)) {
                            String fname = shpname;
                            String srcpath = srcp;
                            String despath = hdfsp + fs.separatorChar() + shpname;
                            try {
                                fs.rmdir(despath);
                                IOCopyUtils.upLoadShpfilesAtlas(this.logger, srcFileSystem, fname, srcpath, despath, fs);
                                break block20;
                            }
                            catch (Throwable var40) {
                                throw new RuntimeException(var40);
                            }
                        }
                        Object fname = null;
                        try {
                            filepaths2 = srcFileSystem.getSubFilpaths(srcp);
                        }
                        catch (Throwable var39) {
                            throw new RuntimeException(var39);
                        }
                        List shpfilepaths = filepaths2.stream().filter(n -> FSPathUtils.isEndWith(n.toString(), ".shp")).collect(Collectors.toList());
                        long count = shpfilepaths.size();
                        int currentindex = 1;
                        int pathindex = 0;
                        while ((long)pathindex < count) {
                            String finishInfo;
                            String subpath = (String)shpfilepaths.get(pathindex);
                            String filename = srcFileSystem.getFilename(subpath);
                            String subfilename = FSPathUtils.getSimpleFromFilename(filename);
                            String despath = hdfsp + fs.separatorChar() + subfilename;
                            String overviewInfo = "Total shp : " + count + " , Current " + currentindex;
                            MessageLog.info(this.logger, overviewInfo);
                            String checkInfo = "Check dir : " + despath;
                            MessageLog.info(this.logger, checkInfo);
                            try {
                                fs.rmdir(despath);
                                finishInfo = "Start upload shp : " + subfilename;
                                MessageLog.info(this.logger, finishInfo);
                                IOCopyUtils.upLoadShpfilesAtlas(this.logger, srcFileSystem, subfilename, srcp, despath, fs);
                            }
                            catch (Throwable var38) {
                                throw new RuntimeException(var38);
                            }
                            finishInfo = "Finsh upload shp : " + subfilename;
                            MessageLog.info(this.logger, finishInfo);
                            ++currentindex;
                            ++pathindex;
                        }
                        MessageLog.info(this.logger, "Finish upload all shape file !");
                        break block20;
                    }
                    try {
                        filepaths = srcFileSystem.getSubFilpaths(srcp);
                    }
                    catch (Throwable var37) {
                        throw new RuntimeException(var37);
                    }
                    List shpfilepaths = filepaths.stream().filter(subpathx -> {
                        try {
                            return srcFileSystem.isDirectory(subpathx.toString());
                        }
                        catch (Throwable var3) {
                            throw new RuntimeException(var3);
                        }
                    }).flatMap(dirpath -> {
                        try {
                            return srcFileSystem.getSubFilpaths(dirpath.toString()).stream();
                        }
                        catch (Throwable var3) {
                            throw new RuntimeException(var3);
                        }
                    }).filter(n -> FSPathUtils.isEndWith(n.toString(), ".shp")).collect(Collectors.toList());
                    long count = shpfilepaths.size();
                    int currentindex = 1;
                    int pathindex = 0;
                    while ((long)pathindex < count) {
                        String finishInfo;
                        String subpath = (String)shpfilepaths.get(pathindex);
                        String filename = srcFileSystem.getFilename(subpath);
                        String subfilename = FSPathUtils.getSimpleFromFilename(filename);
                        String despath = hdfsp + fs.separatorChar() + subfilename;
                        String overviewInfo = "Total shp : " + count + " , Current " + currentindex;
                        MessageLog.info(this.logger, overviewInfo);
                        String checkInfo = "Check dir : " + despath;
                        MessageLog.info(this.logger, checkInfo);
                        try {
                            fs.rmdir(despath);
                            finishInfo = "Start upload shp : " + subfilename;
                            MessageLog.info(this.logger, finishInfo);
                            IOCopyUtils.upLoadShpfilesAtlas(this.logger, srcFileSystem, subfilename, srcp, despath, fs);
                        }
                        catch (Throwable var36) {
                            throw new RuntimeException(var36);
                        }
                        finishInfo = "Finsh upload shp : " + subfilename;
                        MessageLog.info(this.logger, finishInfo);
                        ++currentindex;
                        ++pathindex;
                    }
                    MessageLog.info(this.logger, "Finish upload all shape file !");
                }
                catch (Throwable var41) {
                    var9 = var41;
                    throw var41;
                }
            }
            catch (Exception var43) {
                throw new RuntimeException(var43);
            }
        }
        return "Successful upload path " + srcp + " to hdfs path " + hdfsp + "!";
    }

    public String uploadfile(Hdfs fs, String fsname, String srcp, String hdfsp) {
        SrcFileSystem srcFileSystem = HdfsHandleImpl.getFS(fsname);
        MessageLog.info(this.logger, "Count the numbers of this path !");
        int[] countarray = new int[]{0};
        Throwable var7 = null;
        try {
            try {
                this.loopcountfile(srcFileSystem, srcp, countarray);
                int[] currentarray = new int[]{0};
                String despath = hdfsp + fs.separatorChar() + srcFileSystem.getFilename(srcp);
                this.loopupLoadfile(srcFileSystem, srcp, despath, countarray[0], currentarray, fs);
                MessageLog.info(this.logger, "Finish upload all file !");
            }
            catch (Throwable var18) {
                var7 = var18;
                throw var18;
            }
            finally {
                if (fs != null) {
                    // empty if block
                }
            }
        }
        catch (Throwable var20) {
            throw new RuntimeException(var20);
        }
        return "Successful upload file Successful upload path " + srcp + " to hdfs path " + hdfsp + "!";
    }

    public String showfile(String hdfspath, String isdetail, Hdfs fs) {
        List<FileInfo> fileInfos;
        try {
            Throwable var5 = null;
            try {
                fileInfos = fs.catChildfile(hdfspath, Boolean.parseBoolean(isdetail));
            }
            catch (Throwable var15) {
                var5 = var15;
                throw var15;
            }
            finally {
                if (fs != null) {
                    if (var5 != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable var14) {
                            var5.addSuppressed(var14);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        catch (Throwable var17) {
            throw new RuntimeException(var17);
        }
        return "Successful show file : " + hdfspath + JSON.toJSON(fileInfos).toString();
    }

    public String existfile(String hdfspath, Hdfs fs) {
        Boolean exist = false;
        try {
            Throwable var4 = null;
            try {
                exist = fs.existFile(hdfspath);
            }
            catch (Throwable var14) {
                var4 = var14;
                throw var14;
            }
            finally {
                if (fs != null) {
                    if (var4 != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable var13) {
                            var4.addSuppressed(var13);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        catch (Throwable var16) {
            throw new RuntimeException(var16);
        }
        return exist.toString() + "Exist file " + hdfspath + " : " + exist.toString();
    }

    public String rmfile(String hdfspath, Hdfs fs) {
        try {
            Throwable var3 = null;
            try {
                fs.rmdir(hdfspath);
            }
            catch (Throwable var13) {
                var3 = var13;
                throw var13;
            }
            finally {
                if (fs != null) {
                    if (var3 != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable var12) {
                            var3.addSuppressed(var12);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        catch (Throwable var15) {
            throw new RuntimeException(var15);
        }
        return "Successful remove file ! Successful remove file : " + hdfspath;
    }

    public String mksubdirByName(String hdfsp, int beginindex, int endindex, Hdfs fs) {
        try {
            Throwable var5 = null;
            try {
                fs.mksubdirByName(hdfsp, beginindex, endindex);
            }
            catch (Throwable var15) {
                var5 = var15;
                throw var15;
            }
            finally {
                if (fs != null) {
                    if (var5 != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable var14) {
                            var5.addSuppressed(var14);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        catch (Throwable var17) {
            throw new RuntimeException(var17);
        }
        return "Successful make sub dir by name ! Successful make sub dir by name : begin index is " + beginindex + ", end index is " + endindex;
    }

    public String renamesubBySplit(String hdfsp, int beginindex, int endindex, Hdfs fs) {
        try {
            Throwable var5 = null;
            try {
                fs.renamesubBySplit(hdfsp, beginindex, endindex);
            }
            catch (Throwable var15) {
                var5 = var15;
                throw var15;
            }
            finally {
                if (fs != null) {
                    if (var5 != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable var14) {
                            var5.addSuppressed(var14);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        catch (Throwable var17) {
            throw new RuntimeException(var17);
        }
        return "Successful rename sub dir by name !Successful rename sub dir by name : begin index is " + beginindex + ", end index is " + endindex;
    }

    public String downfile(String fsname, String hdfsp, String descp, Hdfs fs) {
        SrcFileSystem srcFileSystem = HdfsHandleImpl.getFS(fsname);
        try {
            Throwable var6 = null;
            try {
                if (!fs.isDirectory(hdfsp)) {
                    this.getFile(srcFileSystem, hdfsp, descp, fs);
                } else {
                    this.traversalFile(hdfsp, descp, srcFileSystem, fs);
                }
            }
            catch (Throwable var16) {
                var6 = var16;
                throw var16;
            }
            finally {
                if (fs != null) {
                    if (var6 != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable var15) {
                            var6.addSuppressed(var15);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        catch (Throwable var18) {
            throw new RuntimeException(var18);
        }
        return "Successful download file ! Successful download file from hdfs : " + hdfsp + ", save path : " + descp;
    }

    private void traversalFile(String hdfsp, String descp, SrcFileSystem srcFileSystem, Hdfs fs) throws IOException {
        List<String> hdfsps = fs.getSubFilpaths(hdfsp);
        boolean ischeckdir = false;
        for (String hdfspath : hdfsps) {
            String descpath = descp + srcFileSystem.separatorChar() + fs.getFileName(hdfsp);
            if (fs.isDirectory(hdfspath)) {
                this.traversalFile(hdfspath, descpath, srcFileSystem, fs);
                continue;
            }
            try {
                if (!ischeckdir) {
                    String targetInfo = "Target directory " + descp + " exist : " + !srcFileSystem.mkdir(descp);
                    MessageLog.info(this.logger, targetInfo);
                    ischeckdir = true;
                }
                this.getFile(srcFileSystem, hdfspath, descpath, fs);
            }
            catch (Throwable var11) {
                throw new RuntimeException(var11);
            }
        }
    }

    private void getFile(SrcFileSystem srcFileSystem, String hdfsp, String descp, Hdfs fs) throws IOException {
        String descpath = descp + srcFileSystem.separatorChar() + fs.getFileName(hdfsp);
        srcFileSystem.mkdir(descp);
        Pair<FileSystem, InputStream> isSet = fs.getInputStream(hdfsp);
        OutputStream os = srcFileSystem.getOutputStream(descpath, new String[0]);
        IOCopyUtils.copy(this.logger, hdfsp, descpath, (InputStream)isSet.getValue(), os);
    }

    private void loopupLoadfile(SrcFileSystem srcFileSystem, String srcp, String hdfspath, int count, int[] currentarray, Hdfs fs) throws IOException {
        if (srcFileSystem.isDirectory(srcp)) {
            List<String> filepaths = srcFileSystem.getSubFilpaths(srcp);
            for (String subpath : filepaths) {
                String despath = hdfspath + fs.separatorChar() + srcFileSystem.getFilename(subpath);
                this.loopupLoadfile(srcFileSystem, subpath, despath, count, currentarray, fs);
            }
        } else {
            int n = currentarray[0];
            currentarray[0] = n + 1;
            int var10002 = n;
            String overviewInfo = "Total file : " + count + " , Current " + currentarray[0];
            MessageLog.info(this.logger, overviewInfo);
            String checkInfo = "Check dir : " + hdfspath;
            MessageLog.info(this.logger, checkInfo);
            fs.rmdir(hdfspath);
            String subpath = "Start upload file : " + srcp;
            MessageLog.info(this.logger, subpath);
            InputStream is = srcFileSystem.getInputStream(srcp, new String[0]);
            OutputStream os = fs.getOutputStream(hdfspath);
            String finishInfo = "Finsh upload file : " + srcp;
            MessageLog.info(this.logger, finishInfo);
        }
    }

    private void loopcountfile(SrcFileSystem srcFileSystem, String srcp, int[] countArray) throws MalformedURLException, SmbException {
        if (srcFileSystem.isDirectory(srcp)) {
            for (String subpath : srcFileSystem.getSubFilpaths(srcp)) {
                this.loopcountfile(srcFileSystem, subpath, countArray);
            }
        } else {
            int n = countArray[0];
            countArray[0] = n + 1;
            int n2 = n;
        }
    }

    public static SrcFileSystem getFS(String fsname) {
        switch (fsname.toUpperCase()) {
            case "SMB": {
                return new SmbFSystemImpl();
            }
            case "LOCAL": {
                return new LocalFSytemImpl();
            }
        }
        throw new RuntimeException("Can't support this file system " + fsname + ".");
    }
}

