/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.pub.DataDownloadDailyTaskService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDataDownloadTakeHandService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.geoway.landteam.landcloud.service.customtask.thread.MDownloadAttachThread;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MDataDownloadConsumerServiceImpl
implements IConsumerStrategyService {
    private final GiLoger logger = GwLoger.getLoger(MDataDownloadConsumerServiceImpl.class);
    private final String DATA_DOWNLOAD_CODE = "DataDownloadCode";
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    DataDownloadDailyTaskService dataDownloadDailyTaskService;
    @Autowired
    MDataDownloadTakeHandService MDataDownloadTakeHandService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    MTaskRecordService taskRecordService;
    ExecutorService threadPool = Executors.newFixedThreadPool(10);

    @Override
    public String getCode() {
        return "DataDownloadCode";
    }

    @Override
    public void execute(MapMessage mapMessage) {
        try {
            DownloadParameter downlaodParamter;
            Object bean;
            String taskId = mapMessage.getString("taskId");
            String parameter = mapMessage.getString("parameter");
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)parameter));
            if (jsonObject != null && (bean = JSONObject.toJavaObject((JSON)jsonObject, DownloadParameter.class)) != null && (downlaodParamter = (DownloadParameter)bean) != null) {
                TaskRecord taskRecord;
                DataDownloadRecord record = null;
                Object value = this.redisTemplate.opsForValue().get((Object)downlaodParamter.getRecordId());
                if (value != null) {
                    record = (DataDownloadRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)value.toString()), DataDownloadRecord.class);
                }
                if ((taskRecord = this.taskRecordService.findOne(downlaodParamter.getRecordId())) != null) {
                    taskRecord.setState(Integer.valueOf(1));
                    this.taskRecordService.save(taskRecord);
                }
                MDownloadAttachThread thread = new MDownloadAttachThread(taskId, downlaodParamter, record, this.MDataDownloadTakeHandService, this.dataDownloadDailyTaskService, this.taskRecordService);
                Future<?> future = this.threadPool.submit(thread);
                String failReason = null;
                try {
                    Object obj = future.get(60L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    failReason = "\u4e3b\u7ebf\u7a0b\u5728\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u4e2d\u65ad\uff01";
                    taskRecord.setState(Integer.valueOf(4));
                    taskRecord.setRemark(failReason);
                    this.taskRecordService.save(taskRecord);
                }
                catch (ExecutionException e) {
                    failReason = "\u4e3b\u7ebf\u7a0b\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\uff0c\u4f46\u4efb\u52a1\u672c\u8eab\u629b\u51fa\u5f02\u5e38\uff01";
                    taskRecord.setState(Integer.valueOf(4));
                    taskRecord.setRemark(failReason);
                    this.taskRecordService.save(taskRecord);
                }
                catch (TimeoutException e) {
                    failReason = "\u4e3b\u7ebf\u7a0b\u7b49\u5f85\u8ba1\u7b97\u7ed3\u679c\u8d85\u65f6\uff0c\u56e0\u6b64\u4e2d\u65ad\u4efb\u52a1\u7ebf\u7a0b\uff01";
                    taskRecord.setState(Integer.valueOf(4));
                    taskRecord.setRemark(failReason);
                    this.taskRecordService.save(taskRecord);
                }
            }
        }
        catch (JMSException e) {
            this.logger.error(e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), new Object[0]);
        }
    }
}

