/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.mq.DataDownloadProducerService;
import com.geoway.landteam.customtask.servface.mq.DownloadGeometryProducerService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.gw.base.Gw;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MDataDownloadTakeHandService {
    private final GiLoger logger = GwLoger.getLoger(MDataDownloadTakeHandService.class);
    private static final String TAKE_HAND_TASK_ID = "ssp";
    private static final String TAKE_HAND = "\u968f\u624b\u62cd";
    protected String uploadDir;
    private String taskId;
    private String taskCode;
    private String taskName;
    private String prjNum;
    private DataDownloadRecord downloadRecord;
    @Autowired
    AppBasicService appBasicService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    private int pictureCount = 0;
    private int videoCount = 0;
    private Double zipFileSize = 0.0;
    private int voiceCount = 0;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    private DefaultOssOperatorService stsService;
    private int osgbCount = 0;
    private String resultUrl = "";
    @Autowired
    DataDownloadProducerService dataDownloadProducerService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    AppBasicRepository appBasicRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    DownloadGeometryProducerService downloadGeometryProducerService;
    @Autowired
    TaskRecordService taskRecordService;

    public DataDownloadRecord downloadTakeHandData(String tbIds, String tbNames, Long userId) throws Exception {
        GutilAssert.state((userId > 0L ? 1 : 0) != 0, (String)"userId can not be negative number.");
        DataDownloadRecord record = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(TAKE_HAND_TASK_ID, tbIds, userId.longValue());
        record.setBatchOpr(false);
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)JSONObject.toJSONString((Object)record).toString(), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank((CharSequence)this.taskId) ? this.taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank((CharSequence)record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames(StringUtils.isNotBlank((CharSequence)tbNames) ? tbNames : "");
        attachParameter.setOrgIdOrGroupId("");
        attachParameter.setUserId(userId);
        attachParameter.setBizType(TAKE_HAND_TASK_ID);
        attachParameter.setRecordId(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{record.getId()}) ? record.getId() : "");
        attachParameter.setDownloadType(Integer.valueOf(3));
        attachParameter.setDataType("attach");
        String paramter = JSONObject.toJSONString((Object)attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(paramter);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    public DataDownloadRecord downloadTakeHandDataBatch(String taskId, String tbIds, String tbNames, Long userId, String orgIdOrGroupId) throws Exception {
        GutilAssert.state((userId > 0L ? 1 : 0) != 0, (String)"userId can not be negative number.");
        DataDownloadRecord record = this.buildDataDownloadRecord(tbIds, userId, orgIdOrGroupId);
        record = this.dataDownloadRecordService.save(record);
        record.setBatchOpr(true);
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)JSONObject.toJSONString((Object)record).toString(), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank((CharSequence)taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank((CharSequence)record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames(StringUtils.isNotBlank((CharSequence)tbNames) ? tbNames : "");
        attachParameter.setOrgIdOrGroupId(StringUtils.isNotBlank((CharSequence)orgIdOrGroupId) ? orgIdOrGroupId : "");
        attachParameter.setUserId(userId);
        attachParameter.setBizType(TAKE_HAND_TASK_ID);
        attachParameter.setRecordId(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{record.getId()}) ? record.getId() : "");
        attachParameter.setDownloadType(Integer.valueOf(3));
        attachParameter.setDataType("attach");
        String paramter = JSONObject.toJSONString((Object)attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(paramter);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    private DataDownloadRecord buildDataDownloadRecord(String tbIds, Long userId, String orgIdOrGroupId) {
        DataDownloadRecord dataDownloadRecord = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(TAKE_HAND_TASK_ID, tbIds, userId.longValue());
        if (StringUtils.isNotBlank((CharSequence)tbIds)) {
            List<String> ids = Arrays.asList(tbIds.split(","));
            int count = this.appBasicRepository.queryCountByIds(ids);
            dataDownloadRecord.setTbCount(Integer.valueOf(count));
        } else {
            Integer tbCount = 0;
            List idList = null;
            if (StringUtils.isBlank((CharSequence)orgIdOrGroupId)) {
                tbCount = this.appBasicRepository.queryCountByUserId(userId.toString());
                idList = this.appBasicRepository.queryTbidsByUserId(userId.toString());
            } else {
                tbCount = this.appBasicRepository.queryCountByUserId(orgIdOrGroupId);
                idList = this.appBasicRepository.queryTbidsByUserId(orgIdOrGroupId);
            }
            if (idList != null && idList.size() > 0) {
                for (String s : idList) {
                    tbIds = tbIds + "," + s;
                }
                if (tbIds.startsWith(",")) {
                    tbIds = tbIds.substring(1);
                }
            }
            dataDownloadRecord.setTbIds(tbIds);
            dataDownloadRecord.setTbCount(tbCount);
        }
        dataDownloadRecord.setName(TAKE_HAND);
        return dataDownloadRecord;
    }

    public void downloadTakeHandAttach(String ids, String places, Long userId, DataDownloadRecord downloadRecord) throws Exception {
        GutilAssert.notNull((Object)downloadRecord, (String)"downloadRecord can not be null ");
        if (this.dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
            return;
        }
        try {
            File[] subFiles;
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            List<String> placeList = Arrays.asList(places.split(","));
            String tempFolderPath = this.uploadDir + File.separator + UUID.randomUUID().toString();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String safeFileName = placeList.size() > 1 ? placeList.get(0).split("_")[0] + "\u7b49" : placeList.get(0).split("_")[0];
            safeFileName = safeFileName + "(" + UUID.randomUUID().toString() + ")";
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            if (this.dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
                return;
            }
            this.initParameter(TAKE_HAND_TASK_ID, TAKE_HAND, TAKE_HAND, "", downloadRecord);
            this.exportData(tempFolderPath, fileNameNoSuffix, ids, userId);
            if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u5f00\u59cb\u538b\u7f29\u6210zip\u6587\u4ef6 ", new Object[0]);
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setCompressionMethod(8);
            zipParameters.setCompressionLevel(5);
            ZipFile zipFile = new ZipFile(fileNameNoSuffix + ".zip");
            File folder = new File(tempFolderPath);
            if (folder.exists() && folder.isDirectory() && (subFiles = folder.listFiles()).length > 0) {
                for (File subFile : subFiles) {
                    if (subFile.isDirectory()) {
                        zipFile.addFolder(subFile, zipParameters);
                        continue;
                    }
                    zipFile.addFile(subFile, zipParameters);
                }
            }
            this.zipFileSize = (double)new File(fileNameNoSuffix + ".zip").length() / 1024.0;
            this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u5f00\u59cb\u4e0a\u4f20\u5230obs " + safeFileName, new Object[0]);
            this.uploadFileToCloudDisk(userId, safeFileName);
            if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            this.updateRecordToDataBase(downloadRecord);
            this.refreshRedisRecord();
            FileUtils.deleteQuietly((File)new File(tempFolderPath));
            FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
        }
        catch (Exception e) {
            this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38", new Object[0]);
            this.logger.error((Throwable)e);
            downloadRecord.setState(DataDownloadStateEnum.FAILED);
            downloadRecord.setErrorMsg(e.getMessage());
            if (downloadRecord.isBatchOpr()) {
                this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff0c\u66f4\u65b0\u5e93\u8868\u8bb0\u5f55", new Object[0]);
                this.dataDownloadRecordService.update(downloadRecord);
            }
            this.refreshRedisRecord();
            throw e;
        }
    }

    public void initParameter(String taskId, String taskCode, String taskName, String prjNum, DataDownloadRecord downloadRecord) {
        GutilAssert.notNull((Object)taskId, (String)"taskId can not be null");
        GutilAssert.notNull((Object)taskCode, (String)"taskCode can not be null");
        GutilAssert.notNull((Object)taskName, (String)"taskName can not be null");
        GutilAssert.notNull((Object)downloadRecord, (String)"downloadRecord can not be null");
        this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u521d\u59cb\u5316\u4e0b\u8f7d\u53c2\u6570 taskId:" + taskId + "  taskCode:" + taskCode + "   taskName:" + taskName + "   prjNmu:" + prjNum, new Object[0]);
        this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u521d\u59cb\u5316\u4e0b\u8f7d\u53c2\u6570 downloadRecord:" + downloadRecord.toString(), new Object[0]);
        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;
        this.downloadRecord = downloadRecord;
        this.pictureCount = 0;
        this.videoCount = 0;
        this.voiceCount = 0;
        this.osgbCount = 0;
        this.zipFileSize = 0.0;
        this.resultUrl = "";
    }

    public void exportData(String resultDbFileDir, String fileNameNoSuffix, String ids, Long userId) throws Exception {
        if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return;
        }
        this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u5f00\u59cb\u5bfc\u51fa\u6570\u636e ", new Object[0]);
        SqlliteConnTool connTool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String destFileName = this.copyDataBaseFile(resultDbFileDir);
            connTool = new SqlliteConnTool(destFileName);
            conn = connTool.getConnection();
            conn.setAutoCommit(false);
            List<String> idList = Arrays.asList(ids.split(","));
            this.insertAppBasicData(conn, ps, idList, userId);
            this.insertMediaData(conn, ps, idList, userId, resultDbFileDir);
            this.close(connTool, conn, ps);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.close(connTool, conn, ps);
                throw throwable;
            }
        }
    }

    private String copyDataBaseFile(String destDbFileDir) throws IOException {
        String destFileName = "";
        String srcFileName = "";
        FileUtil.creatDirectoryIfNotExist((String)destDbFileDir);
        ClassPathResource meta = new ClassPathResource("/static/meta.db");
        InputStream simheiinputStream = meta.getInputStream();
        File metaFile = File.createTempFile("template_meta_copy", ".db");
        FileUtils.copyInputStreamToFile((InputStream)simheiinputStream, (File)metaFile);
        destFileName = destDbFileDir + File.separator + "meta.db";
        FileUtils.copyFile((File)metaFile, (File)new File(destFileName));
        return destFileName;
    }

    private void insertAppBasicData(Connection connn, PreparedStatement pre, List<String> idList, Long userId) throws Exception {
        if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return;
        }
        String sql = "insert into TaskInfo(taskId ,taskCode,taskName,prjNum,tbId,tbLocation,lon,lat,extent,regionCode,requestId,createtime,userName,type,desc) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        pre = connn.prepareStatement(sql);
        String tbId = "";
        String tbLocation = "";
        Double lon = 0.0;
        Double lat = 0.0;
        String extent = "";
        String regionCode = "";
        String requestId = "";
        String userName = "";
        String createtime = "";
        String taskName = "";
        for (String id : idList) {
            this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u5bfc\u51fa\u6570\u636e---\u63d2\u5165\u56fe\u6591\u6570\u636e \u56fe\u6591\u4e2a\u6570\uff1a" + idList.size(), new Object[0]);
            if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            AppBasic appbasic = this.appBasicService.getDetailById(id, userId.toString());
            this.taskId = id;
            tbId = id;
            String string = tbLocation = StringUtils.isNotBlank((CharSequence)appbasic.getName()) ? appbasic.getName() : null;
            taskName = StringUtils.isNotBlank((CharSequence)appbasic.getHeading()) ? appbasic.getHeading() : (StringUtils.isNotBlank((CharSequence)appbasic.getName()) ? appbasic.getName() : "");
            lon = appbasic.getLon();
            lat = appbasic.getLat();
            extent = appbasic.getShape();
            regionCode = appbasic.getCounty();
            requestId = appbasic.getRequestId();
            createtime = appbasic.getCreatetime();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Timestamp ts = new Timestamp(Long.valueOf(createtime));
                createtime = format.format(ts);
            }
            catch (Exception e) {
                e.printStackTrace();
                createtime = appbasic.getCreatetime();
            }
            userName = this.userNameService.getUserRealNameByUserName(appbasic.getUsername());
            pre.setString(1, this.taskId);
            pre.setString(2, this.taskCode);
            pre.setString(3, taskName);
            pre.setString(4, this.prjNum);
            pre.setString(5, tbId);
            pre.setString(6, tbLocation);
            pre.setDouble(7, lon != null ? lon : 0.0);
            pre.setDouble(8, lat != null ? lat : 0.0);
            pre.setString(9, extent);
            pre.setString(10, StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{regionCode}) ? regionCode : "");
            pre.setString(11, requestId);
            pre.setString(12, createtime);
            pre.setString(13, userName);
            pre.setString(14, StringUtils.isNotBlank((CharSequence)appbasic.getType()) ? appbasic.getType() : "");
            pre.setString(15, StringUtils.isNotBlank((CharSequence)appbasic.getDesc()) ? appbasic.getDesc() : "");
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connn.commit();
    }

    private void insertMediaData(Connection conn, PreparedStatement pre, List<String> idList, Long userId, String tempSavePath) throws Exception {
        if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return;
        }
        String sql = "insert into ResultInfo(attachId ,tbId,mediaSource,mediaFormat,mediaType,viewURL,mediaMeta,jym,status,otherMetaData,time,mediaTimeLength,mediaSize,filename) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        pre = conn.prepareStatement(sql);
        if (idList != null && idList.size() > 0) {
            this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u5bfc\u51fa\u6570\u636e---\u5bfc\u51fa\u9644\u4ef6\u6570\u636e \u56fe\u6591\u603b\u4e2a\u6570\uff1a" + idList.size(), new Object[0]);
            int index = 0;
            for (String id : idList) {
                ++index;
                if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u6b63\u5728\u67e5\u8be2\u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u9644\u4ef6\u6570\u636e \u56fe\u6591id\uff1a" + id, new Object[0]);
                AppBasic appbasic = this.appBasicService.getDetailById(id, userId.toString());
                List medias = appbasic.getList();
                if (medias != null && medias.size() > 0) {
                    int mediaIndex = 0;
                    for (AppMedia media : medias) {
                        Double mediaSize;
                        ++mediaIndex;
                        if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                            return;
                        }
                        this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u6b63\u5728\u5bfc\u51fa\u7b2c" + mediaIndex + "\u4e2a\u9644\u4ef6\u6570\u636e,\u5171" + medias.size() + "\u4e2a\u9644\u4ef6 appMedia id\uff1a" + media.getId(), new Object[0]);
                        String attachId = media.getId();
                        String tbId = media.getGalleryid();
                        Integer mediaSource = 0;
                        String azimuth = media.getAzimuth();
                        String pitch = media.getPitch();
                        String shape = media.getShape();
                        Integer type = media.getType();
                        String videorecord = media.getVideorecord();
                        Integer mediatimelength = media.getMediatimelength();
                        String time = media.getTime();
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            Timestamp ts = new Timestamp(Long.valueOf(time));
                            time = format.format(ts);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            time = media.getTime();
                        }
                        Integer mediaTimeLength = media.getMediatimelength();
                        if (mediaTimeLength == null) {
                            mediaTimeLength = 0;
                        }
                        if ((mediaSize = media.getMediasize()) == null) {
                            mediaSize = 0.0;
                        }
                        String filename = media.getFileId();
                        String mediaFormat = "";
                        if (media.getType() != null) {
                            if (media.getType() == 1) {
                                ++this.pictureCount;
                                mediaFormat = "jpg";
                            } else if (media.getType() == 2) {
                                ++this.videoCount;
                                mediaFormat = "mp4";
                            } else if (media.getType() == 3) {
                                ++this.voiceCount;
                                mediaFormat = "mp3";
                            } else if (media.getType() == 4) {
                                ++this.osgbCount;
                                mediaFormat = "osgb";
                            }
                        }
                        String mediaType = "J";
                        String viewURL = "";
                        String mediaMeta = "";
                        if (media.getType() != null) {
                            if (media.getType() == 1) {
                                mediaMeta = ((TaskTransMediaService)Gw.beans.getBean(TaskTransMediaService.class)).get7FeaturesFromAppMedia(media).toJSONString();
                            } else if (media.getType() == 2) {
                                mediaMeta = media.getVideorecord();
                            } else if (media.getType() != 3 && media.getType() == 4) {
                                mediaMeta = ((TaskTransMediaService)Gw.beans.getBean(TaskTransMediaService.class)).get7FeaturesFromAppMedia(media).toJSONString();
                            }
                        }
                        String jym = "";
                        Integer status = -1;
                        if (media.getTypetype() != null) {
                            if (media.getTypetype() == 0) {
                                status = -1;
                            } else if (media.getTypetype() == 101) {
                                status = 0;
                            } else if (media.getTypetype() == 102) {
                                status = 1;
                            }
                        }
                        String mediaName = media.getId();
                        if (media.getType() != null) {
                            if (media.getType() == 1) {
                                mediaName = mediaName + ".jpg";
                                mediaType = "J";
                            } else if (media.getType() == 2) {
                                mediaName = mediaName + ".mp4";
                                mediaType = "V";
                            } else if (media.getType() == 3) {
                                mediaName = mediaName + ".mp3";
                                mediaType = "M";
                            } else if (media.getType() == 4) {
                                mediaName = mediaName + ".osgb";
                                mediaType = "O";
                            }
                        }
                        String otherMetaData = "";
                        pre.setString(1, attachId);
                        pre.setString(2, tbId);
                        pre.setInt(3, mediaSource);
                        pre.setString(4, mediaFormat);
                        pre.setString(5, mediaType);
                        pre.setString(6, viewURL);
                        pre.setString(7, mediaMeta);
                        pre.setString(8, jym);
                        pre.setInt(9, status);
                        pre.setString(10, otherMetaData);
                        pre.setString(11, time);
                        pre.setDouble(12, mediaTimeLength.intValue());
                        pre.setDouble(13, mediaSize);
                        pre.setString(14, mediaName);
                        pre.addBatch();
                        String mediaPath = tempSavePath + File.separator + appbasic.getHeading() + "(" + appbasic.getId() + ")";
                        String url = StringUtils.isNotBlank((CharSequence)media.getDownloadUrl()) ? media.getDownloadUrl() : media.getServerpath();
                        try {
                            if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                            if (url.startsWith("https://pan.jfunbox.com")) {
                                FileUtils.copyURLToFile((URL)new URL(url), (File)new File(mediaPath, mediaName));
                                continue;
                            }
                            url = this.temporarySignedUrlService.getTemporarySignedUrl(this.defaultOssOperatorService.getServerId().toString(), url, null);
                            FileUtils.copyURLToFile((URL)new URL(url), (File)new File(mediaPath, mediaName));
                        }
                        catch (IOException e) {
                            this.logger.error((Throwable)e);
                            this.downloadRecord.setErrorMsg("\u4e0b\u8f7d\u6587\u4ef6\u65f6\u51fa\u73b0\u9519\u8befI/O\u9519\u8bef");
                        }
                    }
                    continue;
                }
                this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u67e5\u8be2\u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u9644\u4ef6\u6570\u636e \u56fe\u6591id\uff1a" + id + "    \u9644\u4ef6\u603b\u4e2a\u6570\uff1a0", new Object[0]);
            }
        }
        pre.executeBatch();
        pre.clearBatch();
        conn.commit();
    }

    private void close(SqlliteConnTool connPool, Connection conn, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (connPool != null) {
            try {
                connPool.Dispose();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void uploadFileToCloudDisk(Long userId, String safeFileName) {
        String sendObjName = "ssp/download/" + userId + "/" + safeFileName + ".zip";
        this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        String zipFile = this.uploadDir + File.separator + safeFileName + ".zip";
        this.resultUrl = this.stsService.sendObject2Oss(sendObjName, zipFile);
    }

    private void updateRecordToDataBase(DataDownloadRecord downloadRecord) {
        downloadRecord.setUrl(this.resultUrl);
        downloadRecord.setState(DataDownloadStateEnum.FINISTHE);
        downloadRecord.setEndTime(new Date());
        downloadRecord.setPictureCount(Integer.valueOf(this.pictureCount));
        downloadRecord.setVideoCount(Integer.valueOf(this.videoCount));
        downloadRecord.setVoiceCount(Integer.valueOf(this.voiceCount));
        downloadRecord.set_3dModelCount(Integer.valueOf(this.osgbCount));
        downloadRecord.setAttachSize(this.zipFileSize);
        if (downloadRecord.isBatchOpr()) {
            this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u66f4\u65b0\u4e0b\u8f7d\u8bb0\u5f55\u5e93\u8868 " + downloadRecord.toString(), new Object[0]);
            this.dataDownloadRecordService.update(downloadRecord);
        }
    }

    private void refreshRedisRecord() {
        if (this.downloadRecord != null && StringUtils.isNotBlank((CharSequence)this.downloadRecord.getId())) {
            this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u5237\u65b0\u4e0b\u8f7d\u8bb0\u5f55redis " + this.downloadRecord.getId(), new Object[0]);
            if (this.redisTemplate.hasKey((Object)this.downloadRecord.getId()).booleanValue()) {
                this.redisTemplate.delete((Object)this.downloadRecord.getId());
            }
            this.redisTemplate.opsForValue().set((Object)this.downloadRecord.getId(), (Object)this.downloadRecord, 2L, TimeUnit.DAYS);
        }
    }

    private DataDownloadRecord buildDataDownloadRecordForGeometry(String tbIds, Long userId, String orgIdOrGroupId) {
        DataDownloadRecord dataDownloadRecord = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(TAKE_HAND_TASK_ID, tbIds, userId.longValue());
        if (StringUtils.isNotBlank((CharSequence)tbIds)) {
            List<String> ids = Arrays.asList(tbIds.split(","));
            int count = this.appBasicRepository.queryCountByIds(ids);
            dataDownloadRecord.setTbIds(tbIds);
            dataDownloadRecord.setTbCount(Integer.valueOf(count));
        } else {
            Integer tbCount = 0;
            List idList = null;
            if (StringUtils.isBlank((CharSequence)orgIdOrGroupId)) {
                tbCount = this.appBasicRepository.queryCountByUserId(userId.toString());
                idList = this.appBasicRepository.queryTbidsByUserId(userId.toString());
            } else {
                tbCount = this.appBasicRepository.queryCountByUserId(orgIdOrGroupId);
                idList = this.appBasicRepository.queryTbidsByUserId(orgIdOrGroupId);
            }
            if (idList != null && idList.size() > 0) {
                for (String s : idList) {
                    tbIds = tbIds + "," + s;
                }
                if (tbIds.startsWith(",")) {
                    tbIds = tbIds.substring(1);
                }
            }
            dataDownloadRecord.setTbIds(tbIds);
            dataDownloadRecord.setTbCount(tbCount);
        }
        dataDownloadRecord.setName(TAKE_HAND);
        return dataDownloadRecord;
    }

    public DataDownloadRecord downloadGeometry(String taskId, String tbIds, Long userId, String dataType, boolean isBatch, String orgIdOrGroupId) {
        this.checkParameters(taskId, userId, dataType);
        DataDownloadRecord record = this.buildDataDownloadRecordForGeometry(tbIds, userId, orgIdOrGroupId);
        this.dataDownloadRecordService.save(record);
        record.setBatchOpr(isBatch);
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)JSONObject.toJSONString((Object)record).toString(), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank((CharSequence)taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank((CharSequence)record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setOrgIdOrGroupId(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgIdOrGroupId}) ? orgIdOrGroupId : "");
        attachParameter.setUserId(userId);
        attachParameter.setBizType(TAKE_HAND_TASK_ID);
        attachParameter.setRecordId(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{record.getId()}) ? record.getId() : "");
        attachParameter.setDownloadType(Integer.valueOf(0));
        attachParameter.setDataType(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dataType}) ? dataType : "");
        String parameterString = JSONObject.toJSONString((Object)attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    public DataDownloadRecord BatchDownloadExcelByWpzf(TaskQueryParameter parameter, boolean isBatch) {
        this.checkParameters(parameter.getTaskId(), parameter.getUserId(), parameter.getGeoType());
        DataDownloadRecord record = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(parameter.getTaskId(), parameter.getTbIds(), parameter.getUserId().longValue());
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(parameter.getTaskId());
        record.setName(tskTaskBiz.getName() + "(\u9879\u76ee\u6e05\u5355)");
        this.dataDownloadRecordService.save(record);
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)JSONObject.toJSONString((Object)record).toString(), 2L, TimeUnit.DAYS);
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"wpzf");
        params.put("userId", (Object)parameter.getUserId());
        params.put("taskQueryParameter", (Object)parameter);
        params.put("taskId", (Object)parameter.getTaskId());
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(JSONObject.toJSONString((Object)params));
        taskRecord.setTasktype(JobConstants.JOB_TYPE_WPZF_XMQD_EXCEL);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setUserid(parameter.getUserId());
        this.taskRecordService.save(taskRecord);
        return record;
    }

    private void checkParameters(String taskId, Long userId, String dataType) {
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)taskId), (String)"taskId must not be null or empty.");
        GutilAssert.state((userId > -1L ? 1 : 0) != 0, (String)"userId can not be negative number.");
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)dataType), (String)"dataType must not be null or empty.");
    }
}

