/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryDailyTaskBaseService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MDownloadExcelDailyTaskServiceImpl
extends MDownloadGeometryDailyTaskBaseService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadExcelDailyTaskServiceImpl.class);
    private Map<String, String> constHeaderMap;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception {
        if (sourceData != null) {
            this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a" + sourceData.size(), new Object[0]);
            String targetFileName = this.getExportFileName(sourceData, tempSavePath);
            List<String> attrKeys = super.getPropertyKeys(exportFields);
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            Map<String, Object> propertyMap = null;
            for (Map map : sourceData) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                propertyMap = super.getPropertyMap(map, exportFields);
                if (propertyMap == null) continue;
                if (propertyMap != null) {
                    propertyMap.remove("shape");
                }
                data.add(propertyMap);
            }
            try {
                Map<String, String> columnsAndHeaders;
                if (data == null || data.size() <= 0) return;
                File file = new File(targetFileName);
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if ((columnsAndHeaders = this.columnNameToHeaderMap(exportFields)) != null) {
                    for (String key : columnsAndHeaders.keySet()) {
                        if (!key.equalsIgnoreCase("shape")) continue;
                        columnsAndHeaders.remove(key);
                        break;
                    }
                }
                String sheetName = "\u56fe\u6591\u5217\u8868";
                String string = ExcelUtil.CreateExcelXlsx((String)tempSavePath, (String)file.getName(), (String)sheetName, columnsAndHeaders, data);
                return;
            }
            catch (Exception e) {
                this.logger.info(this.getDescription() + " \u5bfc\u51fa\u5c5e\u6027\u6570\u636e\u5230excel\u6587\u4ef6\u5f02\u5e38 ", new Object[0]);
                this.logger.error((Throwable)e);
                throw e;
            }
            finally {
                if (attrKeys != null) {
                    attrKeys = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (data != null) {
                    data = null;
                }
            }
        } else {
            this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a0", new Object[0]);
        }
    }

    private Map<String, String> columnNameToHeaderMap(List<TbtskFields> exportFields) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (exportFields != null && exportFields.size() > 0) {
            result.put("taskId", "\u4efb\u52a1id");
            result.put("taskCode", "\u4efb\u52a1\u7c7b\u578b");
            result.put("taskName", "\u4efb\u52a1\u540d\u79f0");
            for (TbtskFields exportField : exportFields) {
                if (StringUtils.isBlank((CharSequence)exportField.getfFieldtype()) || "taskId".equalsIgnoreCase(exportField.getfFieldname()) || "taskCode".equalsIgnoreCase(exportField.getfFieldname()) || "taskName".equalsIgnoreCase(exportField.getfFieldname()) || "f_shape".equalsIgnoreCase(exportField.getfFieldname())) continue;
                result.put(exportField.getfFieldname().replace("f_", "").trim(), exportField.getfAlias());
            }
        }
        return result;
    }

    String getHeader(List<TbtskFields> sourceFields) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("\u4efb\u52a1\u7f16\u53f7");
        headers.add("\u4efb\u52a1\u4ee3\u7801");
        headers.add("\u4efb\u52a1\u540d\u79f0");
        if (sourceFields != null) {
            for (TbtskFields sourceField : sourceFields) {
                headers.add(sourceField.getfAlias());
            }
        }
        return StringUtils.join(headers, (String)",");
    }

    protected String getDataType() {
        return "excel";
    }

    protected String getFileExtension() {
        return ".xlsx";
    }

    protected String getDescription() {
        return "\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d\u3010Excel\u3011";
    }

    @Override
    boolean isQueryGeoFields() {
        return false;
    }
}

