/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;
import com.geoway.landteam.customtask.service.task.thread.DownloadGeometryThread;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadExcelDailyTaskServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryDailyTaskKmlServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryDailyTaskShapeServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MMDownloadGeometryTakeHandKmlServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MMDownloadGeometryTakeHandShapeServiceImpl;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MDownloadGeometryConsumerServiceImpl
implements IConsumerStrategyService {
    @Autowired
    MDownloadExcelDailyTaskServiceImpl downloadExcelDailyTaskService;
    private final String DOWNLOAD_GEOMETRY_CODE = "DownloadGeometryCode";
    @Autowired
    MMDownloadGeometryTakeHandKmlServiceImpl downloadGeometryTakeHandKmlService;
    @Autowired
    MMDownloadGeometryTakeHandShapeServiceImpl downloadGeometryTakeHandShapeService;
    @Autowired
    MDownloadGeometryDailyTaskKmlServiceImpl downloadGeometryDailyTaskKmlService;
    @Autowired
    MDownloadGeometryDailyTaskShapeServiceImpl downloadGeometryDailyTaskShapeService;
    @Autowired
    TaskRecordService taskRecordService;
    ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private final GiLoger logger = GwLoger.getLoger(MDownloadGeometryConsumerServiceImpl.class);
    private DownloadGeometryService downloadGeometryService;

    @Override
    public String getCode() {
        return "DownloadGeometryCode";
    }

    @Override
    public void execute(MapMessage mapMessage) {
        try {
            DownloadParameter downloadParam;
            JSONObject jsonObject;
            Object bean;
            String taskId = mapMessage.getString("taskId");
            String dataType = mapMessage.getString("dataType");
            String parameter = mapMessage.getString("parameter");
            if ("SSP".equalsIgnoreCase(taskId)) {
                if ("KML".equalsIgnoreCase(dataType)) {
                    this.downloadGeometryService = this.downloadGeometryTakeHandKmlService;
                } else if ("SHP".equalsIgnoreCase(dataType)) {
                    this.downloadGeometryService = this.downloadGeometryTakeHandShapeService;
                } else if ("EXCEL".equalsIgnoreCase(dataType)) {
                    // empty if block
                }
            } else if ("KML".equalsIgnoreCase(dataType)) {
                this.downloadGeometryService = this.downloadGeometryDailyTaskKmlService;
            } else if ("SHP".equalsIgnoreCase(dataType)) {
                this.downloadGeometryService = this.downloadGeometryDailyTaskShapeService;
            } else if ("EXCEL".equalsIgnoreCase(dataType)) {
                this.downloadGeometryService = this.downloadExcelDailyTaskService;
            }
            if (StringUtils.isNotBlank((CharSequence)parameter) && (bean = JSONObject.toJavaObject((JSON)(jsonObject = JSONObject.parseObject((String)parameter)), DownloadParameter.class)) != null && bean instanceof DownloadParameter && (downloadParam = (DownloadParameter)bean) != null) {
                TaskRecord taskRecord = this.taskRecordService.findOne(downloadParam.getRecordId());
                if (taskRecord != null) {
                    taskRecord.setState(Integer.valueOf(1));
                    this.taskRecordService.save(taskRecord);
                }
                if (this.downloadGeometryService != null) {
                    DownloadGeometryThread thread = new DownloadGeometryThread(this.downloadGeometryService, downloadParam, this.taskRecordService);
                    Future<?> future = this.threadPool.submit((Runnable)thread);
                    String failReason = null;
                    try {
                        Object obj = future.get(60L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        failReason = "\u4e3b\u7ebf\u7a0b\u5728\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u4e2d\u65ad\uff01";
                        taskRecord.setState(Integer.valueOf(2));
                        taskRecord.setRemark(failReason);
                        this.taskRecordService.save(taskRecord);
                    }
                    catch (ExecutionException e) {
                        failReason = "\u4e3b\u7ebf\u7a0b\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\uff0c\u4f46\u4efb\u52a1\u672c\u8eab\u629b\u51fa\u5f02\u5e38\uff01";
                        taskRecord.setState(Integer.valueOf(2));
                        taskRecord.setRemark(failReason);
                        this.taskRecordService.save(taskRecord);
                    }
                    catch (TimeoutException e) {
                        failReason = "\u4e3b\u7ebf\u7a0b\u7b49\u5f85\u8ba1\u7b97\u7ed3\u679c\u8d85\u65f6\uff0c\u56e0\u6b64\u4e2d\u65ad\u4efb\u52a1\u7ebf\u7a0b\uff01";
                        taskRecord.setState(Integer.valueOf(2));
                        taskRecord.setRemark(failReason);
                        this.taskRecordService.save(taskRecord);
                    }
                }
            }
        }
        catch (JMSException e) {
            this.logger.error(e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), new Object[0]);
        }
    }
}

