/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.pub.DataDownloadFieldService;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryDailyTaskBaseService;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueFieldsService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueSourceService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import java.io.File;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class MDownloadGeometryDailyTaskBaseService
extends DownloadGeometryService {
    private static final List SystemFiledList = Arrays.asList("f_id", "f_ismycreate", "f_lon", "f_lat", "f_shape");
    private final GiLoger logger = GwLoger.getLoger(DownloadGeometryDailyTaskBaseService.class);
    private static final String TASK_CODE_DAILY_TASK = "\u65e5\u5e38\u4efb\u52a1";
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TbtskFieldsService tbtskFieldsService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    LandUserService landUserService;
    @Autowired
    JcClueSourceService jcClueSourceService;
    @Autowired
    JcClueFieldsService jcClueFieldsService;
    String geoKey = "f_shape";
    String taskId = "";
    String taskCode = "";
    String taskName = "";
    String prjNum = "";

    List<Map> getSourceData(TbtskObjectinfo tbtskObjectinfo, List<String> queryFieldNames) {
        if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return null;
        }
        String whereClause = "";
        String tableName = "";
        if (this.downloadParameter.getDownloadType() != null) {
            if (this.downloadParameter.getDownloadType() == 0) {
                whereClause = " r.f_dataid = d.f_id and r.f_assignto = '" + this.downloadParameter.getUserId() + "'";
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.downloadParameter.getTbIds())) {
                    whereClause = whereClause + "and d.f_id in ( '" + this.downloadParameter.getTbIds().replace(",", "','") + "' )";
                }
                tableName = " tbtsk_assign_record r," + tbtskObjectinfo.getfTablename() + " d ";
            } else if (this.downloadParameter.getDownloadType() == 1) {
                TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(this.downloadParameter.getTaskId());
                String xzqdm = "";
                if (tskTaskBiz.getIsPublic() == 1) {
                    whereClause = whereClause + " d.f_userid = '" + this.downloadParameter.getUserId() + "' ";
                } else {
                    List areas = this.landUserService.queryUserAreas(this.downloadParameter.getUserId());
                    if (areas != null && areas.size() > 0) {
                        xzqdm = (String)areas.get(0);
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)xzqdm)) {
                    whereClause = whereClause + "1=2";
                } else if (!"1".equalsIgnoreCase(xzqdm)) {
                    whereClause = xzqdm.endsWith("0000") ? whereClause + " d.f_xzqdm like '" + xzqdm.substring(0, 2) + "%' " : (xzqdm.endsWith("00") ? whereClause + " d.f_xzqdm like '" + xzqdm.substring(0, 4) + "%' " : whereClause + " d.f_xzqdm = '" + xzqdm + "' ");
                }
                tableName = tbtskObjectinfo.getfTablename() + " d ";
            } else {
                whereClause = "";
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.downloadParameter.getTbIds())) {
                    whereClause = whereClause + "d.f_id in ( '" + this.downloadParameter.getTbIds().replace(",", "','") + "' )";
                }
                tableName = tbtskObjectinfo.getfTablename() + " d ";
            }
        }
        ArrayList<Map> result = new ArrayList<Map>();
        List maps = this.dataBizService.queryAllData(tableName, queryFieldNames, whereClause);
        result.addAll(maps);
        ArrayList<String> parentIdList = new ArrayList<String>();
        for (Map map : maps) {
            if (!map.containsKey("f_issplitted") || map.get("f_issplitted") == null || !"1".equals(map.get("f_issplitted").toString())) continue;
            parentIdList.add(map.get("f_id").toString());
        }
        if (parentIdList.size() > 0) {
            String childTableName = tbtskObjectinfo.getSplitTableName();
            String join = String.join((CharSequence)",", parentIdList);
            List childMaps = this.dataBizService.queryAllData(childTableName + " d ", queryFieldNames, " d.f_splitedid in ( '" + join.replace(",", "','") + "' )");
            result.addAll(childMaps);
        }
        return result;
    }

    public void addApproveInfo(TbtskObjectinfo tbtskObjectinfo, List<Map> sourceData, TskTaskBiz tskTaskBiz) {
        try {
            if (sourceData == null || sourceData.isEmpty()) {
                return;
            }
            String shListSql = String.format("    with \n    t1 as (select f_id from  %s  where f_id in ('%s')),\n    t2 as (SELECT f_tbid,MAX (f_approve_time ) AS f_approve_time,COUNT(f_tbid) as num FROM ( SELECT * FROM tbtsk_approve_record  where f_taskid = '%s' and f_stepindex = 0 and f_tbid in (select f_id from t1)) s1  GROUP BY f_tbid),\n    t3 as (SELECT f_tbid,MAX (f_approve_time ) AS f_approve_time,COUNT(f_tbid) as num FROM ( SELECT * FROM tbtsk_approve_record  where f_taskid = '%s' and f_stepindex = 1 and f_tbid in (select f_id from t1)) s1  GROUP BY f_tbid),\n    t4 as (SELECT s1.*,t2.num,u.f_rname  FROM tbtsk_approve_record AS s1 INNER JOIN t2 ON t2.f_tbid = s1.f_tbid AND t2.f_approve_time = s1.f_approve_time left join tbsys_user u on u.f_userid  = s1.f_approve_userid ),\n    t5 as (SELECT s1.*,t3.num,u.f_rname  FROM tbtsk_approve_record AS s1 INNER JOIN t3 ON t3.f_tbid = s1.f_tbid AND t3.f_approve_time = s1.f_approve_time left join tbsys_user u on u.f_userid  = s1.f_approve_userid )\n    select \n    t1.f_id,t4.f_stepname as xj_stepname,t4.f_option as xj_option,t4.f_remark as xj_remark,t4.f_approve_time as xj_approve_time,t4.num as xj_num,t4.f_rname as xj_rname,\n    t5.f_stepname as sj_stepname,t5.f_option as sj_option,t5.f_remark as sj_remark,t5.f_approve_time as sj_approve_time,t5.num as sj_num,t5.f_rname as sj_rname\n    from t1 left join t4 on t1.f_id = t4.f_tbid left join t5 on t1.f_id = t5.f_tbid", tbtskObjectinfo.getfTablename(), this.GetDataIds(sourceData).replace(",", "','"), tskTaskBiz.getId(), tskTaskBiz.getId());
            List shdata = this.jdbcTemplate.queryForList(shListSql);
            String rjListSql = String.format(" with \n    t1 as (select f_id from  %s  where f_id in ('%s')),\n    t2 as (SELECT f_tbid,MAX (f_reject_time ) AS f_reject_time,COUNT(f_tbid) as num FROM ( SELECT * FROM tbtsk_reject_record  where f_taskid = '%s' and f_stepname = '\u533a\u53bf\u5ba1\u6838' and f_tbid in (select f_id from t1)) s1  GROUP BY f_tbid),\n    t3 as (SELECT f_tbid,MAX (f_reject_time ) AS f_reject_time,COUNT(f_tbid) as num FROM ( SELECT * FROM tbtsk_reject_record  where f_taskid = '%s' and f_stepname = '\u5e02\u7ea7\u5ba1\u6838' and f_tbid in (select f_id from t1)) s1  GROUP BY f_tbid),\n    t4 as (SELECT s1.*,t2.num,u.f_rname  FROM tbtsk_reject_record AS s1 INNER JOIN t2 ON t2.f_tbid = s1.f_tbid AND t2.f_reject_time = s1.f_reject_time left join tbsys_user u on u.f_userid = s1.f_userid ),\n    t5 as (SELECT s1.*,t3.num,u.f_rname  FROM tbtsk_reject_record AS s1 INNER JOIN t3 ON t3.f_tbid = s1.f_tbid AND t3.f_reject_time = s1.f_reject_time left join tbsys_user u on u.f_userid = s1.f_userid )\n    select * from (select \n    t1.f_id,t4.f_stepname as xj_stepname,0 as xj_option,t4.f_remark as xj_remark,t4.f_reject_time as xj_approve_time,t4.num as xj_num,t4.f_rname as xj_rname,\n    t5.f_stepname as sj_stepname,0 as sj_option,t5.f_remark as sj_remark,t5.f_reject_time as sj_approve_time,t5.num as sj_num,t5.f_rname as sj_rname\n    from t1 left join t4 on t1.f_id = t4.f_tbid left join t5 on t1.f_id = t5.f_tbid) t where sj_num >0 or xj_num >0", tbtskObjectinfo.getfTablename(), this.GetDataIds(sourceData).replace(",", "','"), tskTaskBiz.getId(), tskTaskBiz.getId());
            List rjdata = this.jdbcTemplate.queryForList(rjListSql);
            Map<String, List<Map>> shdataMap = null;
            Map<String, List<Map>> rjdataMap = null;
            if (!shdata.isEmpty()) {
                shdataMap = shdata.stream().collect(Collectors.groupingBy(t -> t.get("f_id").toString()));
            }
            if (!rjdata.isEmpty()) {
                rjdataMap = rjdata.stream().collect(Collectors.groupingBy(t -> t.get("f_id").toString()));
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            for (Map map : sourceData) {
                map.put("sj_remark", "");
                map.put("sj_time", "");
                map.put("sj_option", "");
                map.put("sjnum", "");
                map.put("sj_user", "");
                map.put("xj_remark", "");
                map.put("xj_time", "");
                map.put("xj_option", "");
                map.put("xjnum", "");
                map.put("xj_user", "");
                if (shdataMap == null || shdataMap.isEmpty()) continue;
                try {
                    Long approve;
                    Long reject;
                    String rejectTimeXj;
                    Map s;
                    String tbid = map.get("f_id").toString();
                    String approveTimeSj = "";
                    String approveTimeXj = "";
                    if (shdataMap.containsKey(tbid)) {
                        s = shdataMap.get(tbid).get(0);
                        approveTimeSj = s.get("sj_approve_time") != null ? s.get("sj_approve_time").toString() : "";
                        approveTimeXj = s.get("xj_approve_time") != null ? s.get("xj_approve_time").toString() : "";
                        map.put("sj_remark", s.get("sj_remark") != null ? s.get("sj_remark") : "");
                        map.put("sj_time", s.get("sj_approve_time") != null ? s.get("sj_approve_time") : "");
                        map.put("sj_option", s.get("sj_option") != null ? s.get("sj_option") : "");
                        map.put("sjnum", s.get("sj_num") != null ? s.get("sj_num") : "");
                        map.put("sj_user", s.get("sj_rname") != null ? s.get("sj_rname") : "");
                        map.put("xj_remark", s.get("xj_remark") != null ? s.get("xj_remark") : "");
                        map.put("xj_time", s.get("xj_approve_time") != null ? s.get("xj_approve_time") : "");
                        map.put("xj_option", s.get("xj_option") != null ? s.get("xj_option") : "");
                        map.put("xjnum", s.get("xj_num") != null ? s.get("xj_num") : "");
                        map.put("xj_user", s.get("xj_rname") != null ? s.get("xj_rname") : "");
                    }
                    if (rjdataMap == null || !rjdataMap.containsKey(tbid)) continue;
                    s = rjdataMap.get(tbid).get(0);
                    int xjNum = s.get("xj_num") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.get("xj_num").toString()) ? Integer.parseInt(s.get("xj_num").toString()) : 0;
                    int sjNum = s.get("sj_num") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.get("sj_num").toString()) ? Integer.parseInt(s.get("sj_num").toString()) : 0;
                    int xjNum2 = map.get("xjnum") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("xjnum").toString()) ? Integer.parseInt(map.get("xjnum").toString()) : 0;
                    int sjNum2 = map.get("sjnum") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("sjnum").toString()) ? Integer.parseInt(map.get("sjnum").toString()) : 0;
                    map.put("xjnum", xjNum + xjNum2);
                    map.put("sjnum", sjNum + sjNum2);
                    String rejectTimeSj = s.get("sj_approve_time") != null ? s.get("sj_approve_time").toString() : "";
                    String string = rejectTimeXj = s.get("xj_approve_time") != null ? s.get("xj_approve_time").toString() : "";
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rejectTimeXj)) {
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)approveTimeXj)) {
                            map.put("xj_remark", s.get("xj_remark") != null ? s.get("xj_remark") : "");
                            map.put("xj_time", s.get("xj_approve_time") != null ? s.get("xj_approve_time") : "");
                            map.put("xj_option", 0);
                            map.put("xjnum", s.get("xjnum") != null ? s.get("xjnum") : "");
                            map.put("xj_user", s.get("xj_rname") != null ? s.get("xj_rname") : "");
                        } else {
                            reject = df.parse(rejectTimeXj).getTime();
                            approve = df.parse(approveTimeXj).getTime();
                            if (reject > approve) {
                                map.put("xj_remark", s.get("xj_remark") != null ? s.get("xj_remark") : "");
                                map.put("xj_time", s.get("xj_approve_time") != null ? s.get("xj_approve_time") : "");
                                map.put("xj_option", 0);
                                map.put("xjnum", s.get("xjnum") != null ? s.get("xjnum") : "");
                                map.put("xj_user", s.get("xj_rname") != null ? s.get("xj_rname") : "");
                            }
                        }
                    }
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rejectTimeSj)) continue;
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)approveTimeSj)) {
                        map.put("sj_remark", s.get("sj_remark") != null ? s.get("sj_remark") : "");
                        map.put("sj_time", s.get("sj_approve_time") != null ? s.get("sj_approve_time") : "");
                        map.put("sj_option", 0);
                        map.put("sjnum", s.get("sjnum") != null ? s.get("sjnum") : "");
                        map.put("sj_user", s.get("sj_rname") != null ? s.get("sj_rname") : "");
                        continue;
                    }
                    reject = df.parse(rejectTimeSj).getTime();
                    approve = df.parse(approveTimeSj).getTime();
                    if (reject <= approve) continue;
                    map.put("sj_remark", s.get("sj_remark") != null ? s.get("sj_remark") : "");
                    map.put("sj_time", s.get("sj_approve_time") != null ? s.get("sj_approve_time") : "");
                    map.put("sj_option", 0);
                    map.put("sjnum", s.get("sjnum") != null ? s.get("sjnum") : "");
                    map.put("sj_user", s.get("sj_rname") != null ? s.get("sj_rname") : "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String GetDataIds(List<Map> sourceData) {
        if (sourceData == null || sourceData.isEmpty()) {
            return null;
        }
        String ids = "";
        for (Map map : sourceData) {
            ids = ids + map.get("f_id") + ",";
        }
        ids = ids.substring(0, ids.length() - 1);
        return ids;
    }

    public List<TbtskFields> addApproveFields(List<TbtskFields> sourceFields) {
        ArrayList<TbtskFields> results = new ArrayList<TbtskFields>();
        List<String> approveFields = Arrays.asList("sj_remark", "sj_time", "sj_option", "sjnum", "sj_user", "xj_remark", "xj_time", "xj_option", "xjnum", "xj_user");
        HashMap<String, String> approveFieldMap = new HashMap<String, String>();
        approveFieldMap.put("sj_remark", "\u5e02\u7ea7\u5ba1\u6838\u610f\u89c1");
        approveFieldMap.put("sj_time", "\u5e02\u7ea7\u5ba1\u6838\u65f6\u95f4");
        approveFieldMap.put("sj_option", "\u5ba1\u6838\u72b6\u6001");
        approveFieldMap.put("sjnum", "\u6b21\u6570");
        approveFieldMap.put("sj_user", "\u5ba1\u6838\u5458");
        approveFieldMap.put("xj_remark", "\u5ba1\u6838\u610f\u89c1");
        approveFieldMap.put("xj_time", "\u5ba1\u6838\u65f6\u95f4");
        approveFieldMap.put("xj_option", "\u5ba1\u6838\u72b6\u6001");
        approveFieldMap.put("xjnum", "\u6b21\u6570");
        approveFieldMap.put("xj_user", "\u5ba1\u6838\u5458");
        boolean isExistsApproveField = false;
        if (sourceFields != null && sourceFields.size() > 0) {
            for (TbtskFields field : sourceFields) {
                if (approveFields.contains(field.getfFieldname())) {
                    isExistsApproveField = true;
                }
                results.add(field);
            }
        }
        if (!isExistsApproveField) {
            for (String s : approveFields) {
                TbtskFields newfiled = new TbtskFields();
                newfiled.setfId(UUID.randomUUID().toString());
                newfiled.setfFieldname(s);
                newfiled.setfAlias(approveFieldMap.get(s).toString());
                newfiled.setfFieldtype("varchar");
                newfiled.setfLength(Integer.valueOf(64));
                newfiled.setfPrecision(Integer.valueOf(0));
                newfiled.setfNullable(Integer.valueOf(0));
                results.add(newfiled);
            }
        }
        return results;
    }

    public void initParameter(String taskId, String taskCode, String taskName, String prjNum) {
        GutilAssert.notNull((Object)taskId, (String)"taskId can not be null");
        GutilAssert.notNull((Object)taskCode, (String)"taskCode can not be null");
        GutilAssert.notNull((Object)taskName, (String)"taskName can not be null");
        GutilAssert.notNull((Object)this.downloadRecord, (String)"downloadRecord can not be null");
        this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u521d\u59cb\u5316\u4e0b\u8f7d\u53c2\u6570 taskId:" + taskId + "  taskCode:" + taskCode + "   taskName:" + taskName + "   prjNmu:" + prjNum, new Object[0]);
        this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u521d\u59cb\u5316\u4e0b\u8f7d\u53c2\u6570 downloadRecord:" + this.downloadRecord.toString(), new Object[0]);
        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;
        this.resultUrl = "";
    }

    public void doDownload() throws Exception {
        this.logger.info(this.getDescription() + " \u56fe\u6591\u6570\u636e\u4e0b\u8f7d\u5f00\u59cb\u5904\u7406...", new Object[0]);
        TskTaskBiz tskTaskBiz = null;
        TbtskObjectinfo tbtskObjectinfo = null;
        List sourceFields = null;
        ArrayList<TbtskFields> exportFields = new ArrayList();
        ArrayList<String> queryFieldNames = new ArrayList<String>();
        try {
            if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            this.logger.info(this.getDescription() + " \u5f00\u59cb\u67e5\u8be2\u4efb\u52a1f_shape\u5b57\u6bb5\u6570\u636e", new Object[0]);
            tskTaskBiz = this.tskTaskBizService.findByTaskId(this.downloadParameter.getTaskId());
            if (tskTaskBiz != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tskTaskBiz.getTableId())) {
                tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            if (tbtskObjectinfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfTablename())) {
                sourceFields = this.tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
            }
            if (sourceFields != null && sourceFields.size() > 0) {
                for (TbtskFields field : sourceFields) {
                    if ("f_shape1".equalsIgnoreCase(field.getfFieldname()) || "f_shape_b".equalsIgnoreCase(field.getfFieldname()) || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) continue;
                    if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                        if (!this.isQueryGeoFields()) continue;
                        queryFieldNames.add("d." + field.getfFieldname());
                        continue;
                    }
                    if (field.getfFieldname().equals("f_grqm")) continue;
                    queryFieldNames.add("d." + field.getfFieldname());
                }
                exportFields = DataDownloadFieldService.getExportFields((List)sourceFields);
                exportFields = exportFields.stream().filter(r -> !r.getfFieldname().equals("f_grqm")).collect(Collectors.toList());
            }
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String safeFileName = "";
            List<Map> sourceData = this.getSourceData(tbtskObjectinfo, queryFieldNames);
            if (sourceData != null) {
                safeFileName = sourceData.size() == 1 ? (sourceData.get(0).get("f_tbmc") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceData.get(0).get("f_tbmc").toString()) ? tskTaskBiz.getName() + "(" + sourceData.get(0).get("f_tbmc").toString() + UuidUtil.get16UUID() + "\uff09" : tskTaskBiz.getName() + "(" + UuidUtil.get16UUID() + "\uff09") : tskTaskBiz.getName() + "(" + sourceData.size() + "\u4e2a)" + UuidUtil.get16UUID();
                String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
                this.initParameter(tskTaskBiz.getId(), TASK_CODE_DAILY_TASK, tskTaskBiz.getName(), "");
                this.downloadRecord.setName(tskTaskBiz.getName() + "(\u4e0b\u8f7d" + this.getDataType() + ")");
                this.exportAction(sourceData, tempFolderPath, exportFields);
                this.afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    List<String> getPropertyKeys(List<TbtskFields> exportFields) {
        ArrayList<String> propertyKeys = new ArrayList<String>();
        if (exportFields != null && exportFields.size() > 0) {
            for (TbtskFields field : exportFields) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)field.getfFieldname())) continue;
                propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
            }
        }
        return propertyKeys;
    }

    List<Map<String, String>> getPropertyKeysWithFieldType(List<TbtskFields> exportFields) {
        ArrayList<Map<String, String>> propertyKeysMapList = new ArrayList<Map<String, String>>();
        if (exportFields != null && exportFields.size() > 0) {
            for (TbtskFields field : exportFields) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)field.getfFieldname())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fieldname", field.getfFieldname().replace("f_", "").trim());
                map.put("fieldtype", field.getfFieldtype());
                propertyKeysMapList.add(map);
            }
        }
        return propertyKeysMapList;
    }

    List<String> getCluePropertyKeys(List<JcClueFields> exportFields) {
        ArrayList<String> propertyKeys = new ArrayList<String>();
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)field.getfFieldname())) continue;
                propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
            }
        }
        return propertyKeys;
    }

    Map<String, Object> getPropertyMap(Map map, List<TbtskFields> exportFields) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (map == null) {
            return resultMap;
        }
        String userName = "";
        String createtime = "";
        resultMap.put("taskId", this.taskId);
        resultMap.put("taskCode", this.taskCode);
        resultMap.put("taskName", this.taskName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp ts = null;
        DecimalFormat decimalFormat = new DecimalFormat("#.#######");
        String columnNmae = "";
        String tempValue = "";
        if (exportFields != null && exportFields.size() > 0) {
            for (TbtskFields field : exportFields) {
                String translatedValue;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getfFieldtype()) || "taskId".equalsIgnoreCase(field.getfFieldname()) || "taskCode".equalsIgnoreCase(field.getfFieldname()) || "taskName".equalsIgnoreCase(field.getfFieldname()) || "f_shape".equalsIgnoreCase(field.getfFieldname())) continue;
                columnNmae = "sj_remark".equalsIgnoreCase(field.getfFieldname()) || "sj_time".equalsIgnoreCase(field.getfFieldname()) || "sj_option".equalsIgnoreCase(field.getfFieldname()) || "sjnum".equalsIgnoreCase(field.getfFieldname()) || "sj_user".equalsIgnoreCase(field.getfFieldname()) || "xj_remark".equalsIgnoreCase(field.getfFieldname()) || "xj_time".equalsIgnoreCase(field.getfFieldname()) || "xj_option".equalsIgnoreCase(field.getfFieldname()) || "xjnum".equalsIgnoreCase(field.getfFieldname()) || "xj_user".equalsIgnoreCase(field.getfFieldname()) ? field.getfFieldname() : "f_" + field.getfFieldname();
                if ("f_userid".equalsIgnoreCase(columnNmae)) {
                    if (!map.containsKey("f_userid") || map.get("f_userid") == null) continue;
                    userName = this.userNameService.getUserRealNameByUserId(map.get("f_userid").toString());
                    resultMap.put(field.getfFieldname().replace("f_", "").trim(), userName);
                    continue;
                }
                if ("f_createtime".equalsIgnoreCase(columnNmae) || "f_committime".equalsIgnoreCase(columnNmae)) {
                    try {
                        if (!map.containsKey(columnNmae) || map.get(columnNmae) == null) continue;
                        ts = new Timestamp(Long.valueOf(map.get(columnNmae).toString()));
                        createtime = format.format(ts);
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), createtime);
                    }
                    catch (Exception e) {
                        if (!map.containsKey(columnNmae) || map.get(columnNmae) == null) continue;
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae).toString());
                    }
                    continue;
                }
                if ("f_lon".equalsIgnoreCase(columnNmae) || "f_lat".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), decimalFormat.format(Double.parseDouble(map.get(columnNmae).toString())));
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_sfydjzl".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u6709");
                            continue;
                        }
                        if ("2".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u65e0");
                            continue;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_bz".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u5f71\u50cf\u65e0\u623f";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316";
                                break;
                            }
                            case "3": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62";
                                break;
                            }
                            case "4": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316\uff0c\u73b0\u5df2\u6269\u5efa";
                                break;
                            }
                            case "5": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62\uff0c\u73b0\u5df2\u6269\u5efa";
                                break;
                            }
                            case "6": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316\uff0c\u73b0\u72b6\u65e0\u623f\u5c4b";
                                break;
                            }
                            case "7": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62\uff0c\u73b0\u72b6\u65e0\u623f\u5c4b";
                                break;
                            }
                            case "8": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62\u4e0e\u767b\u8bb0\u9762\u79ef\u4e00\u81f4";
                                break;
                            }
                            case "9": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62\u4e0e\u767b\u8bb0\u9762\u79ef\u4e0d\u4e00\u81f4";
                                break;
                            }
                            case "10": {
                                translatedValue = "\u672a\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62";
                                break;
                            }
                            case "11": {
                                translatedValue = "\u5176\u4ed6";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_tdyt".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u519c\u6751\u5b85\u57fa\u5730";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u516c\u5171\u8bbe\u65bd\u519c\u7528\u5730";
                                break;
                            }
                            case "3": {
                                translatedValue = "\u533b\u536b\u6148\u5584\u7528\u5730";
                                break;
                            }
                            case "4": {
                                translatedValue = "\u79d1\u6559\u7528\u5730";
                                break;
                            }
                            case "5": {
                                translatedValue = "\u5176\u4ed6";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_qlrlx".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u4e2a\u4eba";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u5355\u4f4d";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_ismycreate".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u662f");
                            continue;
                        }
                        if ("0".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u5426");
                            continue;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_qlrqm".equalsIgnoreCase(columnNmae) || "f_dcrqm".equalsIgnoreCase(columnNmae) || "f_sign".equalsIgnoreCase(columnNmae) || "f_requestid".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae));
                    continue;
                }
                resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
            }
        }
        return resultMap;
    }

    String getExportFileName(List<Map> sourceData, String folderPath) {
        if (sourceData == null || sourceData.size() == 0 || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)folderPath)) {
            return "";
        }
        FileUtil.creatDirectoryIfNotExist((String)folderPath);
        String fileName = "";
        if (sourceData.size() == 1) {
            Map map = sourceData.get(0);
            if (map != null) {
                if (map.containsKey("f_tbmc") && map.get("f_tbmc") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_tbmc").toString())) {
                    fileName = map.get("f_tbmc").toString();
                } else if (map.containsKey("f_tbbh") && map.get("f_tbmc") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_tbbh").toString())) {
                    fileName = map.get("f_tbbh").toString();
                } else if (map.containsKey("f_id") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_id").toString())) {
                    fileName = map.get("f_id").toString();
                }
            }
        } else {
            fileName = sourceData.size() + "\u4e2a";
        }
        String targetFileName = folderPath + File.separator + this.taskName + "(" + fileName + ")" + this.getFileExtension();
        File file = new File(targetFileName);
        if (!file.exists()) {
            // empty if block
        }
        return targetFileName;
    }

    protected String getObsFolderPath() {
        return "dailyTask/download/" + this.getDataType();
    }

    abstract void exportAction(List<Map> var1, String var2, List<TbtskFields> var3) throws Exception;

    String getName(Map map) {
        if (map == null) {
            return "";
        }
        String result = "";
        if (map.containsKey("f_tbmc") && map.get("f_tbmc") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_tbmc").toString())) {
            result = map.get("f_tbmc").toString();
        } else if (map.containsKey("f_tbbh") && map.get("f_tbbh") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_tbbh").toString())) {
            result = map.get("f_tbbh").toString();
        } else if (map.containsKey("f_id") && map.get("f_id") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)map.get("f_id").toString())) {
            result = map.get("f_id").toString();
        }
        return result;
    }

    public static List<JcClueFields> getExportClueFields(List<JcClueFields> sourceFields) {
        ArrayList<JcClueFields> results = new ArrayList<JcClueFields>();
        boolean isExistsTaskId = false;
        boolean isExistsTaskCode = false;
        boolean isExistsTaskName = false;
        JcClueFields newfiled = null;
        if (sourceFields != null && sourceFields.size() > 0) {
            for (JcClueFields field : sourceFields) {
                boolean canExport = false;
                boolean isSystemField = MDownloadGeometryDailyTaskBaseService.isSystemField(field.getfFieldname());
                if (isSystemField) {
                    canExport = true;
                } else {
                    boolean isOuterField = field.getfFieldInnerOuterSys() == 1 || field.getfFieldInnerOuterSys() == 2 || field.getfFieldInnerOuterSys() == 3 || field.getfFieldInnerOuterSys() == 6;
                    boolean bl = canExport = isOuterField;
                }
                if (!canExport) continue;
                if ("taskid".equalsIgnoreCase(field.getfFieldname())) {
                    isExistsTaskId = true;
                }
                if ("taskCode".equalsIgnoreCase(field.getfFieldname())) {
                    isExistsTaskCode = true;
                }
                if ("taskName".equalsIgnoreCase(field.getfFieldname())) {
                    isExistsTaskName = true;
                }
                newfiled = new JcClueFields();
                BeanUtil.copyProperties((Object)field, (Object)newfiled, (boolean)false);
                if ("f_sign".equalsIgnoreCase(field.getfFieldname()) || "f_qlrqm".equalsIgnoreCase(field.getfFieldname()) || "f_dcrqm".equalsIgnoreCase(field.getfFieldname())) {
                    newfiled.setfFieldtype("blob");
                }
                if (StringUtils.isNotBlank((CharSequence)newfiled.getfFieldname()) && newfiled.getfFieldname().startsWith("f_")) {
                    newfiled.setfFieldname(newfiled.getfFieldname().replace("f_", "").trim());
                }
                results.add(newfiled);
            }
        }
        if (!isExistsTaskId) {
            newfiled = new JcClueFields();
            newfiled.setfId(UUID.randomUUID().toString());
            newfiled.setfFieldname("taskId");
            newfiled.setfAlias("\u7ebf\u7d22id");
            newfiled.setfFieldtype("varchar");
            newfiled.setfLength(Integer.valueOf(36));
            newfiled.setfPrecision(Integer.valueOf(0));
            newfiled.setfNullable(Integer.valueOf(0));
            results.add(newfiled);
        }
        if (!isExistsTaskCode) {
            newfiled = new JcClueFields();
            newfiled.setfId(UUID.randomUUID().toString());
            newfiled.setfFieldname("taskCode");
            newfiled.setfAlias("\u7ebf\u7d22\u7c7b\u578b");
            newfiled.setfFieldtype("varchar");
            newfiled.setfLength(Integer.valueOf(255));
            newfiled.setfPrecision(Integer.valueOf(0));
            newfiled.setfNullable(Integer.valueOf(0));
            results.add(newfiled);
        }
        if (!isExistsTaskName) {
            newfiled = new JcClueFields();
            newfiled.setfId(UUID.randomUUID().toString());
            newfiled.setfFieldname("taskName");
            newfiled.setfAlias("\u7ebf\u7d22\u540d\u79f0");
            newfiled.setfFieldtype("varchar");
            newfiled.setfLength(Integer.valueOf(255));
            newfiled.setfPrecision(Integer.valueOf(0));
            newfiled.setfNullable(Integer.valueOf(0));
            results.add(newfiled);
        }
        return results;
    }

    private static boolean isSystemField(String fieldName) {
        boolean isNeedExport = false;
        if (StringUtils.isNotBlank((CharSequence)fieldName) && SystemFiledList.contains(fieldName.toLowerCase())) {
            isNeedExport = true;
        }
        return isNeedExport;
    }

    abstract boolean isQueryGeoFields();
}

