/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.landcloud.common.util.geometry.KmlUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryDailyTaskBaseService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.stereotype.Service;

@Service
public class MDownloadGeometryDailyTaskKmlServiceImpl
extends MDownloadGeometryDailyTaskBaseService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadGeometryDailyTaskKmlServiceImpl.class);

    @Override
    void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception {
        if (sourceData != null) {
            this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a" + sourceData.size(), new Object[0]);
            int index = 0;
            List<String> attrKeys = this.getPropertyKeys(exportFields);
            ArrayList<Map<String, Object>> geometryList = new ArrayList<Map<String, Object>>();
            String targetFileName = this.getExportFileName(sourceData, tempSavePath);
            for (Map map : sourceData) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                ++index;
                if (map.containsKey("f_shape") && map.get("f_shape") != null && StringUtils.isNotBlank((CharSequence)map.get("f_shape").toString())) {
                    Geometry geometry = null;
                    this.logger.info(this.getDescription() + " \u6b63\u5728\u6784\u5efa" + index + "\u4e2a\u56fe\u6591\u7684geometry\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                    try {
                        geometry = WKTUtil.wktToGeom((String)map.get("f_shape").toString().replace("SRID=4490;", ""));
                    }
                    catch (ParseException e) {
                        this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684shape\u8f6c\u6362\u6210Geometry\u51fa\u73b0\u5f02\u5e38 \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                        this.logger.error((Throwable)e);
                    }
                    if (geometry != null) {
                        Map<String, Object> propertyMap = super.getPropertyMap(map, exportFields);
                        if (propertyMap != null && propertyMap.containsKey("shape")) {
                            propertyMap.remove("shape");
                        }
                        if (propertyMap == null) continue;
                        propertyMap.put(this.geoKey, geometry);
                        geometryList.add(propertyMap);
                        continue;
                    }
                    String name = this.getName(map);
                    this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                    this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684geometry\u8f6c\u6362\u6210Geometry\u4e3a\u7a7a \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                    continue;
                }
                String name = this.getName(map);
                this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684f_shape\u4e3a\u7a7a \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
            }
            try {
                if (attrKeys != null) {
                    for (String key : attrKeys) {
                        if (!"shape".equalsIgnoreCase(key)) continue;
                        attrKeys.remove(key);
                        break;
                    }
                }
                this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u5f00\u59cb\u751f\u6210KML\u6587\u4ef6", new Object[0]);
                KmlUtil.write2Wml((String)targetFileName, (String)this.geoKey, attrKeys, geometryList);
            }
            catch (Exception e) {
                this.logger.info(this.getDescription() + " \u5bfc\u51fageometry\u5230kml\u6587\u4ef6\u5f02\u5e38 ", new Object[0]);
                this.logger.error((Throwable)e);
                throw e;
            }
            finally {
                if (attrKeys != null) {
                    attrKeys = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        }
        this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u5bfc\u51fa\u6570\u636e \u56fe\u6591\u603b\u4e2a\u6570\uff1a0", new Object[0]);
    }

    protected String getDataType() {
        return "kml";
    }

    protected String getFileExtension() {
        return ".kml";
    }

    protected String getDescription() {
        return "\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d\u3010KML\u3011";
    }

    @Override
    boolean isQueryGeoFields() {
        return true;
    }
}

