/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.geometry.ShapeUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKBUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryDailyTaskBaseService;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.service.pub.impl.DataDownloadFieldService;
import com.geoway.landteam.patrolclue.service.util.UuidUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MDownloadGeometryDailyTaskShapeServiceImpl
extends MDownloadGeometryDailyTaskBaseService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadGeometryDailyTaskShapeServiceImpl.class);
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    private static final String TASK_CODE_DAILY_TASK = "\u65e5\u5e38\u4efb\u52a1";

    @Override
    public void doDownload() throws Exception {
        if (DownloadTypeEnum.\u7ebf\u7d22.getCode().equals(this.downloadParameter.getType())) {
            this.dealClueDownload(this.downloadParameter);
        } else {
            this.logger.info(this.getDescription() + " \u56fe\u6591\u6570\u636e\u4e0b\u8f7d\u5f00\u59cb\u5904\u7406...", new Object[0]);
            TskTaskBiz tskTaskBiz = null;
            TbtskObjectinfo tbtskObjectinfo = null;
            List sourceFields = null;
            ArrayList<TbtskFields> exportFields = new ArrayList();
            ArrayList<String> queryFieldNames = new ArrayList<String>();
            try {
                if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                this.logger.info(this.getDescription() + " \u5f00\u59cb\u67e5\u8be2\u4efb\u52a1f_shape\u5b57\u6bb5\u6570\u636e", new Object[0]);
                tskTaskBiz = this.tskTaskBizService.findByTaskId(this.downloadParameter.getTaskId());
                if (tskTaskBiz != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tskTaskBiz.getTableId())) {
                    tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
                }
                if (tbtskObjectinfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfTablename()) && (sourceFields = this.tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename())).size() > 120 && sourceFields.stream().map(r -> r.getfFieldname()).collect(Collectors.toList()).contains("f_id")) {
                    sourceFields = sourceFields.stream().filter(r -> r.getfFieldname().equals("f_id") || r.getfFieldname().equals("f_shape") || r.getfFieldname().equals("f_issplitted") || r.getfFieldname().equals("f_dkbh")).collect(Collectors.toList());
                }
                if (sourceFields != null && sourceFields.size() > 0) {
                    for (TbtskFields field : sourceFields) {
                        if ("f_shape1".equalsIgnoreCase(field.getfFieldname()) || "f_shape_b".equalsIgnoreCase(field.getfFieldname()) || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) continue;
                        if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                            if (!this.isQueryGeoFields()) continue;
                            queryFieldNames.add("d." + field.getfFieldname());
                            continue;
                        }
                        queryFieldNames.add("d." + field.getfFieldname());
                    }
                    exportFields = com.geoway.landteam.customtask.service.pub.DataDownloadFieldService.getExportFields((List)sourceFields);
                }
                this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
                String tempFolderPath = this.uploadDir + File.separator + com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID();
                FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
                String safeFileName = "";
                List<Map> sourceData = this.getSourceData(tbtskObjectinfo, queryFieldNames);
                if (sourceData != null) {
                    safeFileName = sourceData.size() == 1 ? (sourceData.get(0).get("f_tbmc") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceData.get(0).get("f_tbmc").toString()) ? tskTaskBiz.getName() + "(" + sourceData.get(0).get("f_tbmc").toString() + com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID() + "\uff09" : tskTaskBiz.getName() + "(" + com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID() + "\uff09") : tskTaskBiz.getName() + "(" + sourceData.size() + "\u4e2a)" + com.geoway.landteam.customtask.service.util.UuidUtil.get16UUID();
                    exportFields = this.addApproveFields(exportFields);
                    this.addApproveInfo(tbtskObjectinfo, sourceData, tskTaskBiz);
                    String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
                    this.initParameter(tskTaskBiz.getId(), TASK_CODE_DAILY_TASK, tskTaskBiz.getName(), "");
                    this.downloadRecord.setName(tskTaskBiz.getName() + "(\u4e0b\u8f7d" + this.getDataType() + ")");
                    this.exportAction(sourceData, tempFolderPath, exportFields);
                    this.afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected void dealClueDownload(DownloadParameter downloadParameter) throws Exception {
        try {
            this.downloadRecord.setType(DownloadTypeEnum.\u7ebf\u7d22.getCode());
            this.logger.info(this.getDescription() + " \u56fe\u6591\u6570\u636e\u4e0b\u8f7d\u5f00\u59cb\u5904\u7406...", new Object[0]);
            List sourceFields = null;
            ArrayList<JcClueFields> exportFields = new ArrayList();
            ArrayList<String> queryFieldNames = new ArrayList<String>();
            if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            this.logger.info(this.getDescription() + " \u5f00\u59cb\u67e5\u8be2\u4efb\u52a1f_shape\u5b57\u6bb5\u6570\u636e", new Object[0]);
            JcClueSource jcClueSource = null;
            sourceFields = null;
            JcClueImportRecord jcClueImportRecord = null;
            jcClueImportRecord = this.jcClueImportRecordService.selectByPrimaryKey(downloadParameter.getTaskId());
            if (jcClueImportRecord != null && StringUtils.isNotBlank((CharSequence)jcClueImportRecord.getfSourceid())) {
                jcClueSource = this.jcClueSourceService.findOne(jcClueImportRecord.getfSourceid());
            }
            if (jcClueSource != null && StringUtils.isNotBlank((CharSequence)jcClueSource.getfTablename())) {
                sourceFields = this.jcClueFieldsService.findByTableId(jcClueSource.getfId());
            }
            if (sourceFields != null && sourceFields.size() > 0) {
                for (JcClueFields field : sourceFields) {
                    if ("f_shape1".equalsIgnoreCase(field.getfFieldname()) || "f_shape_b".equalsIgnoreCase(field.getfFieldname()) || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) continue;
                    if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                        if (!this.isQueryGeoFields()) continue;
                        queryFieldNames.add("d." + field.getfFieldname());
                        continue;
                    }
                    queryFieldNames.add("d." + field.getfFieldname());
                }
                exportFields = DataDownloadFieldService.getExportFields((List)sourceFields);
            }
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String safeFileName = "";
            List<Map> sourceData = this.getSourceData(jcClueSource, queryFieldNames);
            if (sourceData != null) {
                safeFileName = sourceData.size() == 1 ? (sourceData.get(0).get("f_tbmc") != null && StringUtils.isNotBlank((CharSequence)sourceData.get(0).get("f_tbmc").toString()) ? jcClueImportRecord.getfName() + "(" + sourceData.get(0).get("f_tbmc").toString() + UuidUtil.get16UUID() + "\uff09" : jcClueImportRecord.getfName() + "(" + UuidUtil.get16UUID() + "\uff09") : jcClueImportRecord.getfName() + "(" + sourceData.size() + "\u4e2a)" + UuidUtil.get16UUID();
                String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
                this.initParameter(jcClueImportRecord.getfId(), "\u7ebf\u7d22\u6279\u6b21", jcClueImportRecord.getfName(), "");
                this.downloadRecord.setName(jcClueImportRecord.getfName() + "(\u4e0b\u8f7d" + this.getDataType() + ")");
                this.exportClueAction(sourceData, tempFolderPath, exportFields);
                this.afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    List<Map> getSourceData(JcClueSource jcClueSource, List<String> queryFieldNames) {
        if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
            return null;
        }
        String whereClause = "";
        String tableName = "";
        if (StringUtils.isNotBlank((CharSequence)this.downloadParameter.getTbIds())) {
            whereClause = whereClause + "d.f_id in ( '" + this.downloadParameter.getTbIds().replace(",", "','") + "' )";
        }
        tableName = jcClueSource.getfTablename() + " d ";
        return this.queryAllData(tableName, queryFieldNames, whereClause);
    }

    public List<Map> queryAllData(String tableName, List<String> fieldNameList, String where) {
        List list = this.dataBizMapper.queryAllData(tableName, fieldNameList, where);
        return list;
    }

    @Override
    void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception {
        if (sourceData != null) {
            this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a" + sourceData.size(), new Object[0]);
            int index = 0;
            String targetFileName = this.getExportFileName(sourceData, tempSavePath);
            List<Map<String, String>> propertyKeysMapList = this.getPropertyKeysWithFieldType(exportFields);
            ArrayList<Map> propertyKeysParams = new ArrayList<Map>();
            ArrayList<Map<String, Object>> geometryList = new ArrayList<Map<String, Object>>();
            Map<String, Object> propertyMap = null;
            String geometryType = "";
            Geometry geometry = null;
            String name = "";
            for (Map map : sourceData) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                ++index;
                if (map.containsKey("f_shape") && map.get("f_shape") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)"f_shape")) {
                    geometry = null;
                    this.logger.info(this.getDescription() + " \u6b63\u5728\u6784\u5efa" + index + "\u4e2a\u56fe\u6591\u7684geometry\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                    try {
                        Geometry geometry1 = WKBUtil.wkbToGeom((String)map.get("f_shape").toString());
                        geometry = WKTUtil.wktToGeom((String)geometry1.toText().replace("SRID=4490;", ""));
                    }
                    catch (ParseException e) {
                        this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684geometry\u8f6c\u6362\u6210Geometry\u51fa\u73b0\u5f02\u5e38 \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                        this.logger.error((Throwable)e);
                    }
                    if (geometry != null) {
                        if (index == 1 || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)geometryType)) {
                            geometryType = geometry.getGeometryType();
                        }
                        if ((propertyMap = super.getPropertyMap(map, exportFields)) != null && propertyMap.containsKey("shape")) {
                            propertyMap.remove("shape");
                        }
                        if (propertyMap == null) continue;
                        propertyMap.put(this.geoKey, geometry);
                        geometryList.add(propertyMap);
                        continue;
                    }
                    name = this.getName(map);
                    this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                    this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684geometry\u8f6c\u6362\u6210Geometry\u4e3a\u7a7a \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                    continue;
                }
                name = this.getName(map);
                this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684f_shape\u4e3a\u7a7a \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
            }
            try {
                if (propertyKeysMapList != null && propertyKeysMapList.size() > 0) {
                    for (Map map : propertyKeysMapList) {
                        if (((String)map.get("fieldname")).contains("shape")) continue;
                        propertyKeysParams.add(map);
                    }
                }
                ShapeUtil.write2ShapeWithFieldType((String)targetFileName, (String)"GB2312", (String)geometryType, (String)this.geoKey, propertyKeysParams, geometryList);
            }
            catch (Exception e) {
                this.logger.info(this.getDescription() + " \u5bfc\u51fageometry\u5230shape\u6587\u4ef6\u5f02\u5e38 ", new Object[0]);
                this.logger.error((Throwable)e);
                throw e;
            }
            finally {
                if (propertyKeysMapList != null) {
                    propertyKeysMapList = null;
                }
                if (propertyKeysParams != null) {
                    propertyKeysParams = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        }
        this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a0", new Object[0]);
    }

    void exportClueAction(List<Map> sourceData, String tempSavePath, List<JcClueFields> exportFields) throws Exception {
        if (sourceData != null) {
            this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a" + sourceData.size(), new Object[0]);
            int index = 0;
            String targetFileName = this.getExportFileName(sourceData, tempSavePath);
            List<String> attrKeys = this.getCluePropertyKeys(exportFields);
            ArrayList<Map<String, Object>> geometryList = new ArrayList<Map<String, Object>>();
            Map<String, Object> propertyMap = null;
            String geometryType = "";
            Geometry geometry = null;
            String name = "";
            for (Map map : sourceData) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                ++index;
                if (map.containsKey("f_shape") && map.get("f_shape") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)"f_shape")) {
                    geometry = null;
                    this.logger.info(this.getDescription() + " \u6b63\u5728\u6784\u5efa" + index + "\u4e2a\u56fe\u6591\u7684geometry\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                    try {
                        geometry = WKTUtil.wktToGeom((String)map.get("f_shape").toString().replace("SRID=4490;", ""));
                    }
                    catch (ParseException e) {
                        this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684geometry\u8f6c\u6362\u6210Geometry\u51fa\u73b0\u5f02\u5e38 \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                        this.logger.error((Throwable)e);
                    }
                    if (geometry != null) {
                        if (index == 1 || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)geometryType)) {
                            geometryType = geometry.getGeometryType();
                        }
                        if ((propertyMap = this.getCluePropertyMap(map, exportFields)) != null && propertyMap.containsKey("shape")) {
                            propertyMap.remove("shape");
                        }
                        if (propertyMap == null) continue;
                        propertyMap.put(this.geoKey, geometry);
                        geometryList.add(propertyMap);
                        continue;
                    }
                    name = this.getName(map);
                    this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                    this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684geometry\u8f6c\u6362\u6210Geometry\u4e3a\u7a7a \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                    continue;
                }
                name = this.getName(map);
                this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684f_shape\u4e3a\u7a7a \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
            }
            try {
                if (attrKeys != null) {
                    for (String key : attrKeys) {
                        if (!"shape".equalsIgnoreCase(key)) continue;
                        attrKeys.remove(key);
                        break;
                    }
                }
                ShapeUtil.write2Shape((String)targetFileName, (String)"GB2312", (String)geometryType, (String)this.geoKey, attrKeys, geometryList);
            }
            catch (Exception e) {
                this.logger.info(this.getDescription() + " \u5bfc\u51fageometry\u5230shape\u6587\u4ef6\u5f02\u5e38 ", new Object[0]);
                this.logger.error((Throwable)e);
                throw e;
            }
            finally {
                if (attrKeys != null) {
                    attrKeys = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        }
        this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a0", new Object[0]);
    }

    private Map<String, String> columnNameToHeaderMap(List<JcClueFields> exportFields) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (exportFields != null && exportFields.size() > 0) {
            result.put("taskId", "\u4efb\u52a1id");
            result.put("taskCode", "\u4efb\u52a1\u7c7b\u578b");
            result.put("taskName", "\u4efb\u52a1\u540d\u79f0");
            for (JcClueFields exportField : exportFields) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)exportField.getfFieldtype()) || "taskId".equalsIgnoreCase(exportField.getfFieldname()) || "taskCode".equalsIgnoreCase(exportField.getfFieldname()) || "taskName".equalsIgnoreCase(exportField.getfFieldname()) || "f_shape".equalsIgnoreCase(exportField.getfFieldname())) continue;
                result.put(exportField.getfFieldname().replace("f_", "").trim(), exportField.getfAlias());
            }
        }
        return result;
    }

    protected String getDataType() {
        return "shape";
    }

    protected String getFileExtension() {
        return ".shp";
    }

    protected String getDescription() {
        return "\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d\u3010SHAPE\u3011";
    }

    @Override
    boolean isQueryGeoFields() {
        return true;
    }

    Map<String, Object> getCluePropertyMap(Map map, List<JcClueFields> exportFields) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (map == null) {
            return resultMap;
        }
        String userName = "";
        String createtime = "";
        resultMap.put("taskId", this.taskId);
        resultMap.put("taskCode", this.taskCode);
        resultMap.put("taskName", this.taskName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp ts = null;
        DecimalFormat decimalFormat = new DecimalFormat("#.#######");
        String columnNmae = "";
        String tempValue = "";
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                String translatedValue;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getfFieldtype()) || "taskId".equalsIgnoreCase(field.getfFieldname()) || "taskCode".equalsIgnoreCase(field.getfFieldname()) || "taskName".equalsIgnoreCase(field.getfFieldname()) || "f_shape".equalsIgnoreCase(field.getfFieldname())) continue;
                columnNmae = "f_" + field.getfFieldname();
                if ("f_userid".equalsIgnoreCase(columnNmae)) {
                    if (!map.containsKey("f_userid") || map.get("f_userid") == null) continue;
                    userName = this.userNameService.getUserRealNameByUserId(map.get("f_userid").toString());
                    resultMap.put(field.getfFieldname().replace("f_", "").trim(), userName);
                    continue;
                }
                if ("f_createtime".equalsIgnoreCase(columnNmae) || "f_committime".equalsIgnoreCase(columnNmae)) {
                    try {
                        if (!map.containsKey(columnNmae) || map.get(columnNmae) == null) continue;
                        ts = new Timestamp(Long.valueOf(map.get(columnNmae).toString()));
                        createtime = format.format(ts);
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), createtime);
                    }
                    catch (Exception e) {
                        if (!map.containsKey(columnNmae) || map.get(columnNmae) == null) continue;
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae).toString());
                    }
                    continue;
                }
                if ("f_lon".equalsIgnoreCase(columnNmae) || "f_lat".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), decimalFormat.format(Double.parseDouble(map.get(columnNmae).toString())));
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_sfydjzl".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u6709");
                            continue;
                        }
                        if ("2".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u65e0");
                            continue;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_bz".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u5f71\u50cf\u65e0\u623f";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316";
                                break;
                            }
                            case "3": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62";
                                break;
                            }
                            case "4": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316\uff0c\u73b0\u5df2\u6269\u5efa";
                                break;
                            }
                            case "5": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62\uff0c\u73b0\u5df2\u6269\u5efa";
                                break;
                            }
                            case "6": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u9700\u77e2\u91cf\u5316\uff0c\u73b0\u72b6\u65e0\u623f\u5c4b";
                                break;
                            }
                            case "7": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u767b\u8bb0\u9644\u56fe\u6709\u77e2\u91cf\u56fe\u5f62\uff0c\u73b0\u72b6\u65e0\u623f\u5c4b";
                                break;
                            }
                            case "8": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62\u4e0e\u767b\u8bb0\u9762\u79ef\u4e00\u81f4";
                                break;
                            }
                            case "9": {
                                translatedValue = "\u5df2\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62\u4e0e\u767b\u8bb0\u9762\u79ef\u4e0d\u4e00\u81f4";
                                break;
                            }
                            case "10": {
                                translatedValue = "\u672a\u767b\u8bb0\uff0c\u73b0\u72b6\u56fe\u5f62";
                                break;
                            }
                            case "11": {
                                translatedValue = "\u5176\u4ed6";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_tdyt".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u519c\u6751\u5b85\u57fa\u5730";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u516c\u5171\u8bbe\u65bd\u519c\u7528\u5730";
                                break;
                            }
                            case "3": {
                                translatedValue = "\u533b\u536b\u6148\u5584\u7528\u5730";
                                break;
                            }
                            case "4": {
                                translatedValue = "\u79d1\u6559\u7528\u5730";
                                break;
                            }
                            case "5": {
                                translatedValue = "\u5176\u4ed6";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_qlrlx".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        translatedValue = "";
                        switch (tempValue) {
                            case "1": {
                                translatedValue = "\u4e2a\u4eba";
                                break;
                            }
                            case "2": {
                                translatedValue = "\u5355\u4f4d";
                                break;
                            }
                            default: {
                                translatedValue = tempValue;
                            }
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_ismycreate".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u662f");
                            continue;
                        }
                        if ("0".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "\u5426");
                            continue;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if ("f_qlrqm".equalsIgnoreCase(columnNmae) || "f_dcrqm".equalsIgnoreCase(columnNmae) || "f_sign".equalsIgnoreCase(columnNmae) || "f_requestid".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), new Object[0]);
                    }
                    continue;
                }
                if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae));
                    continue;
                }
                resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
            }
        }
        return resultMap;
    }

    @Override
    List<String> getCluePropertyKeys(List<JcClueFields> exportFields) {
        ArrayList<String> propertyKeys = new ArrayList<String>();
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)field.getfFieldname())) continue;
                propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
            }
        }
        return propertyKeys;
    }
}

