/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.customtask.servface.mq.DataDownloadProducerService;
import com.geoway.landteam.customtask.servface.mq.DownloadGeometryProducerService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;
import com.geoway.landteam.customtask.service.util.FileUtil1;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import java.io.File;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class MDownloadGeometryTakeHandBaseService
extends DownloadGeometryService {
    private static final String TAKE_HAND_TASK_ID = "ssp";
    private static final String TAKE_HAND = "\u968f\u624b\u62cd";
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    AppBasicService appBasicService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    DataDownloadProducerService dataDownloadProducerService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    AppBasicRepository appBasicRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    DownloadGeometryProducerService downloadGeometryProducerService;
    String geoKey = "f_shape";
    String taskId = "";
    String taskCode = "";
    String taskName = "";
    String prjNum = "";
    private final GiLoger logger = GwLoger.getLoger(MDownloadGeometryTakeHandBaseService.class);

    private void initParameter(String taskId, String taskCode, String taskName, String prjNum) {
        GutilAssert.notNull((Object)taskId, (String)"taskId can not be null");
        GutilAssert.notNull((Object)taskCode, (String)"taskCode can not be null");
        GutilAssert.notNull((Object)taskName, (String)"taskName can not be null");
        GutilAssert.notNull((Object)this.downloadRecord, (String)"downloadRecord can not be null");
        this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u521d\u59cb\u5316\u4e0b\u8f7d\u53c2\u6570 taskId:" + taskId + "  taskCode:" + taskCode + "   taskName:" + taskName + "   prjNmu:" + prjNum, new Object[0]);
        this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u521d\u59cb\u5316\u4e0b\u8f7d\u53c2\u6570 downloadRecord:" + this.downloadRecord.toString(), new Object[0]);
        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;
        this.resultUrl = "";
    }

    public void doDownload() throws Exception {
        this.logger.info(this.getDescription() + " \u56fe\u6591\u6570\u636e\u4e0b\u8f7d\u5f00\u59cb\u5904\u7406...", new Object[0]);
        try {
            AppBasic detailById;
            if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            List<String> ids = Arrays.asList(this.downloadParameter.getTbIds().split(","));
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil1.creatDirectoryIfNotExist((String)tempFolderPath);
            String safeFileName = "";
            safeFileName = ids.size() > 1 ? "\u968f\u624b\u62cd(" + ids.size() + "\u4e2a)" + UuidUtil.get16UUID() : (ids.size() == 1 ? ((detailById = this.appBasicService.getDetailById(ids.get(0))) != null ? (StringUtils.isNotBlank((CharSequence)detailById.getHeading()) ? "\u968f\u624b\u62cd(" + detailById.getHeading() + ")" + UuidUtil.get16UUID() : (StringUtils.isNotBlank((CharSequence)detailById.getName()) ? "\u968f\u624b\u62cd(" + detailById.getName() + ")" + UuidUtil.get16UUID() : "\u968f\u624b\u62cd(" + UuidUtil.get16UUID() + ")" + UuidUtil.get16UUID())) : "\u968f\u624b\u62cd(" + UuidUtil.get16UUID() + ")" + UuidUtil.get16UUID()) : "\u968f\u624b\u62cd(" + UuidUtil.get16UUID() + ")" + UuidUtil.get16UUID());
            String fullFileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            this.initParameter(TAKE_HAND_TASK_ID, TAKE_HAND, TAKE_HAND, "");
            this.downloadRecord.setName("\u968f\u624b\u62cd(\u4e0b\u8f7d" + this.getDataType() + ")");
            this.exportGeometry(ids, this.downloadParameter.getUserId(), tempFolderPath);
            this.afterExport(tempFolderPath, safeFileName, fullFileNameNoSuffix);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    String getExportFileName(String fileName, String folderPath) {
        FileUtil1.creatDirectoryIfNotExist((String)folderPath);
        String targetFileName = folderPath + File.separator + this.taskName + "(" + fileName + ")" + this.getFileExtension();
        File file = new File(targetFileName);
        if (!file.exists()) {
            // empty if block
        }
        return targetFileName;
    }

    public String getObsFolderPath() {
        return "ssp/download/" + this.getDataType();
    }

    abstract void exportGeometry(List<String> var1, Long var2, String var3) throws Exception;

    List<String> getPropertyKeys() {
        List<String> propertyKeys = this.getBasicPropertyKeys();
        propertyKeys.add("type");
        propertyKeys.add("desc");
        return propertyKeys;
    }

    List<String> getBasicPropertyKeys() {
        ArrayList<String> propertyKeys = new ArrayList<String>();
        propertyKeys.add("taskId");
        propertyKeys.add("taskCode");
        propertyKeys.add("taskName");
        propertyKeys.add("prjNum");
        propertyKeys.add("tbId");
        propertyKeys.add("tbName");
        propertyKeys.add("tbmj");
        propertyKeys.add("lon");
        propertyKeys.add("lat");
        propertyKeys.add("regionCode");
        propertyKeys.add("requestId");
        propertyKeys.add("createtime");
        propertyKeys.add("userName");
        return propertyKeys;
    }

    Map<String, Object> getPropertyMap(AppBasic appbasic) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (appbasic == null) {
            return null;
        }
        String tbId = "";
        String tbName = "";
        Double lon = 0.0;
        Double lat = 0.0;
        Double tbmj = 0.0;
        String regionCode = "";
        String requestId = "";
        String userName = "";
        String createtime = "";
        this.taskId = appbasic.getId();
        tbId = appbasic.getId();
        String string = tbName = StringUtils.isNotBlank((CharSequence)appbasic.getName()) ? appbasic.getName() : null;
        String heading = StringUtils.isNotBlank((CharSequence)appbasic.getHeading()) ? appbasic.getHeading() : (StringUtils.isNotBlank((CharSequence)appbasic.getName()) ? appbasic.getName() : "");
        lon = appbasic.getLon() != null ? appbasic.getLon() : 0.0;
        lat = appbasic.getLat() != null ? appbasic.getLat() : 0.0;
        tbmj = appbasic.getMj() != null ? appbasic.getMj() : 0.0;
        regionCode = appbasic.getCounty() != null ? appbasic.getCounty() : "";
        requestId = appbasic.getRequestId() != null ? appbasic.getRequestId() : "";
        createtime = appbasic.getCreatetime() != null ? appbasic.getCreatetime() : "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Timestamp ts = new Timestamp(Long.valueOf(createtime));
            createtime = format.format(ts);
        }
        catch (Exception e) {
            e.printStackTrace();
            createtime = appbasic.getCreatetime();
        }
        userName = this.userNameService.getUserRealNameByUserName(appbasic.getUsername());
        resultMap.put("taskId", this.taskId);
        resultMap.put("taskCode", this.taskCode);
        resultMap.put("taskName", this.taskName);
        resultMap.put("prjNum", this.prjNum);
        resultMap.put("tbId", tbId);
        resultMap.put("tbName", tbName);
        resultMap.put("tbmj", tbmj);
        resultMap.put("lon", lon);
        resultMap.put("lat", lat);
        resultMap.put("regionCode", regionCode);
        resultMap.put("requestId", requestId);
        resultMap.put("createtime", createtime);
        resultMap.put("userName", userName);
        resultMap.put("type", StringUtils.isNotBlank((CharSequence)appbasic.getType()) ? appbasic.getType() : "");
        resultMap.put("desc", StringUtils.isNotBlank((CharSequence)appbasic.getDesc()) ? appbasic.getDesc() : "");
        return resultMap;
    }

    protected String getName(AppBasic appbasic) {
        if (appbasic == null) {
            return "";
        }
        String name = "";
        name = StringUtils.isNotBlank((CharSequence)appbasic.getHeading()) ? appbasic.getHeading() : (StringUtils.isNotBlank((CharSequence)appbasic.getName()) ? appbasic.getName() : appbasic.getId());
        return name;
    }
}

