/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.gw.base.Gw;
import com.gw.base.util.GutilAssert;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MDownloadImagesService {
    private static int bufSize;
    @Autowired
    AppBasicService appBasicService;
    private ZipEntry zipEntry;
    private byte[] buf;
    private int readedBytes;
    private String rootDir;
    private String taskId;
    private String taskCode;
    private String taskName;
    private String prjNum;

    public void initParameter(String taskId, String taskCode, String taskName, String prjNum) {
        GutilAssert.notNull((Object)taskId, (String)"taskId can not be null");
        GutilAssert.notNull((Object)taskCode, (String)"taskCode can not be null");
        GutilAssert.notNull((Object)taskName, (String)"taskName can not be null");
        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;
    }

    public void downloadImageToServer(String urlString, String filename, String savePath) throws Exception {
        int len;
        URL url = new URL(urlString);
        URLConnection con = url.openConnection();
        con.setConnectTimeout(5000);
        InputStream is = con.getInputStream();
        byte[] bs = new byte[1024];
        File sf = new File(savePath);
        if (!sf.exists()) {
            sf.mkdirs();
        }
        FileOutputStream os = new FileOutputStream(sf.getPath() + "\\" + filename);
        while ((len = is.read(bs)) != -1) {
            ((OutputStream)os).write(bs, 0, len);
        }
        ((OutputStream)os).close();
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportData(String templateDbFileDir, String resultDbFileDir, String newZipName, String ids, Long userId) {
        List<String> idList = Arrays.asList(ids.split(","));
        String destFileName = this.copyDb2WorkSpace(templateDbFileDir, resultDbFileDir);
        SqlliteConnTool connTool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            connTool = new SqlliteConnTool(destFileName);
            conn = connTool.getConnection();
            conn.setAutoCommit(false);
            this.insertAppBasicData(conn, ps, idList, userId);
            this.insertMediaData(conn, ps, idList, userId, resultDbFileDir);
            this.close(connTool, conn, ps);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.close(connTool, conn, ps);
            }
            catch (Throwable throwable) {
                this.close(connTool, conn, ps);
                throw throwable;
            }
        }
        this.doZip(resultDbFileDir, newZipName);
        return true;
    }

    private String copyDb2WorkSpace(String srcDbFileDir, String destDbFileDir) {
        String destFileName = "";
        String srcFileName = "";
        try {
            File destDir = new File(destDbFileDir);
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            srcFileName = srcDbFileDir + "\\meta.db";
            destFileName = destDbFileDir + "\\meta.db";
            File srcFile = new File(srcFileName);
            File destFile = new File(destFileName);
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return destFileName;
    }

    private void insertAppBasicData(Connection connn, PreparedStatement pre, List<String> idList, Long userId) throws Exception {
        String sql = "insert into TaskInfo(taskId ,taskCode,taskName,prjNum,tbId,tbName,lon,lat,extent,regionCode,requestId,createtime,userName) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        pre = connn.prepareStatement(sql);
        String tbId = "";
        String tbName = "";
        Double lon = 0.0;
        Double lat = 0.0;
        String extent = "";
        String regionCode = "";
        String requestId = "";
        String userName = "";
        String createtime = "";
        this.taskId = this.taskId;
        this.taskCode = this.taskCode;
        this.taskName = this.taskName;
        for (String id : idList) {
            AppBasic appbasic = this.appBasicService.getDetailById(id, userId.toString());
            this.taskId = id;
            tbId = id;
            tbName = StringUtils.isNotBlank((CharSequence)appbasic.getName()) ? appbasic.getName() : null;
            lon = appbasic.getLon();
            lat = appbasic.getLat();
            extent = appbasic.getShape();
            regionCode = appbasic.getCounty();
            requestId = appbasic.getRequestId();
            createtime = appbasic.getCreatetime();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Timestamp ts = new Timestamp(Long.valueOf(createtime));
                createtime = format.format(ts);
            }
            catch (Exception e) {
                e.printStackTrace();
                createtime = appbasic.getCreatetime();
            }
            userName = appbasic.getUsername();
            pre.setString(1, this.taskId);
            pre.setString(2, this.taskCode);
            pre.setString(3, this.taskName);
            pre.setString(4, this.prjNum);
            pre.setString(5, tbId);
            pre.setString(6, tbName);
            pre.setDouble(7, lon);
            pre.setDouble(8, lat);
            pre.setString(9, extent);
            pre.setString(10, regionCode);
            pre.setString(11, requestId);
            pre.setString(12, createtime);
            pre.setString(13, userName);
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connn.commit();
    }

    private void insertMediaData(Connection conn, PreparedStatement pre, List<String> idList, Long userId, String tempSavePath) throws Exception {
        String sql = "insert into ResultInfo(attachId ,tbId,mediaSource,mediaFormat,mediaType,viewURL,mediaMeta,jym,status,otherMetaData,time,mediaTimeLength,mediaSize,filename) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        pre = conn.prepareStatement(sql);
        for (String id : idList) {
            AppBasic appbasic = this.appBasicService.getDetailById(id, userId.toString());
            List medias = appbasic.getList();
            for (AppMedia media : medias) {
                Double mediaSize;
                String attachId = media.getId();
                String tbId = media.getGalleryid();
                Integer mediaSource = 0;
                String azimuth = media.getAzimuth();
                String pitch = media.getPitch();
                String shape = media.getShape();
                Integer type = media.getType();
                String videorecord = media.getVideorecord();
                Integer mediatimelength = media.getMediatimelength();
                String time = media.getTime();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Timestamp ts = new Timestamp(Long.valueOf(time));
                    time = format.format(ts);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    time = media.getTime();
                }
                Integer mediaTimeLength = media.getMediatimelength();
                if (mediaTimeLength == null) {
                    mediaTimeLength = 0;
                }
                if ((mediaSize = media.getMediasize()) == null) {
                    mediaSize = 0.0;
                }
                String filename = media.getFileId();
                String mediaFormat = "";
                if (media.getType() == 1) {
                    mediaFormat = "jpg";
                } else if (media.getType() == 2) {
                    mediaFormat = "mp4";
                } else if (media.getType() == 3) {
                    mediaFormat = "mp3";
                } else if (media.getType() == 4) {
                    mediaFormat = "osgb";
                }
                String mediaType = "J";
                String viewURL = "";
                String mediaMeta = "";
                if (media.getType() == 1) {
                    mediaMeta = ((TaskTransMediaService)Gw.beans.getBean(TaskTransMediaService.class)).get7FeaturesFromAppMedia(media).toJSONString();
                } else if (media.getType() == 2) {
                    mediaMeta = media.getVideorecord();
                } else if (media.getType() != 3 && media.getType() == 4) {
                    mediaMeta = ((TaskTransMediaService)Gw.beans.getBean(TaskTransMediaService.class)).get7FeaturesFromAppMedia(media).toJSONString();
                }
                String jym = "";
                Integer status = -1;
                if (media.getTypetype() == 0) {
                    status = -1;
                } else if (media.getTypetype() == 101) {
                    status = 0;
                } else if (media.getTypetype() == 102) {
                    status = 1;
                }
                String mediaName = media.getId();
                if (media.getType() == 1) {
                    mediaName = mediaName + ".jpg";
                } else if (media.getType() == 2) {
                    mediaName = mediaName + ".mp4";
                } else if (media.getType() == 3) {
                    mediaName = mediaName + ".mp3";
                } else if (media.getType() == 4) {
                    mediaName = mediaName + ".osgb";
                }
                String otherMetaData = "";
                pre.setString(1, attachId);
                pre.setString(2, tbId);
                pre.setInt(3, mediaSource);
                pre.setString(4, mediaFormat);
                pre.setString(5, mediaType);
                pre.setString(6, viewURL);
                pre.setString(7, mediaMeta);
                pre.setString(8, jym);
                pre.setInt(9, status);
                pre.setString(10, otherMetaData);
                pre.setString(11, time);
                pre.setDouble(12, mediaTimeLength.intValue());
                pre.setDouble(13, mediaSize);
                pre.setString(14, mediaName);
                pre.addBatch();
                String mediaPath = tempSavePath + File.separator + appbasic.getHeading() + "(" + appbasic.getId() + ")";
                String url = StringUtils.isNotBlank((CharSequence)media.getDownloadUrl()) ? media.getDownloadUrl() : media.getServerpath();
                try {
                    FileUtils.copyURLToFile((URL)new URL(url), (File)new File(mediaPath, mediaName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        pre.executeBatch();
        pre.clearBatch();
        conn.commit();
    }

    private void close(SqlliteConnTool connPool, Connection conn, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (connPool != null) {
            try {
                connPool.Dispose();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void doZip(String zipDirectory, String newZipName) {
        this.buf = new byte[1024];
        File zipDir = new File(zipDirectory);
        if (zipDir.exists()) {
            this.rootDir = zipDir.getName();
            String zipFileName = newZipName + ".zip";
            if (zipDir.isFile()) {
                zipFileName = newZipName + ".zip";
            }
            try {
                ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
                this.handleDir(zipDir, zipOut, newZipName);
                zipOut.close();
                System.out.println("\u5b8c\u6210\uff01");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println(" \u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6587\u4ef6\u8def\u5f84\uff01");
            }
        } else {
            System.err.println("\u60a8\u8f93\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
        }
    }

    private void handleDir(File dir, ZipOutputStream zipOut, String newZipName) throws IOException {
        File[] files = null;
        String zipName = new File(newZipName).getName();
        if (dir.isDirectory()) {
            files = dir.listFiles();
            if (null == files && files.length == 0) {
                zipOut.putNextEntry(new ZipEntry(dir.toString() + "/"));
                zipOut.closeEntry();
            } else {
                for (File fileName : files) {
                    if (fileName.isDirectory()) {
                        this.handleDir(fileName, zipOut, newZipName);
                        continue;
                    }
                    FileInputStream fileIn = new FileInputStream(fileName);
                    String path = dir.getPath();
                    String tempName = dir.getName();
                    if (tempName.equals(this.rootDir)) {
                        zipOut.putNextEntry(new ZipEntry(zipName + "/" + fileName.getName().toString()));
                    } else {
                        path = path.substring(path.indexOf(tempName));
                        zipOut.putNextEntry(new ZipEntry(zipName + "/" + path + "/" + fileName.getName().toString()));
                    }
                    while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
                        zipOut.write(this.buf, 0, this.readedBytes);
                    }
                    zipOut.closeEntry();
                }
            }
        } else if (dir.isFile()) {
            FileInputStream fileIn = new FileInputStream(dir);
            zipOut.putNextEntry(new ZipEntry(dir.getName().toString()));
            while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
                zipOut.write(this.buf, 0, this.readedBytes);
            }
            zipOut.closeEntry();
        }
    }
}

