/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.service.pub.DataDownloadFieldService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.geometry.ShapeUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.pub.impl.SysConfigServiceImpl;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryDailyTaskBaseService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MDownloadTxtDailyTaskServiceImpl
extends MDownloadGeometryDailyTaskBaseService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadTxtDailyTaskServiceImpl.class);
    @Autowired
    DataBizMapper dataBizMapper;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.txtdown.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.txtdown.module:}")
    String transmitModule;
    @Value(value="${transmit.enable:false}")
    boolean transmitEnable;
    @Autowired
    SysConfigServiceImpl sysConfigService;
    private static final String TASK_CODE_DAILY_TASK = "\u65e5\u5e38\u4efb\u52a1";
    private static final String CONFIG = "txt-down-config";

    @Override
    public void doDownload() throws Exception {
        this.logger.info(this.getDescription() + " \u56fe\u6591\u6570\u636e\u4e0b\u8f7d\u5f00\u59cb\u5904\u7406...", new Object[0]);
        TskTaskBiz tskTaskBiz = null;
        TbtskObjectinfo tbtskObjectinfo = null;
        List fields = null;
        ArrayList<TbtskFields> exportFields = new ArrayList();
        ArrayList<String> queryFieldNames = new ArrayList<String>();
        try {
            if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                return;
            }
            this.logger.info(this.getDescription() + " \u5f00\u59cb\u67e5\u8be2\u4efb\u52a1f_shape\u5b57\u6bb5\u6570\u636e", new Object[0]);
            tskTaskBiz = this.tskTaskBizService.findByTaskId(this.downloadParameter.getTaskId());
            if (tskTaskBiz != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tskTaskBiz.getTableId())) {
                tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            if (tbtskObjectinfo != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfTablename())) {
                fields = this.tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
            }
            ArrayList<TbtskFields> sourceFields = new ArrayList<TbtskFields>();
            SysConfig config = this.sysConfigService.findOne(CONFIG);
            if (config != null) {
                JSONObject jsonObject = JSONObject.parseObject((String)config.getValue());
                JSONArray arr = jsonObject.getJSONArray("fields");
                for (int i = 0; i < arr.size(); ++i) {
                    String field = arr.getString(i);
                    TbtskFields tf = fields.stream().filter(t -> t.getfFieldname().equals(field)).findFirst().orElse(null);
                    if (tf == null) continue;
                    sourceFields.add(tf);
                }
            }
            if (sourceFields != null && sourceFields.size() > 0) {
                for (TbtskFields field : sourceFields) {
                    if ("f_shape1".equalsIgnoreCase(field.getfFieldname()) || "f_shape_b".equalsIgnoreCase(field.getfFieldname()) || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) continue;
                    if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                        if (!this.isQueryGeoFields()) continue;
                        queryFieldNames.add("d." + field.getfFieldname());
                        continue;
                    }
                    queryFieldNames.add("d." + field.getfFieldname());
                }
                exportFields = DataDownloadFieldService.getExportFields(sourceFields);
            }
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            String tempFolderPath = this.uploadDir + File.separator + UuidUtil.get16UUID();
            FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
            String safeFileName = UUID.randomUUID().toString();
            List<Map> sourceData = this.getSourceData(tbtskObjectinfo, queryFieldNames);
            if (sourceData != null) {
                String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
                this.initParameter(tskTaskBiz.getId(), TASK_CODE_DAILY_TASK, tskTaskBiz.getName(), "");
                this.downloadRecord.setName(tskTaskBiz.getName() + "(\u4e0b\u8f7d" + this.getDataType() + ")");
                this.exportAction(sourceData, tempFolderPath, exportFields);
                this.afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void afterExport(String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        this.generateLog(tempFolderPath);
        this.generateConfig(tempFolderPath);
        Zip4jUtils.zip((String)tempFolderPath, (String)(fileNameNoSuffix + ".zip"), (boolean)false, (String)"");
        JSONObject httpResult = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(fileNameNoSuffix + ".zip"), this.transmitUrl + "/monitor/trans/transData.action");
        if (httpResult == null || !"200".equals(httpResult.getString("code"))) {
            this.downloadRecord.setState(DataDownloadStateEnum.FAILED);
            this.downloadRecord.setEndTime(new Date());
            this.downloadRecord.setErrorMsg("\u53d1\u9001shp\u5305\u5230\u5185\u7f51\u5931\u8d25");
            this.dataDownloadRecordService.update(this.downloadRecord);
        }
        FileUtils.deleteQuietly((File)new File(tempFolderPath));
        FileUtils.deleteQuietly((File)new File(fileNameNoSuffix + ".zip"));
    }

    @Override
    void exportAction(List<Map> sourceData, String tempSavePath, List<TbtskFields> exportFields) throws Exception {
        if (sourceData != null) {
            this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a" + sourceData.size(), new Object[0]);
            int index = 0;
            String targetFileName = this.getExportFileName(sourceData, tempSavePath);
            List<Map<String, String>> propertyKeysMapList = this.getPropertyKeysWithFieldType(exportFields);
            ArrayList<Map> propertyKeysParams = new ArrayList<Map>();
            ArrayList<Map<String, Object>> geometryList = new ArrayList<Map<String, Object>>();
            Map<String, Object> propertyMap = null;
            String geometryType = "";
            Geometry geometry = null;
            String name = "";
            for (Map map : sourceData) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                ++index;
                if (map.containsKey("f_shape") && map.get("f_shape") != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)"f_shape")) {
                    geometry = null;
                    this.logger.info(this.getDescription() + " \u6b63\u5728\u6784\u5efa" + index + "\u4e2a\u56fe\u6591\u7684geometry\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                    try {
                        geometry = WKTUtil.wktToGeom((String)map.get("f_shape").toString().replace("SRID=4490;", ""));
                    }
                    catch (ParseException e) {
                        this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684geometry\u8f6c\u6362\u6210Geometry\u51fa\u73b0\u5f02\u5e38 \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                        this.logger.error((Throwable)e);
                    }
                    if (geometry != null) {
                        if (index == 1 || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)geometryType)) {
                            geometryType = geometry.getGeometryType();
                        }
                        if ((propertyMap = super.getPropertyMap(map, exportFields)) != null && propertyMap.containsKey("shape")) {
                            propertyMap.remove("shape");
                        }
                        if (propertyMap == null) continue;
                        propertyMap.put(this.geoKey, geometry);
                        geometryList.add(propertyMap);
                        continue;
                    }
                    name = this.getName(map);
                    this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                    this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684geometry\u8f6c\u6362\u6210Geometry\u4e3a\u7a7a \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
                    continue;
                }
                name = this.getName(map);
                this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684f_shape\u4e3a\u7a7a \u56fe\u6591id\uff1a" + map.get("f_id").toString(), new Object[0]);
            }
            try {
                if (propertyKeysMapList != null && propertyKeysMapList.size() > 0) {
                    for (Map map : propertyKeysMapList) {
                        if (((String)map.get("fieldname")).contains("shape")) continue;
                        propertyKeysParams.add(map);
                    }
                }
                ShapeUtil.write2ShapeWithFieldType((String)targetFileName, (String)"GB2312", (String)geometryType, (String)this.geoKey, propertyKeysParams, geometryList);
            }
            catch (Exception e) {
                this.logger.info(this.getDescription() + " \u5bfc\u51fageometry\u5230shape\u6587\u4ef6\u5f02\u5e38 ", new Object[0]);
                this.logger.error((Throwable)e);
                throw e;
            }
            finally {
                if (propertyKeysMapList != null) {
                    propertyKeysMapList = null;
                }
                if (propertyKeysParams != null) {
                    propertyKeysParams = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        }
        this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a0", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateConfig(String folderPath) {
        if (StringUtils.isNotBlank((CharSequence)folderPath)) {
            FileUtil.creatDirectoryIfNotExist((String)folderPath);
            String fileName = folderPath + File.separator + "config.json";
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                Writer writer = null;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)this.downloadRecord.getId());
                try {
                    writer = new FileWriter(file, true);
                    writer.write(jsonObject.toJSONString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String getDataType() {
        return "txt";
    }

    protected String getFileExtension() {
        return ".shp";
    }

    protected String getDescription() {
        return "\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d\u3010TXT\u3011";
    }

    @Override
    boolean isQueryGeoFields() {
        return true;
    }

    @Override
    List<String> getCluePropertyKeys(List<JcClueFields> exportFields) {
        ArrayList<String> propertyKeys = new ArrayList<String>();
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)field.getfFieldname())) continue;
                propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
            }
        }
        return propertyKeys;
    }
}

