/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.pub.impl;

import com.geoway.landteam.landcloud.common.util.geometry.KmlUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryTakeHandBaseService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.stereotype.Service;

@Service
public class MMDownloadGeometryTakeHandKmlServiceImpl
extends MDownloadGeometryTakeHandBaseService {
    private final GiLoger logger = GwLoger.getLoger(MMDownloadGeometryTakeHandKmlServiceImpl.class);

    @Override
    void exportGeometry(List<String> idList, Long userId, String tempSavePath) throws Exception {
        if (idList != null && idList.size() > 0) {
            this.logger.info(this.getDescription() + " \u5bfc\u51fa\u6570\u636e---\u56fe\u6591\u603b\u4e2a\u6570\uff1a" + idList.size(), new Object[0]);
            int index = 0;
            String targetFileName = "";
            List<String> attrKeys = this.getPropertyKeys();
            ArrayList<Map<String, Object>> geometryList = new ArrayList<Map<String, Object>>();
            Map<String, Object> propertyMap = null;
            AppBasic appbasic = null;
            String name = "";
            Geometry geometry = null;
            for (String id : idList) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(this.downloadRecord)) {
                    return;
                }
                this.logger.info(this.getDescription() + " \u6b63\u5728\u67e5\u8be2\u7b2c" + ++index + "\u4e2a\u56fe\u6591\u7684geometry\u6570\u636e \u56fe\u6591id\uff1a" + id, new Object[0]);
                appbasic = this.appBasicService.getDetailById(id, userId.toString());
                if (index == 1) {
                    name = "";
                    name = idList.size() == 1 ? this.getName(appbasic) : idList.size() + "\u4e2a";
                    targetFileName = this.getExportFileName(name, tempSavePath);
                }
                if (appbasic.getShape() != null) {
                    geometry = null;
                    this.logger.info(this.getDescription() + " \u6b63\u5728\u6784\u5efa" + index + "\u4e2a\u56fe\u6591\u7684geometry\u6570\u636e\u53ca\u5c5e\u6027\u6570\u636e \u56fe\u6591id\uff1a" + id, new Object[0]);
                    try {
                        geometry = WKTUtil.wktToGeom((String)appbasic.getShape());
                    }
                    catch (ParseException e) {
                        this.logger.info("\u968f\u624b\u62cd\u4e0b\u8f7d \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684shape\u8f6c\u6362\u6210Geometry\u51fa\u73b0\u5f02\u5e38 \u56fe\u6591id\uff1a" + id, new Object[0]);
                        this.logger.error((Throwable)e);
                    }
                    if (geometry != null) {
                        propertyMap = this.getPropertyMap(appbasic);
                        if (propertyMap == null) continue;
                        propertyMap.put(this.geoKey, geometry);
                        geometryList.add(propertyMap);
                        continue;
                    }
                    name = this.getName(appbasic);
                    this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                    this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684\u7684geometry\u8f6c\u6362\u6210Geometry\u4e3a\u7a7a \u56fe\u6591id\uff1a" + id, new Object[0]);
                    continue;
                }
                name = this.getName(appbasic);
                this.errorInfo.add("\u56fe\u6591 [" + name + "] \u7684\u56fe\u5f62\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u8be5\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e\u53ca\u5c5e\u6027\u4fe1\u606f\r\n");
                this.logger.info(this.getDescription() + " \u7b2c" + index + "\u4e2a\u56fe\u6591\u7684f_shape\u4e3a\u7a7a \u56fe\u6591id\uff1a" + id, new Object[0]);
            }
            try {
                KmlUtil.write2Wml((String)targetFileName, (String)this.geoKey, attrKeys, geometryList);
            }
            catch (Exception e) {
                this.logger.info(this.getDescription() + " \u5bfc\u51fageometry\u5230kml\u6587\u4ef6\u5f02\u5e38", new Object[0]);
                this.logger.error((Throwable)e);
                throw e;
            }
            finally {
                if (attrKeys != null) {
                    attrKeys = null;
                }
                if (propertyMap != null) {
                    propertyMap = null;
                }
                if (appbasic != null) {
                    appbasic = null;
                }
                if (geometry != null) {
                    geometry = null;
                }
                if (geometryList != null) {
                    geometryList = null;
                }
            }
        }
    }

    protected String getDataType() {
        return "kml";
    }

    protected String getFileExtension() {
        return ".kml";
    }

    protected String getDescription() {
        return "\u968f\u624b\u62cd\u4e0b\u8f7d\u3010KML\u3011";
    }
}

