/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.resultshare.enm.AnalysisTaskStateEnum;
import com.geoway.landteam.customtask.resultshare.pub.dto.AnalysisParam;
import com.geoway.landteam.customtask.resultshare.pub.dto.AnalysisTaskDto;
import com.geoway.landteam.customtask.service.resultshare.config.AnalysisConfig;
import com.geoway.landteam.customtask.util.ObjectReference;
import com.geoway.landteam.landcloud.common.util.HttpConnectionUtil;
import com.geoway.landteam.landcloud.common.util.RequestUtil;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MAnalysisTaskService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MAnalysisTaskServiceImpl
implements MAnalysisTaskService {
    private final GiLoger logger = GwLoger.getLoger(MAnalysisTaskServiceImpl.class);
    @Autowired
    AnalysisConfig analysisConfig;

    public String createAnalysisTask(AnalysisParam params, ObjectReference ref) {
        try {
            String result = RequestUtil.sendPost((String)this.analysisConfig.getTaskCreate(), (String)JSONObject.toJSONString((Object)params));
            JSONObject json = JSONObject.parseObject((String)result);
            if (json != null) {
                if (json.getString("code").equalsIgnoreCase("200")) {
                    return json.getString("data");
                }
                ref.setTag(json.getString("message"));
                return "";
            }
            return "";
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efa\u53e0\u52a0\u5206\u6790\u4efb\u52a1\u5931\u8d25", new Object[]{ex});
            ref.setTag("\u521b\u5efa\u53e0\u52a0\u5206\u6790\u4efb\u52a1\u5931\u8d25");
            return "";
        }
    }

    public Boolean startAnalysisTask(String id, ObjectReference ref) {
        try {
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            JSONObject json = RequestUtil.sendHttpRequest(null, (String)this.analysisConfig.getTaskStart(), null, formparams, (boolean)true);
            if (json != null) {
                if (json.getString("code").equalsIgnoreCase("200")) {
                    return true;
                }
                ref.setTag(json.getString("message"));
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            this.logger.error("\u542f\u52a8\u53e0\u52a0\u5206\u6790\u4efb\u52a1" + id + "\u5931\u8d25", new Object[]{ex});
            ref.setTag("\u542f\u52a8\u53e0\u52a0\u5206\u6790\u4efb\u52a1" + id + "\u5931\u8d25");
            return false;
        }
    }

    public AnalysisTaskDto getAnalysisTaskState(String id) {
        try {
            String result = HttpConnectionUtil.httpget((String)(this.analysisConfig.getTaskGet() + "?id=" + id));
            JSONObject json = JSONObject.parseObject((String)result);
            if (json != null) {
                if (json.getString("code").equalsIgnoreCase("200")) {
                    String data = json.getString("data");
                    JSONObject jsonObject = JSONObject.parseObject((String)data);
                    AnalysisTaskDto dto = new AnalysisTaskDto();
                    dto.setId(jsonObject.getString("id"));
                    dto.setProgress(jsonObject.getInteger("progress"));
                    Integer suc = jsonObject.getInteger("success");
                    dto.setName(jsonObject.getString("name"));
                    Integer state = jsonObject.getInteger("state");
                    switch (state) {
                        case 1: {
                            dto.setState(AnalysisTaskStateEnum.create);
                            break;
                        }
                        case 2: {
                            dto.setState(AnalysisTaskStateEnum.runing);
                            break;
                        }
                        case 3: {
                            if (suc.equals(1)) {
                                dto.setState(AnalysisTaskStateEnum.success);
                                break;
                            }
                            dto.setState(AnalysisTaskStateEnum.error);
                        }
                    }
                    return dto;
                }
                return null;
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.error("\u83b7\u53d6\u5206\u6790\u4efb\u52a1:" + id + "\u8fdb\u5ea6\u5931\u8d25", new Object[]{ex});
            return null;
        }
    }

    public Boolean deleteAnalysisTask(String id) {
        try {
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            JSONObject json = RequestUtil.sendHttpRequest(null, (String)this.analysisConfig.getTaskDelete(), null, formparams, (boolean)true);
            if (json != null) {
                if (json.getString("code").equalsIgnoreCase("200")) {
                    return true;
                }
                this.logger.error(json.getString("message"), new Object[0]);
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            this.logger.error("\u5220\u9664\u5206\u6790\u4efb\u52a1:" + id + "\u5931\u8d25", new Object[]{ex});
            return false;
        }
    }
}

