/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.resultshare.enm.AnalysisTaskStateEnum;
import com.geoway.landteam.customtask.resultshare.pub.dto.ATLAS_HTTP_Output_Obj;
import com.geoway.landteam.customtask.resultshare.pub.dto.AnalysisTaskDto;
import com.geoway.landteam.customtask.resultshare.pub.dto.Atlas_Analysis_Param;
import com.geoway.landteam.customtask.service.resultshare.atlas.ATLAS_WF_Intersect;
import com.geoway.landteam.customtask.service.resultshare.config.AtlasConfig;
import com.geoway.landteam.customtask.util.ObjectReference;
import com.geoway.landteam.landcloud.common.util.HttpConnectionUtil;
import com.geoway.landteam.landcloud.common.util.RequestUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MAtlasTaskService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MAtlasTaskServiceImpl
implements MAtlasTaskService {
    private final GiLoger logger = GwLoger.getLoger(MAtlasTaskServiceImpl.class);
    @Autowired
    private AtlasConfig atlasConfig;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    SysConfigRepository sysConfigRepository;
    private String intersectWorkFlow;

    public String createAnalysisTask(Atlas_Analysis_Param params, ObjectReference ref) {
        if (ref == null) {
            ref = new ObjectReference();
        }
        try {
            String atlasid = this.executeAtlasTaskIntersectNew(params, ref);
            return atlasid;
        }
        catch (Exception ex) {
            ref.setTag("\u521b\u5efaatlas\u4efb\u52a1\u5931\u8d25," + ex.getMessage());
            this.logger.error("\u521b\u5efaatlas\u4efb\u52a1\u5931\u8d25", new Object[]{ex});
            return "";
        }
    }

    public Boolean startAnalysisTask(String atlasid, ObjectReference ref) {
        return true;
    }

    public AnalysisTaskDto getAnalysisTaskState(String atlasid) {
        String result = this.getAtlasTaskStatus(atlasid);
        JSONObject resultO = JSONObject.parseObject((String)result);
        String state = resultO.getString("State");
        Boolean flag = resultO.getBoolean("IsSucceed");
        Double progress = resultO.getDouble("Progress");
        AnalysisTaskDto dto = new AnalysisTaskDto();
        dto.setId(atlasid);
        if (progress != null) {
            dto.setProgress(Integer.valueOf(progress.intValue()));
        } else {
            dto.setProgress(Integer.valueOf(0));
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            state = state.toLowerCase();
        }
        switch (state) {
            case "running": {
                dto.setState(AnalysisTaskStateEnum.runing);
                break;
            }
            case "finished": {
                if (flag.booleanValue()) {
                    dto.setState(AnalysisTaskStateEnum.success);
                    break;
                }
                dto.setState(AnalysisTaskStateEnum.error);
                break;
            }
            default: {
                dto.setState(AnalysisTaskStateEnum.create);
            }
        }
        return dto;
    }

    private String executeAtlasTaskIntersectNew(Atlas_Analysis_Param params, ObjectReference ref) throws Exception {
        SysConfig systemConfig = this.sysConfigRepository.queryByKey("shareConfig");
        if (systemConfig == null) {
            throw new Exception("\u6210\u679c\u670d\u7528\u914d\u7f6eshareConfig:\u4e3a\u7a7a");
        }
        JSONObject confg = JSONObject.parseObject((String)systemConfig.getValue());
        String intersectUrl = confg.getString("serviceUrl");
        String atlasUrl = confg.getString("atlasUrl");
        String db = this.getDBAtlas();
        this.checkIntersectParams(params);
        if (StringUtils.isBlank((CharSequence)this.intersectWorkFlow)) {
            this.intersectWorkFlow = this.getTemplateNew();
        }
        String curParam = this.intersectWorkFlow;
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("{left}", db + "/" + params.getLayerLeft().getFeatureSet());
        mapParam.put("{leftPkField}", "aid");
        mapParam.put("{leftShapeField}", "f_shape");
        mapParam.put("{leftWhere}", StringUtils.isNotBlank((CharSequence)params.getLayerLeft().getSql()) ? params.getLayerLeft().getSql() : "1=1");
        mapParam.put("{right}", db + "/" + params.getLayerRight().getFeatureSet());
        mapParam.put("{rightPkField}", "aid");
        mapParam.put("{rightShapeField}", "f_shape");
        mapParam.put("{rightWhere}", StringUtils.isNotBlank((CharSequence)params.getLayerRight().getSql()) ? params.getLayerLeft().getSql() : "1=1");
        mapParam.put("{result}", params.getOutputFeatureSet());
        mapParam.put("{resultdb}", db + "/" + params.getOutputFeatureSet());
        for (Map.Entry kv : mapParam.entrySet()) {
            curParam = curParam.replace((CharSequence)kv.getKey(), (CharSequence)kv.getValue());
        }
        this.logger.info("atlas service url:" + intersectUrl + " param:" + curParam, new Object[0]);
        String result = HttpUtil.createPost((String)intersectUrl).body(curParam).execute().body();
        this.logger.info("atlas service url:" + intersectUrl + " http result: " + result, new Object[0]);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (resultJson.containsKey((Object)"code") && resultJson.getString("code").equals("200")) {
            String taskId = resultJson.getJSONObject("data").getString("taskId");
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                return taskId;
            }
            return null;
        }
        return null;
    }

    private String executeAtlasTaskIntersect(Atlas_Analysis_Param params, ObjectReference ref) throws Exception {
        String taskId;
        String atlasid = null;
        String createurl = this.atlasConfig.getTaskCreate();
        String HdfsAddress = this.atlasConfig.getHdfsBaseAddress();
        String resultDb = this.getDB();
        this.checkIntersectParams(params);
        if (StringUtils.isBlank((CharSequence)this.intersectWorkFlow)) {
            this.intersectWorkFlow = this.getTemplate();
        }
        ATLAS_WF_Intersect aw = new ATLAS_WF_Intersect(this.intersectWorkFlow, params, HdfsAddress, resultDb, resultDb);
        aw.init();
        JSONObject taskJson = aw.getWorkFlowParam();
        if (taskJson == null) {
            this.logger.error("\u521d\u59cb\u5316ATALS\u4efb\u52a1\u5931\u8d25", new Object[0]);
            return null;
        }
        String postStr = taskJson.toJSONString();
        postStr = "taskdata=[" + postStr + "]";
        String result = RequestUtil.sendPost((String)createurl, (String)postStr);
        ATLAS_HTTP_Output_Obj resultObj = (ATLAS_HTTP_Output_Obj)JSON.parseObject((String)result, ATLAS_HTTP_Output_Obj.class);
        if (resultObj == null) {
            ref.setTag("\u521b\u5efaATALS\u4efb\u52a1\u5931\u8d25");
            this.logger.error("\u521b\u5efaATALS\u4efb\u52a1\u5931\u8d25", new Object[0]);
            return null;
        }
        if (!resultObj.isFlag() || !resultObj.getMsg().equals("succeed")) {
            ref.setTag("\u521b\u5efaATALS\u4efb\u52a1\u5931\u8d25," + resultObj.getMsg());
            this.logger.error("\u521b\u5efaATALS\u4efb\u52a1\u5931\u8d25\uff0catlasid=" + atlasid + "," + resultObj.getMsg(), new Object[0]);
            return null;
        }
        atlasid = taskId = resultObj.getTaskid();
        this.logger.info("\u521b\u5efaATALS\u4efb\u52a1\u6210\u529f, atlasid=" + atlasid, new Object[0]);
        return atlasid;
    }

    private void checkIntersectParams(Atlas_Analysis_Param params) {
        String errorStr = "\u8f93\u5165\u7684ATLAS\u4efb\u52a1\u53c2\u6570\u6709\u8bef\uff01";
        if (params != null) {
            if (StringUtils.isNotBlank((CharSequence)params.getOutputFeatureSet())) {
                if (params.getLayerLeft() != null && StringUtils.isNotBlank((CharSequence)params.getLayerLeft().getFeatureSet())) {
                    if (params.getLayerRight() != null && StringUtils.isNotBlank((CharSequence)params.getLayerRight().getFeatureSet())) {
                        return;
                    }
                    errorStr = errorStr + "\u6bd4\u5bf9\u56fe\u5c421\u7684\u56fe\u5c42\u540d\u4e3a\u7a7a\uff01";
                } else {
                    errorStr = errorStr + "\u8f93\u5165\u7684\u6bd4\u5bf9\u56fe\u5c42\u6811\u5c0f\u4e8e2\uff01";
                }
            } else {
                errorStr = errorStr + "\u8f93\u51fa\u56fe\u5c42\u540d\u4e3a\u7a7a\uff01";
            }
        } else {
            errorStr = errorStr + "\u53c2\u6570\u4e3a\u7a7a\uff01";
        }
        throw new RuntimeException(errorStr);
    }

    private String getTemplate() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/overlay_template.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result = result + s;
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error("\u8bfb\u53d6\u53e0\u52a0\u5de5\u4f5c\u6d41\u5931\u8d25", new Object[]{ex});
            return null;
        }
    }

    private String getTemplateNew() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/intersect.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result = result + s;
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error("\u8bfb\u53d6\u53e0\u52a0\u5de5\u4f5c\u6d41\u5931\u8d25", new Object[]{ex});
            return null;
        }
    }

    private String getAtlasTaskStatus(String id) {
        try {
            SysConfig systemConfig = this.sysConfigRepository.queryByKey("shareConfig");
            if (systemConfig == null) {
                return "";
            }
            JSONObject confg = JSONObject.parseObject((String)systemConfig.getValue());
            String atlasUrl = confg.getString("atlasUrl") + "/atlas/task/get";
            return HttpConnectionUtil.httpget((String)(atlasUrl + "?id=" + id + "&thin=1"));
        }
        catch (Exception ex) {
            this.logger.error("", new Object[]{ex});
            return "";
        }
    }

    public Boolean deleteAtlasTask(String id) {
        try {
            String result = this.excuteCmd(this.atlasConfig.getTaskDelete(), id);
            JSONObject resultO = JSONObject.parseObject((String)result);
            String msg = resultO.getString("msg");
            Boolean flag = resultO.getBoolean("flag");
            if (!flag.booleanValue()) {
                this.logger.error("\u5220\u9664atlas\u4efb\u52a1:" + id + "\u5931\u8d25," + msg, new Object[0]);
            }
            return flag;
        }
        catch (Exception ex) {
            this.logger.error("\u5220\u9664atlas\u4efb\u52a1:" + id + "\u5931\u8d25", new Object[]{ex});
            return false;
        }
    }

    public Boolean stopAtlasTask(String id) {
        try {
            String result = this.excuteCmd(this.atlasConfig.getTaskStop(), id);
            JSONObject resultO = JSONObject.parseObject((String)result);
            String msg = resultO.getString("msg");
            Boolean flag = resultO.getBoolean("flag");
            if (!flag.booleanValue()) {
                this.logger.error("\u505c\u6b62atlas\u4efb\u52a1:" + id + "\u5931\u8d25," + msg, new Object[0]);
            }
            return flag;
        }
        catch (Exception ex) {
            this.logger.error("\u505c\u6b62atlas\u4efb\u52a1:" + id + "\u5931\u8d25", new Object[]{ex});
            return false;
        }
    }

    public boolean isTaskError(String atlasid) {
        int errorCount = 0;
        JSONObject resultO = null;
        for (int i = 0; i < 3; ++i) {
            String result = this.getAtlasTaskStatus(atlasid);
            resultO = JSONObject.parseObject((String)result);
            String state = resultO.getString("flag");
            Boolean flag = resultO.getBoolean("IsSucceed");
            Double progress = resultO.getDouble("Progress");
            if (!"finished".equalsIgnoreCase(state) || flag.booleanValue() || !(progress < 100.0)) continue;
            ++errorCount;
        }
        if (errorCount == 3) {
            this.logger.error("atlas\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0catlasid=" + atlasid + ",result:" + resultO.toJSONString(), new Object[0]);
            return true;
        }
        return false;
    }

    private String excuteCmd(String url, String id) {
        try {
            return HttpConnectionUtil.httpget((String)(url + "?id=" + id));
        }
        catch (Exception ex) {
            this.logger.error("", new Object[]{ex});
            return "";
        }
    }

    private String getDBAtlas() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        DruidDataSource druidDataSource = (DruidDataSource)dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split((String)url, (String)"?");
        url = urls[0];
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;
    }

    private String getDB() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        DruidDataSource druidDataSource = (DruidDataSource)dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split((String)url, (String)"?");
        url = StringUtils.replace((String)urls[0], (String)"jdbc:", (String)"");
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;
    }
}

