/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;

import com.geoway.landteam.customtask.dao.resultshare.ResultShareTaskDao;
import com.geoway.landteam.customtask.resultshare.pub.dto.ResultShareTaskInfoDto;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTask;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTaskDetail;
import com.geoway.landteam.customtask.service.resultshare.config.AtlasConfig;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MAnalysisTaskService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MAtlasTaskService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareTaskDetailService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareTaskService;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.mchange.v2.beans.BeansUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MResultShareTaskServiceImpl
implements MResultShareTaskService {
    private final GiLoger logger = GwLoger.getLoger(MResultShareTaskServiceImpl.class);
    @Resource
    private ResultShareTaskDao resultShareTaskDao;
    @Resource
    private MResultShareTaskDetailService resultShareTaskDetailService;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Autowired
    MAtlasTaskService atlasTaskService;
    @Autowired
    MAnalysisTaskService analysisTaskService;
    @Autowired
    AtlasConfig atlasConfig;

    public void delete(String id) {
        this.resultShareTaskDao.gwDeleteByPK((Serializable)((Object)id));
    }

    public int setDelete(String id) {
        return this.resultShareTaskDao.setDelete(id);
    }

    public void insert(ResultShareTask task) {
        this.resultShareTaskDao.gwAccess((GiEntitySaveable)task);
    }

    public ResultShareTask select(String id) {
        return (ResultShareTask)this.resultShareTaskDao.gwSearchByPK((Serializable)((Object)id));
    }

    public List<ResultShareTask> select(String taskId, String userId) {
        return this.resultShareTaskDao.selectByTaskIdAndUser(taskId, userId);
    }

    public List<ResultShareTaskInfoDto> selecteTaskInfo(String taskId, String userId) {
        ArrayList<ResultShareTaskInfoDto> dtos = new ArrayList<ResultShareTaskInfoDto>();
        List tasks = this.resultShareTaskDao.selectByTaskIdAndUser(taskId, userId);
        if (tasks != null) {
            for (ResultShareTask task : tasks) {
                ResultShareTaskInfoDto dto = new ResultShareTaskInfoDto();
                try {
                    BeansUtils.overwriteAccessibleProperties((Object)task, (Object)dto);
                }
                catch (Exception ex) {
                    this.logger.error("", new Object[]{ex});
                }
                dto.setDetailList(this.resultShareTaskDetailService.selectByAnalysisId(task.getId()));
                dtos.add(dto);
            }
        }
        return dtos;
    }

    public boolean updateStatus(String id, Short status) {
        return this.resultShareTaskDao.updateStatus(id, status) > 0;
    }

    public boolean startTask(String id, Short status, String msg) {
        return this.resultShareTaskDao.startTask(id, status, msg) > 0;
    }

    public boolean finishTask(String id, Short status, String msg) {
        return this.resultShareTaskDao.finishTask(id, status, msg) > 0;
    }

    public List<ResultShareTask> getDelete() {
        return this.resultShareTaskDao.getDelete();
    }

    public List<ResultShareTask> getRunning() {
        return this.resultShareTaskDao.getRunning();
    }

    public List<ResultShareTask> getCreate() {
        return this.resultShareTaskDao.getCreate();
    }

    public List<ResultShareTask> getAutoAttach() {
        return this.resultShareTaskDao.getAutoAttach();
    }

    public List<ResultShareTask> getDeleteByShard(int total, int index) {
        return this.resultShareTaskDao.getDeleteByShard(total, index);
    }

    public List<ResultShareTask> getRunningByShard(int total, int index) {
        return this.resultShareTaskDao.getRunningByShard(total, index);
    }

    public List<ResultShareTask> getCreateByShard(int total, int index) {
        return this.resultShareTaskDao.getCreateByShard(total, index);
    }

    public List<ResultShareTask> getAutoAttachByShard(int total, int index) {
        return this.resultShareTaskDao.getAutoAttachByShard(total, index);
    }

    public Boolean deleteWholeTask(ResultShareTask task) {
        List detailList = this.resultShareTaskDetailService.selectByAnalysisId(task.getId());
        if (detailList != null) {
            for (ResultShareTaskDetail detail : detailList) {
                String resultTable = detail.getResultname();
                String sql = "drop table IF EXISTS " + resultTable;
                this.jdbcTemplate.execute(sql);
                if (!StringUtils.isNotBlank((CharSequence)detail.getAtlasId())) continue;
                try {
                    if (this.atlasConfig.getUseAtlas().booleanValue()) {
                        this.atlasTaskService.deleteAtlasTask(detail.getAtlasId());
                        continue;
                    }
                    this.analysisTaskService.deleteAnalysisTask(detail.getAtlasId());
                }
                catch (Exception ex) {
                    this.logger.error("", new Object[]{ex});
                }
            }
            this.resultShareTaskDetailService.deleteByAnalysisId(task.getId());
        }
        this.resultShareTaskDao.gwDeleteByPK((Serializable)((Object)task.getId()));
        return true;
    }
}

