/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.resultshare.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.resultshare.ResultShareTemplateDao;
import com.geoway.landteam.customtask.resultshare.pub.dto.ResultShareTemplateParamDto;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTemplate;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareTemplateService;
import com.gw.base.data.GwValidateException;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MResultShareTemplateServiceImpl
implements MResultShareTemplateService {
    private final GiLoger logger = GwLoger.getLoger(MResultShareTemplateServiceImpl.class);
    @Resource
    private ResultShareTemplateDao templateDao;

    public void deleteByPrimaryKey(String id) {
        this.templateDao.gwDeleteByPK((Serializable)((Object)id));
    }

    public ResultShareTemplate selectByPrimaryKey(String id) {
        return (ResultShareTemplate)this.templateDao.gwSearchByPK((Serializable)((Object)id));
    }

    public String saveOne(ResultShareTemplateParamDto dto, long userId) throws Exception {
        String checkResult = this.checkDto(dto);
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            throw new GwValidateException(checkResult);
        }
        ResultShareTemplate template = new ResultShareTemplate();
        template.setName(dto.getName());
        template.setId(UUID.randomUUID().toString());
        template.setCreateTime(new Date());
        template.setCreateUserId(String.valueOf(userId));
        template.setTargetTaskId(dto.getTargetTaskId());
        template.setParam(JSONObject.toJSONString((Object)dto));
        this.templateDao.gwAccess((GiEntitySaveable)template);
        return template.getId();
    }

    private String checkDto(ResultShareTemplateParamDto template) {
        StringBuilder sb = new StringBuilder();
        if (template.getTranslateType() == null) {
            sb.append(" \u8f6c\u6362\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
        } else if (template.getTranslateType() < 1 || template.getTranslateType() > 3) {
            sb.append(" \u8f6c\u6362\u5185\u5bb9\u4e0d\u6b63\u786e\u3002 ");
        }
        if (template.getRate1() == null && template.getRate2() == null) {
            sb.append(" \u8f6c\u6362\u9762\u79ef\u5360\u6bd4\u4e0d\u6b63\u786e\u3002 ");
        } else {
            if (template.getRate1() != null && (template.getRate1() <= 0.0 || template.getRate1() >= 100.0)) {
                sb.append(" \u8f6c\u6362\u9762\u79ef\u5360\u6bd4\u4e0d\u6b63\u786e\u3002 ");
            }
            if (template.getRate2() != null && (template.getRate2() <= 0.0 || template.getRate2() >= 100.0)) {
                sb.append(" \u8f6c\u6362\u9762\u79ef\u5360\u6bd4\u4e0d\u6b63\u786e\u3002 ");
            }
        }
        if (StringUtils.isEmpty((CharSequence)template.getTargetTaskId())) {
            sb.append(" \u76ee\u6807\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
        }
        if (StringUtils.isEmpty((CharSequence)template.getName())) {
            sb.append(" \u5206\u4eab\u6210\u679c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
        }
        if (template.getSourceTaskList() == null || template.getSourceTaskList().isEmpty()) {
            sb.append(" \u5206\u4eab\u6210\u679c\u6e90\u4efb\u52a1\u4e3a\u7a7a\u3002 ");
        }
        return sb.toString();
    }

    public Map isTemplateNameExist(String templateName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        resultMap.put("isExist", false);
        resultMap.put("error", "");
        try {
            if (this.templateDao.countByName(templateName) > 0) {
                resultMap.put("isExist", true);
            } else {
                resultMap.put("isExist", false);
            }
            resultMap.put("result", true);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), new Object[]{e});
            resultMap.put("result", false);
            resultMap.put("error", e.getMessage());
        }
        return resultMap;
    }

    public List<ResultShareTemplate> selectByTaskid(String taskid) {
        return this.templateDao.selectByTaskid(taskid);
    }
}

