/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.task.TbtskObjectinfoDao;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.BizAreaRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.task.constants.UpResultEnum;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ExternalInterfaceService {
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    BizAreaRepository bizAreaRepository;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    RegionRepository regionDao;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbtskObjectinfoDao tbtskObjectinfoDao;

    public JSONObject findTbInfos(String taskId, String keyWord) {
        ArrayList<String> taskIds = new ArrayList<String>();
        taskIds.add(taskId);
        List tskTaskBizList = this.tskTaskBizRepository.findByIds(taskIds);
        if (ObjectUtils.isEmpty((Object)tskTaskBizList)) {
            throw new RuntimeException("taskId\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u8c03\u67e5\u4efb\u52a1\uff01");
        }
        TskTaskBiz tskTaskBiz = (TskTaskBiz)tskTaskBizList.get(0);
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        List fields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tableInfo.getfId());
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (TbtskFields item : fields) {
            if (item.getfFieldname().indexOf("f_shape") >= 0) continue;
            fieldNames.add(item.getfFieldname());
        }
        List uniqueFields = this.tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), Integer.valueOf(1));
        String sql = "select " + StringUtils.join(fieldNames, (String)",") + ",st_astext(f_shape) as f_shape from " + tableInfo.getfTablename() + " where " + ((TbtskFields)uniqueFields.get(0)).getfFieldname() + "='" + keyWord + "'";
        List tbs = this.jdbcTemplate.queryForList(sql);
        List medias = new ArrayList();
        ArrayList<String> gids = new ArrayList<String>();
        for (Map tb : tbs) {
            String lsId = tb.get("f_id").toString();
            gids.add(lsId);
        }
        if (gids.size() > 0) {
            medias = this.appMediaRepository.queryByGalleryids(gids);
            for (AppMedia media : medias) {
                String url = this.temporarySignedUrlService.getTemporarySignedUrl("", media.getServerpath(), null);
                media.setServerpath(url);
            }
        }
        JSONObject result = new JSONObject();
        result.put("tbInfos", (Object)tbs);
        result.put("medias", medias);
        return result;
    }

    public JSONObject importTaskData(JSONObject params) throws Exception {
        JSONObject resultObject = new JSONObject();
        String taskId = params.getString("taskId");
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new RuntimeException("taskId\u4e0d\u80fd\u4e3anull\uff01");
        }
        ArrayList<String> taskIds = new ArrayList<String>();
        taskIds.add(taskId);
        List tskTaskBizList = this.tskTaskBizRepository.findByIds(taskIds);
        if (ObjectUtils.isEmpty((Object)tskTaskBizList)) {
            throw new RuntimeException("taskId\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u8c03\u67e5\u4efb\u52a1\uff01");
        }
        TskTaskBiz tskTaskBiz = (TskTaskBiz)tskTaskBizList.get(0);
        List tbtskObjectinfoList = this.tbtskObjectinfoDao.getObjectbyTaskId(taskId);
        if (ObjectUtils.isEmpty((Object)tbtskObjectinfoList)) {
            throw new RuntimeException("taskId\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u8c03\u67e5\u4efb\u52a1\uff01");
        }
        TbtskObjectinfo tableInfo = (TbtskObjectinfo)tbtskObjectinfoList.get(0);
        JSONArray dataList = params.getJSONArray("dataList");
        if (dataList.size() <= 0) {
            throw new RuntimeException("dataList\u4e3anull\uff01");
        }
        ArrayList<Map<String, Object>> addDataCacheList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateDataCacheList = new ArrayList<Map<String, Object>>();
        List allFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tableInfo.getfId());
        List uniqueFields = this.tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), Integer.valueOf(1));
        List bizAreas = this.bizAreaRepository.queryByBizId(taskId);
        Set<String> areaCodes = bizAreas.stream().map(bizArea -> bizArea.getArea()).collect(Collectors.toSet());
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        ArrayList<String> add = new ArrayList<String>();
        ArrayList<String> update = new ArrayList<String>();
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject object = dataList.getJSONObject(i);
            Map<String, Object> result = this.saveData(object, tableInfo, addDataCacheList, updateDataCacheList, allFields, uniqueFields, areaCodes, defaultVersion);
            UpResultEnum r = (UpResultEnum)result.get("type");
            switch (r) {
                case ADD: {
                    add.add((String)result.get("f_id"));
                    break;
                }
                case UPDATE: {
                    update.add((String)result.get("f_id"));
                    break;
                }
                case SKIP: {
                    break;
                }
            }
            if (addDataCacheList.size() != 200) continue;
            this.dataBizService.insertDatasBatch(tableInfo.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        if (!addDataCacheList.isEmpty()) {
            this.dataBizService.insertDatasBatch(tableInfo.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        this.dataPackge(tskTaskBiz, add, update);
        resultObject.put("addData", add);
        resultObject.put("updateData", update);
        return resultObject;
    }

    private Map<String, Object> saveData(JSONObject object, TbtskObjectinfo table, List<Map<String, Object>> addDataList, List<Map<String, Object>> updateDataList, List<TbtskFields> allFields, List<TbtskFields> uniqueFields, Set<String> areaCodes, RegionVersion defaultVersion) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DecimalFormat format = new DecimalFormat("######0.0000000");
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap updateMap = new HashMap();
        String fieldName = "";
        String fieldType = "";
        String alias = "";
        StringBuilder stringBuilder = new StringBuilder();
        String f_shape = "";
        for (TbtskFields field : allFields) {
            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();
            fieldType = TskTaskBizDBUtil.getDBType((String)fieldType);
            alias = field.getfAlias();
            if (!object.containsKey((Object)fieldName)) continue;
            if ("f_shape".equals(fieldName)) {
                f_shape = object.getString(fieldName);
                Geometry geo = WKTUtil.wktToGeom((String)f_shape);
                map.put(fieldName, f_shape);
                map.put("f_shape1", f_shape);
                Point point = geo.getCentroid();
                if (point != null) {
                    map.put("f_lat", format.format(point.getY()));
                    map.put("f_lon", format.format(point.getX()));
                }
                Point pt = geo.getCentroid();
                int proNum = this.getColNum(pt.getX());
                HashMap<String, Object> map1 = this.getXzqdmSys((Geometry)pt, geo, proNum);
                map.put("f_xzqdm", map1.get("xzqdmsys").toString().substring(0, 6));
                map.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0, 4) + "00");
                map.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0, 6));
                if (map1.get("xzqdmsys").toString().length() >= 9) {
                    map.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0, 9));
                }
                map.put("f_xzqdmsys", map1.get("xzqdmsys"));
                map.put("f_tbmj", map1.get("area"));
                map.put("f_xzqmc1", map1.get("xzqmc"));
                result.put("xzqdm", map.get("f_xzqdm"));
                continue;
            }
            map.put(fieldName, object.get((Object)fieldName));
        }
        map.put("f_id", UUID.randomUUID().toString());
        map.put("f_status", "1");
        map.put("f_createtime", System.currentTimeMillis() + "");
        map.put("f_ismy", "0");
        List maps = new ArrayList();
        if (uniqueFields != null && !uniqueFields.isEmpty()) {
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append("select f_id from " + table.getfTablename() + " where 1=1 ");
            ArrayList values = new ArrayList(uniqueFields.size());
            for (TbtskFields tbtskFields : uniqueFields) {
                stringBuilder.append(" and ");
                stringBuilder.append(tbtskFields.getfFieldname());
                stringBuilder.append(" = ?");
                values.add(map.get(tbtskFields.getfFieldname()));
            }
            maps = this.jdbcTemplate.query(stringBuilder.toString(), values.toArray(new Object[0]), (RowMapper)new RowMapper<Map>(){

                public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, String> ha = new HashMap<String, String>();
                    rs.getString("f_id");
                    ha.put("f_id", rs.getString("f_id"));
                    return ha;
                }
            });
        }
        if (maps.isEmpty()) {
            result.put("f_id", map.get("f_id"));
            result.put("type", UpResultEnum.ADD);
            addDataList.add(map);
        } else {
            String fid = (String)((Map)maps.get(0)).get("f_id");
            result.put("f_id", fid);
            result.put("type", UpResultEnum.UPDATE);
            map.remove("f_id");
            this.dataBizService.updateData(table.getfTablename(), map, " f_id = '" + fid + "'");
        }
        return result;
    }

    public void dataPackge(TskTaskBiz task, List<String> add, List<String> update) {
        if (task != null && task.getMode() != null && ("1".equals(task.getType()) || 2 == task.getMode())) {
            TaskRecordTemp temp;
            ArrayList<TaskRecordTemp> tempList;
            if (add.size() > 0) {
                JSONObject additionJson = new JSONObject();
                additionJson.put("count", (Object)add.size());
                additionJson.put("addOrUpdate", (Object)"ADD");
                additionJson.put("taskMode", (Object)task.getMode());
                additionJson.put("curMode", (Object)"receive");
                String recordId = UUID.randomUUID().toString();
                TaskDataDbParameter parameter = new TaskDataDbParameter();
                parameter.setRecordId(recordId);
                parameter.setTaskId(task.getId());
                parameter.setGroups(new JSONArray());
                parameter.setOrgs(new JSONArray());
                parameter.setAddition(additionJson);
                parameter.setDate(String.valueOf(System.currentTimeMillis()));
                parameter.setMode(task.getMode().toString());
                tempList = new ArrayList<TaskRecordTemp>();
                for (int i = 0; i < add.size(); ++i) {
                    temp = new TaskRecordTemp();
                    temp.setId(UUID.randomUUID().toString());
                    temp.setRecordid(recordId);
                    temp.setDataid(add.get(i));
                    tempList.add(temp);
                }
                this.taskRecordService.saveTaskRecordTemp(tempList);
                TaskRecord record2 = new TaskRecord();
                record2.setId(recordId);
                record2.setParam(JSONObject.toJSONString((Object)parameter));
                record2.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record2.setStarttime(new Date());
                record2.setState(Integer.valueOf(1));
                record2.setUserid(Long.valueOf(101L));
                this.taskRecordService.save(record2);
            }
            if (update.size() > 0) {
                String recordId1 = UUID.randomUUID().toString();
                JSONObject additionJson1 = new JSONObject();
                additionJson1.put("count", (Object)update.size());
                additionJson1.put("addOrUpdate", (Object)"UPDATE");
                additionJson1.put("taskMode", (Object)task.getMode());
                additionJson1.put("curMode", (Object)"receive");
                TaskDataDbParameter parameter1 = new TaskDataDbParameter();
                parameter1.setRecordId(recordId1);
                parameter1.setTaskId(task.getId());
                parameter1.setGroups(new JSONArray());
                parameter1.setOrgs(new JSONArray());
                parameter1.setAddition(additionJson1);
                parameter1.setDate(String.valueOf(System.currentTimeMillis()));
                parameter1.setMode(task.getMode().toString());
                tempList = new ArrayList();
                for (int i = 0; i < update.size(); ++i) {
                    temp = new TaskRecordTemp();
                    temp.setId(UUID.randomUUID().toString());
                    temp.setRecordid(recordId1);
                    temp.setDataid(update.get(i));
                    tempList.add(temp);
                }
                this.taskRecordService.saveTaskRecordTemp(tempList);
                TaskRecord record1 = new TaskRecord();
                record1.setId(recordId1);
                record1.setParam(JSONObject.toJSONString((Object)parameter1));
                record1.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record1.setStarttime(new Date());
                record1.setState(Integer.valueOf(1));
                record1.setUserid(Long.valueOf(101L));
                this.taskRecordService.save(record1);
            }
        }
    }

    private HashMap<String, Object> getXzqdmSys(Geometry pt, Geometry geo, int proNum) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String wkt = WKTUtil.geomToWkt((Geometry)pt);
            String sql = "select * from ((select f_xzqdm as xzqdm,f_xzqmc as xzqmc,3 as level from tb_region where st_contains(shape, st_geomfromtext('" + wkt + "',4490)) and f_level =3  limit 1)\nunion\n(select xzqdm,xzqmc,4 as level from tb_region_town where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)\nunion\n(select xzqdm,xzqmc,5 as level from tb_region_village where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)) as q order by q.level";
            List maps = this.jdbcTemplate.queryForList(sql);
            Map region = null;
            Map regionTown = null;
            Map regionVillage = null;
            for (int i = 0; i < maps.size(); ++i) {
                Object xzqdm = ((Map)maps.get(i)).get("xzqdm");
                if (xzqdm == null) continue;
                if (xzqdm.toString().length() == 12) {
                    regionVillage = (Map)maps.get(i);
                    continue;
                }
                if (xzqdm.toString().length() == 9) {
                    regionTown = (Map)maps.get(i);
                    continue;
                }
                if (xzqdm.toString().length() != 6) continue;
                region = (Map)maps.get(i);
            }
            String location = "";
            String xzqdmsys = "";
            String xzqmc = "";
            if (regionVillage != null && regionVillage.get("xzqdm") != null) {
                xzqdmsys = regionVillage.get("xzqdm").toString();
                location = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
                String string = xzqmc = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
            }
            if (regionTown != null && regionTown.get("xzqdm") != null) {
                if (StringUtils.isBlank((CharSequence)xzqdmsys)) {
                    xzqdmsys = regionTown.get("xzqdm").toString() + "000";
                    xzqmc = regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "";
                }
                location = (regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "") + location;
            }
            if (region != null && region.get("xzqdm") != null) {
                if (StringUtils.isBlank((CharSequence)xzqdmsys)) {
                    xzqdmsys = region.get("xzqdm").toString() + "000000";
                    xzqmc = region.get("xzqmc") != null ? region.get("xzqmc").toString() : "" + location;
                }
                location = (region.get("xzqmc") != null ? region.get("xzqmc").toString() : "") + location;
            }
            String areasql = "select st_area(ST_Transform(ST_GeomFromText('" + WKTUtil.geomToWkt((Geometry)geo) + "',4490)," + proNum + "))/666.6666667 as area";
            Map areaMap = this.jdbcTemplate.queryForMap(areasql);
            String area = areaMap.get("area").toString();
            BigDecimal bigDecimal = new BigDecimal(Double.valueOf(area));
            map.put("area", bigDecimal);
            map.put("xzqdmsys", xzqdmsys);
            map.put("xzqmc", xzqmc);
            map.put("location", location);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return map;
    }

    private int getColNum(Double xLine) {
        int proNum = 2362;
        if (xLine >= 75.5 && xLine < 78.5) {
            proNum = 2353;
        } else if (xLine >= 78.5 && xLine < 81.5) {
            proNum = 2354;
        } else if (xLine >= 81.5 && xLine < 84.5) {
            proNum = 2355;
        } else if (xLine >= 84.5 && xLine < 87.5) {
            proNum = 2356;
        } else if (xLine >= 87.5 && xLine < 90.5) {
            proNum = 2357;
        } else if (xLine >= 90.5 && xLine < 93.5) {
            proNum = 2358;
        } else if (xLine >= 93.5 && xLine < 96.5) {
            proNum = 2359;
        } else if (xLine >= 96.5 && xLine < 99.5) {
            proNum = 2360;
        } else if (xLine >= 99.5 && xLine < 112.5) {
            proNum = 2361;
        } else if (xLine >= 112.5 && xLine < 115.5) {
            proNum = 2362;
        } else if (xLine > 115.5 && xLine < 118.5) {
            proNum = 2363;
        } else if (xLine > 118.5 && xLine < 121.5) {
            proNum = 2364;
        } else if (xLine > 121.5 && xLine < 124.5) {
            proNum = 2365;
        } else if (xLine > 124.5 && xLine < 127.5) {
            proNum = 2366;
        } else if (xLine > 127.5 && xLine < 130.5) {
            proNum = 2367;
        } else if (xLine > 130.5 && xLine < 133.5) {
            proNum = 2368;
        } else if (xLine > 133.5 && xLine < 136.5) {
            proNum = 2369;
        }
        return proNum;
    }
}

