/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtAssign;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtAssignRepository;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GjhtAssignService {
    private final GiLoger logger = GwLoger.getLoger(GjhtAssignService.class);
    @Autowired
    TbGjhtAssignRepository tbGjhtAssignRepository;
    @Value(value="${hbfzx.keyPublic}")
    protected String keyPublic;
    @Value(value="${hbfzx.keyPrivate}")
    protected String keyPrivate;
    @Value(value="${hbfzx.certCode}")
    protected String certCode;
    @Value(value="${hbfzx.gtUrl}")
    protected String gtUrl;
    @Value(value="${hbfzx.url}")
    private String url;
    @Value(value="${gjgty.obs}")
    private String gjObs;

    public String getGjObs() {
        return this.gjObs;
    }

    public boolean save(TbGjhtAssign tbGjhtAssign) {
        boolean flag = false;
        if (ObjectUtils.isNotEmpty((Object)tbGjhtAssign)) {
            TbGjhtAssign gjhtAssign = (TbGjhtAssign)this.tbGjhtAssignRepository.save((Object)tbGjhtAssign);
            flag = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)gjhtAssign.getId());
        }
        return flag;
    }

    public JSONObject saveData(String xLcSecret, String xLcToken, JSONObject parameter) {
        JSONObject returnJsonObject = new JSONObject();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPublic) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPrivate) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.gtUrl) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.url)) {
            System.out.println("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01");
            this.logger.info("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01", new Object[0]);
            returnJsonObject.put("code", (Object)"500");
            returnJsonObject.put("data", (Object)"");
            returnJsonObject.put("message", (Object)"\u5931\u8d25");
            returnJsonObject.put("traceid", (Object)"xxx");
            return returnJsonObject;
        }
        SM2 sm2 = new SM2(this.keyPrivate, this.keyPublic);
        String secretData = "base64";
        String data = this.getDecrypt(sm2, secretData, xLcSecret);
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        TbGjhtAssign tbGjhtAssign = new TbGjhtAssign();
        String code = parameter.getString("code");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)code), (String)"code \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setCode(code);
        String regioncode = parameter.getString("regioncode");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)regioncode), (String)"regioncode \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setXzqdm(regioncode);
        Integer version = parameter.getInteger("version");
        GutilAssert.state((version != null ? 1 : 0) != 0, (String)"parameter\u53c2\u6570\u4e2dversion \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setStatus(version);
        Integer size = parameter.getInteger("size");
        GutilAssert.state((size != null ? 1 : 0) != 0, (String)"parameter\u53c2\u6570\u4e2dsize \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setZip_len(size);
        Integer count = parameter.getInteger("count");
        GutilAssert.state((count != null ? 1 : 0) != 0, (String)"parameter\u53c2\u6570\u4e2dcount \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setNum(count);
        Integer attachment_count = parameter.getInteger("attachment_count");
        GutilAssert.state((attachment_count != null ? 1 : 0) != 0, (String)"parameter\u53c2\u6570\u4e2dattachment_count \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setClgs(attachment_count);
        String extension = parameter.getString("extension");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)extension), (String)"extension \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setZip_res(extension);
        String password = parameter.getString("password");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)password), (String)"password \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setZip_pwd(password);
        String hash = parameter.getString("hash");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)hash), (String)"hash \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setMd5(hash);
        Long timestamp = parameter.getLong("timestamp");
        GutilAssert.state((timestamp != null ? 1 : 0) != 0, (String)"parameter\u53c2\u6570\u4e2dtimestamp \u4e0d\u80fd\u4e3a\u7a7a!");
        Date timestampDate = new Date(timestamp);
        tbGjhtAssign.setXfsj(timestampDate);
        String url = parameter.getString("url");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)url), (String)"url \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setUrl(url);
        String sign = parameter.getString("sign");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)sign), (String)"sign \u4e0d\u80fd\u4e3a\u7a7a!");
        tbGjhtAssign.setSmc(sign);
        StringBuilder dataBuilder = new StringBuilder();
        if (ObjectUtils.isNotEmpty((Object)tbGjhtAssign)) {
            TbGjhtAssign gjhtAssign = (TbGjhtAssign)this.tbGjhtAssignRepository.save((Object)tbGjhtAssign);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)gjhtAssign.getId())) {
                returnJsonObject.put("code", (Object)"200");
                returnJsonObject.put("data", (Object)153);
                returnJsonObject.put("message", (Object)"\u6210\u529f");
                returnJsonObject.put("traceid", (Object)"xxx");
            } else {
                returnJsonObject.put("code", (Object)"500");
                returnJsonObject.put("data", (Object)"");
                returnJsonObject.put("message", (Object)"\u5931\u8d25");
                returnJsonObject.put("traceid", (Object)"xxx");
            }
        }
        sm2.usePlainEncoding();
        byte[] sm4Key = SecureUtil.generateKey((String)"SM4").getEncoded();
        String token = this.getToken(sm2);
        String secret = this.getSecret(sm2, sm4Key);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-lc-secret", secret);
        headerMap.put("x-lc-token", token);
        String returnJsonObjectData = returnJsonObject.toString();
        returnJsonObjectData = returnJsonObjectData.substring(1, returnJsonObjectData.length() - 1);
        String dataEncrypt = this.getEncrypt(returnJsonObjectData, sm4Key);
        HttpResponse httpResponse = ((HttpRequest)HttpUtil.createPost((String)(this.gtUrl + "/DataExchange/receiveDataPackage")).addHeaders(headerMap)).body("{" + dataEncrypt + "}").execute();
        return returnJsonObject;
    }

    public JSONObject register(String regioncode, String serviceurl, String contacts, String phone) throws Exception {
        JSONObject dataJson = new JSONObject();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)regioncode) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)serviceurl) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contacts) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)phone)) {
            System.out.println("\u6570\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01");
            this.logger.info("\u6570\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01", new Object[0]);
            return null;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPublic) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPrivate) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.gtUrl) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.url)) {
            System.out.println("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01");
            this.logger.info("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01", new Object[0]);
            return null;
        }
        serviceurl = this.url + serviceurl;
        SM2 sm2 = new SM2(this.keyPrivate, this.keyPublic);
        sm2.usePlainEncoding();
        byte[] sm4Key = SecureUtil.generateKey((String)"SM4").getEncoded();
        String token = this.getToken(sm2);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        String secret = this.getSecret(sm2, sm4Key);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)secret)) {
            return null;
        }
        dataJson.put("regioncode", (Object)regioncode);
        dataJson.put("serviceurl", (Object)serviceurl);
        dataJson.put("contacts", (Object)contacts);
        dataJson.put("phone", (Object)phone);
        System.out.println(" dataJson = " + dataJson.toString());
        String dataEncrypt2 = this.getEncrypt(dataJson.toJSONString(), sm4Key);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-lc-secret", secret);
        headerMap.put("x-lc-token", token);
        HttpResponse httpResponse = ((HttpRequest)HttpUtil.createPost((String)(this.gtUrl + "/DataExchange/RegistService")).contentType("application/json").addHeaders(headerMap)).body(dataEncrypt2).execute();
        if (ObjectUtils.isEmpty((Object)httpResponse)) {
            return null;
        }
        String result = httpResponse.body();
        System.out.println(" result : " + result);
        String xLcSecret = httpResponse.header("x-lc-secret");
        System.out.println(" xLcSecret : " + xLcSecret);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result) || result.indexOf("\"code\": 200") == -1 || result.indexOf("\"code\":200") == -1) {
            return null;
        }
        JSONObject resultJsonObject = JSONObject.parseObject((String)result);
        String rssultSecretData = "";
        if (ObjectUtils.isNotEmpty((Object)resultJsonObject) && ObjectUtils.isNotEmpty((Object)resultJsonObject.get((Object)"code")) && resultJsonObject.get((Object)"code").toString().equals("200") && ObjectUtils.isNotEmpty((Object)resultJsonObject.get((Object)"data"))) {
            rssultSecretData = resultJsonObject.get((Object)"data").toString();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)xLcSecret) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rssultSecretData)) {
            String data = this.getDecrypt(sm2, rssultSecretData, xLcSecret);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)xLcSecret)) {
                resultJsonObject.put("data", (Object)("{" + data + "}"));
            }
        }
        return resultJsonObject;
    }

    public JSONObject registerData(String registerCode, String[] includeXzqdms, String[] excludeXzqdms) throws Exception {
        JSONObject dataJson = new JSONObject();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerCode)) {
            System.out.println("\u6570\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01");
            this.logger.info("\u6570\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01", new Object[0]);
            return null;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPublic) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPrivate) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.gtUrl)) {
            System.out.println("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01");
            this.logger.info("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01", new Object[0]);
            return null;
        }
        SM2 sm2 = new SM2(this.keyPrivate, this.keyPublic);
        sm2.usePlainEncoding();
        byte[] sm4Key = SecureUtil.generateKey((String)"SM4").getEncoded();
        String token = this.getToken(sm2);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        String secret = this.getSecret(sm2, sm4Key);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)secret)) {
            return null;
        }
        StringBuilder dataBuilder = new StringBuilder();
        dataBuilder.append("\"code\"").append(":").append("\"" + registerCode + "\"");
        dataJson.put("code", (Object)registerCode);
        if (ObjectUtils.isNotEmpty((Object)includeXzqdms) && includeXzqdms.length > 0) {
            String inXzqdms = this.getXzqdmsData(includeXzqdms);
            dataBuilder.append(",").append("\"include_xzqdms\"").append(":").append("[").append(inXzqdms).append("]");
            dataJson.put("include_xzqdms", (Object)inXzqdms);
        }
        if (ObjectUtils.isNotEmpty((Object)excludeXzqdms) && excludeXzqdms.length > 0) {
            String exXzqdms = this.getXzqdmsData(excludeXzqdms);
            dataBuilder.append(",").append("\"include_xzqdms\"").append(":").append("[").append(exXzqdms).append("]");
            dataJson.put("include_xzqdms", (Object)exXzqdms);
        }
        String dataEncrypt1 = this.getEncrypt(dataBuilder.toString(), sm4Key);
        String dataEncrypt2 = this.getEncrypt(dataJson.toJSONString(), sm4Key);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-lc-secret", secret);
        headerMap.put("x-lc-token", token);
        HttpResponse httpResponse = ((HttpRequest)HttpUtil.createPost((String)(this.gtUrl + "/DataExchange/RegistDataCode")).addHeaders(headerMap)).body("{" + dataEncrypt1 + "}").execute();
        if (ObjectUtils.isEmpty((Object)httpResponse)) {
            return null;
        }
        String result = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");
        JSONObject resultJsonObject = JSONObject.parseObject((String)result);
        String rssultSecretData = "";
        if (ObjectUtils.isNotEmpty((Object)resultJsonObject) && ObjectUtils.isNotEmpty((Object)resultJsonObject.get((Object)"code")) && resultJsonObject.get((Object)"code").toString().equals("200") && ObjectUtils.isNotEmpty((Object)resultJsonObject.get((Object)"data"))) {
            rssultSecretData = resultJsonObject.get((Object)"data").toString();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)xLcSecret) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rssultSecretData)) {
            String data = this.getDecrypt(sm2, rssultSecretData, xLcSecret);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)xLcSecret)) {
                resultJsonObject.put("data", (Object)data);
            }
        }
        return resultJsonObject;
    }

    public String getToken(SM2 sm2) {
        String token = "";
        if (ObjectUtils.isEmpty((Object)sm2) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.certCode) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPublic) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPrivate)) {
            this.logger.info("token \u751f\u6210\u5931\u8d25\uff01", new Object[0]);
            return "";
        }
        long timestamp = System.currentTimeMillis();
        String needSignData = this.certCode + timestamp;
        byte[] needSignDataByte = needSignData.getBytes(StandardCharsets.UTF_8);
        byte[] signData = sm2.sign(needSignDataByte);
        String signDataBase64 = Base64.encode((byte[])signData);
        System.out.println("sign Base64:" + signDataBase64);
        token = this.certCode + "." + timestamp + "." + signDataBase64;
        System.out.println("token:" + token);
        return token;
    }

    public String getSecret(SM2 sm2, byte[] sm4Key) {
        String secret = "";
        if (ObjectUtils.isEmpty((Object)sm2) || ObjectUtils.isEmpty((Object)sm4Key) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.keyPublic)) {
            return "";
        }
        byte[] sm2EncryptDataByte = sm2.encrypt(sm4Key, KeyType.PublicKey);
        System.out.println("SM2 encrypt Base64:" + Base64.encode((byte[])sm2EncryptDataByte));
        secret = Base64.encode((byte[])sm2EncryptDataByte);
        return secret;
    }

    public String getEncrypt(String data, byte[] sm4Key) {
        String encryptData = "";
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)data) || ObjectUtils.isEmpty((Object)sm4Key)) {
            return "";
        }
        SM4 sm4 = new SM4(sm4Key);
        byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
        byte[] sm4EncryptDataByte = sm4.encrypt(dataByte);
        System.out.println("SM4 encrypt Base64:" + Base64.encode((byte[])sm4EncryptDataByte));
        encryptData = Base64.encode((byte[])sm4EncryptDataByte);
        return encryptData;
    }

    public String getDecrypt(SM2 sm2, String base64Data, String base64Secret) {
        byte[] encryptDataByte;
        String data = "";
        if (ObjectUtils.isEmpty((Object)sm2) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)base64Data) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)base64Secret)) {
            return "";
        }
        byte[] sm2EncryptDataByte = Base64.decode((CharSequence)base64Secret);
        byte[] sm4KeyByte = sm2.decrypt(sm2EncryptDataByte, KeyType.PrivateKey);
        SM4 sm4Me = new SM4(sm4KeyByte);
        byte[] sm4DataByteMe = sm4Me.decrypt(encryptDataByte = Base64.decode((CharSequence)base64Data));
        if (ObjectUtils.isNotEmpty((Object)sm4DataByteMe)) {
            data = new String(sm4DataByteMe, StandardCharsets.UTF_8);
        }
        return data;
    }

    private String getXzqdmsData(String[] xzqdms) {
        if (ObjectUtils.isEmpty((Object)xzqdms)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < xzqdms.length; ++i) {
            builder.append("\"").append(xzqdms[i]).append("\",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public String getKeyPublic() {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.keyPublic)) {
            return this.keyPublic;
        }
        return "";
    }

    public String getKeyPrivate() {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.keyPrivate)) {
            return this.keyPrivate;
        }
        return "";
    }

    public String getGtUrl() {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.gtUrl)) {
            return this.gtUrl;
        }
        return "";
    }

    public String getUrl() {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.url)) {
            return this.url;
        }
        return "";
    }

    public String getCertCode() {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.certCode)) {
            return this.certCode;
        }
        return "";
    }
}

