/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDJQ;
import com.geoway.landteam.landcloud.core.repository.base.RegionDJQRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MCommonService {
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    RegionDJQRepository regionDJQRepository;

    public String GeneratoeSeq(String prefix, int numLength) {
        int Suffix;
        String upperCode = "";
        Long size = this.redisTemplate.opsForList().size((Object)prefix);
        if (size > 0L) {
            List leve = this.redisTemplate.opsForList().range((Object)prefix, 0L, -1L);
            upperCode = leve.get(leve.size() - 1).toString();
        }
        String returnCode = "";
        if (StringUtils.isNotBlank((CharSequence)upperCode)) {
            String sequence = upperCode.substring(prefix.length());
            Suffix = Integer.parseInt(sequence);
            ++Suffix;
        } else {
            Suffix = 1;
        }
        returnCode = prefix + String.format("%0" + numLength + "d", Suffix);
        this.redisTemplate.opsForList().rightPush((Object)prefix, (Object)returnCode);
        System.out.println(returnCode + "%%%");
        return returnCode;
    }

    public JSONObject generatorSeqByBizId(String bizId, String type, Double x, Double y) throws Exception {
        String wkt;
        List villages;
        JSONObject json = new JSONObject();
        String gen = null;
        String villageCode = null;
        String name = null;
        TskTaskBiz biz = this.mTskTaskBizService.findByTaskId(bizId);
        if (biz.getGranularity() != null && 5 == biz.getGranularity() && (villages = this.regionDJQRepository.queryContains(WKTUtil.wktToGeom((String)(wkt = String.format("POINT (%s %s)", x, y))))) != null && villages.size() > 0) {
            villageCode = ((RegionDJQ)villages.get(0)).getCode();
            name = ((RegionDJQ)villages.get(0)).getName();
            gen = this.mTskTaskBizService.generatorSeqByXzqdm(bizId, type, villageCode, biz.getTableId(), null);
        }
        json.put("xzqdm", villageCode);
        json.put("xzqmc", name);
        json.put("tbbh", gen);
        return json;
    }
}

