/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.pub.dto.ApproveRecordDTO;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskApproveRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFlowDefRepository;
import com.geoway.landteam.customtask.repository.task.TbtskGroupRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskRejectRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskSubmitReportRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.task.enm.FlowTypeEnum;
import com.geoway.landteam.customtask.task.enm.RejectTypeEnum;
import com.geoway.landteam.customtask.task.enm.UserRoleEnum;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TbtskApproveRecord;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskFlowDef;
import com.geoway.landteam.customtask.task.entity.TbtskGroup;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskRejectDef;
import com.geoway.landteam.customtask.task.entity.TbtskRejectRecord;
import com.geoway.landteam.customtask.task.entity.TbtskRevokeRecord;
import com.geoway.landteam.customtask.task.entity.TbtskSubmitReportRecord;
import com.geoway.landteam.customtask.task.entity.TbtskSuperUserAuditArea;
import com.geoway.landteam.customtask.task.entity.TbtskUserAuditArea;
import com.geoway.landteam.customtask.task.entity.TbtskUserManageArea;
import com.geoway.landteam.customtask.task.entity.TbtskUserReviewArea;
import com.geoway.landteam.customtask.task.entity.TbtskUserUploadArea;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.UserBiz2;
import com.geoway.landteam.customtask.util.FlowFilterUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.MapUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.pub.impl.EnumeratorValueServiceImpl;
import com.geoway.landteam.landcloud.core.service.pub.impl.SystemConfigCacheService;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskRejectDefService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskRevokeRecordService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskSuperUserAuditAreaService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserAuditAreaService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserManageAreaService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserReviewAreaService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserUploadAreaService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskNoticeNewService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskNoticeService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.javatuples.Triplet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MConfigTaskReviewService {
    private static final GiLoger log = GwLoger.getLoger();
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    SystemConfigCacheService systemConfigCacheService;
    @Autowired
    TbtskFlowDefRepository tbtskFlowDefRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Autowired
    TbtskSubmitReportRecordRepository tbtskSubmitReportRecordRepository;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TbtskRejectRecordRepository tbtskRejectRecordRepository;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    MTaskNoticeService mTaskNoticeService;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    MTbtskRejectDefService mTbtskRejectDefService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    MTaskRecordService mTaskRecordService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    TbtskGroupRepository tbtskGroupRepository;
    @Autowired
    MTbtskUserReviewAreaService mTbtskUserReviewAreaService;
    @Autowired
    MTbtskUserUploadAreaService tbtskUserUploadAreaService;
    @Autowired
    MTbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    MTbtskSuperUserAuditAreaService tbtskSuperUserAuditAreaService;
    @Autowired
    MTbtskRevokeRecordService tbtskRevokeRecordService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    MTbtskUserManageAreaService tbtskUserManageAreaService;
    @Autowired
    LandUserService landUserService;
    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;
    @Autowired
    EnumeratorDomainService enumeratorDomainService;
    @Autowired
    EnumeratorValueServiceImpl enumeratorValueService;

    public String operatorSubmit(String taskId, String tbIds, String type, Long userId) {
        String result = "\u63d0\u62a5\u6210\u529f";
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)tbIds), (String)"tbIds \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        boolean isBatch = tbIds.contains(",");
        if (isBatch) {
            JSONObject params = new JSONObject();
            params.put("filterType", (Object)"checkFilter");
            params.put("userId", (Object)userId);
            params.put("tbIds", (Object)tbIds);
            this.addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_SUBMIT_BATCH, taskId);
        } else {
            result = this.operatorSubmit(taskId, tbIds, userId);
        }
        return result;
    }

    public static void getZjggFieldNameCollection(List<String> fieldNameList) {
        fieldNameList.add("f_zzzb");
        fieldNameList.add("f_xzgdmj");
        fieldNameList.add("f_qtnydmj");
        fieldNameList.add("f_zgmj");
        fieldNameList.add("f_zgfa");
    }

    private String operatorSubmit(String taskId, String tbId, Long userId) {
        Map data;
        List<String> conditionNotNullRelatedFieldNames;
        String result = "";
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            result = "\u63d0\u62a5\u5931\u8d25\uff0c\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664";
            return result;
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            result = "\u63d0\u62a5\u5931\u8d25\uff0c\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664";
            return result;
        }
        List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
        List<TbtskFields> requiredFields = this.queryRequiredFields(tbtskObjectinfo.getfId());
        if (requiredFields != null && requiredFields.size() > 0) {
            requiredFields.forEach(a -> fieldNameList.add(a.getfFieldname()));
        }
        if (!GutilCollection.isEmpty(conditionNotNullRelatedFieldNames = this.queryConditionNotNullRelatedFieldNames(tbtskObjectinfo.getfTablename()))) {
            fieldNameList.addAll(conditionNotNullRelatedFieldNames);
        }
        if (null == (data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'"))) {
            result = "\u63d0\u62a5\u5931\u8d25\uff0c\u56fe\u6591\u4e0d\u5b58\u5728";
            return result;
        }
        Integer status = MapUtils.getInteger((Map)data, (Object)"f_status");
        String xzqdm = MapUtils.getString((Map)data, (Object)"f_xzqdmsys");
        Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
        if (status != null) {
            if (status >= TbStatusEnum.SUBMIT.getCode() && status < TbStatusEnum.WAITING_VERIFY.getCode() || status.intValue() == TbStatusEnum.INIT.getCode()) {
                Triplet checkResult = this.checkDataBeforeSubmit(data, tbtskObjectinfo, taskId);
                if (((Boolean)checkResult.getValue0()).booleanValue()) {
                    ReviewStageEnum reviewStage = this.getFirstStageOfFlow(taskId);
                    String updateSql = "f_status= " + TbStatusEnum.WAITING_VERIFY.getCode() + " ,f_reject_status= 0 ,f_review_stage=" + reviewStage.getCode();
                    int row = this.mDataBizService.updateBySql(tbtskObjectinfo.getfTablename(), updateSql, "f_id ='" + tbId + "'");
                    if (row == 1) {
                        this.saveConfigTaskSubmitReportRecord(taskId, tbId, xzqdm, rejectCount, userId);
                        result = "\u63d0\u62a5\u6210\u529f";
                    } else {
                        result = "\u63d0\u62a5\u5931\u8d25";
                    }
                } else {
                    String error = (String)checkResult.getValue2();
                    result = StringUtils.isNotBlank((CharSequence)error) ? "\u63d0\u62a5\u5931\u8d25:" + error : "\u63d0\u62a5\u5931\u8d25";
                }
            } else {
                result = "\u63d0\u62a5\u5931\u8d25\uff0c\u56fe\u6591\u5df2\u63d0\u62a5\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u62a5";
            }
        } else {
            ReviewStageEnum reviewStage = this.getFirstStageOfFlow(taskId);
            String updateSql = "f_status= " + TbStatusEnum.WAITING_VERIFY.getCode() + " ,f_reject_status= 0 ,f_review_stage=" + reviewStage.getCode();
            int row = this.mDataBizService.updateBySql(tbtskObjectinfo.getfTablename(), updateSql, "f_id ='" + tbId + "'");
            if (row == 1) {
                this.saveConfigTaskSubmitReportRecord(taskId, tbId, xzqdm, rejectCount, userId);
                result = "\u63d0\u62a5\u6210\u529f";
            } else {
                result = "\u63d0\u62a5\u5931\u8d25";
            }
        }
        return result;
    }

    private Triplet<Boolean, String, String> checkConditionNotNullFields(Map map, String tableName) {
        HashMap remap = new HashMap();
        ArrayList<String> errorList = new ArrayList<String>();
        List<TbtskGroup> tbtskGroupList = this.queryConditionRequiredFields(tableName);
        if (!GutilCollection.isEmpty(tbtskGroupList)) {
            try {
                JSONObject connJsonObj = null;
                JSONArray refJsonArray = null;
                JSONArray effectsJsonArray = null;
                JSONObject refSingleJsonObj = null;
                JSONObject effectSingleJsonObj = null;
                JSONObject correctCheckJsonObj = null;
                JexlBuilder jexlB = new JexlBuilder();
                MapContext jc = new MapContext();
                for (TbtskGroup tbtskGroup : tbtskGroupList) {
                    connJsonObj = JSONObject.parseObject((String)tbtskGroup.getConnection());
                    if (null == connJsonObj || null == (refJsonArray = JSONArray.parseArray((String)JSONArray.toJSONString((Object)connJsonObj.get((Object)"ref")), (Feature[])new Feature[0]))) continue;
                    for (Object obj : refJsonArray) {
                        refSingleJsonObj = JSONObject.parseObject((String)JSONArray.toJSONString(obj));
                        if (null == refSingleJsonObj || null == (effectsJsonArray = JSONArray.parseArray((String)JSONArray.toJSONString((Object)refSingleJsonObj.get((Object)"effects")), (Feature[])new Feature[0]))) continue;
                        for (Object effectObj : effectsJsonArray) {
                            effectSingleJsonObj = JSONObject.parseObject((String)JSONArray.toJSONString(effectObj));
                            if (null == effectSingleJsonObj || effectSingleJsonObj.getIntValue("required") != 1) continue;
                            HashMap<String, Object> valueMap = new HashMap<String, Object>();
                            String[] fields = refSingleJsonObj.getString("fields").split(",");
                            for (int i = 0; i < fields.length; ++i) {
                                valueMap.put(fields[i], map.get(fields[i]));
                            }
                            Object o = this.evaluateExpression(jexlB, (JexlContext)jc, refSingleJsonObj.getString("condition"), valueMap);
                            if (!((Boolean)o).booleanValue() || map.get(effectSingleJsonObj.get((Object)"targetFiled").toString()) != null && StringUtils.isNotBlank((CharSequence)map.get(effectSingleJsonObj.get((Object)"targetFiled").toString()).toString())) continue;
                            String errorMsg = " \u503c\u4e0d\u7b26\u5408\u8981\u6c42";
                            correctCheckJsonObj = JSONObject.parseObject((String)refSingleJsonObj.getString("correctCheck"));
                            if (null != correctCheckJsonObj && correctCheckJsonObj.containsKey((Object)"errorMessage") && StringUtils.isNotBlank((CharSequence)correctCheckJsonObj.getString("errorMessage")) && !"null".equalsIgnoreCase(correctCheckJsonObj.getString("errorMessage"))) {
                                errorMsg = correctCheckJsonObj.getString("errorMessage");
                            }
                            errorList.add(tbtskGroup.getfAlias() + errorMsg);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage(), new Object[0]);
                }
                errorList.add("\u4e0d\u7b26\u5408\u6761\u4ef6\u5fc5\u586b\u8981\u6c42" + e.getMessage());
            }
        }
        if (!GutilCollection.isEmpty(errorList)) {
            return new Triplet((Object)false, (Object)map.get("f_id").toString(), (Object)StringUtils.join(errorList, (CharSequence)","));
        }
        return new Triplet((Object)true, (Object)map.get("f_id").toString(), (Object)"");
    }

    private Object evaluateExpression(JexlBuilder jexlB, JexlContext jexlContext, String jexlExp, HashMap<String, Object> map) {
        JexlEngine jexl = jexlB.create();
        JexlExpression e = jexl.createExpression(jexlExp);
        for (String key : map.keySet()) {
            jexlContext.set(key, map.get(key));
        }
        return e.evaluate(jexlContext);
    }

    private List<TbtskFields> queryRequiredFields(String tableId) {
        List notNullFieldList = this.tbtskFieldsRepository.queryNotNullFieldsByTableId(tableId);
        return notNullFieldList;
    }

    private List<TbtskGroup> queryConditionRequiredFields(String tableName) {
        return this.tbtskGroupRepository.queryConditionNotNullFields(tableName);
    }

    private List<String> queryConditionNotNullRelatedFieldNames(String tableName) {
        HashSet<String> result;
        block6: {
            result = new HashSet<String>();
            List<TbtskGroup> tbtskGroupList = this.queryConditionRequiredFields(tableName);
            if (!GutilCollection.isEmpty(tbtskGroupList)) {
                JSONObject connJsonObj = null;
                JSONArray refJsonArray = null;
                JSONArray effectsJsonArray = null;
                JSONObject refSingleJsonObj = null;
                JSONObject effectSingleJsonObj = null;
                try {
                    for (TbtskGroup tbtskGroup : tbtskGroupList) {
                        connJsonObj = JSONObject.parseObject((String)tbtskGroup.getConnection());
                        if (null == connJsonObj || null == (refJsonArray = JSONArray.parseArray((String)JSONArray.toJSONString((Object)connJsonObj.get((Object)"ref")), (Feature[])new Feature[0]))) continue;
                        for (Object obj : refJsonArray) {
                            refSingleJsonObj = JSONObject.parseObject((String)JSONArray.toJSONString(obj));
                            if (null == refSingleJsonObj || null == (effectsJsonArray = JSONArray.parseArray((String)JSONArray.toJSONString((Object)refSingleJsonObj.get((Object)"effects")), (Feature[])new Feature[0]))) continue;
                            for (Object effectObj : effectsJsonArray) {
                                effectSingleJsonObj = JSONObject.parseObject((String)JSONArray.toJSONString(effectObj));
                                if (null == effectSingleJsonObj || effectSingleJsonObj.getIntValue("required") != 1) continue;
                                result.add(effectSingleJsonObj.getString("targetFiled"));
                                if (result.contains(result.add(refSingleJsonObj.getString("fields")))) continue;
                                result.add(refSingleJsonObj.getString("fields"));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error(e.getMessage(), new Object[0]);
                }
            }
        }
        return result.stream().collect(Collectors.toList());
    }

    private ReviewStageEnum getFirstStageOfFlow(String taskId) {
        JSONObject jsonObject;
        Object firstStepObj;
        JSONArray jsonArray;
        TbtskFlowDef flowDef;
        List flowDefList = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, Integer.valueOf(FlowTypeEnum.AUDIT.getCode()));
        if (!GutilCollection.isEmpty((Collection)flowDefList) && StringUtils.isNotBlank((CharSequence)(flowDef = (TbtskFlowDef)flowDefList.get(0)).getSteps()) && (jsonArray = JSONArray.parseArray((String)flowDef.getSteps(), (Feature[])new Feature[0])) != null && !jsonArray.isEmpty() && (firstStepObj = jsonArray.get(0)) != null && (jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)firstStepObj))) != null && jsonObject.containsKey((Object)"name") && StringUtils.isNotBlank((CharSequence)jsonObject.get((Object)"name").toString())) {
            switch (jsonObject.get((Object)"name").toString()) {
                case "\u6751\u7ea7\u5ba1\u6838": {
                    return ReviewStageEnum.VILLAGE_VERIFY;
                }
                case "\u4e61\u9547\u5ba1\u6838": {
                    return ReviewStageEnum.TOWN_VERIFY;
                }
                case "\u533a\u53bf\u5ba1\u6838": {
                    return ReviewStageEnum.COUNTY_VERIFY;
                }
                case "\u5e02\u7ea7\u5ba1\u6838": {
                    return ReviewStageEnum.CITY_VERIFY;
                }
                case "\u7701\u7ea7\u5ba1\u6838": {
                    return ReviewStageEnum.PROVINCE_VERIFY;
                }
                case "\u56fd\u5bb6\u5ba1\u6838": {
                    return ReviewStageEnum.COUNTRY_VERIFY;
                }
            }
            return ReviewStageEnum.VILLAGE_VERIFY;
        }
        return ReviewStageEnum.VILLAGE_VERIFY;
    }

    private void saveConfigTaskSubmitReportRecord(String taskId, String id, String xzqdm, Integer rejectCount, Long userId) {
        TbtskSubmitReportRecord submitReportRecord = TbtskSubmitReportRecord.builder().taskid(taskId).dataid(id).submitTime(new Date()).submitUserid(userId).xzqdm(xzqdm).rejectCount(rejectCount).build();
        this.tbtskSubmitReportRecordRepository.save((Object)submitReportRecord);
    }

    public static List<String> getAuditFieldNameCollection() {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        fieldNameList.add("f_id");
        fieldNameList.add("f_status");
        fieldNameList.add("f_xzqdmsys");
        fieldNameList.add("f_reject_status");
        fieldNameList.add("f_review_stage");
        fieldNameList.add("f_reject_count");
        return fieldNameList;
    }

    public Triplet checkDataBeforeSubmit(Map data, TbtskObjectinfo tbtskObjectinfo, String taskId) {
        Triplet<Boolean, String, String> tempResult;
        List<TbtskFields> requiredFields;
        ArrayList<Object> errorList = new ArrayList<Object>();
        if (data.get("f_id") == null || StringUtils.isBlank((CharSequence)data.get("f_id").toString())) {
            errorList.add("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u4e14id\u4e0d\u80fd\u4e3a\u7a7a");
            return new Triplet((Object)false, (Object)"", (Object)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u4e14id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)data.get("f_xzqdmsys").toString())) {
            errorList.add("\u653f\u533a\u4ee3\u7801 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        List appMedias = this.appMediaRepository.queryByGid(data.get("f_id").toString());
        SysConfig sysConfig = this.sysConfigService.findOne("scgtyCheckAttr");
        if (sysConfig != null) {
            if (!sysConfig.getValue().contains(taskId) && appMedias.size() <= 0) {
                errorList.add("\u7f3a\u5931\u9644\u4ef6");
            }
        } else if (appMedias.size() <= 0) {
            errorList.add("\u7f3a\u5931\u9644\u4ef6");
        }
        if ((requiredFields = this.queryRequiredFields(tbtskObjectinfo.getfId())) != null && requiredFields.size() > 0) {
            for (TbtskFields tbtskFields : requiredFields) {
                if (!data.containsKey(tbtskFields.getfFieldname())) {
                    errorList.add(tbtskFields.getfAlias() + "\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                if (data.get(tbtskFields.getfFieldname()) != null && !StringUtils.isBlank((CharSequence)data.get(tbtskFields.getfFieldname()).toString())) continue;
                errorList.add(tbtskFields.getfAlias() + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!((Boolean)(tempResult = this.checkConditionNotNullFields(data, tbtskObjectinfo.getfTablename())).getValue0()).booleanValue()) {
            errorList.add(tempResult.getValue2());
        }
        if (!GutilCollection.isEmpty(errorList)) {
            return new Triplet((Object)false, (Object)data.get("f_id").toString(), (Object)StringUtils.join(errorList, (CharSequence)","));
        }
        return new Triplet((Object)true, (Object)data.get("f_id").toString(), (Object)"");
    }

    public void addTaskRecord(JSONObject params, Long userId, Integer taskType, String bizId) {
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(taskType);
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        record.setBizId(bizId);
        this.mTaskRecordService.save(record);
    }

    public List<ApproveRecordDTO> findApproveRecord(String taskId, String tbId, String type, Long UserId, Integer userRole) {
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        ArrayList<ApproveRecordDTO> resultList = new ArrayList();
        UserRoleEnum roleEnum = this.getUserRoleWithPriority(taskId, UserId, userRole);
        switch (roleEnum.getCode()) {
            case 3: {
                resultList = this.getRejectRecords(taskId, tbId);
                break;
            }
            default: {
                resultList = this.getApproveRecordsAndRejectRecords(taskId, tbId);
            }
        }
        if (!GutilCollection.isEmpty(resultList)) {
            Collections.sort(resultList, new Comparator<ApproveRecordDTO>(){

                @Override
                public int compare(ApproveRecordDTO o1, ApproveRecordDTO o2) {
                    int flag = o2.getApproveTime().compareTo(o1.getApproveTime());
                    return flag;
                }
            });
        }
        return resultList;
    }

    private UserRoleEnum getUserRoleWithPriority(String taskId, Long userId, Integer priorityRole) {
        Integer tempRole = Integer.MAX_VALUE;
        List userBiz2List = this.userBiz2Repository.findByUserIdAndBizId(userId, taskId);
        if (!GutilCollection.isEmpty((Collection)userBiz2List)) {
            boolean existPriorityRole = false;
            if (priorityRole != null) {
                existPriorityRole = userBiz2List.stream().filter(role -> role.getRole().equals(priorityRole)).findAny().isPresent();
            }
            if (existPriorityRole) {
                tempRole = priorityRole;
            } else {
                for (UserBiz2 userBiz2 : userBiz2List) {
                    if (userBiz2.getRole() == 4) {
                        if (tempRole != 3) continue;
                        tempRole = 4;
                        continue;
                    }
                    if (userBiz2.getRole() >= tempRole) continue;
                    tempRole = userBiz2.getRole();
                }
            }
        }
        if (tempRole != Integer.MAX_VALUE) {
            return UserRoleEnum.getEnum((int)tempRole);
        }
        return UserRoleEnum.UNDEFINED;
    }

    private List<ApproveRecordDTO> getRejectRecords(String taskId, String tbId) {
        ArrayList<ApproveRecordDTO> resultList = new ArrayList<ApproveRecordDTO>();
        List rejectRecords = this.tbtskRejectRecordRepository.findByTaskIdAndTbId(taskId, tbId);
        if (!GutilCollection.isEmpty((Collection)rejectRecords)) {
            for (TbtskRejectRecord rejectRecord : rejectRecords) {
                if (!rejectRecord.getTargetStage().equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) continue;
                ApproveRecordDTO approveRecord = this.convertRejectRecord2ApproveRecordDTO(rejectRecord);
                resultList.add(approveRecord);
            }
        }
        return resultList;
    }

    private List<ApproveRecordDTO> getApproveRecordsAndRejectRecords(String taskId, String tbId) {
        List revokeRecords;
        List rejectRecords;
        ArrayList<ApproveRecordDTO> resultList = new ArrayList<ApproveRecordDTO>();
        List approveRecords = this.tbtskApproveRecordRepository.findApproveRecordOrderByTime(taskId, tbId);
        if (!GutilCollection.isEmpty((Collection)approveRecords)) {
            for (Object tbtskApproveRecord : approveRecords) {
                ApproveRecordDTO approveRecord = this.convertApproveRecord2ApproveRecordDTO((TbtskApproveRecord)tbtskApproveRecord);
                resultList.add(approveRecord);
            }
        }
        if (!GutilCollection.isEmpty((Collection)(rejectRecords = this.tbtskRejectRecordRepository.findByTaskIdAndTbId(taskId, tbId)))) {
            for (TbtskRejectRecord rejectRecord : rejectRecords) {
                ApproveRecordDTO approveRecord = this.convertRejectRecord2ApproveRecordDTO(rejectRecord);
                resultList.add(approveRecord);
            }
        }
        if (!GutilCollection.isEmpty((Collection)(revokeRecords = this.tbtskRevokeRecordService.selectByTaskIdAndTbId(taskId, tbId)))) {
            for (TbtskRevokeRecord revokeRecord : revokeRecords) {
                ApproveRecordDTO approveRecord = this.convertRevokeRecord2ApproveRecordDTO(revokeRecord);
                resultList.add(approveRecord);
            }
        }
        return resultList;
    }

    private ApproveRecordDTO convertApproveRecord2ApproveRecordDTO(TbtskApproveRecord approveRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(approveRecord.getStatus());
        dto.setOption(approveRecord.getOption());
        dto.setApproveUserId(approveRecord.getApproveUserId());
        dto.setApproveUser(approveRecord.getApproveUser());
        dto.setApproveTime(approveRecord.getApproveTime());
        dto.setDescription(approveRecord.getDescription());
        dto.setId(approveRecord.getId());
        dto.setRemark(approveRecord.getRemark());
        dto.setTaskid(approveRecord.getTaskid());
        dto.setTbid(approveRecord.getTbid());
        dto.setStepname(approveRecord.getStepname());
        dto.setStepindex(approveRecord.getStepindex());
        dto.setNextstep(approveRecord.getNextstep());
        dto.setType(Integer.valueOf(1));
        dto.setWflx(approveRecord.getWflx());
        return dto;
    }

    private ApproveRecordDTO convertRevokeRecord2ApproveRecordDTO(TbtskRevokeRecord revokeRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(Integer.valueOf(1));
        dto.setOption(Integer.valueOf(1));
        dto.setApproveUserId(revokeRecord.getUserId());
        dto.setApproveUser(revokeRecord.getUserName());
        dto.setApproveTime(revokeRecord.getRevokeTime());
        dto.setDescription("");
        dto.setId(revokeRecord.getId());
        dto.setRemark(revokeRecord.getRemark());
        dto.setTaskid(revokeRecord.getTaskId());
        dto.setTbid(revokeRecord.getTbId());
        dto.setStepname(revokeRecord.getStepName());
        dto.setStepindex(Integer.valueOf(0));
        dto.setNextstep(Integer.valueOf(1));
        dto.setType(Integer.valueOf(3));
        return dto;
    }

    private ApproveRecordDTO convertRejectRecord2ApproveRecordDTO(TbtskRejectRecord rejectRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(Integer.valueOf(1));
        dto.setOption(Integer.valueOf(2));
        dto.setApproveUserId(rejectRecord.getUserId());
        dto.setApproveUser(rejectRecord.getUserName());
        dto.setApproveTime(rejectRecord.getRejectTime());
        dto.setDescription(rejectRecord.getDescription());
        dto.setId(rejectRecord.getId());
        dto.setRemark(rejectRecord.getRemark());
        dto.setTaskid(rejectRecord.getTaskid());
        dto.setTbid(rejectRecord.getTbid());
        dto.setStepname(rejectRecord.getStepName());
        dto.setStepindex(Integer.valueOf(0));
        dto.setNextstep(Integer.valueOf(1));
        dto.setType(Integer.valueOf(2));
        return dto;
    }

    public List<Integer> getUserRole(String taskId, Long userId) {
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        ArrayList<Integer> result = new ArrayList<Integer>();
        List userBiz2List = this.userBiz2Repository.findByUserId(userId);
        if (!GutilCollection.isEmpty((Collection)userBiz2List)) {
            for (UserBiz2 userBiz2 : userBiz2List) {
                if (!StringUtils.isNotBlank((CharSequence)userBiz2.getBizId()) || !userBiz2.getBizId().equalsIgnoreCase(taskId) || userBiz2.getRole() == null) continue;
                result.add(userBiz2.getRole());
            }
        }
        return result;
    }

    public Map checkAuditPermission(String taskId, String tbId, Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("hasPermission", false);
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return resultMap;
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return resultMap;
        }
        List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
        Map data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u4e0d\u5b58\u5728");
            return resultMap;
        }
        Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
        String xzqdm = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
        Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
        Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
        Integer rejectStatus = MapUtils.getInteger((Map)data, (Object)"f_reject_status", null);
        if (status == null || status < TbStatusEnum.WAITING_VERIFY.getCode()) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u672a\u63d0\u62a5\uff0c\u4e0d\u80fd\u5ba1\u6838");
            return resultMap;
        }
        if (reviewStage != null && reviewStage.equals(ReviewStageEnum.OVER_VERIFY)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u5ba1\u6838\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u5ba1\u6838");
            return resultMap;
        }
        FlowStep currentStep = this.getStepByReviewStageAndStatus(taskId, ReviewStageEnum.getEnum((int)reviewStage), TbStatusEnum.getEnum((int)status));
        String statusFilter = currentStep.getPre_status();
        Object[] statusArray = null;
        if (StringUtils.isNotBlank((CharSequence)statusFilter)) {
            statusArray = statusFilter.split(",");
        }
        if (statusArray != null && !ArrayUtils.contains((Object[])statusArray, (Object)status.toString())) {
            return resultMap;
        }
        String stageFilter = currentStep.getPre_stages();
        Object[] stagesArray = null;
        if (StringUtils.isNotBlank((CharSequence)stageFilter)) {
            stagesArray = stageFilter.split(",");
        }
        if (stagesArray != null && !ArrayUtils.contains((Object[])stagesArray, (Object)reviewStage.toString())) {
            return resultMap;
        }
        String filter = currentStep.getFilter();
        xzqdm = this.processRegionCode(xzqdm, currentStep.getName());
        List userRegions = this.landUser2AreaRepository.queryAreas(userId);
        String userSql = FlowFilterUtil.filterUserSql((String)filter, (String)((String)userRegions.get(0)), (String)xzqdm, (String)taskId);
        List userList = this.jdbcTemplate.query(userSql, (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet resultSet, int i) throws SQLException {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("userid", resultSet.getObject("f_userid"));
                temp.put("username", resultSet.getObject("f_username"));
                return temp;
            }
        });
        if (userList != null && userList.size() > 0) {
            for (int k = 0; k < userList.size(); ++k) {
                Long temUserId = Long.parseLong(((Map)userList.get(k)).get("userid").toString());
                if (!temUserId.equals(userId)) continue;
                resultMap.put("hasPermission", true);
                resultMap.put("stepIndex", currentStep.getIndex());
                resultMap.put("stepName", currentStep.getName());
                FlowStep preStep = this.getPreviousFlowStep(taskId, currentStep);
                resultMap.put("preStepName", preStep.getName());
                TbtskRejectDef rejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
                if (rejectDef != null) {
                    resultMap.put("canReject", rejectDef.getRejectType() != 0);
                    resultMap.put("rejectType", rejectDef.getRejectType());
                } else {
                    resultMap.put("canReject", false);
                }
                return resultMap;
            }
        }
        return resultMap;
    }

    private FlowStep getPreviousFlowStep(String taskId, FlowStep currentStep) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return this.getPreviousFlowStep(flowSteps, currentStep);
    }

    private FlowStep getPreviousFlowStep(List<FlowStep> flowSteps, FlowStep currentStep) {
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        for (int i = 0; i < flowSteps.size(); ++i) {
            if (!flowSteps.get(i).getName().equalsIgnoreCase(currentStep.getName())) continue;
            if (i == 0) {
                FlowStep step = new FlowStep();
                step.setContainReview(currentStep.getContainReview());
                step.setIndex(Integer.valueOf(-1));
                step.setIs_end(Boolean.valueOf(false));
                step.setIs_start(Boolean.valueOf(false));
                step.setName("\u4f5c\u4e1a\u5458\u6838\u5b9e");
                return step;
            }
            return flowSteps.get(i - 1);
        }
        return null;
    }

    private Map queryPermissionByFilter(String taskId, String tbId, Long userId, String dataRegionCode, Integer status, Integer reviewStage, Integer rejectCount, Integer rejectStatus) {
        TbtskRejectRecord rejectRecord;
        Map<String, Integer> resultMap = new HashMap<String, Boolean>();
        resultMap.put("hasPermission", (Integer)((Object)Boolean.valueOf(false)));
        if (rejectStatus == null || rejectStatus.equals(0)) {
            List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
            if (flowSteps == null || flowSteps.size() == 0) {
                return resultMap;
            }
            if (StringUtils.isBlank((CharSequence)dataRegionCode) || status == null || reviewStage == null) {
                return resultMap;
            }
            resultMap = this.validateFlowStage(taskId, tbId, userId, dataRegionCode, status, reviewStage, rejectCount, resultMap, flowSteps);
        } else if (rejectStatus.equals(1) && (rejectRecord = this.tbtskRejectRecordRepository.findTopOneByTbIdOrderByRejectTime(taskId, tbId)) != null) {
            if (rejectRecord.getTargetStage().equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) {
                return resultMap;
            }
            if (reviewStage.equals(rejectRecord.getTargetStage())) {
                List<FlowStep> flowSteps = this.getAuditFlowSteps(taskId);
                if (flowSteps == null || flowSteps.size() == 0) {
                    return resultMap;
                }
                List userRegions = this.landUser2AreaRepository.queryAreas(userId);
                ReviewStageEnum reviewStageEnum = this.getFirstStageOfFlow(taskId);
                boolean hasReview = this.containsReviewStep(flowSteps);
                boolean isFirstStage = false;
                for (int j = 0; j < flowSteps.size(); ++j) {
                    FlowStep flowStep = flowSteps.get(j);
                    if (!hasReview) {
                        isFirstStage = reviewStage.equals(reviewStageEnum.getCode());
                    } else {
                        boolean bl = isFirstStage = reviewStage.equals(reviewStageEnum.getCode()) && status.equals(TbStatusEnum.WAITING_VERIFY);
                    }
                    if (!isFirstStage && !reviewStage.toString().equals(flowStep.getPost_stage())) continue;
                    if (isFirstStage) {
                        flowStep = flowSteps.get(0);
                    } else if (j < flowSteps.size() - 1) {
                        flowStep = flowSteps.get(j + 1);
                    }
                    String statusFilter = flowStep.getPre_status();
                    Object[] statusArray = null;
                    if (StringUtils.isNotBlank((CharSequence)statusFilter)) {
                        statusArray = statusFilter.split(",");
                    }
                    if (statusArray != null && !ArrayUtils.contains((Object[])statusArray, (Object)status.toString())) {
                        return resultMap;
                    }
                    String stageFilter = flowStep.getPre_stages();
                    Object[] stagesArray = null;
                    if (StringUtils.isNotBlank((CharSequence)stageFilter)) {
                        stagesArray = stageFilter.split(",");
                    }
                    if (stagesArray != null && !ArrayUtils.contains((Object[])stagesArray, (Object)reviewStage.toString())) {
                        return resultMap;
                    }
                    String filter = flowStep.getFilter();
                    dataRegionCode = this.processRegionCode(dataRegionCode, flowStep.getName());
                    String userSql = FlowFilterUtil.filterUserSql((String)filter, (String)((String)userRegions.get(0)), (String)dataRegionCode, (String)taskId);
                    List userList = this.jdbcTemplate.query(userSql, (RowMapper)new RowMapper<Map<String, Object>>(){

                        public Map<String, Object> mapRow(ResultSet resultSet, int i) throws SQLException {
                            HashMap<String, Object> temp = new HashMap<String, Object>();
                            temp.put("userid", resultSet.getObject("f_userid"));
                            temp.put("username", resultSet.getObject("f_username"));
                            return temp;
                        }
                    });
                    if (userList == null || userList.size() <= 0) break;
                    for (int k = 0; k < userList.size(); ++k) {
                        Long temUserId = Long.parseLong(((Map)userList.get(k)).get("userid").toString());
                        if (!temUserId.equals(userId)) continue;
                        resultMap.put("hasPermission", (Integer)((Object)Boolean.valueOf(true)));
                        resultMap.put("stepIndex", flowStep.getIndex());
                        resultMap.put("stepName", (Integer)((Object)flowStep.getName()));
                        if (j > 0) {
                            FlowStep preStep = flowSteps.get(j - 1);
                            resultMap.put("preStepName", (Integer)((Object)preStep.getName()));
                        } else if (!hasReview) {
                            resultMap.put("preStepName", (Integer)((Object)"\u4f5c\u4e1a\u5458\u6838\u5b9e"));
                        } else {
                            resultMap.put("preStepName", (Integer)((Object)flowSteps.get(j).getName()));
                        }
                        TbtskRejectDef rejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
                        if (rejectDef != null) {
                            resultMap.put("canReject", (Integer)((Object)Boolean.valueOf(rejectDef.getRejectType() != 0)));
                            resultMap.put("rejectType", rejectDef.getRejectType());
                        } else {
                            resultMap.put("canReject", (Integer)((Object)Boolean.valueOf(false)));
                        }
                        return resultMap;
                    }
                    break;
                }
            }
        }
        return resultMap;
    }

    private ReviewStageEnum getPreviousStage(String taskId, String tbId, ReviewStageEnum currentStage) {
        if (StringUtils.isBlank((CharSequence)taskId) || StringUtils.isBlank((CharSequence)tbId)) {
            return null;
        }
        List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return this.getPreviousStage(flowSteps, tbId, currentStage);
    }

    private ReviewStageEnum getPreviousStage(List<FlowStep> flowSteps, String tbId, ReviewStageEnum currentStage) {
        if (GutilCollection.isEmpty(flowSteps) || StringUtils.isBlank((CharSequence)tbId)) {
            return null;
        }
        for (int i = 0; i < flowSteps.size(); ++i) {
            if (!flowSteps.get(i).getName().equalsIgnoreCase(currentStage.getName())) continue;
            if (i == 0) {
                return ReviewStageEnum.OPERATOR_VERIFY;
            }
            return this.getStageByStep(flowSteps.get(i - 1));
        }
        return null;
    }

    private ReviewStageEnum getNextStage(String taskId, ReviewStageEnum currentStage) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return this.getNextStage(flowSteps, currentStage);
    }

    private ReviewStageEnum getNextStage(List<FlowStep> flowSteps, ReviewStageEnum currentStage) {
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        for (int i = 0; i < flowSteps.size(); ++i) {
            if (!flowSteps.get(i).getName().equalsIgnoreCase(currentStage.getName())) continue;
            if (i == flowSteps.size() - 1) {
                return ReviewStageEnum.OVER_VERIFY;
            }
            return this.getStageByStep(flowSteps.get(i));
        }
        return null;
    }

    private ReviewStageEnum getStageByStep(FlowStep step) {
        String[] stagesArray = null;
        if (StringUtils.isNotBlank((CharSequence)step.getPre_stages())) {
            stagesArray = step.getPre_stages().split(",");
        }
        if (stagesArray != null) {
            if (stagesArray.length == 2) {
                return ReviewStageEnum.getEnum((int)Integer.parseInt(stagesArray[1]));
            }
            if (stagesArray.length == 1) {
                return ReviewStageEnum.getEnum((int)Integer.parseInt(stagesArray[0]));
            }
        }
        return null;
    }

    private FlowStep getStepByReviewStageAndStatus(String taskId, Integer currentStage, Integer status) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return this.getStepByReviewStageAndStatus(flowSteps, ReviewStageEnum.getEnum((int)currentStage), TbStatusEnum.getEnum((int)status));
    }

    private FlowStep getStepByReviewStageAndStatus(String taskId, ReviewStageEnum currentStage, TbStatusEnum status) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (GutilCollection.isEmpty(flowSteps)) {
            return null;
        }
        return this.getStepByReviewStageAndStatus(flowSteps, currentStage, status);
    }

    private FlowStep getStepByReviewStageAndStatus(List<FlowStep> flowSteps, ReviewStageEnum currentStage, TbStatusEnum status) {
        String stepName = "";
        switch (currentStage.getCode()) {
            case 90: {
                if (status.equals((Object)TbStatusEnum.WAITING_VERIFY) || status.equals((Object)TbStatusEnum.VERIFY_NOT_PASS) || status.equals((Object)TbStatusEnum.WAITING_REVIEW) || status.equals((Object)TbStatusEnum.REVIEW_NOT_PASS)) break;
                stepName = "\u4f5c\u4e1a\u5458\u6838\u5b9e";
                break;
            }
            case 91: {
                if (status.equals((Object)TbStatusEnum.WAITING_VERIFY) || status.equals((Object)TbStatusEnum.VERIFY_NOT_PASS)) {
                    stepName = "\u6751\u7ea7\u5ba1\u6838";
                    break;
                }
                if (!status.equals((Object)TbStatusEnum.WAITING_REVIEW) && !status.equals((Object)TbStatusEnum.REVIEW_NOT_PASS)) break;
                stepName = "\u6751\u7ea7\u590d\u6838";
                break;
            }
            case 92: {
                if (status.equals((Object)TbStatusEnum.WAITING_VERIFY) || status.equals((Object)TbStatusEnum.VERIFY_NOT_PASS)) {
                    stepName = "\u4e61\u9547\u5ba1\u6838";
                    break;
                }
                if (!status.equals((Object)TbStatusEnum.WAITING_REVIEW) && !status.equals((Object)TbStatusEnum.REVIEW_NOT_PASS)) break;
                stepName = "\u4e61\u9547\u590d\u6838";
                break;
            }
            case 93: {
                if (status.equals((Object)TbStatusEnum.WAITING_VERIFY) || status.equals((Object)TbStatusEnum.VERIFY_NOT_PASS)) {
                    stepName = "\u533a\u53bf\u5ba1\u6838";
                    break;
                }
                if (!status.equals((Object)TbStatusEnum.WAITING_REVIEW) && !status.equals((Object)TbStatusEnum.REVIEW_NOT_PASS)) break;
                stepName = "\u533a\u53bf\u590d\u6838";
                break;
            }
            case 95: {
                if (status.equals((Object)TbStatusEnum.WAITING_VERIFY) || status.equals((Object)TbStatusEnum.VERIFY_NOT_PASS)) {
                    stepName = "\u5e02\u7ea7\u5ba1\u6838";
                    break;
                }
                if (!status.equals((Object)TbStatusEnum.WAITING_REVIEW) && !status.equals((Object)TbStatusEnum.REVIEW_NOT_PASS)) break;
                stepName = "\u5e02\u7ea7\u590d\u6838";
                break;
            }
            case 97: {
                if (status.equals((Object)TbStatusEnum.WAITING_VERIFY) || status.equals((Object)TbStatusEnum.VERIFY_NOT_PASS)) {
                    stepName = "\u7701\u7ea7\u5ba1\u6838";
                    break;
                }
                if (!status.equals((Object)TbStatusEnum.WAITING_REVIEW) && !status.equals((Object)TbStatusEnum.REVIEW_NOT_PASS)) break;
                stepName = "\u7701\u7ea7\u590d\u6838";
                break;
            }
            case 101: {
                if (status.equals((Object)TbStatusEnum.WAITING_VERIFY) || status.equals((Object)TbStatusEnum.VERIFY_NOT_PASS)) {
                    stepName = "\u56fd\u5bb6\u5ba1\u6838";
                    break;
                }
                if (!status.equals((Object)TbStatusEnum.WAITING_REVIEW) && !status.equals((Object)TbStatusEnum.REVIEW_NOT_PASS)) break;
                stepName = "\u56fd\u5bb6\u590d\u6838";
                break;
            }
        }
        if (!GutilCollection.isEmpty(flowSteps) && StringUtils.isNotBlank((CharSequence)stepName)) {
            for (FlowStep flowStep : flowSteps) {
                if (!flowStep.getName().equalsIgnoreCase(stepName)) continue;
                return flowStep;
            }
        }
        return null;
    }

    public Map validateFlowStage(String taskId, String tbId, Long userId, String dataRegionCode, Integer status, Integer stage, Integer rejectCount, Map resultMap, List<FlowStep> flowSteps) {
        List userRegions = this.landUser2AreaRepository.queryAreas(userId);
        TbtskApproveRecord latestRecord = this.tbtskApproveRecordRepository.queryNotRevokedTopOne(taskId, tbId, rejectCount);
        Integer step = null;
        if (latestRecord != null) {
            SysConfig sysConfig = this.sysConfigService.findOne("scgtyBizId");
            String ynbgdcBizId = this.systemConfigCacheService.querySysConfig("ynbgdcBizId", "");
            if (sysConfig.getValue().equalsIgnoreCase(taskId)) {
                step = latestRecord.getNextstep();
            } else if (latestRecord.getOption().equals(1)) {
                step = latestRecord.getNextstep();
            } else if (latestRecord.getOption().equals(2)) {
                step = latestRecord.getStepindex();
            } else if (latestRecord.getOption().equals(3) && latestRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId) && latestRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                step = latestRecord.getNextstep();
            }
        } else {
            step = 0;
        }
        for (int j = 0; j < flowSteps.size(); ++j) {
            FlowStep flowStep = flowSteps.get(j);
            if (!step.equals(flowStep.getIndex())) continue;
            String statusFilter = flowStep.getPre_status();
            Object[] statusArray = null;
            if (StringUtils.isNotBlank((CharSequence)statusFilter)) {
                statusArray = statusFilter.split(",");
            }
            if (statusArray != null && !ArrayUtils.contains((Object[])statusArray, (Object)status.toString())) {
                return resultMap;
            }
            String stageFilter = flowStep.getPre_stages();
            Object[] stagesArray = null;
            if (StringUtils.isNotBlank((CharSequence)stageFilter)) {
                stagesArray = stageFilter.split(",");
            }
            if (stagesArray != null && !ArrayUtils.contains((Object[])stagesArray, (Object)stage.toString())) {
                return resultMap;
            }
            String filter = flowStep.getFilter();
            dataRegionCode = this.processRegionCode(dataRegionCode, flowStep.getName());
            String userSql = FlowFilterUtil.filterUserSql((String)filter, (String)((String)userRegions.get(0)), (String)dataRegionCode, (String)taskId);
            List userList = this.jdbcTemplate.query(userSql, (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet resultSet, int i) throws SQLException {
                    HashMap<String, Object> temp = new HashMap<String, Object>();
                    temp.put("userid", resultSet.getObject("f_userid"));
                    temp.put("username", resultSet.getObject("f_username"));
                    return temp;
                }
            });
            if (userList == null || userList.size() <= 0) continue;
            for (int k = 0; k < userList.size(); ++k) {
                Long temUserId = Long.parseLong(((Map)userList.get(k)).get("userid").toString());
                if (!temUserId.equals(userId)) continue;
                resultMap.put("hasPermission", true);
                resultMap.put("stepIndex", flowStep.getIndex());
                resultMap.put("stepName", flowStep.getName());
                if (j > 0) {
                    FlowStep preStep = flowSteps.get(j - 1);
                    resultMap.put("preStepName", preStep.getName());
                } else {
                    resultMap.put("preStepName", "\u4f5c\u4e1a\u5458\u6838\u5b9e");
                }
                TbtskRejectDef rejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
                if (rejectDef != null) {
                    resultMap.put("canReject", rejectDef.getRejectType() != 0);
                    resultMap.put("rejectType", rejectDef.getRejectType());
                } else {
                    resultMap.put("canReject", false);
                }
                return resultMap;
            }
        }
        return null;
    }

    public String processRegionCode(String dataRegionCode, String name) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)dataRegionCode)) {
            result = dataRegionCode;
            switch (name) {
                case "\u6751\u7ea7\u5ba1\u6838": 
                case "\u6751\u7ea7\u590d\u6838": {
                    result = dataRegionCode;
                    break;
                }
                case "\u4e61\u9547\u5ba1\u6838": 
                case "\u4e61\u9547\u590d\u6838": {
                    result = dataRegionCode.substring(0, 9);
                    break;
                }
                case "\u533a\u53bf\u5ba1\u6838": 
                case "\u533a\u53bf\u590d\u6838": {
                    result = dataRegionCode.substring(0, 6);
                    break;
                }
                case "\u5e02\u7ea7\u5ba1\u6838": 
                case "\u5e02\u7ea7\u590d\u6838": {
                    result = dataRegionCode.substring(0, 4) + "00";
                    break;
                }
                case "\u7701\u7ea7\u5ba1\u6838": 
                case "\u7701\u7ea7\u590d\u6838": {
                    result = dataRegionCode.substring(0, 2) + "0000";
                    break;
                }
                case "\u56fd\u5bb6\u5ba1\u6838": 
                case "\u56fd\u5bb6\u590d\u6838": {
                    result = "1";
                    break;
                }
            }
        }
        return result;
    }

    public TbtskApproveRecord submitApproveRecord(TbtskApproveRecord approveRecord, String type, Long userId) throws Exception {
        TbtskApproveRecord result;
        block40: {
            String ynbgdcBizId;
            block41: {
                result = null;
                if (approveRecord == null) {
                    return null;
                }
                if (StringUtils.isBlank((CharSequence)approveRecord.getTaskid())) {
                    throw new RuntimeException("taskId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                SysConfig sysConfig = this.sysConfigService.findOne("scgtyBizId");
                ynbgdcBizId = this.systemConfigCacheService.querySysConfig("ynbgdcBizId", "");
                if (!sysConfig.getValue().equalsIgnoreCase(approveRecord.getTaskid())) break block41;
                TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)approveRecord.getTaskid()).orElse(null);
                if (null == tskTaskBiz) {
                    throw new RuntimeException("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
                }
                TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
                if (null == tbtskObjectinfo) {
                    throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
                }
                List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
                Map data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + approveRecord.getTbid() + "'");
                if (null == data) {
                    throw new RuntimeException("\u56fe\u6591\u4e0d\u5b58\u5728");
                }
                Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
                Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
                Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
                approveRecord.setRejectCount(Integer.valueOf(rejectCount != null ? rejectCount : 0));
                result = (TbtskApproveRecord)this.tbtskApproveRecordRepository.save((Object)approveRecord);
                List recordList = this.tbtskApproveRecordRepository.findApproveRecordOrderByTime(approveRecord.getTaskid(), approveRecord.getTbid());
                if (GutilCollection.isEmpty((Collection)recordList)) break block40;
                Integer index = ((TbtskApproveRecord)recordList.get(0)).getStepindex();
                List<FlowStep> flowSteps = this.getAuditFlowSteps(approveRecord.getTaskid());
                if (!GutilCollection.isEmpty(flowSteps)) {
                    boolean hashReview = flowSteps.stream().filter(flowStep -> StringUtils.isNotBlank((CharSequence)flowStep.getName()) && flowStep.getName().contains("\u590d\u6838")).count() > 0L;
                    for (int i = 0; i < flowSteps.size(); ++i) {
                        FlowStep flowStep2 = flowSteps.get(i);
                        if (!index.equals(flowStep2.getIndex())) continue;
                        String stage = flowStep2.getPost_stage();
                        if (hashReview) {
                            if (approveRecord.getStepindex() % 2 == 0) {
                                if (approveRecord.getOption().equals(1)) {
                                    status = TbStatusEnum.WAITING_REVIEW.getCode();
                                    reviewStage = Integer.valueOf(stage);
                                } else {
                                    status = TbStatusEnum.VERIFY_NOT_PASS.getCode();
                                }
                            } else if (approveRecord.getOption().equals(1)) {
                                if (StringUtils.isNotBlank((CharSequence)stage)) {
                                    status = TbStatusEnum.WAITING_VERIFY.getCode();
                                    reviewStage = Integer.valueOf(stage);
                                }
                            } else {
                                status = TbStatusEnum.REVIEW_NOT_PASS.getCode();
                            }
                        } else {
                            status = approveRecord.getNextstep().intValue() == flowSteps.size() ? Integer.valueOf(TbStatusEnum.VERIFY_NOT_PASS.getCode()) : Integer.valueOf(TbStatusEnum.WAITING_REVIEW.getCode());
                            reviewStage = Integer.valueOf(stage);
                        }
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("f_status", status);
                        map.put("f_review_stage", reviewStage);
                        map.put("f_reject_status", 0);
                        map.put("f_updatetime", System.currentTimeMillis());
                        int row = this.mDataBizService.updateData(tbtskObjectinfo.getfTablename(), map, "f_id='" + approveRecord.getTbid() + "'");
                        break block40;
                    }
                }
                break block40;
            }
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)approveRecord.getTaskid()).orElse(null);
            if (null == tskTaskBiz) {
                throw new RuntimeException("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            if (null == tbtskObjectinfo) {
                throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
            Map data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + approveRecord.getTbid() + "'");
            if (null == data) {
                throw new RuntimeException("\u56fe\u6591\u4e0d\u5b58\u5728");
            }
            Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
            Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
            Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
            approveRecord.setRejectCount(Integer.valueOf(rejectCount != null ? rejectCount : 0));
            result = (TbtskApproveRecord)this.tbtskApproveRecordRepository.save((Object)approveRecord);
            List recordList = this.tbtskApproveRecordRepository.findApproveRecordOrderByTime(approveRecord.getTaskid(), approveRecord.getTbid());
            if (!GutilCollection.isEmpty((Collection)recordList)) {
                Integer index = ((TbtskApproveRecord)recordList.get(0)).getStepindex();
                List<FlowStep> flowSteps = this.getAuditFlowSteps(approveRecord.getTaskid());
                if (!GutilCollection.isEmpty(flowSteps)) {
                    boolean hashReview = this.containsReviewStep(flowSteps);
                    for (int i = 0; i < flowSteps.size(); ++i) {
                        FlowStep flowStep3 = flowSteps.get(i);
                        if (!index.equals(flowStep3.getIndex())) continue;
                        String stage = flowStep3.getPost_stage();
                        String postStatus = flowStep3.getPost_status();
                        if (hashReview) {
                            if (approveRecord.getStepindex() % 2 == 0) {
                                if (approveRecord.getOption().equals(1)) {
                                    status = TbStatusEnum.WAITING_REVIEW.getCode();
                                    reviewStage = Integer.valueOf(stage);
                                } else if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                    status = TbStatusEnum.WAITING_REVIEW.getCode();
                                    reviewStage = Integer.valueOf(stage);
                                } else {
                                    status = TbStatusEnum.VERIFY_NOT_PASS.getCode();
                                }
                            } else if (approveRecord.getOption().equals(1)) {
                                if (StringUtils.isNotBlank((CharSequence)stage)) {
                                    status = TbStatusEnum.WAITING_VERIFY.getCode();
                                    reviewStage = Integer.valueOf(stage);
                                }
                            } else if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                if (StringUtils.isNotBlank((CharSequence)stage)) {
                                    status = TbStatusEnum.WAITING_VERIFY.getCode();
                                    reviewStage = Integer.valueOf(stage);
                                }
                            } else {
                                status = TbStatusEnum.REVIEW_NOT_PASS.getCode();
                            }
                        } else if (approveRecord.getOption().equals(1)) {
                            status = TbStatusEnum.WAITING_VERIFY.getCode();
                            reviewStage = Integer.valueOf(stage);
                        } else if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                            status = TbStatusEnum.WAITING_VERIFY.getCode();
                            reviewStage = Integer.valueOf(stage);
                        } else {
                            status = TbStatusEnum.VERIFY_NOT_PASS.getCode();
                        }
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("f_status", status);
                        map.put("f_review_stage", reviewStage);
                        map.put("f_reject_status", 0);
                        map.put("f_updatetime", System.currentTimeMillis());
                        int row = this.mDataBizService.updateData(tbtskObjectinfo.getfTablename(), map, "f_id='" + approveRecord.getTbid() + "'");
                        break;
                    }
                }
            }
        }
        return result;
    }

    public String rejectBatchByFilter(Integer type, String taskId, Long userId, String remark, String description, String userName, String stepName, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt, Date startTime, Date endTime, String tbzt, String xmhj, String shfh, String sfdh, String ywzp) throws Exception {
        String result = "\u6253\u56de\u6210\u529f";
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"conditionFilter");
        params.put("xzqdm", (Object)xzqdm);
        params.put("fwbh", (Object)fwbh);
        params.put("jslx", (Object)jslx);
        params.put("xfzt", (Object)xfzt);
        params.put("tjzt", (Object)tjzt);
        params.put("tbzt", (Object)tbzt);
        params.put("xmhj", (Object)xmhj);
        params.put("shfh", (Object)shfh);
        params.put("sfdh", (Object)sfdh);
        params.put("startTime", (Object)startTime);
        params.put("endTime", (Object)endTime);
        params.put("userId", (Object)userId);
        params.put("ywzp", (Object)ywzp);
        params.put("taskId", (Object)taskId);
        params.put("type", (Object)type);
        params.put("description", (Object)description);
        params.put("remark", (Object)remark);
        params.put("userName", (Object)userName);
        params.put("stepName", (Object)stepName);
        params.put("result", (Object)result);
        this.addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_REJECT_BATCH, taskId);
        return result;
    }

    public String submitApproveRecordBatch(String taskId, String tbId, Integer option, String description, String remark, Long userId, String approveUser, Integer type) {
        String result = "\u6279\u91cf\u5ba1\u6838/\u590d\u6838\u6210\u529f";
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (tskTaskBiz.getIsApprove() == null || tskTaskBiz.getIsApprove() == 0) {
            return "\u8be5\u4efb\u52a1\u6ca1\u6709\u5ba1\u6838\u590d\u6838\u6d41\u7a0b";
        }
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"checkFilter");
        params.put("tbIds", (Object)tbId);
        params.put("taskId", (Object)taskId);
        params.put("option", (Object)option);
        params.put("description", (Object)description);
        params.put("remark", (Object)remark);
        params.put("approveUser", (Object)approveUser);
        params.put("type", (Object)type);
        params.put("userId", (Object)userId);
        this.addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_AUDIT_BATCH, taskId);
        return result;
    }

    public String submitApproveRecordBatchByFilter(String taskId, Integer option, String description, String remark, Long userId, String approveUser, Integer type, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt, Date startTime, Date endTime, String tbzt, String xmhj, String shfh, String sfdh, String ywzp) throws Exception {
        String result = "\u6279\u91cf\u5ba1\u6838/\u590d\u6838\u6210\u529f";
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"conditionFilter");
        params.put("xzqdm", (Object)xzqdm);
        params.put("fwbh", (Object)fwbh);
        params.put("jslx", (Object)jslx);
        params.put("xfzt", (Object)xfzt);
        params.put("tjzt", (Object)tjzt);
        params.put("tbzt", (Object)tbzt);
        params.put("xmhj", (Object)xmhj);
        params.put("shfh", (Object)shfh);
        params.put("sfdh", (Object)sfdh);
        params.put("startTime", (Object)startTime);
        params.put("endTime", (Object)endTime);
        params.put("userId", (Object)userId);
        params.put("ywzp", (Object)ywzp);
        params.put("taskId", (Object)taskId);
        params.put("option", (Object)option);
        params.put("description", (Object)description);
        params.put("remark", (Object)remark);
        params.put("approveUser", (Object)approveUser);
        params.put("type", (Object)type);
        this.addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_AUDIT_BATCH, taskId);
        return result;
    }

    public Map canRevoke(String taskId, String tbId, Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("hasPermission", false);
        resultMap.put("currentStage", "");
        resultMap.put("currentStatus", "");
        resultMap.put("stepIndex", "");
        resultMap.put("stepName", "");
        List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
        Map data = null;
        try {
            if (StringUtils.isBlank((CharSequence)taskId)) {
                throw new RuntimeException("taskId");
            }
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
            if (null == tskTaskBiz) {
                throw new GwValidateException();
            }
            if (tskTaskBiz.getCanRevoke() != null && tskTaskBiz.getCanRevoke().equals(0)) {
                resultMap.put("hasPermission", false);
                resultMap.put("error", "\u8be5\u4efb\u52a1\u4e0d\u652f\u6301\u64a4\u56de\u64cd\u4f5c");
                return resultMap;
            }
            data = this.queryData(taskId, tbId, fieldNameList);
        }
        catch (Exception e) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", e.getMessage());
            return resultMap;
        }
        if (null == data) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u4e0d\u5b58\u5728");
            return resultMap;
        }
        Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
        String xzqdm = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
        Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
        Integer rejectStatus = MapUtils.getInteger((Map)data, (Object)"f_reject_status", null);
        Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
        if (status == null || status < TbStatusEnum.WAITING_VERIFY.getCode()) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u672a\u88ab\u5ba1\u6838\u6216\u590d\u6838\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de");
            return resultMap;
        }
        if (rejectStatus != null && rejectStatus.equals(1)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u88ab\u6253\u56de\u7684\u56fe\u6591\u4e0d\u5141\u8bb8\u64a4\u56de");
            return resultMap;
        }
        List<FlowStep> flowSteps = this.getAuditFlowSteps(taskId);
        if (flowSteps == null || flowSteps.size() == 0) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u4efb\u52a1\u672a\u67e5\u8be2\u5230\u6d41\u7a0b\u6b65\u9aa4\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de");
            return resultMap;
        }
        TbtskApproveRecord latestRecord = this.tbtskApproveRecordRepository.queryLatestApproveRecord(taskId, tbId, rejectCount);
        if (latestRecord == null) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u6ca1\u6709\u5ba1\u6838\u6216\u590d\u6838\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de");
            return resultMap;
        }
        if (latestRecord.getIsRevoked() != null && latestRecord.getIsRevoked().equals(1)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u5ba1\u6838\u6216\u590d\u6838\u8bb0\u5f55\u5df2\u88ab\u64a4\u56de\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u64a4\u56de");
            return resultMap;
        }
        if (latestRecord.getOption().equals(2)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u4fdd\u5b58\u7591\u4e49\u7684\u5ba1\u6838\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de");
            return resultMap;
        }
        ReviewStageEnum firstStage = this.getFirstStageOfFlow(taskId);
        if (!(status.equals(TbStatusEnum.WAITING_VERIFY.getCode()) || status.equals(TbStatusEnum.WAITING_REVIEW.getCode()) || status.equals(TbStatusEnum.WAITING_VERIFY.getCode()) && reviewStage != null && !reviewStage.equals(firstStage.getCode()))) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u5f53\u524d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de");
            return resultMap;
        }
        Integer step = latestRecord.getStepindex();
        for (int i = 0; i < flowSteps.size(); ++i) {
            FlowStep flowStep = flowSteps.get(i);
            if (!step.equals(flowStep.getIndex())) continue;
            resultMap.put("stepIndex", flowStep.getIndex());
            resultMap.put("stepName", flowStep.getName());
            String filter = flowStep.getFilter();
            String dataRegionCode = this.processRegionCode(xzqdm, flowStep.getName());
            String userSql = FlowFilterUtil.filterUserSql((String)filter, (String)"", (String)dataRegionCode, (String)taskId);
            List userList = this.jdbcTemplate.query(userSql, (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet resultSet, int i) throws SQLException {
                    HashMap<String, Object> temp = new HashMap<String, Object>();
                    temp.put("userid", resultSet.getObject("f_userid"));
                    temp.put("username", resultSet.getObject("f_username"));
                    return temp;
                }
            });
            if (userList == null || userList.size() <= 0) continue;
            for (int k = 0; k < userList.size(); ++k) {
                Long temUserId = Long.parseLong(((Map)userList.get(k)).get("userid").toString());
                if (!temUserId.equals(userId)) continue;
                resultMap.put("hasPermission", true);
                return resultMap;
            }
        }
        resultMap.put("hasPermission", false);
        resultMap.put("error", "\u65e0\u64a4\u56de\u6743\u9650\uff0c\u65e0\u6cd5\u64a4\u56de");
        return resultMap;
    }

    private Map queryData(String taskId, String tbId, List<String> fieldNameList) throws Exception {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new RuntimeException("taskId");
        }
        if (StringUtils.isBlank((CharSequence)tbId)) {
            throw new RuntimeException("tbId");
        }
        if (GutilCollection.isEmpty(fieldNameList)) {
            throw new RuntimeException("fieldNameList");
        }
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            throw new RuntimeException();
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            throw new RuntimeException();
        }
        Map data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        return data;
    }

    public String reject(String taskId, String tbId, Long userId, String remark, String description, String userName, String stepName, String result, String targetStepName) throws Exception {
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            throw new RuntimeException("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            throw new RuntimeException("\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
        fieldNameList.add("f_submit_userid");
        Map data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (data != null) {
            Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
            Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
            Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
            String submitUserId = MapUtils.getString((Map)data, (Object)"f_submit_userid", (String)"");
            String xzqdmsys = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
            if (status != null) {
                if (status < TbStatusEnum.WAITING_VERIFY.getCode()) {
                    result = "\u6253\u56de\u5931\u8d25\uff0c\u56fe\u6591\u5c1a\u672a\u63d0\u4ea4\uff0c\u4e0d\u80fd\u6253\u56de";
                } else {
                    int newRejectCount = rejectCount != null ? rejectCount : 0;
                    TbtskRejectDef rejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
                    if (rejectDef != null && rejectDef.getRejectType() != null) {
                        if (rejectDef.getRejectType().equals(RejectTypeEnum.DO_NOTHING.getCode())) {
                            result = "\u6253\u56de\u5931\u8d25\uff0c\u6b64\u4efb\u52a1\u4e0d\u652f\u6301\u6253\u56de";
                        } else {
                            Pair<ReviewStageEnum, TbStatusEnum> targetStageAndStatus = null;
                            SysConfig sysConfig = this.sysConfigService.findOne("scgtyBizId");
                            targetStageAndStatus = sysConfig.getValue().equalsIgnoreCase(taskId) ? Pair.of((Object)ReviewStageEnum.COUNTY_VERIFY, (Object)TbStatusEnum.WAITING_VERIFY) : this.getRejectTargetStageAndStatus(taskId, rejectDef.getRejectType(), stepName, targetStepName);
                            HashMap<String, Object> updateMap = new HashMap<String, Object>();
                            updateMap.put("f_reject_status", 1);
                            updateMap.put("f_reject_count", newRejectCount + 1);
                            updateMap.put("f_review_stage", ((ReviewStageEnum)targetStageAndStatus.getLeft()).getCode());
                            updateMap.put("f_status", ((TbStatusEnum)targetStageAndStatus.getRight()).getCode());
                            updateMap.put("f_updatetime", System.currentTimeMillis());
                            int row = this.mDataBizService.updateData(tbtskObjectinfo.getfTablename(), updateMap, "f_id='" + tbId + "'");
                            if (row == 1) {
                                TbtskRejectRecord rejectRecord = this.saveRejectRecord(taskId, userId, remark, description, userName, stepName, tbId, reviewStage, ((ReviewStageEnum)targetStageAndStatus.getLeft()).getCode());
                                if (submitUserId != null && ((ReviewStageEnum)targetStageAndStatus.getLeft()).getCode() == ReviewStageEnum.OPERATOR_VERIFY.getCode()) {
                                    String receiverUserId = submitUserId;
                                    JSONArray id2RejectIdArray = new JSONArray();
                                    id2RejectIdArray.add((Object)(rejectRecord.getTbid() + ":" + rejectRecord.getId()));
                                    this.sendRejectMessageToAPPByPlatform(Arrays.asList(tbId.split(",")), userId, Arrays.asList(receiverUserId.split(",")), description, remark, id2RejectIdArray, tbtskObjectinfo, taskId, tskTaskBiz, xzqdmsys);
                                }
                                result = "\u6253\u56de\u6210\u529f";
                            } else {
                                result = "\u6253\u56de\u5931\u8d25";
                            }
                        }
                    } else {
                        result = "\u6253\u56de\u5931\u8d25\uff0c\u6b64\u4efb\u52a1\u4e0d\u672a\u914d\u7f6e\u6253\u56de\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
                    }
                }
            }
        }
        return result;
    }

    private TbtskRejectRecord saveRejectRecord(String taskId, Long userId, String remark, String description, String userName, String stepName, String id, Integer sourceStage, Integer targetStage) {
        TbtskRejectRecord rejectRecord = new TbtskRejectRecord();
        rejectRecord.setTaskid(taskId);
        rejectRecord.setTbid(id);
        rejectRecord.setUserId(userId);
        rejectRecord.setRejectTime(new Date());
        rejectRecord.setRemark(remark);
        rejectRecord.setDescription(description);
        rejectRecord.setUserName(userName);
        rejectRecord.setSourceStage(sourceStage);
        rejectRecord.setTargetStage(targetStage);
        rejectRecord.setStepName(stepName);
        return (TbtskRejectRecord)this.tbtskRejectRecordRepository.save((Object)rejectRecord);
    }

    public void sendRejectMessageToAPPByPlatform(List<String> ids, Long userId, List<String> submitUserIds, String description, String remark, JSONArray id2RejectIdArray, TbtskObjectinfo tableInfo, String taskId, TskTaskBiz tskTaskBiz, String xzqdmsys) {
        String content = String.format("\u3010\u4efb\u52a1\u56fe\u6591\u6253\u56de\u901a\u77e5\u3011\u3002\u4efb\u52a1\u540d\u79f0\uff1a" + tableInfo.getfTablealias() + "\uff1b\u6253\u56de\u4e86%s\u4e2a\u56fe\u6591", ids.size());
        if (StringUtils.isNotBlank((CharSequence)description)) {
            content = content + "  \u539f\u56e0\uff1a" + description + "";
        }
        if (StringUtils.isNotBlank((CharSequence)remark)) {
            content = content + "  \u5907\u6ce8\uff1a" + remark;
        }
        TaskNotice taskNotice = new TaskNotice();
        taskNotice.setData(StringUtils.join((Object[])ids.toArray(), (char)','));
        taskNotice.setContent(content);
        taskNotice.setId(UUID.randomUUID().toString());
        taskNotice.setState(Integer.valueOf(1));
        taskNotice.setSendUser(null);
        taskNotice.setTitle("\u4efb\u52a1\u56fe\u6591\u6253\u56de\u901a\u77e5");
        taskNotice.setSendTime(new Date());
        taskNotice.setType(Integer.valueOf(2));
        taskNotice.setAction(Integer.valueOf(11));
        taskNotice.setRegion("");
        taskNotice.setRegion1("");
        taskNotice.setMsgtype("0");
        taskNotice.setBizId(taskId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)ids.size());
        if (id2RejectIdArray != null) {
            jsonObject.put("rejectIds", (Object)id2RejectIdArray);
        }
        taskNotice.setAddition(jsonObject.toString());
        taskNotice = this.mTaskNoticeService.save(taskNotice);
        ArrayList<String> alias = new ArrayList<String>();
        for (int i = 0; i < submitUserIds.size(); ++i) {
            String userid = submitUserIds.get(i);
            TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
            taskNoticeUserNew.setId(UUID.randomUUID().toString());
            taskNoticeUserNew.setSenduser(userId.toString());
            taskNoticeUserNew.setTitle("\u4efb\u52a1\u56fe\u6591\u6253\u56de\u901a\u77e5");
            taskNoticeUserNew.setContent(content);
            taskNoticeUserNew.setAction(Integer.valueOf(11));
            taskNoticeUserNew.setTaskmode(tskTaskBiz.getMode());
            taskNoticeUserNew.setBizid(taskId);
            taskNoticeUserNew.setCount(Integer.valueOf(id2RejectIdArray.size()));
            taskNoticeUserNew.setReceiveuser(userid);
            taskNoticeUserNew.setData(StringUtils.join((Object[])ids.toArray(), (char)','));
            taskNoticeUserNew.setXzqdmsys(this.converXzqdmsysByGr(tskTaskBiz, xzqdmsys));
            taskNoticeUserNew.setSenddate(new Date());
            this.mTaskNoticeNewService.addTaskNoticeUserNew(taskNoticeUserNew);
            alias.add(userid);
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", 3);
        message.put("bizid", taskId);
        try {
            MixPushServer.sendNotifyToAlias(alias, (String)taskNotice.getTitle(), (String)taskNotice.getContent(), (String)JSON.toJSONString(message));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String converXzqdmsysByGr(TskTaskBiz task, String xzqdmsys) {
        String xzqdm = "";
        xzqdm = task.getGranularity() != null && task.getGranularity() == 3 ? xzqdmsys.substring(0, 6) : (task.getGranularity() != null && task.getGranularity() == 4 ? xzqdmsys.substring(0, 9) : (task.getGranularity() != null && task.getGranularity() == 5 ? xzqdmsys.substring(0, 12) : xzqdmsys.substring(0, 6)));
        return xzqdm;
    }

    private Pair<ReviewStageEnum, TbStatusEnum> getRejectTargetStageAndStatus(String taskId, Integer rejectType, String currentStepName, String targetStepName) {
        ReviewStageEnum targetStage = null;
        TbStatusEnum targetStatus = null;
        if (rejectType.equals(RejectTypeEnum.TO_OPERATOR.getCode())) {
            targetStage = ReviewStageEnum.OPERATOR_VERIFY;
            targetStatus = TbStatusEnum.SUBMIT;
        } else if (rejectType.equals(RejectTypeEnum.TO_PREVIOUS_STAGE.getCode())) {
            String preStep = this.getRejectPreStep(taskId, currentStepName);
            if ("\u4f5c\u4e1a\u5458\u63d0\u62a5\u9636\u6bb5".equals(preStep)) {
                targetStage = ReviewStageEnum.OPERATOR_VERIFY;
                targetStatus = TbStatusEnum.SUBMIT;
            } else {
                JSONObject preStepJsonObj = JSONObject.parseObject((String)preStep);
                if (preStepJsonObj != null) {
                    String preTwoStep = this.getRejectPreStep(taskId, preStepJsonObj.get((Object)"name").toString());
                    if ("\u4f5c\u4e1a\u5458\u63d0\u62a5\u9636\u6bb5".equals(preTwoStep)) {
                        ReviewStageEnum reviewStageEnum;
                        targetStage = reviewStageEnum = this.getFirstStageOfFlow(taskId);
                        targetStatus = TbStatusEnum.WAITING_VERIFY;
                    } else {
                        JSONObject preTwoStepJsonObj = JSONObject.parseObject((String)preTwoStep);
                        if (preTwoStepJsonObj.containsKey((Object)"post_stage") && StringUtils.isNotBlank((CharSequence)preTwoStepJsonObj.get((Object)"post_stage").toString())) {
                            targetStage = ReviewStageEnum.getEnum((int)Integer.parseInt(preTwoStepJsonObj.get((Object)"post_stage").toString()));
                        }
                        if (preTwoStepJsonObj.containsKey((Object)"post_status") && StringUtils.isNotBlank((CharSequence)preTwoStepJsonObj.get((Object)"post_status").toString())) {
                            targetStatus = TbStatusEnum.getEnum((int)Integer.parseInt(preTwoStepJsonObj.get((Object)"post_status").toString()));
                        }
                    }
                }
            }
        } else if (rejectType.equals(RejectTypeEnum.TO_CUSTOM_STAGE.getCode()) && StringUtils.isNotBlank((CharSequence)targetStepName)) {
            switch (targetStepName) {
                case "\u6751\u7ea7\u5ba1\u6838": {
                    targetStage = ReviewStageEnum.VILLAGE_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_VERIFY;
                    break;
                }
                case "\u6751\u7ea7\u590d\u6838": {
                    targetStage = ReviewStageEnum.VILLAGE_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_REVIEW;
                    break;
                }
                case "\u4e61\u9547\u5ba1\u6838": {
                    targetStage = ReviewStageEnum.TOWN_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_VERIFY;
                    break;
                }
                case "\u4e61\u9547\u590d\u6838": {
                    targetStage = ReviewStageEnum.TOWN_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_REVIEW;
                    break;
                }
                case "\u533a\u53bf\u5ba1\u6838": {
                    targetStage = ReviewStageEnum.COUNTY_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_VERIFY;
                    break;
                }
                case "\u533a\u53bf\u590d\u6838": {
                    targetStage = ReviewStageEnum.COUNTY_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_REVIEW;
                    break;
                }
                case "\u5e02\u7ea7\u5ba1\u6838": {
                    targetStage = ReviewStageEnum.CITY_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_VERIFY;
                    break;
                }
                case "\u5e02\u7ea7\u590d\u6838": {
                    targetStage = ReviewStageEnum.CITY_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_REVIEW;
                    break;
                }
                case "\u7701\u7ea7\u5ba1\u6838": {
                    targetStage = ReviewStageEnum.PROVINCE_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_VERIFY;
                    break;
                }
                case "\u7701\u7ea7\u590d\u6838": {
                    targetStage = ReviewStageEnum.PROVINCE_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_REVIEW;
                    break;
                }
                case "\u56fd\u5bb6\u5ba1\u6838": {
                    targetStage = ReviewStageEnum.COUNTRY_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_VERIFY;
                    break;
                }
                case "\u56fd\u5bb6\u590d\u6838": {
                    targetStage = ReviewStageEnum.COUNTRY_VERIFY;
                    targetStatus = TbStatusEnum.WAITING_REVIEW;
                    break;
                }
                case "\u4f5c\u4e1a\u5458": {
                    targetStage = ReviewStageEnum.OPERATOR_VERIFY;
                    targetStatus = TbStatusEnum.SUBMIT;
                    break;
                }
                default: {
                    targetStage = ReviewStageEnum.OPERATOR_VERIFY;
                    targetStatus = TbStatusEnum.SUBMIT;
                }
            }
        }
        return Pair.of((Object)targetStage, (Object)targetStatus);
    }

    private String getRejectPreStep(String taskId, String stepName) {
        JSONArray stepsJsonArray;
        TbtskFlowDef flowDef;
        String result = "\u4f5c\u4e1a\u5458\u63d0\u62a5\u9636\u6bb5";
        List flowDefs = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, Integer.valueOf(FlowTypeEnum.AUDIT.getCode()));
        if (!GutilCollection.isEmpty((Collection)flowDefs) && (flowDef = (TbtskFlowDef)flowDefs.get(0)).getSteps() != null && (stepsJsonArray = JSONArray.parseArray((String)flowDef.getSteps(), (Feature[])new Feature[0])) != null) {
            JSONObject jsonObj = null;
            for (int i = 0; i < stepsJsonArray.size(); ++i) {
                jsonObj = JSONObject.parseObject((String)stepsJsonArray.get(i).toString());
                if (jsonObj != null && jsonObj.containsKey((Object)"name") && StringUtils.isNotBlank((CharSequence)jsonObj.get((Object)"name").toString()) && jsonObj.get((Object)"name").toString().equals(stepName)) {
                    if (i == 0) {
                        result = "\u4f5c\u4e1a\u5458\u63d0\u62a5\u9636\u6bb5";
                        break;
                    }
                    result = stepsJsonArray.get(i - 1).toString();
                    break;
                }
                jsonObj = null;
            }
        }
        return result;
    }

    @Transactional
    public Pair<Boolean, String> revoke(String taskId, String tbId, Integer auditType, String remark, String stepName, Long userId) {
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            return Pair.of((Object)false, (Object)"\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        TbtskObjectinfo objectInfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == objectInfo) {
            return Pair.of((Object)false, (Object)"\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
        Map data = this.mDataBizService.selectFieldByID(objectInfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            return Pair.of((Object)false, (Object)"\u56fe\u6591\u4e0d\u5b58\u5728");
        }
        List<FlowStep> flowSteps = this.getAuditFlowSteps(taskId);
        if (GutilCollection.isEmpty(flowSteps)) {
            return Pair.of((Object)false, (Object)"\u5ba1\u6838\u6d41\u7a0b\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
        Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
        Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
        boolean hasReview = this.containsReviewStep(flowSteps);
        TbtskApproveRecord record = this.tbtskApproveRecordRepository.queryLatestApproveRecord(taskId, tbId, rejectCount);
        if (record != null && record.getApproveUserId().equals(userId) && (record.getIsRevoked() == null || record.getIsRevoked().equals(0))) {
            String revokeRecordId = UUID.randomUUID().toString();
            record.setRevokeRecordId(revokeRecordId);
            record.setIsRevoked(Integer.valueOf(1));
            this.tbtskApproveRecordRepository.save((Object)record);
            TbtskRevokeRecord tbtskRevokeRecord = TbtskRevokeRecord.builder().id(revokeRecordId).taskId(taskId).tbId(tbId).revokeTime(new Date()).approveRecordId(record.getId()).remark(remark).stepName(stepName).userId(userId).userName(this.userNameService.getUserNameByUserId(userId.toString())).build();
            this.tbtskRevokeRecordService.insert(tbtskRevokeRecord);
            this.updateTbStatusAndReviewStage(taskId, tbId, objectInfo, flowSteps, status, reviewStage, hasReview, record);
            return Pair.of((Object)true, (Object)"\u64a4\u56de\u6210\u529f");
        }
        return Pair.of((Object)false, (Object)"\u64a4\u56de\u5931\u8d25");
    }

    private void updateTbStatusAndReviewStage(String taskId, String tbId, TbtskObjectinfo objectInfo, List<FlowStep> flowSteps, Integer status, Integer reviewStage, boolean hasReview, TbtskApproveRecord record) {
        for (int i = 0; i < flowSteps.size(); ++i) {
            if (!record.getStepindex().equals(flowSteps.get(i).getIndex())) continue;
            Integer newStatus = null;
            Integer newReviewStage = null;
            if (status.equals(TbStatusEnum.WAITING_VERIFY.getCode())) {
                if (i < 1) {
                    newReviewStage = this.getFirstStageOfFlow(taskId).getCode();
                } else {
                    FlowStep preStep = flowSteps.get(i - 1);
                    newReviewStage = Integer.valueOf(preStep.getPost_stage());
                }
                newStatus = hasReview ? Integer.valueOf(TbStatusEnum.WAITING_REVIEW.getCode()) : Integer.valueOf(TbStatusEnum.WAITING_VERIFY.getCode());
            } else if (status.equals(TbStatusEnum.WAITING_REVIEW.getCode())) {
                newReviewStage = reviewStage;
                newStatus = TbStatusEnum.WAITING_VERIFY.getCode();
            }
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            if (newStatus != null && !newStatus.equals(status)) {
                updateMap.put("f_status", newStatus);
            }
            if (newReviewStage != null && !newReviewStage.equals(reviewStage)) {
                updateMap.put("f_review_stage", newReviewStage);
            }
            if (!MapUtil.isNotEmpty(updateMap)) break;
            int n = this.mDataBizService.updateDataById(objectInfo.getfTablename(), tbId, updateMap);
            break;
        }
    }

    private boolean containsReviewStep(List<FlowStep> flowSteps) {
        boolean result = false;
        if (!GutilCollection.isEmpty(flowSteps)) {
            result = flowSteps.stream().filter(step -> StringUtils.isNotBlank((CharSequence)step.getName()) && step.getName().contains("\u590d\u6838")).count() > 0L;
        }
        return result;
    }

    public List<FlowStep> getAuditFlowSteps(String taskId) {
        return this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
    }

    public List<FlowStep> findFlowSteps(String taskId, FlowTypeEnum flowType) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        List flows = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, Integer.valueOf(flowType.getCode()));
        if (flows == null || flows.size() == 0) {
            return null;
        }
        List steps = (List)new Gson().fromJson(((TbtskFlowDef)flows.get(0)).getSteps(), new TypeToken<List<FlowStep>>(){}.getType());
        return steps;
    }

    public String rejectFinish(String taskId, String tbId, String remark, String stepName, Long userId, String userName, String description) throws Exception {
        Map data;
        String result = "";
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            throw new GwValidateException("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            throw new GwValidateException("\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
        fieldNameList.add("f_submit_userid");
        if (fieldNameList.contains("f_isfinish")) {
            fieldNameList.add("f_isfinish");
        }
        if ((data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'")) != null) {
            Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
            Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
            Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
            String submitUserId = MapUtils.getString((Map)data, (Object)"f_submit_userid", (String)"");
            String xzqdmsys = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
            if (status != null) {
                if (status < TbStatusEnum.WAITING_VERIFY.getCode()) {
                    result = "\u9a73\u56de\u5931\u8d25\uff0c\u56fe\u6591\u5c1a\u672a\u63d0\u4ea4\uff0c\u4e0d\u80fd\u9a73\u56de";
                } else {
                    int newRejectCount = rejectCount != null ? rejectCount : 0;
                    TbtskRejectDef rejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
                    if (rejectDef != null && rejectDef.getRejectType() != null) {
                        if (rejectDef.getRejectType().equals(RejectTypeEnum.DO_NOTHING.getCode())) {
                            result = "\u9a73\u56de\u5931\u8d25\uff0c\u6b64\u4efb\u52a1\u4e0d\u652f\u6301\u9a73\u56de";
                        } else {
                            HashMap<String, Object> updateMap = new HashMap<String, Object>();
                            updateMap.put("f_reject_status", 1);
                            updateMap.put("f_reject_count", newRejectCount + 1);
                            updateMap.put("f_review_stage", ReviewStageEnum.OPERATOR_VERIFY.getCode());
                            updateMap.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
                            updateMap.put("f_isfinish", 1);
                            updateMap.put("f_updatetime", System.currentTimeMillis());
                            int row = this.mDataBizService.updateData(tbtskObjectinfo.getfTablename(), updateMap, "f_id='" + tbId + "'");
                            if (row == 1) {
                                TbtskRejectRecord rejectRecord = this.saveRejectRecord(taskId, userId, remark, "\u53bf\u7ea7\u9a73\u56de\uff0c\u529e\u7ed3\u3002" + description, userName, stepName, tbId, reviewStage, ReviewStageEnum.OPERATOR_VERIFY.getCode());
                                if (submitUserId != null) {
                                    String receiverUserId = submitUserId;
                                    JSONArray id2RejectIdArray = new JSONArray();
                                    id2RejectIdArray.add((Object)(rejectRecord.getTbid() + ":" + rejectRecord.getId()));
                                    this.sendRejectMessageToAPPByPlatform(Arrays.asList(tbId.split(",")), userId, Arrays.asList(receiverUserId.split(",")), "\u53bf\u7ea7\u9a73\u56de\uff0c\u529e\u7ed3\u3002" + description, remark, id2RejectIdArray, tbtskObjectinfo, taskId, tskTaskBiz, xzqdmsys);
                                }
                                result = "\u9000\u56de\u6210\u529f";
                            } else {
                                result = "\u9a73\u56de\u5931\u8d25";
                            }
                        }
                    } else {
                        result = "\u9a73\u56de\u5931\u8d25\uff0c\u6b64\u4efb\u52a1\u4e0d\u672a\u914d\u7f6e\u6253\u56de\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
                    }
                }
            }
        }
        return result;
    }

    public Map checkRejectFinishPermission(String taskId, String tbId, Long userId) {
        Map data;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("hasPermission", false);
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return resultMap;
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return resultMap;
        }
        List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
        if (fieldNameList.contains("f_isfinish")) {
            fieldNameList.add("f_isfinish");
        }
        if (null == (data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'"))) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u4e0d\u5b58\u5728");
            return resultMap;
        }
        Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
        String xzqdm = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
        Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
        Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
        Integer rejectStatus = MapUtils.getInteger((Map)data, (Object)"f_reject_status", null);
        Integer finish = MapUtils.getInteger((Map)data, (Object)"f_isfinish", (Integer)0);
        if (status == null || status < TbStatusEnum.WAITING_VERIFY.getCode()) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u672a\u63d0\u62a5\uff0c\u4e0d\u80fd\u5ba1\u6838");
            return resultMap;
        }
        if (finish.equals(1)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u5df2\u7ecf\u56de\u9000\uff0c\u4e0d\u80fd\u91cd\u590d\u56de\u9000");
            return resultMap;
        }
        List<Integer> userRoleList = this.getUserRole(taskId, userId);
        if (GutilCollection.isEmpty(userRoleList)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u975e\u5ba1\u6838\u4eba\u5458\uff0c\u4e0d\u80fd\u56de\u9000");
            return resultMap;
        }
        if (userRoleList.stream().filter(role -> role.equals(UserRoleEnum.AUDITOR.getCode())).count() <= 0L) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u975e\u5ba1\u6838\u4eba\u5458\uff0c\u4e0d\u80fd\u56de\u9000");
            return resultMap;
        }
        List auditAreas = this.tbtskUserAuditAreaService.listAuditAreas(taskId, String.valueOf(userId), Short.valueOf((short)3));
        if (GutilCollection.isEmpty((Collection)auditAreas)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u975e\u533a\u53bf\u5ba1\u6838\u4eba\u5458\uff0c\u4e0d\u80fd\u56de\u9000");
            return resultMap;
        }
        Map permissionMap = this.queryPermissionByFilter(taskId, tbId, userId, xzqdm, status, reviewStage, rejectCount, rejectStatus);
        if (permissionMap != null) {
            for (Object key : permissionMap.keySet()) {
                resultMap.put(key.toString(), permissionMap.get(key));
            }
        }
        return resultMap;
    }

    public Map<String, Short> getBizAreaAndLevel(String taskId, Long userId, Integer role) {
        Map<String, Short> map;
        block20: {
            List areaLists;
            block19: {
                map = new HashMap<String, Short>();
                if (role.intValue() != UserRoleEnum.CREATOR.getCode()) break block19;
                List areaLists2 = this.landUserService.queryUserAreas(userId);
                if (GutilCollection.isEmpty((Collection)areaLists2)) break block20;
                for (String area : areaLists2) {
                    if (area.equals("1")) {
                        map.put(area, (short)0);
                        continue;
                    }
                    if (area.endsWith("0000")) {
                        map.put(area, (short)1);
                        continue;
                    }
                    if (area.endsWith("00")) {
                        map.put(area, (short)2);
                        continue;
                    }
                    map.put(area, (short)3);
                }
                break block20;
            }
            if (role.intValue() == UserRoleEnum.MANAGER.getCode()) {
                List list = this.tbtskUserManageAreaService.listManageAreas(taskId, userId.toString());
                map = list.stream().collect(Collectors.toMap(TbtskUserManageArea::getRegioncode, TbtskUserManageArea::getLevel));
            } else if (role.intValue() == UserRoleEnum.AUDITOR.getCode()) {
                List list = this.tbtskUserAuditAreaService.listAuditAreas(taskId, userId.toString());
                map = list.stream().collect(Collectors.toMap(TbtskUserAuditArea::getRegionCode, TbtskUserAuditArea::getLevel));
            } else if (role.intValue() == UserRoleEnum.SUPERAUDITOR.getCode()) {
                List list = this.tbtskSuperUserAuditAreaService.listAuditAreas(taskId, userId.toString());
                map = list.stream().collect(Collectors.toMap(TbtskSuperUserAuditArea::getRegionCode, TbtskSuperUserAuditArea::getLevel));
            } else if (role.intValue() == UserRoleEnum.REVIEWER.getCode()) {
                List list = this.mTbtskUserReviewAreaService.listReviewAreas(taskId, userId.toString());
                map = list.stream().collect(Collectors.toMap(TbtskUserReviewArea::getRegionCode, TbtskUserReviewArea::getLevel));
            } else if (role.intValue() == UserRoleEnum.UPLOADER.getCode()) {
                List list = this.tbtskUserUploadAreaService.listManageAreas(taskId, userId.toString());
                map = list.stream().collect(Collectors.toMap(TbtskUserUploadArea::getRegioncode, TbtskUserUploadArea::getLevel));
            } else if (role.intValue() == UserRoleEnum.OPERATOR.getCode() && !GutilCollection.isEmpty((Collection)(areaLists = this.landUser2AreaRepository.queryAreas(userId)))) {
                for (String area : areaLists) {
                    if (area.equals("1")) {
                        map.put(area, (short)0);
                        continue;
                    }
                    if (area.endsWith("0000")) {
                        map.put(area, (short)1);
                        continue;
                    }
                    if (area.endsWith("00")) {
                        map.put(area, (short)2);
                        continue;
                    }
                    map.put(area, (short)3);
                }
            }
        }
        return map;
    }

    public HashMap<Integer, Map<String, Short>> queryUserRoleAndRegionCodeOfTaskSC(String taskId, Long userId) {
        HashMap<Integer, Map<String, Short>> result = new HashMap<Integer, Map<String, Short>>();
        List userBiz2List = this.userBiz2Repository.findByUserId(userId);
        if (!GutilCollection.isEmpty((Collection)userBiz2List)) {
            for (UserBiz2 userBiz2 : userBiz2List) {
                Map<String, Short> map;
                if (!StringUtils.isNotBlank((CharSequence)userBiz2.getBizId()) || !userBiz2.getBizId().equalsIgnoreCase(taskId) || userBiz2.getRole() == null || !MapUtil.isNotEmpty(map = this.getBizAreaAndLevel(taskId, userId, userBiz2.getRole()))) continue;
                if (result.containsKey((int)userBiz2.getRole())) {
                    Map<String, Short> oldList = result.get((int)userBiz2.getRole());
                    if (MapUtil.isNotEmpty(oldList)) {
                        oldList.putAll(map);
                        result.put((int)userBiz2.getRole(), oldList);
                        continue;
                    }
                    result.put((int)userBiz2.getRole(), map);
                    continue;
                }
                result.put((int)userBiz2.getRole(), map);
            }
        }
        return result;
    }

    public TbStatusEnum queryTbStatus(String taskId, String tbId, Long userId) {
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            return TbStatusEnum.INIT;
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            return TbStatusEnum.INIT;
        }
        List<String> fieldNameList = MConfigTaskReviewService.getAuditFieldNameCollection();
        Map data = this.mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            return TbStatusEnum.INIT;
        }
        Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
        if (status != null) {
            return TbStatusEnum.getEnum((int)status);
        }
        return TbStatusEnum.INIT;
    }
}

