/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import cn.org.landcloud.security.Util;
import cn.org.landcloud.security.sm2.SM2SignVO;
import cn.org.landcloud.security.sm2.SM2SignVerUtils;
import cn.org.landcloud.security.sm3.SM3Utils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.TbtskSubmitReportRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.servface.review.TbtskFlowService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskClassService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskSubmitRecord;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TskAssignRecord;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.DateUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUserDetail;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserDetailRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDetailConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDetailInfo;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.servface.cffx.MCffxTaskService;
import com.geoway.landteam.landcloud.servface.customtask.task.MITaskRecieveService;
import com.geoway.landteam.landcloud.servface.xzjsydmj.MXzjsydmjService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskNoticeService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterTaskTransmitDataService;
import com.geoway.landteam.landcloud.service.pub.TbsysBhmanagerService;
import com.geoway.landteam.landcloud.service.util.TbbhUtils;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolConfigMapper;
import com.gw.base.data.GwValidateException;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
@Transactional(rollbackFor={Exception.class})
public class MMyWorkService {
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    TbtskFlowService tbtskFlowService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    TbtskSubmitReportRepository tbtskSubmitReportRepository;
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    OuterTaskTransmitDataService outerTaskTransmitDataService;
    @Autowired
    RegionService regionService;
    @Autowired
    TbsysBhmanagerService tbsysBhmanagerService;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    LandUserDetailRepository userDetailRepository;
    @Autowired
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    MTaskNoticeService mTaskNoticeService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    SysConfigRepository sysConfigRepository;
    @Autowired
    MITaskRecieveService taskRecieveService;
    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;
    @Autowired
    MCffxTaskService mCffxTaskService;
    @Autowired
    MXzjsydmjService mXzjsydmjService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    PatrolConfigMapper patrolConfigMapper;
    @Autowired
    TbtskTaskClassService tbtskTaskClassService;
    @Autowired
    TbbhUtils tbbhUtils;

    public JSONArray upload(HttpServletRequest request, Long userId, String bizId, Integer level) throws Exception {
        JSONArray jsonResult = new JSONArray();
        MultipartFile fileOfDB = ((MultipartHttpServletRequest)request).getFile("file");
        File tempUploadFile = this.buildTempUploadFile(userId.toString());
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        LandUserDetail user = this.userDetailRepository.findById((Object)userId).orElse(null);
        String xzqdm = "";
        List areas = this.landUser2AreaDao.queryAreas(userId);
        if (areas != null && areas.size() > 0) {
            xzqdm = (String)areas.get(0);
        }
        String orgId = "";
        if (request.getSession().getAttribute("user-organization") != null) {
            orgId = request.getSession().getAttribute("user-organization").toString();
        }
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        String sql = "";
        String sqlPrj = "";
        sql = "select * from media";
        rs = statement.executeQuery(sql);
        ArrayList<AppMedia> listMedia = new ArrayList<AppMedia>();
        while (rs.next()) {
            AppMedia appMedia = this.getAppMedia(rs);
            appMedia.setUsername(user.getName());
            appMedia.setBizId(bizId);
            listMedia.add(appMedia);
        }
        this.appMediaRepository.saveAll(listMedia);
        connPool.closeAll(connection, statement, rs);
        tempUploadFile.delete();
        return jsonResult;
    }

    public static double format7(double value) {
        double result = MMyWorkService.toFixed(BigDecimal.valueOf(value), 7).doubleValue();
        return result;
    }

    public static String format7Str(double value) {
        return MMyWorkService.toFixed(BigDecimal.valueOf(value), 7).toPlainString();
    }

    public static double format2(double value) {
        return MMyWorkService.toFixed(BigDecimal.valueOf(value), 2).doubleValue();
    }

    public static String format2Str(double value) {
        return MMyWorkService.toFixed(BigDecimal.valueOf(value), 2).toPlainString();
    }

    public static int format0(double value) {
        return MMyWorkService.toFixed(BigDecimal.valueOf(value), 0).intValue();
    }

    public static String format0Str(double value) {
        return MMyWorkService.toFixed(BigDecimal.valueOf(value), 0).toPlainString();
    }

    public static BigDecimal toFixed(BigDecimal bigDecimal, int scale) {
        String plainStr = bigDecimal.toPlainString();
        if (plainStr.indexOf(".") != -1) {
            String xiaoshu = plainStr.substring(plainStr.indexOf(".") + 1);
            if (xiaoshu.length() > scale) {
                bigDecimal = bigDecimal.setScale(scale, 4);
                return MMyWorkService.delEndZero(bigDecimal);
            }
            return MMyWorkService.delEndZero(bigDecimal);
        }
        return bigDecimal;
    }

    private static BigDecimal delEndZero(BigDecimal bigDecimal) {
        while (bigDecimal.toPlainString().contains(".") && bigDecimal.toPlainString().endsWith("0")) {
            String str = bigDecimal.toPlainString().substring(0, bigDecimal.toPlainString().length() - 1);
            bigDecimal = new BigDecimal(str);
        }
        return bigDecimal;
    }

    public boolean verifyJym(ResultSet rs) throws SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer buffer = new StringBuffer();
        buffer.append(rs.getString("f_sm3")).append(",");
        buffer.append(sdf.format(new Date(rs.getLong("f_time")))).append(",");
        buffer.append(MMyWorkService.format7Str(rs.getDouble("f_lon"))).append(",");
        buffer.append(MMyWorkService.format7Str(rs.getDouble("f_lat"))).append(",");
        buffer.append(MMyWorkService.format0Str(rs.getDouble("f_psfyj"))).append(",");
        buffer.append(MMyWorkService.format0Str(rs.getDouble("f_azimuth"))).append(",");
        buffer.append(MMyWorkService.format0Str(rs.getDouble("f_roll"))).append(",");
        buffer.append(rs.getString("f_psry")).append(",");
        buffer.append(rs.getString("f_zsdm"));
        String hash = SM3Utils.sm3((String)buffer.toString());
        SM2SignVO verify = SM2SignVerUtils.VerifySignSM2((byte[])Util.hexStringToBytes((String)"04D964FD6AE472FC3367C09935DEBFC9A613F6F084ED8CA5B4C2EBF0E9F9FA5146E1631B842FED8FD55B488674C37B5FE695A49EE5A52BBEEA0868C2E816E5C47C"), (byte[])hash.getBytes(StandardCharsets.UTF_8), (byte[])Util.hexToByte((String)Util.SM2SignHardToSoft((String)rs.getString("f_jym"))));
        if (verify != null) {
            return verify.isVerify();
        }
        return false;
    }

    public JSONArray upload1(MultipartFile[] files, AuthUserInfo authUserInfo, String bizId, String orgId) throws Exception {
        JSONArray jsonArray;
        Optional<Object> op;
        JSONObject jsonConfig;
        JSONArray jsonResult = new JSONArray();
        TskTaskBiz task = this.mTskTaskBizService.findByTaskId(bizId);
        TbtskTaskClass tbtskTaskClass = null;
        if (task.getClassId() != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)task.getClassId().toString())) {
            tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(task.getClassId());
        }
        if (files.length < 1) {
            return jsonResult;
        }
        CffxConfig cffxConfig = this.mCffxTaskService.getConfig();
        CffxDetailConfig detailConfig = null;
        if (cffxConfig.isAppUploadCffx()) {
            detailConfig = this.mCffxTaskService.getDetailConfig(cffxConfig, bizId);
        }
        boolean validGeoTopo = false;
        boolean disableMultiPolygon = false;
        String pkField = "f_id";
        SysConfig config = this.sysConfigRepository.queryByKey("validGeoConfig");
        if (config != null && (jsonConfig = JSONObject.parseObject((String)config.getValue())).containsKey((Object)"validTask") && (op = (jsonArray = jsonConfig.getJSONArray("validTask")).stream().filter(t -> bizId.equals(((JSONObject)t).getString("taskId"))).findFirst()).isPresent()) {
            JSONObject jsonObject = (JSONObject)op.get();
            validGeoTopo = jsonObject.getBoolean("validGeoTopo");
            disableMultiPolygon = jsonObject.getBoolean("disableMultiPolygon");
            pkField = jsonObject.getString("pkField");
        }
        boolean xzjsydmj = this.mXzjsydmjService.needXzjsydmj(bizId);
        ArrayList<String> xzjsydmjSql = new ArrayList<String>();
        MultipartFile fileOfDB = files[0];
        File tempUploadFile = this.buildTempUploadFile(authUserInfo.getUserId().toString());
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        JSONArray taskIds = new JSONArray();
        String tableInfoSql = "select * from table_info";
        ResultSet rs = statement.executeQuery(tableInfoSql);
        ArrayList tableInfoResult = new ArrayList();
        while (rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("f_tablename", rs.getString("f_tablename"));
            map.put("f_tableid", rs.getString("f_tableid"));
            map.put("f_allownedit", rs.getString("f_allownedit"));
            tableInfoResult.add(map);
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        for (Map map : tableInfoResult) {
            String tableName = map.get("f_tablename").toString();
            String f_tableid = map.get("f_tableid").toString();
            TbtskObjectinfo objectinfo = this.mTskTaskBizService.getTableByTableId(f_tableid);
            String allowEdit = map.get("f_allownedit").toString();
            String sqlField = "select * from task_fields where f_tablename='" + tableName + "'";
            ResultSet rsField = statement.executeQuery(sqlField);
            HashSet<String> editkeys = new HashSet<String>();
            HashSet<String> keys = new HashSet<String>();
            while (rsField.next()) {
                String key = rsField.getString("f_fieldname");
                keys.add(key);
            }
            List tbtskFieldsByTaskId = this.mTskTaskBizService.findTbtskFieldsByTableName(objectinfo.getfTablename()).stream().filter(r -> !r.getfFieldname().equals("f_submittime")).collect(Collectors.toList());
            ArrayList<String> autovalField = new ArrayList<String>();
            HashMap<String, String> autovalMap = new HashMap<String, String>();
            HashMap<String, Object> timeMap = new HashMap<String, Object>();
            for (TbtskFields tbtskFields : tbtskFieldsByTaskId) {
                boolean outer;
                Integer isIOS = tbtskFields.getfFieldInnerOuterSys();
                Integer isedit = tbtskFields.getfIsWebEdit();
                boolean bl = outer = (isIOS & 2) == 2;
                if (outer) {
                    editkeys.add(tbtskFields.getfFieldname());
                }
                if (tbtskFields.getfFieldtype().equals("11") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tbtskFields.getAutoVal())) {
                    autovalField.add(tbtskFields.getfFieldname());
                    autovalMap.put(tbtskFields.getfFieldname(), tbtskFields.getAutoVal());
                }
                if (!tbtskFields.getfFieldtype().equals("4") && !tbtskFields.getfFieldtype().equals("5")) continue;
                timeMap.put(tbtskFields.getfFieldname(), tbtskFields.getfFieldtype());
            }
            TbtskTaskClass parentTbtskTaskClass = this.tbtskTaskClassService.getParentTbtskTaskClass(task.getClassId());
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                String tableNamesql = "select * from " + tableName;
                ResultSet resultSet = statement.executeQuery(tableNamesql);
                String id = null;
                ArrayList<String> addList = new ArrayList<String>();
                ArrayList<String> updateList = new ArrayList<String>();
                while (resultSet.next()) {
                    Object object;
                    Object shape;
                    Timestamp ts;
                    Date date;
                    String tt;
                    Calendar calendar;
                    SimpleDateFormat dateFormat;
                    String kvalue;
                    JSONObject resultObject = new JSONObject();
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    int isMyCreat = resultSet.getInt("f_ismycreate");
                    String f_id = resultSet.getString("f_id");
                    resultObject.put("f_id", (Object)f_id);
                    Map mapdata = this.mDataBizService.selectByID(objectinfo.getfTablename(), "f_id", "'" + f_id + "'");
                    if (mapdata == null) {
                        JSONObject object2;
                        List fields;
                        String xzqname;
                        String xzq;
                        if (task.getMode().equals(2)) {
                            addList.add(f_id);
                        }
                        map2.put("f_lat", resultSet.getDouble("f_lat"));
                        map2.put("f_lon", resultSet.getDouble("f_lon"));
                        for (String key : keys) {
                            if (!StringUtils.isNotBlank((CharSequence)resultSet.getString(key))) continue;
                            kvalue = resultSet.getString(key);
                            map2.put(key, kvalue);
                            if (!timeMap.containsKey(key)) continue;
                            if (StringUtils.isNotBlank((CharSequence)kvalue)) {
                                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                try {
                                    long t2 = Long.parseLong(kvalue);
                                    calendar = Calendar.getInstance();
                                    calendar.setTimeInMillis(t2);
                                    tt = dateFormat.format(calendar.getTime());
                                    map2.put(key, tt);
                                }
                                catch (Exception ex) {
                                    try {
                                        date = dateFormat.parse(kvalue);
                                        map2.put(key, kvalue);
                                    }
                                    catch (ParseException e2) {
                                        ts = new Timestamp(Long.valueOf(kvalue));
                                        map2.put(key, ts);
                                    }
                                }
                                continue;
                            }
                            map2.put(key, null);
                        }
                        shape = "";
                        if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape"))) {
                            shape = resultSet.getString("f_shape");
                            map2.put("f_shape", "SRID=4490;" + (String)shape);
                        }
                        if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape1"))) {
                            map2.put("f_shape1", "SRID=4490;" + resultSet.getString("f_shape1"));
                        }
                        if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_b"))) {
                            map2.put("f_shape_b", "SRID=4490;" + resultSet.getString("f_shape_b"));
                        }
                        if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_g"))) {
                            map2.put("f_shape_g", "SRID=4490;" + resultSet.getString("f_shape_g"));
                        }
                        map2.put("f_status", "4");
                        if (tbtskTaskClass != null && "XCYW".equals(tbtskTaskClass.getAppkey())) {
                            map2.put("f_status", "10");
                            map2.put("f_review_stage", "90");
                        }
                        map2.put("f_id", resultSet.getString("f_id"));
                        map2.put("f_createtime", resultSet.getString("f_createtime"));
                        map2.put("f_committime", System.currentTimeMillis());
                        map2.put("f_updatetime", System.currentTimeMillis());
                        map2.put("f_upload_userid", authUserInfo.getUserRname());
                        map2.put("f_userid", authUserInfo.getUserId().toString());
                        map2.put("f_submit_userid", authUserInfo.getUserId().toString());
                        map2.put("f_ismycreate", resultSet.getString("f_ismycreate"));
                        map2.put("f_submittime", System.currentTimeMillis());
                        String pkFieldValue = f_id;
                        if (resultSet.findColumn(pkField) > -1) {
                            pkFieldValue = resultSet.getString(pkField);
                        }
                        this.cffx(map2, detailConfig, task, null);
                        if (validGeoTopo || disableMultiPolygon) {
                            this.valid(f_id, pkFieldValue, map2, validGeoTopo, disableMultiPolygon);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(xzq = resultSet.getString("f_xzqdm"))) && (xzqname = this.regionService.getNameByCode(xzq)) != null) {
                            map2.put("f_xzqmc1", xzqname);
                        }
                        if ((fields = tbtskFieldsByTaskId.stream().map(e -> e.getfFieldname()).collect(Collectors.toList())).contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)map2.get("f_xzqdmsys")))) {
                            map2.put("f_xzqdmcity", map2.get("f_xzqdmsys").toString().substring(0, 4) + "00");
                            map2.put("f_xzqdmcounty", map2.get("f_xzqdmsys").toString().substring(0, 6));
                            map2.put("f_xzqdmtown", map2.get("f_xzqdmsys").toString().substring(0, 9));
                        }
                        if (StringUtils.isNotBlank((CharSequence)parentTbtskTaskClass.getParam())) {
                            String tbbh = this.tbbhUtils.getTaskTbbh(bizId, map2.get("f_xzqdmsys").toString());
                            map2.put("f_tbbh", tbbh);
                            object = new JSONObject();
                            object.put("f_tbbh", (Object)tbbh);
                            resultObject.put("data", object);
                        }
                        if (autovalField.size() > 0) {
                            JSONObject jsonObject = new JSONObject();
                            object = autovalField.iterator();
                            while (object.hasNext()) {
                                String s = (String)object.next();
                                Pair<String, String> paramKey = this.tbsysBhmanagerService.getParamKey(autovalMap.get(s).toString(), map2);
                                String bhNextValue = this.tbsysBhmanagerService.getBhNextValue(objectinfo.getfTablename(), s, (String)paramKey.getLeft(), Integer.valueOf((String)paramKey.getRight()));
                                map2.put(s, bhNextValue);
                                jsonObject.put(s, (Object)bhNextValue);
                            }
                            resultObject.put("data", (Object)jsonObject);
                        }
                        if ((object2 = JSONObject.parseObject((String)task.getConfigArgs())).get((Object)"isxjzf") != null && object2.get((Object)"isxjzf").toString().equals("1")) {
                            map2.put("f_status", 10);
                            map2.put("f_reject_status", null);
                            FlowStep flow = this.tbtskFlowService.findFlow(bizId, Integer.valueOf(1), Integer.valueOf(0));
                            if (flow != null) {
                                String pre_stages = flow.getPre_stages();
                                String[] split = pre_stages.split(",");
                                map2.put("f_review_stage", split[1]);
                            }
                        }
                        this.mDataBizService.insertDataByTimeStamp(objectinfo.getfTablename(), map2, "f_shape");
                        if (xzjsydmj && StringUtils.isNotBlank((CharSequence)shape)) {
                            xzjsydmjSql.add(String.format("insert into xzjsydmj(f_id,f_shape,f_split,f_taskid) values('%s','%s','0','%s')", f_id, shape, bizId));
                        }
                        datas.add(map2);
                        TskAssignRecord tar = new TskAssignRecord();
                        tar.setTaskId(bizId);
                        tar.setDataId(resultSet.getString("f_id"));
                        tar.setCreateTime(DateUtils.getSysTime());
                        tar.setAssignto(authUserInfo.getUserId().toString());
                        tar.setOptUserId(authUserInfo.getUserId().toString());
                        tar.setSourceId(orgId);
                        tar.setStatus("1");
                        tar.setSourceType("org");
                        this.tskAssignRecordRepository.save((Object)tar);
                        taskIds.add((Object)resultSet.getString("f_id"));
                    } else {
                        if (task.getMode().equals("2")) {
                            updateList.add(f_id);
                        }
                        id = resultSet.getString("f_id");
                        for (String key : editkeys) {
                            kvalue = resultSet.getString(key);
                            map2.put(key, kvalue);
                            if (!timeMap.containsKey(key)) continue;
                            if (StringUtils.isNotBlank((CharSequence)kvalue)) {
                                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                try {
                                    long t3 = Long.parseLong(kvalue);
                                    calendar = Calendar.getInstance();
                                    calendar.setTimeInMillis(t3);
                                    tt = dateFormat.format(calendar.getTime());
                                    map2.put(key, tt);
                                }
                                catch (Exception ex) {
                                    try {
                                        date = dateFormat.parse(kvalue);
                                        map2.put(key, kvalue);
                                    }
                                    catch (ParseException e3) {
                                        ts = new Timestamp(Long.valueOf(kvalue));
                                        map2.put(key, ts);
                                    }
                                }
                                continue;
                            }
                            map2.put(key, null);
                        }
                        if ("1".equals(allowEdit)) {
                            map2.put("f_lat", resultSet.getDouble("f_lat"));
                            map2.put("f_lon", resultSet.getDouble("f_lon"));
                            map2.put("f_lat_b", resultSet.getDouble("f_lat_b"));
                            map2.put("f_lon_b", resultSet.getDouble("f_lon_b"));
                            map2.put("f_lat_g", resultSet.getDouble("f_lat_g"));
                            map2.put("f_lon_g", resultSet.getDouble("f_lon_g"));
                            shape = "";
                            if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape"))) {
                                shape = resultSet.getString("f_shape");
                                map2.put("f_shape", "SRID=4490;" + (String)shape);
                            }
                            if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape1"))) {
                                map2.put("f_shape1", "SRID=4490;" + resultSet.getString("f_shape1"));
                            }
                            if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_b"))) {
                                map2.put("f_shape_b", "SRID=4490;" + resultSet.getString("f_shape_b"));
                            }
                            if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_g"))) {
                                map2.put("f_shape_g", "SRID=4490;" + resultSet.getString("f_shape_g"));
                            }
                            if (xzjsydmj && StringUtils.isNotBlank((CharSequence)shape)) {
                                xzjsydmjSql.add(String.format("insert into xzjsydmj(f_id,f_shape,f_split,f_taskid) values('%s','%s','0','%s')", f_id, shape, bizId));
                            }
                        }
                        map2.put("f_status", "4");
                        map2.put("f_upload_userid", authUserInfo.getUserRname());
                        map2.put("f_submit_userid", authUserInfo.getUserId().toString());
                        map2.put("f_committime", System.currentTimeMillis());
                        map2.put("f_updatetime", System.currentTimeMillis());
                        List fields = tbtskFieldsByTaskId.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
                        if (fields.contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)map2.get("f_xzqdmsys")))) {
                            map2.put("f_xzqdmcity", map2.get("f_xzqdmsys").toString().substring(0, 4) + "00");
                            map2.put("f_xzqdmcounty", map2.get("f_xzqdmsys").toString().substring(0, 6));
                            map2.put("f_xzqdmtown", map2.get("f_xzqdmsys").toString().substring(0, 9));
                        }
                        TskAssignRecord sr = null;
                        List srList = this.tskAssignRecordRepository.findByTaskIdAndAssigntoAndDataIdList(bizId, authUserInfo.getUserId().toString(), id);
                        if (srList != null && srList.size() > 0) {
                            sr = (TskAssignRecord)srList.get(0);
                        }
                        if (sr != null) {
                            sr.setStatus("1");
                            this.tskAssignRecordRepository.save((Object)sr);
                        } else {
                            TskAssignRecord tar = new TskAssignRecord();
                            tar.setStatus("1");
                            tar.setSourceType("org");
                            tar.setTaskId(bizId);
                            tar.setDataId(id);
                            tar.setCreateTime(DateUtils.getSysTime());
                            tar.setAssignto(authUserInfo.getUserId().toString());
                            tar.setOptUserId(authUserInfo.getUserId().toString());
                            tar.setSourceId(orgId);
                            this.tskAssignRecordRepository.save((Object)tar);
                            taskIds.add((Object)id);
                        }
                        if (StringUtils.isNotBlank((CharSequence)id)) {
                            ArrayList<String> field1s = new ArrayList<String>();
                            field1s.add("f_id");
                            field1s.add("f_status");
                            Map currObj = this.mDataBizService.selectFieldByID(objectinfo.getfTablename(), field1s, "f_id", "'" + id + "'");
                            if (currObj.get("f_status") != null && Integer.parseInt(currObj.get("f_status").toString()) < 10) {
                                if ("1".equals(allowEdit)) {
                                    String pkFieldValue = id;
                                    if (mapdata.containsKey(pkField)) {
                                        pkFieldValue = mapdata.get(pkField) == null ? "" : mapdata.get(pkField).toString();
                                    }
                                    this.cffx(map2, detailConfig, task, null);
                                    if (validGeoTopo || disableMultiPolygon) {
                                        this.valid(id, pkFieldValue, map2, validGeoTopo, disableMultiPolygon);
                                    }
                                }
                                if ((object = JSONObject.parseObject((String)task.getConfigArgs())).get((Object)"isxjzf") != null && object.get((Object)"isxjzf").toString().equals("1")) {
                                    map2.put("f_status", 10);
                                    map2.put("f_reject_status", null);
                                    FlowStep flow = this.tbtskFlowService.findFlow(bizId, Integer.valueOf(1), Integer.valueOf(0));
                                    if (flow != null) {
                                        String pre_stages = flow.getPre_stages();
                                        String[] split = pre_stages.split(",");
                                        map2.put("f_review_stage", split[1]);
                                    }
                                }
                                this.mDataBizService.updateData(objectinfo.getfTablename(), map2, " f_id = '" + id + "'");
                                map2.put("f_id", id);
                                datas.add(map2);
                            }
                        }
                    }
                    jsonResult.add((Object)resultObject);
                }
                this.createTaskRecord(task, addList, updateList, authUserInfo.getUserId());
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)objectinfo.getSplitTableName())) continue;
            this.handlyChildData(objectinfo.getSplitTableName(), statement, editkeys, keys, authUserInfo, allowEdit, xzjsydmj, xzjsydmjSql, bizId, timeMap);
        }
        String mediasql = "select * from media";
        rs = statement.executeQuery(mediasql);
        ArrayList<AppMedia> arrayList = new ArrayList<AppMedia>();
        while (rs.next()) {
            AppMedia appMedia = this.getAppMedia(rs);
            appMedia.setUsername(authUserInfo.getUsername());
            appMedia.setBizId(bizId);
            arrayList.add(appMedia);
        }
        if (task != null && "2".equals(task.getType()) && 2 == task.getMode()) {
            JSONArray groups = new JSONArray();
            groups.add((Object)authUserInfo.getUserId());
            this.taskRecieveService.recieveTask(authUserInfo.getUserId(), task.getId(), taskIds, groups);
        }
        if (task.getSource().equals("\u5185\u7f51\u4efb\u52a1")) {
            this.outerTaskTransmitDataService.doWork(datas, bizId, arrayList, authUserInfo.getUserId());
        }
        this.appMediaRepository.saveAll(arrayList);
        connPool.closeAll(connection, statement, rs);
        tempUploadFile.delete();
        if (xzjsydmj && !xzjsydmjSql.isEmpty()) {
            ArrayList fields = new ArrayList();
            fields.addAll(Arrays.stream(org.apache.commons.lang3.StringUtils.split((String)"f_id,f_shape,f_split,f_taskid", (String)",")).collect(Collectors.toList()));
            this.mXzjsydmjService.xzjsydmj(xzjsydmjSql, "xzjsydmj", bizId, fields, "f_shape");
        }
        return jsonResult;
    }

    void createTaskRecord(TskTaskBiz task, List<String> addList, List<String> updateList, Long userId) {
        if (task.getMode().equals(2)) {
            TaskRecordTemp temp;
            ArrayList<TaskRecordTemp> tempList;
            if (!addList.isEmpty()) {
                JSONObject additionJson = new JSONObject();
                additionJson.put("count", (Object)addList.size());
                additionJson.put("addOrUpdate", (Object)"ADD");
                additionJson.put("taskMode", (Object)task.getMode());
                additionJson.put("curMode", (Object)"receive");
                String recordId = UUID.randomUUID().toString();
                TaskDataDbParameter parameter = new TaskDataDbParameter();
                parameter.setRecordId(recordId);
                parameter.setTaskId(task.getId());
                parameter.setGroups(new JSONArray());
                parameter.setOrgs(new JSONArray());
                parameter.setAddition(additionJson);
                parameter.setDate(String.valueOf(System.currentTimeMillis()));
                parameter.setMode(task.getMode().toString());
                tempList = new ArrayList<TaskRecordTemp>();
                for (int i = 0; i < addList.size(); ++i) {
                    temp = new TaskRecordTemp();
                    temp.setId(UUID.randomUUID().toString());
                    temp.setRecordid(recordId);
                    temp.setDataid(addList.get(i));
                    tempList.add(temp);
                }
                this.taskRecordService.saveTaskRecordTemp(tempList);
                TaskRecord record2 = new TaskRecord();
                record2.setId(recordId);
                record2.setParam(JSONObject.toJSONString((Object)parameter));
                record2.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record2.setStarttime(new Date());
                record2.setState(Integer.valueOf(1));
                record2.setUserid(userId);
                this.taskRecordService.save(record2);
            }
            if (!updateList.isEmpty()) {
                String recordId1 = UUID.randomUUID().toString();
                JSONObject additionJson1 = new JSONObject();
                additionJson1.put("count", (Object)updateList.size());
                additionJson1.put("addOrUpdate", (Object)"UPDATE");
                additionJson1.put("taskMode", (Object)task.getMode());
                additionJson1.put("curMode", (Object)"receive");
                TaskDataDbParameter parameter1 = new TaskDataDbParameter();
                parameter1.setRecordId(recordId1);
                parameter1.setTaskId(task.getId());
                parameter1.setGroups(new JSONArray());
                parameter1.setOrgs(new JSONArray());
                parameter1.setAddition(additionJson1);
                parameter1.setDate(String.valueOf(System.currentTimeMillis()));
                parameter1.setMode(task.getMode().toString());
                tempList = new ArrayList();
                for (int i = 0; i < updateList.size(); ++i) {
                    temp = new TaskRecordTemp();
                    temp.setId(UUID.randomUUID().toString());
                    temp.setRecordid(recordId1);
                    temp.setDataid(updateList.get(i));
                    tempList.add(temp);
                }
                this.taskRecordService.saveTaskRecordTemp(tempList);
                TaskRecord record1 = new TaskRecord();
                record1.setId(recordId1);
                record1.setParam(JSONObject.toJSONString((Object)parameter1));
                record1.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record1.setStarttime(new Date());
                record1.setState(Integer.valueOf(1));
                record1.setUserid(userId);
                this.taskRecordService.save(record1);
            }
        }
    }

    public JSONArray upload2(MultipartFile[] files, AuthUserInfo authUserInfo, String bizId, String orgId) throws Exception {
        Long userId = authUserInfo.getUserId();
        JSONArray jsonResult = new JSONArray();
        TskTaskBiz task = this.mTskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo tableByTableId = this.mTskTaskBizService.getTableByTableId(task.getTableId());
        if (files.length < 1) {
            return jsonResult;
        }
        MultipartFile fileOfDB = files[0];
        File tempUploadFile = this.buildTempUploadFile(userId.toString());
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        String sql = "";
        JSONArray taskIds = new JSONArray();
        sql = "select * from table_info";
        rs = statement.executeQuery(sql);
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            String tableName = rs.getString("f_tablename");
            String allowEdit = rs.getString("f_allownedit");
            String sqlField = "select * from task_fields where f_tablename='" + tableName + "'";
            ResultSet rsField = statement.executeQuery(sqlField);
            HashSet<String> editkeys = new HashSet<String>();
            HashSet<String> keys = new HashSet<String>();
            while (rsField.next()) {
                String key = rsField.getString("f_fieldname");
                keys.add(key);
            }
            List<TbtskFields> tbtskFieldsByTaskId = this.mTskTaskBizService.findTbtskFieldsByTableName(tableName);
            ArrayList<String> autovalField = new ArrayList<String>();
            HashMap<String, String> autovalMap = new HashMap<String, String>();
            HashMap<String, Object> timeMap = new HashMap<String, Object>();
            for (TbtskFields tbtskFields : tbtskFieldsByTaskId) {
                boolean outer;
                Integer isIOS = tbtskFields.getfFieldInnerOuterSys();
                Integer isedit = tbtskFields.getfIsWebEdit();
                boolean innerEdit = new Integer(1).equals(isedit) && 1 == isIOS;
                boolean bl = outer = (isIOS & 2) == 2;
                if (innerEdit || outer) {
                    editkeys.add(tbtskFields.getfFieldname());
                }
                if (tbtskFields.getfFieldtype().equals("11") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tbtskFields.getAutoVal())) {
                    autovalField.add(tbtskFields.getfFieldname());
                    autovalMap.put(tbtskFields.getfFieldname(), tbtskFields.getAutoVal());
                }
                if (!tbtskFields.getfFieldtype().equals("4") && !tbtskFields.getfFieldtype().equals("5")) continue;
                timeMap.put(tbtskFields.getfFieldname(), tbtskFields.getfFieldtype());
            }
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                sql = "select * from " + tableName;
                ResultSet resultSet = statement.executeQuery(sql);
                String id = null;
                while (resultSet.next()) {
                    Timestamp ts;
                    Timestamp timestamp;
                    Date date;
                    Object dateFormat;
                    JSONObject resultObject = new JSONObject();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    int isMyCreat = resultSet.getInt("f_ismycreate");
                    String f_id = resultSet.getString("f_id");
                    resultObject.put("f_id", (Object)f_id);
                    Map mapdata = this.mDataBizService.selectByID(tableName, "f_id", "'" + f_id + "'");
                    if (mapdata == null) {
                        String xzqname;
                        map.put("f_lat", resultSet.getDouble("f_lat"));
                        map.put("f_lon", resultSet.getDouble("f_lon"));
                        for (String key : keys) {
                            if (!StringUtils.isNotBlank((CharSequence)resultSet.getString(key))) continue;
                            map.put(key, resultSet.getString(key));
                            if (!timeMap.containsKey(key)) continue;
                            if (StringUtils.isNotBlank((CharSequence)resultSet.getString(key))) {
                                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                try {
                                    date = ((DateFormat)dateFormat).parse(resultSet.getString(key));
                                    timestamp = new Timestamp(date.getTime());
                                    map.put(key, timestamp);
                                }
                                catch (ParseException e) {
                                    ts = new Timestamp(Long.valueOf(resultSet.getString(key)));
                                    map.put(key, ts);
                                }
                                continue;
                            }
                            map.put(key, null);
                        }
                        if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape"))) {
                            map.put("f_shape", "SRID=4490;" + resultSet.getString("f_shape"));
                        }
                        if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape1"))) {
                            map.put("f_shape1", "SRID=4490;" + resultSet.getString("f_shape1"));
                        }
                        if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_b"))) {
                            map.put("f_shape_b", "SRID=4490;" + resultSet.getString("f_shape_b"));
                        }
                        if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_g"))) {
                            map.put("f_shape_g", "SRID=4490;" + resultSet.getString("f_shape_g"));
                        }
                        map.put("f_status", "10");
                        map.put("f_review_stage", "90");
                        map.put("f_id", resultSet.getString("f_id"));
                        map.put("f_createtime", resultSet.getString("f_createtime"));
                        map.put("f_committime", System.currentTimeMillis());
                        map.put("f_updatetime", System.currentTimeMillis());
                        map.put("f_upload_userid", authUserInfo.getUserRname());
                        map.put("f_userid", userId.toString());
                        map.put("f_submit_userid", userId.toString());
                        map.put("f_ismycreate", resultSet.getString("f_ismycreate"));
                        String xzq = resultSet.getString("f_xzqdm");
                        if (StringUtils.isNotBlank((CharSequence)xzq) && (xzqname = this.regionService.getNameByCode(xzq)) != null) {
                            map.put("f_xzqmc1", xzqname);
                        }
                        if (autovalField.size() > 0) {
                            JSONObject jsonObject = new JSONObject();
                            for (String s : autovalField) {
                                Pair<String, String> paramKey = this.tbsysBhmanagerService.getParamKey(autovalMap.get(s).toString(), map);
                                String bhNextValue = this.tbsysBhmanagerService.getBhNextValue(tableByTableId.getfTablename(), s, (String)paramKey.getLeft(), Integer.valueOf((String)paramKey.getRight()));
                                map.put(s, bhNextValue);
                                jsonObject.put(s, (Object)bhNextValue);
                            }
                            resultObject.put("data", (Object)jsonObject);
                        }
                        this.mDataBizService.insertDataByTimeStamp(tableByTableId.getfTablename(), map, "f_shape");
                        datas.add(map);
                        taskIds.add((Object)resultSet.getString("f_id"));
                    } else {
                        id = resultSet.getString("f_id");
                        for (String key : editkeys) {
                            map.put(key, resultSet.getString(key));
                            if (!timeMap.containsKey(key)) continue;
                            if (StringUtils.isNotBlank((CharSequence)resultSet.getString(key))) {
                                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                try {
                                    date = ((DateFormat)dateFormat).parse(resultSet.getString(key));
                                    timestamp = new Timestamp(date.getTime());
                                    map.put(key, timestamp);
                                }
                                catch (ParseException e) {
                                    ts = new Timestamp(Long.valueOf(resultSet.getString(key)));
                                    map.put(key, ts);
                                }
                                continue;
                            }
                            map.put(key, null);
                        }
                        if ("1".equals(allowEdit)) {
                            map.put("f_lat", resultSet.getDouble("f_lat"));
                            map.put("f_lon", resultSet.getDouble("f_lon"));
                            map.put("f_lat_b", resultSet.getDouble("f_lat_b"));
                            map.put("f_lon_b", resultSet.getDouble("f_lon_b"));
                            map.put("f_lat_g", resultSet.getDouble("f_lat_g"));
                            map.put("f_lon_g", resultSet.getDouble("f_lon_g"));
                            if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape"))) {
                                map.put("f_shape", "SRID=4490;" + resultSet.getString("f_shape"));
                            }
                            if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape1"))) {
                                map.put("f_shape1", "SRID=4490;" + resultSet.getString("f_shape1"));
                            }
                            if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_b"))) {
                                map.put("f_shape_b", "SRID=4490;" + resultSet.getString("f_shape_b"));
                            }
                            if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_g"))) {
                                map.put("f_shape_g", "SRID=4490;" + resultSet.getString("f_shape_g"));
                            }
                        }
                        map.put("f_status", "10");
                        map.put("f_upload_userid", authUserInfo.getUserRname());
                        map.put("f_submit_userid", userId.toString());
                        map.put("f_committime", System.currentTimeMillis());
                        map.put("f_updatetime", System.currentTimeMillis());
                        TskAssignRecord sr = null;
                        List srList = this.tskAssignRecordRepository.findByTaskIdAndAssigntoAndDataIdList(bizId, userId.toString(), id);
                        if (srList != null && srList.size() > 0) {
                            sr = (TskAssignRecord)srList.get(0);
                        }
                        if (sr != null) {
                            sr.setStatus("1");
                            this.tskAssignRecordRepository.save((Object)sr);
                        } else {
                            TskAssignRecord tar = new TskAssignRecord();
                            tar.setStatus("1");
                            tar.setSourceType("org");
                            tar.setTaskId(bizId);
                            tar.setDataId(id);
                            tar.setCreateTime(DateUtils.getSysTime());
                            tar.setAssignto(userId.toString());
                            tar.setOptUserId(userId.toString());
                            tar.setSourceId(orgId);
                            this.tskAssignRecordRepository.save((Object)tar);
                            taskIds.add((Object)id);
                        }
                        if (StringUtils.isNotBlank((CharSequence)id)) {
                            ArrayList<String> fields = new ArrayList<String>();
                            fields.add("f_id");
                            fields.add("f_status");
                            Map currObj = this.mDataBizService.selectFieldByID(tableByTableId.getfTablename(), fields, "f_id", "'" + id + "'");
                            if (currObj.get("f_status") != null && Integer.parseInt(currObj.get("f_status").toString()) < 10) {
                                this.mDataBizService.updateData(tableByTableId.getfTablename(), map, " f_id = '" + id + "'");
                                map.put("f_id", id);
                                datas.add(map);
                            }
                        }
                    }
                    jsonResult.add((Object)resultObject);
                }
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tableByTableId.getSplitTableName())) continue;
            this.handlyChildData(tableByTableId.getSplitTableName(), statement, editkeys, keys, authUserInfo, allowEdit, false, null, bizId, timeMap);
        }
        sql = "select * from media";
        rs = statement.executeQuery(sql);
        ArrayList<AppMedia> listMedia = new ArrayList<AppMedia>();
        while (rs.next()) {
            AppMedia appMedia = this.getAppMedia(rs);
            appMedia.setUsername(authUserInfo.getUsername());
            appMedia.setBizId(bizId);
            listMedia.add(appMedia);
        }
        if (task != null && "2".equals(task.getType()) && 2 == task.getMode()) {
            JSONArray groups = new JSONArray();
            groups.add((Object)userId);
            this.taskRecieveService.recieveTask(userId, task.getId(), taskIds, groups);
        }
        if (task.getSource().equals("\u5185\u7f51\u4efb\u52a1")) {
            this.outerTaskTransmitDataService.doWork(datas, bizId, listMedia, userId);
        }
        this.appMediaRepository.saveAll(listMedia);
        connPool.closeAll(connection, statement, rs);
        tempUploadFile.delete();
        return jsonResult;
    }

    public void handlyChildData(String tableName, Statement statement, Set<String> editkeys, Set<String> keys, AuthUserInfo user, String allowEdit, Boolean xzjsydmj, List<String> xzjsydmjSql, String taskId, Map<String, Object> timeMap) throws SQLException {
        String childtableName = tableName;
        if (childtableName.contains(".")) {
            String[] split = childtableName.split("\\.");
            childtableName = split[1];
        }
        if (this.existTable(statement, childtableName).booleanValue()) {
            String sql1 = "select * from " + childtableName;
            ResultSet resultSet = statement.executeQuery(sql1);
            String id = null;
            while (resultSet.next()) {
                Object shape;
                Timestamp ts;
                Timestamp timestamp;
                Date date;
                SimpleDateFormat dateFormat;
                HashMap<String, Object> map = new HashMap<String, Object>();
                String f_id = resultSet.getString("f_id");
                Map mapdata = this.mDataBizService.selectByID(tableName, "f_id", "'" + f_id + "'");
                if (mapdata == null) {
                    String xzqname;
                    String xzq;
                    map.put("f_lat", resultSet.getDouble("f_lat"));
                    map.put("f_lon", resultSet.getDouble("f_lon"));
                    for (String key : keys) {
                        if (!StringUtils.isNotBlank((CharSequence)resultSet.getString(key))) continue;
                        map.put(key, resultSet.getString(key));
                        if (!timeMap.containsKey(key)) continue;
                        if (StringUtils.isNotBlank((CharSequence)resultSet.getString(key))) {
                            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                date = dateFormat.parse(resultSet.getString(key));
                                timestamp = new Timestamp(date.getTime());
                                map.put(key, timestamp);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                                ts = new Timestamp(Long.valueOf(resultSet.getString(key)));
                                map.put(key, ts);
                            }
                            continue;
                        }
                        map.put(key, null);
                    }
                    shape = "";
                    if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape"))) {
                        shape = resultSet.getString("f_shape");
                        map.put("f_shape", "SRID=4490;" + (String)shape);
                    }
                    if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape1"))) {
                        map.put("f_shape1", "SRID=4490;" + resultSet.getString("f_shape1"));
                    }
                    if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_b"))) {
                        map.put("f_shape_b", "SRID=4490;" + resultSet.getString("f_shape_b"));
                    }
                    if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_g"))) {
                        map.put("f_shape_g", "SRID=4490;" + resultSet.getString("f_shape_g"));
                    }
                    map.put("f_status", "4");
                    map.put("f_id", resultSet.getString("f_id"));
                    map.put("f_createtime", resultSet.getString("f_createtime"));
                    map.put("f_committime", System.currentTimeMillis());
                    map.put("f_upload_userid", user.getUserRname());
                    map.put("f_userid", user.getUserId().toString());
                    map.put("f_submit_userid", user.getUserId().toString());
                    map.put("f_ismycreate", resultSet.getString("f_ismycreate"));
                    if (keys.contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)map.get("f_xzqdmsys")))) {
                        map.put("f_xzqdmcity", map.get("f_xzqdmsys").toString().substring(0, 4) + "00");
                        map.put("f_xzqdmcounty", map.get("f_xzqdmsys").toString().substring(0, 6));
                        map.put("f_xzqdmtown", map.get("f_xzqdmsys").toString().substring(0, 9));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(xzq = resultSet.getString("f_xzqdm"))) && (xzqname = this.regionService.getNameByCode(xzq)) != null) {
                        map.put("f_xzqmc1", xzqname);
                    }
                    this.mDataBizService.insertData(tableName, map, "f_shape");
                    if (!xzjsydmj.booleanValue() || !StringUtils.isNotBlank((CharSequence)shape)) continue;
                    xzjsydmjSql.add(String.format("insert into xzjsydmj(f_id,f_shape,f_split,f_taskid) values('%s','%s','1','%s')", f_id, shape, taskId));
                    continue;
                }
                id = resultSet.getString("f_id");
                for (String key : editkeys) {
                    map.put(key, resultSet.getString(key));
                    if (!timeMap.containsKey(key)) continue;
                    if (StringUtils.isNotBlank((CharSequence)resultSet.getString(key))) {
                        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            date = dateFormat.parse(resultSet.getString(key));
                            timestamp = new Timestamp(date.getTime());
                            map.put(key, timestamp);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                            ts = new Timestamp(Long.valueOf(resultSet.getString(key)));
                            map.put(key, ts);
                        }
                        continue;
                    }
                    map.put(key, null);
                }
                if ("1".equals(allowEdit)) {
                    map.put("f_lat", resultSet.getDouble("f_lat"));
                    map.put("f_lon", resultSet.getDouble("f_lon"));
                    map.put("f_lat_b", resultSet.getDouble("f_lat_b"));
                    map.put("f_lon_b", resultSet.getDouble("f_lon_b"));
                    map.put("f_lat_g", resultSet.getDouble("f_lat_g"));
                    map.put("f_lon_g", resultSet.getDouble("f_lon_g"));
                    shape = "";
                    if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape"))) {
                        shape = resultSet.getString("f_shape");
                        map.put("f_shape", "SRID=4490;" + (String)shape);
                    }
                    if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape1"))) {
                        map.put("f_shape1", "SRID=4490;" + resultSet.getString("f_shape1"));
                    }
                    if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_b"))) {
                        map.put("f_shape_b", "SRID=4490;" + resultSet.getString("f_shape_b"));
                    }
                    if (!StringUtils.isBlank((CharSequence)resultSet.getString("f_shape_g"))) {
                        map.put("f_shape_g", "SRID=4490;" + resultSet.getString("f_shape_g"));
                    }
                    if (xzjsydmj.booleanValue() && StringUtils.isNotBlank((CharSequence)shape)) {
                        xzjsydmjSql.add(String.format("insert into xzjsydmj(f_id,f_shape,f_split,f_taskid) values('%s','%s','1','%s')", f_id, shape, taskId));
                    }
                }
                map.put("f_status", "4");
                map.put("f_upload_userid", user.getUserRname());
                map.put("f_submit_userid", user.getUserId().toString());
                map.put("f_committime", System.currentTimeMillis());
                map.put("f_updatetime", System.currentTimeMillis());
                if (keys.contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)map.get("f_xzqdmsys")))) {
                    map.put("f_xzqdmcity", map.get("f_xzqdmsys").toString().substring(0, 4) + "00");
                    map.put("f_xzqdmcounty", map.get("f_xzqdmsys").toString().substring(0, 6));
                    map.put("f_xzqdmtown", map.get("f_xzqdmsys").toString().substring(0, 9));
                }
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                ArrayList<String> fields = new ArrayList<String>();
                fields.add("f_id");
                fields.add("f_status");
                Map currObj = this.mDataBizService.selectFieldByID(tableName, fields, "f_id", "'" + id + "'");
                if (currObj.get("f_status") == null || Integer.parseInt(currObj.get("f_status").toString()) >= 10) continue;
                this.mDataBizService.updateData(tableName, map, " f_id = '" + id + "'");
            }
        }
    }

    private void cffx(Map<String, Object> map, CffxDetailConfig detailConfig, TskTaskBiz task, String splitTableName) throws Exception {
        CffxDetailInfo detailInfo;
        if (detailConfig != null && (detailInfo = this.mCffxTaskService.cffx(map, detailConfig, task, splitTableName)) != null) {
            throw new Exception(detailInfo.getMsg());
        }
    }

    private void valid(String f_id, String pkFieldValue, Map map, boolean validGeoTopo, boolean disableMultiPolygon) throws Exception {
        String shape;
        WKTReader wktReader = new WKTReader();
        String string = shape = map.get("f_shape") == null ? null : map.get("f_shape").toString();
        if (StringUtils.isNotBlank((CharSequence)pkFieldValue)) {
            f_id = pkFieldValue;
        }
        if (shape.toLowerCase().startsWith("srid=4490;")) {
            shape = org.apache.commons.lang3.StringUtils.split((String)shape, (String)";")[1];
        }
        Geometry geo = wktReader.read(shape);
        if (validGeoTopo && !geo.isValid()) {
            throw new Exception("\u56fe\u6591:" + f_id + "\u5b58\u5728\u56fe\u5f62\u62d3\u6251\u9519\u8bef");
        }
        if (disableMultiPolygon) {
            MultiPolygon multiPolygon;
            MultiLineString multiLineString;
            boolean isMultiLine = false;
            boolean isMultiPolygon = false;
            boolean dataType = false;
            if (geo.getGeometryType().equals("Point")) {
                dataType = true;
            }
            if (geo.getGeometryType().equals("LineString")) {
                dataType = true;
            } else if (geo.getGeometryType().equals("MultiLineString")) {
                dataType = true;
                isMultiLine = true;
            }
            if (geo.getGeometryType().equals("Polygon")) {
                dataType = true;
            } else if (geo.getGeometryType().equals("MultiPolygon")) {
                dataType = true;
                isMultiPolygon = true;
            }
            if (!dataType) {
                throw new Exception("\u56fe\u6591:" + f_id + "\u6570\u636e\u7c7b\u578b\u9519\u8bef");
            }
            if (isMultiLine ? (multiLineString = (MultiLineString)geo).getNumGeometries() > 1 : isMultiPolygon && (multiPolygon = (MultiPolygon)geo).getNumGeometries() > 1) {
                throw new Exception("\u56fe\u6591:" + f_id + "\u6570\u636e\u7c7b\u578b\u9519\u8bef,\u4e0d\u652f\u6301\u591a\u90e8\u4ef6");
            }
        }
    }

    private Boolean existTable(Statement statement, String tableName) {
        try {
            String sql = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "'";
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return false;
        }
    }

    private AppMedia getAppMedia(ResultSet rs) throws SQLException {
        DecimalFormat format = new DecimalFormat("######0.00");
        AppMedia appMedia = new AppMedia();
        appMedia.setId(rs.getString("f_id"));
        appMedia.setGalleryid(rs.getString("f_galleryid"));
        appMedia.setType(rs.getObject("f_type") == null ? null : Integer.valueOf(Integer.parseInt(rs.getString("f_type"))));
        String time = rs.getString("f_time");
        if (StringUtils.isNotBlank((CharSequence)time)) {
            Long timeLong = null;
            try {
                timeLong = Long.valueOf(time);
            }
            catch (NumberFormatException e) {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                    timeLong = date.getTime();
                }
                catch (ParseException date) {
                    // empty catch block
                }
            }
            if (timeLong != null) {
                appMedia.setTime(String.valueOf(timeLong));
            }
        }
        appMedia.setLon(rs.getObject("f_lon") == null ? null : Double.valueOf(Double.parseDouble(rs.getString("f_lon"))));
        appMedia.setLat(rs.getObject("f_lat") == null ? null : Double.valueOf(Double.parseDouble(rs.getString("f_lat"))));
        String azimuth = rs.getString("f_azimuth");
        appMedia.setAzimuth(StringUtils.isNotBlank((CharSequence)azimuth) ? format.format(Double.parseDouble(azimuth)) : null);
        appMedia.setPitch(rs.getString("f_pitch"));
        appMedia.setShape(rs.getString("f_shape"));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appMedia.getShape())) {
            Geometry geo = null;
            try {
                geo = WKTUtil.wktToGeom((String)appMedia.getShape());
                Point pt = geo.getCentroid();
                int proNum = this.getColNum(pt.getX());
                String areasql = "select st_area(ST_Transform(ST_GeomFromText('" + WKTUtil.geomToWkt((Geometry)geo) + "',4490)," + proNum + "))/666.6666667 as area";
                Map areaMap = this.jdbcTemplate.queryForMap(areasql);
                String area = areaMap.get("area").toString();
                DecimalFormat df = new DecimalFormat("#.00");
                appMedia.setArea(Double.valueOf(Double.parseDouble(df.format(area))));
            }
            catch (org.locationtech.jts.io.ParseException e) {
                e.printStackTrace();
            }
        }
        appMedia.setVideorecord(rs.getString("f_videorecord"));
        appMedia.setServerpath(rs.getString("f_serverpath"));
        appMedia.setMediatimelength(rs.getObject("f_mediatimelength") == null ? null : Integer.valueOf(Integer.parseInt(rs.getString("f_mediatimelength"))));
        appMedia.setMediasize(rs.getObject("f_mediasize") == null ? null : Double.valueOf(Double.parseDouble(rs.getString("f_mediasize"))));
        appMedia.setMark(rs.getObject("f_mark") == null ? null : Integer.valueOf(Integer.parseInt(rs.getString("f_mark"))));
        appMedia.setTypetype(rs.getObject("f_typetype") == null ? null : Integer.valueOf(Integer.parseInt(rs.getString("f_typetype"))));
        appMedia.setDeviceSource(Integer.valueOf(0));
        if (this.checkColumn(rs, "f_jym")) {
            appMedia.setJym(rs.getObject("f_jym") == null ? null : rs.getString("f_jym"));
        }
        if (this.checkColumn(rs, "f_sm3")) {
            appMedia.setSm3(rs.getObject("f_sm3") == null ? null : rs.getString("f_sm3"));
        }
        if (this.checkColumn(rs, "f_roll")) {
            appMedia.setRoll(rs.getObject("f_roll") == null ? null : Integer.valueOf(rs.getInt("f_roll")));
        }
        if (this.checkColumn(rs, "f_dimheight")) {
            appMedia.setDimHeight(rs.getObject("f_dimheight") == null ? null : Integer.valueOf(rs.getInt("f_dimheight")));
        }
        if (this.checkColumn(rs, "f_dimwidth")) {
            appMedia.setDimWidth(rs.getObject("f_dimwidth") == null ? null : Integer.valueOf(rs.getInt("f_dimwidth")));
        }
        if (this.checkColumn(rs, "f_35mmfocal")) {
            appMedia.setF35mmfocal(rs.getObject("f_35mmfocal") == null ? null : Integer.valueOf(rs.getInt("f_35mmfocal")));
        }
        if (this.checkColumn(rs, "f_psfyj")) {
            appMedia.setPsfyj(rs.getObject("f_psfyj") == null ? null : rs.getString("f_psfyj"));
        }
        if (this.checkColumn(rs, "f_zsdm")) {
            appMedia.setZsdm(rs.getObject("f_zsdm") == null ? null : rs.getString("f_zsdm"));
        }
        if (this.checkColumn(rs, "f_am")) {
            appMedia.setAm(rs.getObject("f_am") == null ? null : Double.valueOf(Double.parseDouble(rs.getString("f_am"))));
        }
        if (this.checkColumn(rs, "f_an")) {
            appMedia.setAn(rs.getObject("f_an") == null ? null : Double.valueOf(Double.parseDouble(rs.getString("f_an"))));
        }
        if (this.checkColumn(rs, "f_jdgd")) {
            appMedia.setJdgd(rs.getObject("f_jdgd") == null ? null : Double.valueOf(Double.parseDouble(rs.getString("f_jdgd"))));
        }
        if (this.checkColumn(rs, "f_focal")) {
            appMedia.setFocal(rs.getObject("f_focal") == null ? null : Double.valueOf(Double.parseDouble(rs.getString("f_focal"))));
        }
        if (this.checkColumn(rs, "f_psgd")) {
            appMedia.setPsgd(rs.getObject("f_psgd") == null ? null : Double.valueOf(Double.parseDouble(rs.getString("f_psgd"))));
        }
        if (this.checkColumn(rs, "f_jym") && !this.verifyJym(rs)) {
            throw new GwValidateException("\u9644\u4ef6\u6821\u9a8c\u7801\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
        }
        return appMedia;
    }

    private boolean checkColumn(ResultSet rs, String column) {
        try {
            rs.findColumn(column);
            return true;
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
            return false;
        }
    }

    private int getColNum(Double xLine) {
        int proNum = 2362;
        if (xLine >= 75.5 && xLine < 78.5) {
            proNum = 2353;
        } else if (xLine >= 78.5 && xLine < 81.5) {
            proNum = 2354;
        } else if (xLine >= 81.5 && xLine < 84.5) {
            proNum = 2355;
        } else if (xLine >= 84.5 && xLine < 87.5) {
            proNum = 2356;
        } else if (xLine >= 87.5 && xLine < 90.5) {
            proNum = 2357;
        } else if (xLine >= 90.5 && xLine < 93.5) {
            proNum = 2358;
        } else if (xLine >= 93.5 && xLine < 96.5) {
            proNum = 2359;
        } else if (xLine >= 96.5 && xLine < 99.5) {
            proNum = 2360;
        } else if (xLine >= 99.5 && xLine < 112.5) {
            proNum = 2361;
        } else if (xLine >= 112.5 && xLine < 115.5) {
            proNum = 2362;
        } else if (xLine > 115.5 && xLine < 118.5) {
            proNum = 2363;
        } else if (xLine > 118.5 && xLine < 121.5) {
            proNum = 2364;
        } else if (xLine > 121.5 && xLine < 124.5) {
            proNum = 2365;
        } else if (xLine > 124.5 && xLine < 127.5) {
            proNum = 2366;
        } else if (xLine > 127.5 && xLine < 130.5) {
            proNum = 2367;
        } else if (xLine > 130.5 && xLine < 133.5) {
            proNum = 2368;
        } else if (xLine > 133.5 && xLine < 136.5) {
            proNum = 2369;
        }
        return proNum;
    }

    private File buildTempUploadFile(String userid) {
        this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("task-%s-%s-%s.db", userid, sdf.format(new Date()), UUID.randomUUID().toString());
        return new File(this.uploadDir, fileName);
    }

    private Date stampToDate(String s) {
        long lt = new Long(s);
        Date date = new Date(lt);
        return date;
    }

    public Boolean saveZjdTsk(JSONObject zjdTsk, Long userId, String bizId, String tbId) {
        TskTaskBiz tskTaskBiz = this.mTskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo tableInfo = this.mTbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        List<TbtskFields> fieldsList = this.mTskTaskBizService.getFieldsByTableId(tableInfo.getfId());
        ArrayList<String> editkeys = new ArrayList<String>();
        for (TbtskFields tbtskFields : fieldsList) {
            Boolean innserWebEdit = new Integer(1).equals(tbtskFields.getfIsWebEdit()) && tbtskFields.getfFieldInnerOuterSys() == 1;
            Boolean isOuter = (tbtskFields.getfFieldInnerOuterSys() & 2) == 2;
            if (!innserWebEdit.booleanValue() && !isOuter.booleanValue()) continue;
            editkeys.add(tbtskFields.getfFieldname());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : editkeys) {
            if (!zjdTsk.containsKey((Object)key) || "f_sfzhm".equals(key) && zjdTsk.getString(key).contains("*") || "f_qlrsjh".equals(key) && zjdTsk.getString(key).contains("*")) continue;
            map.put(key, zjdTsk.getString(key));
        }
        if ("zjd".equals(tableInfo.getfRemark()) && map.containsKey("f_zdlx")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("f_zdlx");
            arrayList.add("f_id");
            arrayList.add("f_xzqdm");
            arrayList.add("f_dzwdwdm");
            List<Map> maps = this.mDataBizService.queryAllData(tableInfo.getfTablename(), arrayList, " f_id = '" + tbId + "'");
            if (!maps.isEmpty()) {
                Map data = maps.get(0);
                String oldZdlx = (String)data.get("f_zdlx");
                String nexZdlx = (String)map.get("f_zdlx");
                String xzqdm = (String)data.get("f_xzqdm");
                String f_dzwdwdm = (String)data.get("f_dzwdwdm");
                if (!oldZdlx.equals(nexZdlx)) {
                    String tbbh = "";
                    try {
                        tbbh = this.mTskTaskBizService.generatorSeqByXzqdm(bizId, nexZdlx, xzqdm, tableInfo.getfId(), tableInfo);
                        map.put("f_tbbh", tbbh);
                        map.put("f_bdcdydm", tbbh + f_dzwdwdm);
                        map.put("f_zdsxh", tbbh.substring(14));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u751f\u6210\u5b97\u5730\u4ee3\u7801\u53d1\u751f\u9519\u8bef");
                    }
                }
            }
        }
        if (!map.isEmpty() && StringUtils.isNotBlank((CharSequence)tbId)) {
            this.mDataBizService.updateData(tableInfo.getfTablename(), map, " f_id = '" + tbId + "'");
        }
        return true;
    }

    public JSONObject checkSplitData(Long userId, String bizId, String tbId, String childTbIds) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("isChange", (Object)false);
        TskTaskBiz task = this.mTskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo objectinfo = this.mTskTaskBizService.getTableByTableId(task.getTableId());
        List<TbtskFields> fieldsList = this.mTskTaskBizService.getFieldsByTableId(task.getTableId());
        ArrayList<String> fields = new ArrayList<String>();
        for (TbtskFields f : fieldsList) {
            fields.add(f.getfFieldname());
        }
        Map currObj = this.mDataBizService.selectFieldByID(objectinfo.getfTablename(), fields, "f_id", "'" + tbId + "'");
        if (null == currObj) {
            throw new RuntimeException("\u56fe\u6591\u4e0d\u5b58\u5728");
        }
        jsonObject.put("parentData", (Object)currObj);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)objectinfo.getSplitTableName())) {
            List<Map> childMap = this.mDataBizService.queryAllData(objectinfo.getSplitTableName(), fields, "f_splitedid = '" + tbId + "' ORDER BY to_number(COALESCE(NULLIF(split_part(f_tbbh,'_',2),''),'0'),'00')");
            jsonObject.put("childData", childMap);
            if (childMap.size() > 0) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)childTbIds)) {
                    String[] split = childTbIds.split(",");
                    if (split.length == childMap.size()) {
                        for (Map map1 : childMap) {
                            String f_id = MapUtils.getString((Map)map1, (Object)"f_id", (String)"");
                            if (childTbIds.contains(f_id)) continue;
                            jsonObject.put("isChange", (Object)true);
                        }
                    } else {
                        jsonObject.put("isChange", (Object)true);
                    }
                } else {
                    jsonObject.put("isChange", (Object)true);
                }
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)childTbIds)) {
                jsonObject.put("isChange", (Object)true);
            }
        }
        return jsonObject;
    }

    public JSONArray uploadShy(MultipartFile[] files, Long userId, String bizId) throws Exception {
        JSONArray jsonResult = new JSONArray();
        if (files.length < 1) {
            return jsonResult;
        }
        MultipartFile fileOfDB = files[0];
        File tempUploadFile = this.buildTempUploadFile(userId.toString());
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        LandUserDetail user = this.userDetailRepository.findById((Object)userId).orElse(null);
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        String sql = "";
        sql = "select * from table_info";
        rs = statement.executeQuery(sql);
        ArrayList<String> tableNames = new ArrayList<String>();
        while (rs.next()) {
            String tableName = rs.getString("f_tablename");
            tableNames.add(tableName);
        }
        sql = "select f_shifields as shiwy,f_shengfields as shengwy from tb_shi_audit where f_taskid='" + bizId + "'";
        List shfields = this.jdbcTemplate.queryForList(sql);
        ArrayList<String> cjFields = new ArrayList<String>();
        if (shfields.size() > 0) {
            List<String> fds1;
            String lsField;
            if (((Map)shfields.get(0)).get("shiwy") != null) {
                lsField = ((Map)shfields.get(0)).get("shiwy").toString();
                fds1 = Arrays.asList(lsField.split(","));
                cjFields.addAll(fds1);
            }
            if (((Map)shfields.get(0)).get("shengwy") != null) {
                lsField = ((Map)shfields.get(0)).get("shengwy").toString();
                fds1 = Arrays.asList(lsField.split(","));
                cjFields.addAll(fds1);
            }
        }
        for (int i = 0; i < tableNames.size(); ++i) {
            String tableName = (String)tableNames.get(i);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tableName)) continue;
            sql = "select * from " + tableName;
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String id = resultSet.getString("f_id");
                Map currObj = this.mDataBizService.selectFieldByID(tableName, Arrays.asList("f_id,f_status,f_review_stage"), "f_id", "'" + id + "'");
                Integer index = 0;
                for (String key : cjFields) {
                    if (!this.isExistColumn(resultSet, key)) continue;
                    map.put(key, resultSet.getString(key));
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                }
                if (index > 0) {
                    this.mDataBizService.updateData(tableName, map, " f_id = '" + id + "'");
                }
                if (currObj == null) continue;
                Integer f_status = Integer.valueOf(currObj.get("f_status").toString());
                Integer f_review_stage = currObj.get("f_review_stage") != null ? Integer.valueOf(currObj.get("f_review_stage").toString()) : null;
                TbtskSubmitRecord tbtskSubmitRecord = new TbtskSubmitRecord();
                tbtskSubmitRecord.setDataid(id);
                tbtskSubmitRecord.setDataStatus(f_status);
                tbtskSubmitRecord.setDataReviewStage(f_review_stage);
                tbtskSubmitRecord.setTaskid(bizId);
                tbtskSubmitRecord.setSubmitUserid(userId);
                tbtskSubmitRecord.setSubmitTime(new Date());
                if (f_status >= 10 && f_review_stage != null && f_review_stage >= 90 && f_review_stage < 95) {
                    tbtskSubmitRecord.setStepName("\u533a\u53bf\u5ba1\u6838");
                } else if (f_status >= 10 && f_review_stage != null && f_review_stage >= 95 && f_review_stage < 97) {
                    tbtskSubmitRecord.setStepName("\u5e02\u7ea7\u5ba1\u6838");
                } else if (f_status >= 10 && f_review_stage != null && f_review_stage >= 97 && f_review_stage < 101) {
                    tbtskSubmitRecord.setStepName("\u7701\u7ea7\u5ba1\u6838");
                } else {
                    tbtskSubmitRecord.setStepName(null);
                }
                this.tbtskSubmitReportRepository.save((Object)tbtskSubmitRecord);
            }
        }
        sql = "select * from media";
        rs = statement.executeQuery(sql);
        ArrayList<AppMedia> listMedia = new ArrayList<AppMedia>();
        while (rs.next()) {
            AppMedia appMedia = this.getAppMedia(rs);
            appMedia.setUsername(user.getName());
            listMedia.add(appMedia);
        }
        this.appMediaRepository.saveAll(listMedia);
        connPool.closeAll(connection, statement, rs);
        tempUploadFile.delete();
        return jsonResult;
    }

    public JSONObject checkDatRetake(String bizId, String tbId) {
        JSONObject jsonObject = new JSONObject();
        List tbtskSubmitRecords = this.tbtskSubmitReportRepository.queryByTaskidAndDataid(bizId, tbId);
        jsonObject.put("tbtskSubmitRecords", (Object)tbtskSubmitRecords);
        jsonObject.put("countyRetake", (Object)false);
        jsonObject.put("cityRetake", (Object)false);
        jsonObject.put("provinceRetake", (Object)false);
        jsonObject.put("currentStatusRetake", (Object)false);
        if (tbtskSubmitRecords.size() > 0) {
            TskTaskBiz tskTaskBiz = this.mTskTaskBizService.findByTaskId(bizId);
            TbtskObjectinfo tableInfo = this.mTbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            Map currObj = this.mDataBizService.selectFieldByID(tableInfo.getfTablename(), Arrays.asList("f_id,f_status,f_review_stage"), "f_id", "'" + tbId + "'");
            for (TbtskSubmitRecord tbtskSubmitRecord : tbtskSubmitRecords) {
                if ("\u533a\u53bf\u5ba1\u6838".equals(tbtskSubmitRecord.getStepName())) {
                    jsonObject.put("countyRetake", (Object)true);
                } else if ("\u5e02\u7ea7\u5ba1\u6838".equals(tbtskSubmitRecord.getStepName())) {
                    jsonObject.put("cityRetake", (Object)true);
                } else if ("\u7701\u7ea7\u5ba1\u6838".equals(tbtskSubmitRecord.getStepName())) {
                    jsonObject.put("provinceRetake", (Object)true);
                }
                if (currObj == null) continue;
                Integer f_status = Integer.valueOf(currObj.get("f_status").toString());
                Integer f_review_stage = currObj.get("f_review_stage") != null ? Integer.valueOf(currObj.get("f_review_stage").toString()) : null;
                if (f_review_stage == null || tbtskSubmitRecord.getDataStatus() != f_status || tbtskSubmitRecord.getDataReviewStage() != f_review_stage) continue;
                jsonObject.put("currentStatusRetake", (Object)true);
            }
        }
        return jsonObject;
    }

    private boolean isExistColumn(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }
}

