/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.NoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.task.entity.Notice;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.dto.NoticeDTO;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.gw.base.util.GutilStr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MNoticeService {
    @Autowired
    TaskNoticeUserRepository taskNoticeUserDao;
    @Autowired
    NoticeRepository noticeRepository;
    @Autowired
    TaskNoticeRepository taskNoticeRepository;
    @Autowired
    TskRightAreaRepository tskRightAreaRepository;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    DefaultOssOperatorService ossOperatorService;

    public Page<Notice> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page results = this.noticeRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public void saveNotice(String id, int target, String content, String title, int act, Long userId) {
        Notice notice = new Notice();
        if (!GutilStr.isBlank((CharSequence)id)) {
            notice = this.noticeRepository.findById((Object)id).orElse(null);
        } else {
            notice.setCreateDate(new Date());
            notice.setType(Integer.valueOf(1));
        }
        notice.setTitle(title);
        notice.setContent(content);
        notice.setTargetType(Integer.valueOf(target));
        notice.setSendUserId(userId);
        if (act == 1) {
            notice.setState(Integer.valueOf(1));
        } else if (act == 2) {
            notice.setState(Integer.valueOf(2));
            notice.setSendDate(new Date());
        }
        this.noticeRepository.save((Object)notice);
    }

    public void processReplyNotice(String userid, String replyIds) {
        String[] arrs = replyIds.split(",");
        for (int i = 0; i < arrs.length; ++i) {
            String replyId = arrs[i];
            List noticeList = this.taskNoticeUserDao.queryNotice(userid, replyId);
            if (noticeList != null && noticeList.size() > 0) {
                TaskNoticeUser taskNoticeUser = (TaskNoticeUser)noticeList.get(0);
                taskNoticeUser.setState(Integer.valueOf(1));
                this.taskNoticeUserDao.save((Object)taskNoticeUser);
                continue;
            }
            Boolean sysmsg = this.redisTemplate.opsForSet().isMember((Object)replyId, (Object)userid);
            if (sysmsg.booleanValue()) {
                Set members = this.redisTemplate.opsForSet().members((Object)replyId);
                this.redisTemplate.opsForSet().add((Object)replyId, new Object[]{userid});
                continue;
            }
            this.redisTemplate.opsForSet().add((Object)replyId, new Object[]{userid});
        }
    }

    public List<NoticeDTO> queryPendingTaskNotice(Long userId) {
        ArrayList<NoticeDTO> listNotice = new ArrayList<NoticeDTO>();
        String filterParam = "Q_userId_S_EQ=" + userId;
        filterParam = filterParam + ";(Q_state_N_EQ=0;QOR_state_N_EQ=null)";
        String sortParam = "";
        List noticeUsers = this.queryTaskNoticeUserByFilter(filterParam, sortParam, 0, 100).getContent();
        for (TaskNoticeUser noticeUser : noticeUsers) {
            TaskNotice one = this.taskNoticeRepository.findById((Object)noticeUser.getNoticeId()).orElse(null);
            if (one == null) continue;
            NoticeDTO noticeDTO = new NoticeDTO();
            noticeDTO.setId(one.getId());
            noticeDTO.setAction(one.getAction());
            noticeDTO.setContent(one.getContent());
            noticeDTO.setData(one.getData());
            noticeDTO.setRegion(one.getRegion());
            noticeDTO.setSendTime(one.getSendTime());
            noticeDTO.setState(one.getState());
            noticeDTO.setTitle(one.getTitle());
            noticeDTO.setType(one.getType());
            noticeDTO.setSendUser(one.getSendUser());
            noticeDTO.setBizId(one.getBizId());
            String data = noticeUser.getData();
            if (GutilStr.isNotBlank((CharSequence)data)) {
                try {
                    JSONObject object = JSONObject.parseObject((String)data);
                    String oriType = object.getString("oriType");
                    String oriId = object.getString("oriId");
                    noticeDTO.setOriType(oriType);
                    noticeDTO.setOriId(oriId);
                    noticeDTO.setUserData(data);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            listNotice.add(noticeDTO);
        }
        return listNotice;
    }

    public Page<TaskNoticeUser> queryTaskNoticeUserByFilter(String filterParam, String sortParam, int start, int limit) {
        Page results = this.taskNoticeUserDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public Map queryPendingTaskNoticeResult(String filterParam, String sortParam, int start, int limit) {
        ArrayList<NoticeDTO> listNotice = new ArrayList<NoticeDTO>();
        Page<TaskNoticeUser> result = this.queryTaskNoticeUserByFilter(filterParam, sortParam, start, limit);
        long total = result.getTotalElements();
        List noticeUsers = result.getContent();
        for (TaskNoticeUser noticeUser : noticeUsers) {
            TaskNotice one = this.taskNoticeRepository.findById((Object)noticeUser.getNoticeId()).orElse(null);
            if (one == null) continue;
            NoticeDTO noticeDTO = new NoticeDTO();
            noticeDTO.setId(one.getId());
            noticeDTO.setAction(one.getAction());
            noticeDTO.setContent(one.getContent());
            noticeDTO.setData(one.getData());
            noticeDTO.setRegion(one.getRegion());
            noticeDTO.setSendTime(one.getSendTime());
            noticeDTO.setState(one.getState());
            noticeDTO.setTitle(one.getTitle());
            noticeDTO.setType(one.getType());
            noticeDTO.setSendUser(one.getSendUser());
            noticeDTO.setBizId(one.getBizId());
            String data = noticeUser.getData();
            if (GutilStr.isNotBlank((CharSequence)data)) {
                try {
                    JSONObject object = JSONObject.parseObject((String)data);
                    String oriType = object.getString("oriType");
                    String oriId = object.getString("oriId");
                    noticeDTO.setOriType(oriType);
                    noticeDTO.setOriId(oriId);
                    noticeDTO.setUserData(data);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            listNotice.add(noticeDTO);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Long.valueOf(total));
        map.put("list", listNotice);
        return map;
    }

    public List<NoticeDTO> findTaskNoticesBySendTimeAndBizId(String userId, String bizId, Date time) {
        List list = this.taskNoticeRepository.queryBySendTimeAndBizId(userId, bizId, time);
        List xzqdms = this.tskRightAreaRepository.findXzqdmByTaskIdAndUserId(bizId, userId);
        if (xzqdms != null && xzqdms.size() > 0) {
            List list2 = this.taskNoticeRepository.queryBySendTimeAndBizIdAndXzqdms2(xzqdms, bizId, time);
            list.addAll(list2);
        }
        List taskNotices = this.taskNoticeRepository.queryTaskNoticeByUserIdAndBiz2(userId, time, Integer.valueOf(1), bizId);
        list.addAll(taskNotices);
        Collections.sort(list, new Comparator<TaskNotice>(){

            @Override
            public int compare(TaskNotice arg0, TaskNotice arg1) {
                return arg0.getSendTime().compareTo(arg1.getSendTime());
            }
        });
        ArrayList<NoticeDTO> rlist = new ArrayList<NoticeDTO>();
        HashSet<String> set = new HashSet<String>();
        HashSet<String> obsPath = new HashSet<String>();
        int i = 0;
        for (TaskNotice notice : list) {
            if (set.contains(notice.getId())) continue;
            set.add(notice.getId());
            if (obsPath.contains(notice.getData())) continue;
            obsPath.add(notice.getData());
            if (notice.getSendTime().equals(time)) continue;
            rlist.add(this.getNoticeDTO(notice, userId));
            if (i++ != 0 || !"15".equals(notice.getAction())) continue;
            break;
        }
        return rlist;
    }

    public NoticeDTO findLastedTaskNotice(String userId) {
        List list = this.taskNoticeRepository.queryLastedTaskNoticeByUserId(userId);
        if (list != null && list.size() > 0) {
            return this.getNoticeDTO((TaskNotice)list.get(0), userId);
        }
        return null;
    }

    private NoticeDTO getNoticeDTO(TaskNotice one, String userId) {
        String data;
        NoticeDTO noticeDTO = new NoticeDTO();
        noticeDTO.setId(one.getId());
        noticeDTO.setAction(one.getAction());
        noticeDTO.setContent(one.getContent());
        noticeDTO.setData(one.getData());
        noticeDTO.setRegion(one.getRegion());
        noticeDTO.setSendTime(one.getSendTime());
        noticeDTO.setState(one.getState());
        noticeDTO.setTitle(one.getTitle());
        noticeDTO.setType(one.getType());
        noticeDTO.setSendUser(one.getSendUser());
        noticeDTO.setBizId(one.getBizId());
        noticeDTO.setAddition(one.getAddition());
        List list = this.taskNoticeUserDao.queryNotice(userId, one.getId());
        if (list != null && list.size() > 0 && GutilStr.isNotBlank((CharSequence)(data = ((TaskNoticeUser)list.get(0)).getData()))) {
            try {
                JSONObject object = JSONObject.parseObject((String)data);
                String oriType = object.getString("oriType");
                String oriId = object.getString("oriId");
                noticeDTO.setOriType(oriType);
                noticeDTO.setOriId(oriId);
                noticeDTO.setUserData(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return noticeDTO;
    }

    public Map<String, Object> getHomeSysMessage(String text, Date startTime, Date endTime, String sort, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuffer countsql = new StringBuffer("select count(1) from tb_notice n where 1=1");
        StringBuffer sql = new StringBuffer("select n.f_id,n.f_title,n.f_content,n.f_createdate from tb_notice n where 1=1 ");
        if (text != null && !text.equals("")) {
            sql.append(" and n.f_content like '%" + text + "%' ");
            countsql.append(" and n.f_content like '%" + text + "%' ");
        }
        ArrayList<Notice> notices = new ArrayList<Notice>();
        if (startTime != null && endTime != null) {
            Calendar endtime = Calendar.getInstance();
            endtime.setTime(endTime);
            endtime.set(10, 23);
            endtime.set(12, 59);
            endtime.set(13, 59);
            sql.append(" and n.f_createdate between '" + startTime + "' and '" + endtime.getTime() + "' ");
            countsql.append(" and n.f_createdate between '" + startTime + "' and '" + endtime.getTime() + "' ");
        }
        sql.append(" and f_noticetype=1 ");
        countsql.append(" and f_noticetype=1");
        if ("DESC".equals(sort)) {
            sql.append(" order by n.f_createdate desc ");
        } else if ("ASC".equals(sort)) {
            sql.append(" order by n.f_createdate asc ");
        }
        int current = (page - 1) * rows;
        sql.append(" limit " + rows + " offset " + current);
        List noticeMap = this.jdbcTemplate.queryForList(sql.toString());
        for (Map temp : noticeMap) {
            Notice notice = new Notice();
            notice.setId(temp.get("f_id").toString());
            notice.setCreateDate((Date)temp.get("f_createdate"));
            notice.setContent(temp.get("f_content").toString());
            notice.setTitle(temp.get("f_title").toString());
            notices.add(notice);
        }
        Integer count = (Integer)this.jdbcTemplate.queryForObject(countsql.toString(), Integer.class);
        map.put("notices", notices);
        map.put("count", count);
        return map;
    }
}

