/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.task.entity.TbtskFieldGroupView;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.gw.base.util.GutilStr;
import com.meizu.push.sdk.utils.StringUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MTaskDataService {
    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;
    @Autowired
    MTbtskFieldsService mTbtskFieldsService;
    @Autowired
    MDataBizService mDataBizService;
    String sysCode = "web";

    public String createDB(String tableid, String tempPath, String filter) {
        String fileName = UUID.randomUUID().toString() + ".db";
        String filePath = tempPath + File.separator + fileName;
        SqlliteConnTool tool = new SqlliteConnTool(filePath);
        Connection connection = tool.getConnection();
        try {
            TbtskObjectinfo tbtskObjectinfo = this.mTbtskObjectinfoService.getObjectbyID(tableid);
            if (tbtskObjectinfo == null) {
                return null;
            }
            List<TbtskFieldGroupView> fieldsList = this.mTbtskFieldsService.getTbtskViewFields("web", tableid, "201");
            if (fieldsList == null || fieldsList.size() < 1) {
                return null;
            }
            this.createDB(connection, tbtskObjectinfo.getfTablename(), fieldsList);
            this.insertData(connection, tbtskObjectinfo, filter);
        }
        catch (Exception ex) {
            tool.closeAll(connection, null, null);
            return null;
        }
        tool.closeAll(connection, null, null);
        return filePath;
    }

    public void importDB(String filePath, String tableid) {
        TbtskObjectinfo tbtskObjectinfo = this.mTbtskObjectinfoService.getObjectbyID(tableid);
        if (tbtskObjectinfo == null) {
            return;
        }
        SqlliteConnTool tool = new SqlliteConnTool(filePath);
        Connection connection = tool.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            this.addDataFromDB2PG(statement, tbtskObjectinfo);
            tool.closeAll(connection, statement, null);
        }
        catch (Exception ex) {
            tool.closeAll(connection, null, null);
        }
    }

    private void createDB(Connection connection, String tablename, List<TbtskFieldGroupView> fieldsList) throws SQLException {
        if (connection == null || connection.isClosed() || tablename == null) {
            return;
        }
        connection.setAutoCommit(false);
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE \"" + tablename + "\"(");
        String primaryKeyName = "";
        for (TbtskFieldGroupView field : fieldsList) {
            String type = field.getfFieldtype();
            Integer length = field.getfLength();
            String fieldName = field.getfFieldname();
            Integer isprimary = field.getfIsprimary();
            Integer nullable = field.getfNullable();
            Integer percision = field.getfPrecision();
            if (isprimary != null && isprimary == 1) {
                primaryKeyName = fieldName;
            }
            switch (type) {
                case "varchar": {
                    builder.append("\"" + fieldName + "\" varchar(" + length + "),");
                    break;
                }
                case "double": {
                    builder.append("\"" + fieldName + "\" double,");
                    break;
                }
                case "number": {
                    builder.append("\"" + fieldName + "\" int(4),");
                    break;
                }
                case "float": {
                    builder.append("\"" + fieldName + "\" float(" + length + "," + percision + "),");
                    break;
                }
                case "text": {
                    builder.append("\"" + fieldName + "\" text,");
                    break;
                }
                case "timestamp": {
                    builder.append("\"" + fieldName + "\" datetime,");
                    break;
                }
                case "geometry": {
                    builder.append("\"" + fieldName + "\" blob,");
                    break;
                }
            }
        }
        builder.append("primary key (\"" + primaryKeyName + "\" asc)");
        builder.append(")");
        String sql = builder.toString();
        PreparedStatement pre = connection.prepareStatement(sql);
        pre.execute();
        connection.commit();
        pre.close();
    }

    private void insertData(Connection connection, TbtskObjectinfo tbtskObjectinfo, String filter) throws SQLException {
        List<String> fieldNameList = this.mTbtskFieldsService.getTbtskFieldsNameListBySysCodeAndGroupCode(this.sysCode, tbtskObjectinfo.getfId(), "201");
        List<TbtskFieldGroupView> fieldsList = this.mTbtskFieldsService.getTbtskViewFields(this.sysCode, tbtskObjectinfo.getfId(), "201");
        String sql = "insert into BASIC_TB (" + GutilStr.join(fieldNameList, (CharSequence)",") + ")";
        sql = sql + " values(" + GutilStr.removeEnd((String)GutilStr.repeat((CharSequence)"?,", (int)fieldNameList.size()), (String)",") + ")";
        List<Map> tableDatas = this.mDataBizService.queryAllData(tbtskObjectinfo.getfTablename(), fieldNameList, filter);
        PreparedStatement pre = connection.prepareStatement(sql);
        WKBWriter wr = new WKBWriter();
        WKTReader wktReader = new WKTReader();
        for (Map tableItem : tableDatas) {
            block21: for (int i = 0; i < fieldsList.size(); ++i) {
                String type = fieldsList.get(i).getfFieldtype();
                String fieldName = fieldsList.get(i).getfFieldname();
                Object fieldValue = tableItem.get(fieldName);
                if (fieldValue == null) {
                    pre.setNull(i + 1, 0);
                    continue;
                }
                switch (type) {
                    case "varchar": {
                        pre.setString(i + 1, String.valueOf(fieldValue));
                        continue block21;
                    }
                    case "double": {
                        pre.setDouble(i + 1, Double.valueOf(fieldValue.toString()));
                        continue block21;
                    }
                    case "number": {
                        pre.setInt(i + 1, Integer.valueOf(fieldValue.toString()));
                        continue block21;
                    }
                    case "float": {
                        pre.setFloat(i + 1, Float.valueOf(fieldValue.toString()).floatValue());
                        continue block21;
                    }
                    case "text": {
                        pre.setString(i + 1, String.valueOf(fieldValue));
                        continue block21;
                    }
                    case "timestamp": {
                        pre.setTimestamp(i + 1, Timestamp.valueOf(fieldValue.toString()));
                        continue block21;
                    }
                    case "geometry": {
                        try {
                            Geometry geo = wktReader.read(fieldValue.toString());
                            pre.setBytes(i + 1, wr.write(geo));
                        }
                        catch (Exception e) {
                            pre.setBytes(i + 1, null);
                        }
                        continue block21;
                    }
                }
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    private void addDataFromDB2PG(Statement statement, TbtskObjectinfo table) throws Exception {
        List<TbtskFieldGroupView> fields = this.mTbtskFieldsService.getTbtskViewFields(this.sysCode, table.getfId(), "203");
        if (fields == null || fields.size() < 1) {
            return;
        }
        String tableName = table.getfTablename();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        for (int i = 0; i < fields.size() - 1; ++i) {
            stringBuilder.append(fields.get(i).getfFieldname());
            stringBuilder.append(",");
        }
        stringBuilder.append(fields.get(fields.size() - 1).getfFieldname());
        stringBuilder.append(" from ");
        stringBuilder.append(table.getfTablename());
        String sql = stringBuilder.toString();
        ResultSet rs = statement.executeQuery(sql);
        while (rs.next()) {
            int ismycreate = rs.getInt("f_ismycreate");
            String fid = rs.getString("f_id");
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (ismycreate == 1) {
                List<TbtskFields> allFields = this.mTbtskFieldsService.getAllFieldsByTableID(table.getfId());
                for (TbtskFields tbtskFields : allFields) {
                    String defaultvalue = tbtskFields.getfDefaultvalue();
                    if (!GutilStr.isNotBlank((CharSequence)defaultvalue)) continue;
                    map.put(tbtskFields.getfFieldname(), defaultvalue);
                }
                for (TbtskFieldGroupView tbtskFieldGroupView : fields) {
                    String fieldName = tbtskFieldGroupView.getfFieldname();
                    String fieldType = tbtskFieldGroupView.getfFieldtype();
                    this.addDatatoMap(map, rs, fieldType, fieldName);
                }
                this.mDataBizService.insertData(tableName, map, "shape");
                continue;
            }
            for (TbtskFieldGroupView field : fields) {
                String string = field.getfFieldname();
                String fieldType = field.getfFieldtype();
                if ("geometry".equals(fieldType) || "f_id".equals(string)) continue;
                this.addDatatoMap(map, rs, fieldType, string);
            }
            this.mDataBizService.updateData(tableName, map, "f_id='" + fid + "'");
        }
    }

    void addDatatoMap(Map map, ResultSet rs, String fieldType, String fieldName) throws SQLException, ParseException {
        WKBReader wr = new WKBReader();
        switch (fieldType) {
            case "varchar": 
            case "text": {
                String value1 = rs.getString(fieldName);
                if (value1 == null || "null".equals(value1.toLowerCase()) || "".equals(value1)) {
                    map.put(fieldName, 0);
                    break;
                }
                map.put(fieldName, value1);
                break;
            }
            case "double": {
                Double value2 = rs.getDouble(fieldName);
                if (StringUtils.isBlank((CharSequence)String.valueOf(value2))) {
                    map.put(fieldName, 0);
                    break;
                }
                map.put(fieldName, value2);
                break;
            }
            case "number": {
                Integer value3 = rs.getInt(fieldName);
                if (StringUtils.isBlank((CharSequence)String.valueOf(value3))) {
                    map.put(fieldName, 0);
                    break;
                }
                map.put(fieldName, value3);
                break;
            }
            case "float": {
                Float value4 = Float.valueOf(rs.getFloat(fieldName));
                if (StringUtils.isBlank((CharSequence)String.valueOf(value4))) {
                    map.put(fieldName, 0);
                    break;
                }
                map.put(fieldName, value4);
                break;
            }
            case "timestamp": {
                map.put(fieldName, rs.getTimestamp(fieldName));
                Timestamp value5 = rs.getTimestamp(fieldName);
                if (value5 == null) {
                    map.put(fieldName, 0);
                    break;
                }
                map.put(fieldName, value5);
                break;
            }
            case "geometry": {
                byte[] byteShape = rs.getBytes(fieldName);
                if (byteShape == null || byteShape.length < 1 || byteShape == null) break;
                Geometry shape = wr.read(byteShape);
                map.put(fieldName, shape.toString());
                break;
            }
        }
    }
}

