/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.ImageCaptureDef;
import com.geoway.landteam.customtask.pub.entity.ImageCaptureJob;
import com.geoway.landteam.customtask.repository.pub.ImageCaptureDefRepository;
import com.geoway.landteam.customtask.repository.pub.ImageCaptureJobRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskImageCaptureService;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueSourceDao;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTaskImageCaptureServiceImpl
implements MTaskImageCaptureService {
    GiLoger loger = GwLoger.getLoger(MTaskImageCaptureServiceImpl.class);
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    ImageCaptureJobRepository imageCaptureJobRepository;
    @Autowired
    ImageCaptureDefRepository captureDefRepository;
    @Autowired
    JcClueSourceDao sourceDao;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    private static final String NAME_PREFIX = "zhjcjg";
    private static final String DEFAULT_CONFIG = "capture.default";

    public boolean startImageCapture(String tablename, String ids) {
        return this.startImageCapture(tablename, ids, new ImageCaptureDef());
    }

    public boolean startImageCapture(String tablename, String ids, ImageCaptureDef param) {
        tablename = tablename.trim().replace(" as tb", "").trim();
        ids = ids.replaceAll(",", "','");
        String sql = "";
        sql = StringUtils.isNotBlank((CharSequence)ids) ? String.format("select f_id,f_shape from %s where f_id in('%s')", tablename, ids) : String.format("select f_id,f_shape from %s", tablename);
        List spots = this.dataBizService.queryDataBySql(sql);
        List wkts = spots.stream().map(this::parseCaptureJson).filter(e -> !e.isEmpty()).collect(Collectors.toList());
        if (wkts.isEmpty()) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e");
        }
        String wktStrs = new JSONArray(wkts).toString();
        String jobName = Optional.ofNullable(param.getNamePrefix()).orElse(NAME_PREFIX) + System.currentTimeMillis();
        ImageCaptureJob job = new ImageCaptureJob();
        job.setId(UUID.randomUUID().toString());
        job.setJobName(jobName);
        job.setParams(wktStrs);
        job.setStartTime(new Date());
        job.setStatus(Integer.valueOf(0));
        job.setDefId(Optional.of(param.getId()).orElse("0"));
        job.setTableName(tablename);
        job.setSplit(Boolean.valueOf(tablename.endsWith("_child")));
        this.imageCaptureJobRepository.save((Object)job);
        return false;
    }

    public ImageCaptureDef getCaptureDef(@NotNull ImageCaptureJob job) {
        ImageCaptureDef result = Optional.ofNullable(job).map(ImageCaptureJob::getDefId).map(arg_0 -> ((ImageCaptureDefRepository)this.captureDefRepository).findById(arg_0)).map(e -> (ImageCaptureDef)e.orElseThrow(RuntimeException::new)).orElseThrow(RuntimeException::new);
        return result;
    }

    public String getBizid(@NotNull ImageCaptureJob job) {
        Integer type = this.getBizType(job);
        String tablename = job.getTableName();
        String bizid = this.getBizid(type, tablename);
        return bizid;
    }

    public Integer getBizType(@NotNull ImageCaptureJob job) {
        Integer type = Optional.ofNullable(job).map(ImageCaptureJob::getDefId).map(arg_0 -> ((ImageCaptureDefRepository)this.captureDefRepository).findById(arg_0)).map(e -> (ImageCaptureDef)e.orElseThrow(RuntimeException::new)).map(ImageCaptureDef::getObjectType).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u6b63\u786e\u7684\u914d\u7f6e"));
        return type;
    }

    private String getBizid(Integer type, String tablename) {
        if (type == 0) {
            return Optional.ofNullable(tablename).map(arg_0 -> ((TbtskObjectinfoRepository)this.tbtskObjectinfoRepository).getObjectbyName(arg_0)).filter(l -> !l.isEmpty()).map(e -> (TbtskObjectinfo)e.get(0)).map(TbtskObjectinfo::getfId).map(arg_0 -> ((TskTaskBizRepository)this.tskTaskBizRepository).findByTableId(arg_0)).map(TskTaskBiz::getId).orElseThrow(RuntimeException::new);
        }
        if (type == 1) {
            return Optional.ofNullable(tablename).map(arg_0 -> ((JcClueSourceDao)this.sourceDao).findByName(arg_0)).map(JcClueSource::getfId).orElseThrow(RuntimeException::new);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b");
    }

    private JSONObject parseCaptureJson(Map data) {
        JSONObject result = new JSONObject();
        if (data.containsKey("f_id") && data.containsKey("f_shape") && data.get("f_id") != null && data.get("f_shape") != null) {
            result.put("id", (Object)data.get("f_id").toString());
            String ewkt = data.get("f_shape").toString();
            String wkt = "";
            if (StringUtils.isNotBlank((CharSequence)ewkt)) {
                wkt = ewkt.replaceAll("^SRID=\\d{1,4};", "");
            }
            result.put("shape", (Object)wkt);
        }
        return result;
    }
}

