/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.resultshare.ResultShareTbIdDao;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.pub.entity.TbgstDataLog;
import com.geoway.landteam.customtask.repository.pub.TbgstDataLogRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.resultshare.enm.AnalysisTaskStateEnum;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTask;
import com.geoway.landteam.customtask.resultshare.pub.entity.ResultShareTbId;
import com.geoway.landteam.customtask.servface.multitask.TbtskDataLogService;
import com.geoway.landteam.customtask.servface.taskTranslate.TaskTranslateAtlasService;
import com.geoway.landteam.customtask.servface.taskTranslate.TbTaskTranslateTaskService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.dto.TskUploadLogDTO;
import com.geoway.landteam.customtask.task.entity.TbtskDataLog;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareAtlasService;
import com.geoway.landteam.landcloud.servface.customtask.resultshare.MResultShareTaskService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskDataLogService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MTaskImportTaskDataService {
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    MTaskRecordService mTaskRecordService;
    @Autowired
    MTbtskDataLogService mTbtskDataLogService;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    TbgstDataLogRepository tbgstDataLogRepository;
    @Autowired
    MResultShareAtlasService resultShareAtlasService;
    @Autowired
    MResultShareTaskService resultShareTaskService;
    @Autowired
    ResultShareTbIdDao resultShareTbIdDao;
    @Autowired
    TaskTranslateAtlasService taskTranslateAtlasService;
    @Autowired
    TbTaskTranslateTaskService tbTaskTranslateTaskService;
    @Autowired
    TbtskDataLogService tbtskDataLogService;
    @Autowired
    RedisTemplate redisTemplate;
    @Value(value="${project.uploadDir}")
    String uploadDir;
    private final GiLoger logger = GwLoger.getLoger(MTaskImportTaskDataService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataImport(TaskRecord record) {
        HttpURLConnection httpURLConnection = null;
        SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-DD HH:mm:ss");
        HashMap<String, TskUploadLogDTO> dataUploadLog = new HashMap<String, TskUploadLogDTO>();
        TskTaskBiz task = new TskTaskBiz();
        Long userId = null;
        try {
            JSONObject paramsObject = JSONObject.parseObject((String)record.getParam());
            String uploadurl = this.temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
            URL url = new URL(uploadurl);
            URLConnection urlConnection = url.openConnection();
            httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(600000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            URLConnection con = url.openConnection();
            File zipFile = null;
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(this.uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"gtdcy2019");
            String taskId = paramsObject.getString("taskId");
            task = this.mTskTaskBizService.findByTaskId(taskId);
            userId = paramsObject.getLongValue("userId");
            Map<String, List<String>> tempIds = this.mTskTaskBizService.importTaskData(unzipFileDir, taskId, userId, paramsObject.getString("updateType"), dataUploadLog);
            HashMap<String, List> ids = new HashMap<String, List>();
            ids.computeIfAbsent("ADD", k -> new ArrayList()).addAll(tempIds.getOrDefault("ADD", new ArrayList()));
            ids.computeIfAbsent("UPDATE", k -> new ArrayList()).addAll(tempIds.getOrDefault("UPDATE", new ArrayList()));
            this.createLog(userId, dataUploadLog, task.getName(), task.getId());
            List add = (List)ids.get("ADD");
            List update = (List)ids.get("UPDATE");
            if (task != null && task.getMode() != null && ("1".equals(task.getType()) || 2 == task.getMode())) {
                TaskRecordTemp temp;
                ArrayList<TaskRecordTemp> tempList;
                if (add.size() > 0) {
                    JSONObject additionJson = new JSONObject();
                    additionJson.put("count", (Object)add.size());
                    additionJson.put("addOrUpdate", (Object)"ADD");
                    additionJson.put("taskMode", (Object)task.getMode());
                    additionJson.put("curMode", (Object)"receive");
                    String recordId = UUID.randomUUID().toString();
                    TaskDataDbParameter parameter = new TaskDataDbParameter();
                    parameter.setRecordId(recordId);
                    parameter.setTaskId(task.getId());
                    parameter.setGroups(new JSONArray());
                    parameter.setOrgs(new JSONArray());
                    parameter.setAddition(additionJson);
                    parameter.setDate(String.valueOf(System.currentTimeMillis()));
                    parameter.setMode(task.getMode().toString());
                    tempList = new ArrayList<TaskRecordTemp>();
                    for (int i = 0; i < add.size(); ++i) {
                        temp = new TaskRecordTemp();
                        temp.setId(UUID.randomUUID().toString());
                        temp.setRecordid(recordId);
                        temp.setDataid((String)add.get(i));
                        tempList.add(temp);
                    }
                    this.mTaskRecordService.saveTaskRecordTemp(tempList);
                    TaskRecord record2 = new TaskRecord();
                    record2.setId(recordId);
                    record2.setParam(JSONObject.toJSONString((Object)parameter));
                    record2.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                    record2.setStarttime(new Date());
                    record2.setState(Integer.valueOf(1));
                    record2.setUserid(userId);
                    this.mTaskRecordService.save(record2);
                }
                if (update.size() > 0) {
                    String recordId1 = UUID.randomUUID().toString();
                    JSONObject additionJson1 = new JSONObject();
                    additionJson1.put("count", (Object)update.size());
                    additionJson1.put("addOrUpdate", (Object)"UPDATE");
                    additionJson1.put("taskMode", (Object)task.getMode());
                    additionJson1.put("curMode", (Object)"receive");
                    TaskDataDbParameter parameter1 = new TaskDataDbParameter();
                    parameter1.setRecordId(recordId1);
                    parameter1.setTaskId(task.getId());
                    parameter1.setGroups(new JSONArray());
                    parameter1.setOrgs(new JSONArray());
                    parameter1.setAddition(additionJson1);
                    parameter1.setDate(String.valueOf(System.currentTimeMillis()));
                    parameter1.setMode(task.getMode().toString());
                    tempList = new ArrayList();
                    for (int i = 0; i < update.size(); ++i) {
                        temp = new TaskRecordTemp();
                        temp.setId(UUID.randomUUID().toString());
                        temp.setRecordid(recordId1);
                        temp.setDataid((String)update.get(i));
                        tempList.add(temp);
                    }
                    this.mTaskRecordService.saveTaskRecordTemp(tempList);
                    TaskRecord record1 = new TaskRecord();
                    record1.setId(recordId1);
                    record1.setParam(JSONObject.toJSONString((Object)parameter1));
                    record1.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                    record1.setStarttime(new Date());
                    record1.setState(Integer.valueOf(1));
                    record1.setUserid(userId);
                    this.mTaskRecordService.save(record1);
                }
            }
            record.setEndtime(new Date());
            record.setState(Integer.valueOf(3));
            this.mTaskRecordService.save(record);
            if (paramsObject.containsKey((Object)"translateId") && StringUtils.isNotBlank((CharSequence)paramsObject.getString("translateId"))) {
                ResultShareTbId tbid;
                ArrayList<ResultShareTbId> tbids;
                List subs;
                int endIndex;
                String translateId = paramsObject.getString("translateId");
                ResultShareTask resultShareTask = this.resultShareTaskService.select(translateId);
                if (add != null && !add.isEmpty()) {
                    int batchCount = 100;
                    int page = add.size() / batchCount + 1;
                    for (int i = 0; i < page; ++i) {
                        int startIndex = i * batchCount;
                        endIndex = (i + 1) * batchCount;
                        if (startIndex >= add.size()) break;
                        if (endIndex >= add.size()) {
                            endIndex = add.size();
                        }
                        subs = add.subList(startIndex, endIndex);
                        tbids = new ArrayList<ResultShareTbId>();
                        for (String id : subs) {
                            tbid = new ResultShareTbId();
                            tbid.setId(UUID.randomUUID().toString());
                            tbid.setTbid(id);
                            tbid.setAnalysisId(translateId);
                            tbid.setTaskId(taskId);
                            tbid.setTemplateId(resultShareTask.getTemplateId());
                            tbids.add(tbid);
                        }
                        this.resultShareTbIdDao.batchInsert(tbids);
                    }
                }
                if (update != null && !update.isEmpty()) {
                    int batchCount = 100;
                    int page = update.size() / batchCount + 1;
                    for (int i = 0; i < page; ++i) {
                        int startIndex = i * batchCount;
                        endIndex = (i + 1) * batchCount;
                        if (startIndex >= update.size()) break;
                        if (endIndex >= update.size()) {
                            endIndex = update.size();
                        }
                        subs = update.subList(startIndex, endIndex);
                        tbids = new ArrayList();
                        for (String id : subs) {
                            tbid = new ResultShareTbId();
                            tbid.setId(UUID.randomUUID().toString());
                            tbid.setTbid(id);
                            tbid.setAnalysisId(translateId);
                            tbid.setTaskId(taskId);
                            tbid.setTemplateId(resultShareTask.getTemplateId());
                            tbids.add(tbid);
                        }
                        this.resultShareTbIdDao.batchInsert(tbids);
                    }
                }
                this.resultShareTaskService.updateStatus(translateId, Short.valueOf(AnalysisTaskStateEnum.create.getCode().shortValue()));
            } else if (paramsObject.containsKey((Object)"atlasId") && StringUtils.isNotBlank((CharSequence)paramsObject.getString("atlasId"))) {
                Map result;
                HashMap<String, String> map;
                ArrayList<Map<String, Object>> maps;
                List subs;
                String atlasId = paramsObject.getString("atlasId");
                if (add != null && !add.isEmpty()) {
                    int batchCount = 100;
                    int page = add.size() / batchCount + 1;
                    for (int i = 0; i < page; ++i) {
                        int startIndex = i * batchCount;
                        int endIndex = (i + 1) * batchCount;
                        if (startIndex >= add.size()) break;
                        if (endIndex >= add.size()) {
                            endIndex = add.size();
                        }
                        subs = add.subList(startIndex, endIndex);
                        maps = new ArrayList<Map<String, Object>>();
                        for (String id : subs) {
                            map = new HashMap<String, String>();
                            map.put("f_atlasid", atlasId);
                            map.put("f_tbid", id);
                            maps.add(map);
                        }
                        this.mDataBizService.insertDatasBatch("tb_task_translate_tbid", maps, null);
                    }
                }
                if (update != null && !update.isEmpty()) {
                    int batchCount = 100;
                    int page = update.size() / batchCount + 1;
                    for (int i = 0; i < page; ++i) {
                        int startIndex = i * batchCount;
                        int endIndex = (i + 1) * batchCount;
                        if (startIndex >= update.size()) break;
                        if (endIndex >= update.size()) {
                            endIndex = update.size();
                        }
                        subs = update.subList(startIndex, endIndex);
                        maps = new ArrayList();
                        for (String id : subs) {
                            map = new HashMap();
                            map.put("f_atlasid", atlasId);
                            map.put("f_tbid", id);
                            maps.add(map);
                        }
                        this.mDataBizService.insertDatasBatch("tb_task_translate_tbid", maps, null);
                    }
                }
                if (MapUtils.getBoolean((Map)(result = this.taskTranslateAtlasService.startTask(atlasId)), (Object)"result").booleanValue()) {
                    this.tbTaskTranslateTaskService.update(atlasId, Integer.valueOf(1), new Date());
                } else {
                    this.tbTaskTranslateTaskService.update(atlasId, Integer.valueOf(-1), new Date());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.createLog(userId, dataUploadLog, task.getName(), task.getId());
            record.setEndtime(new Date());
            record.setState(Integer.valueOf(4));
            record.setRemark(ExceptionUtil.stacktraceToString((Throwable)e));
            this.mTaskRecordService.save(record);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.logger.info("JobRunTask-rateJobDataImportInner \u5e73\u53f0\u4efb\u52a1\u6570\u636e\u52a0\u8f7d\u6267\u884c\u7ed3\u675f" + record.getId() + "-" + record.getState() + "-" + df.format(new Date()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gstDataImport(TaskRecord record) {
        HttpURLConnection httpURLConnection = null;
        SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-DD HH:mm:ss");
        HashMap<String, TskUploadLogDTO> dataUploadLog = new HashMap<String, TskUploadLogDTO>();
        TskTaskBiz task = new TskTaskBiz();
        String tbgstDataLogId = null;
        Long userId = null;
        try {
            JSONObject paramsObject = JSONObject.parseObject((String)record.getParam());
            String uploadurl = this.temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
            URL url = new URL(uploadurl);
            URLConnection urlConnection = url.openConnection();
            httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(1800000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            URLConnection con = url.openConnection();
            File zipFile = null;
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(this.uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"gtdcy2019");
            String taskId = paramsObject.getString("taskId");
            task = this.mTskTaskBizService.findByTaskId(taskId);
            userId = paramsObject.getLongValue("userId");
            tbgstDataLogId = paramsObject.getString("tbgstDataLogId");
            if (!StringUtils.isEmpty((CharSequence)tbgstDataLogId)) {
                this.tbgstDataLogRepository.updateTbgstDataLogByid(tbgstDataLogId);
            }
            Map<String, List<String>> tempIds = this.mTskTaskBizService.importTaskGstData(unzipFileDir, taskId, userId, paramsObject.getString("updateType"), dataUploadLog);
            this.createGstLog(userId, dataUploadLog, task, tbgstDataLogId, "success");
            record.setEndtime(new Date());
            record.setState(Integer.valueOf(3));
            this.mTaskRecordService.save(record);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.createGstLog(userId, dataUploadLog, task, tbgstDataLogId, "fail");
            record.setEndtime(new Date());
            record.setState(Integer.valueOf(4));
            record.setRemark(ExceptionUtil.stacktraceToString((Throwable)e));
            this.mTaskRecordService.save(record);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.logger.info("JobRunTask-rateJobDataImport \u5e73\u53f0\u4efb\u52a1\u6570\u636e\u52a0\u8f7d\u6267\u884c\u7ed3\u675f" + df.format(new Date()), new Object[0]);
        }
    }

    public TbtskDataLog createLog(Long userId, Map<String, TskUploadLogDTO> dataUploadLog, String taskName, String dataId) {
        Integer successCount = 0;
        Integer failCount = 0;
        Integer skipCount = 0;
        if (!dataUploadLog.isEmpty()) {
            String name = this.landUserRepository.queryUserById(userId).getName();
            ArrayList<Object> data = new ArrayList<Object>();
            if (dataUploadLog.size() == 1 && dataUploadLog.containsKey("error")) {
                Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataUploadLog.get("error")), Map.class);
                map.put("uploadUser", name);
                map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                map.put("error", map.get("errorInfo"));
                map.put("updateType", map.get("uploadType"));
                failCount = failCount + Integer.valueOf(map.get("failNum").toString());
                data.add(map);
            } else {
                for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                    Map map = entry.getValue().toMap();
                    map.put("uploadUser", name);
                    map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    successCount = successCount + Integer.valueOf(map.get("success").toString());
                    failCount = failCount + Integer.valueOf(map.get("fail").toString());
                    skipCount = skipCount + Integer.valueOf(map.get("skip").toString());
                    data.add(map);
                }
            }
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = taskName + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + System.currentTimeMillis() + ".xls";
            String fileName1 = taskName + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";
            String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
            String colName = TskUploadLogDTO.getExcelColName() + ",\u4e0a\u4f20\u4eba,\u4e0a\u4f20\u65f6\u95f4";
            String filePath = null;
            try {
                filePath = ExcelUtil.CreateExcel(data, (String)tempDir, (String)fileName, (String)col, (String)colName, (String)"\u65e5\u5fd7\u5bfc\u51fa");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String sendObjName = "taskManagerUploadLog/" + fileName1;
            String downloadPath = this.ossOperatorService.sendObject2Oss(sendObjName, filePath);
            TbtskDataLog tbtskDataLog = new TbtskDataLog();
            tbtskDataLog.setCreateTime(new Date());
            tbtskDataLog.setLogUrl(downloadPath);
            tbtskDataLog.setName(fileName1);
            tbtskDataLog.setTaskId(dataId);
            tbtskDataLog.setUserId(userId.toString());
            tbtskDataLog.setSuccessCount(successCount.toString());
            tbtskDataLog.setFailCount(failCount.toString());
            tbtskDataLog.setSkipCount(skipCount.toString());
            this.mTbtskDataLogService.saveDataLog(tbtskDataLog);
            return tbtskDataLog;
        }
        return null;
    }

    public void createImportLog(JcClueSource jcClueSource, TbtskDataLog tbtskDataLog, Long userId) {
        String fileName = jcClueSource.getfName() + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";
        tbtskDataLog.setCreateTime(new Date());
        tbtskDataLog.setName(fileName);
        tbtskDataLog.setTaskId(jcClueSource.getfId());
        tbtskDataLog.setUserId(userId.toString());
        tbtskDataLog = this.tbtskDataLogService.saveDataLog(tbtskDataLog);
        this.redisTemplate.opsForHash().put((Object)"JOB_WEB_ID", (Object)tbtskDataLog.getId(), (Object)"0%");
    }

    public void createGstLog(Long userId, Map<String, TskUploadLogDTO> dataUploadLog, TskTaskBiz task, String tbgstDataLogId, String state) {
        if (!dataUploadLog.isEmpty()) {
            String name = this.landUserRepository.queryUserById(userId).getName();
            ArrayList<Object> data = new ArrayList<Object>();
            if (dataUploadLog.size() == 1 && dataUploadLog.containsKey("error")) {
                Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataUploadLog.get("error")), Map.class);
                map.put("uploadUser", name);
                map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                map.put("error", map.get("errorInfo"));
                map.put("updateType", map.get("uploadType"));
                data.add(map);
            } else {
                for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                    Map map = entry.getValue().toMap();
                    map.put("uploadUser", name);
                    map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    data.add(map);
                }
            }
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = task.getName() + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + System.currentTimeMillis() + ".xls";
            String fileName1 = task.getName() + "-\u622a\u56fe\u670d\u52a1\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date()) + ".xls";
            String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
            String colName = TskUploadLogDTO.getExcelColName() + ",\u4e0a\u4f20\u4eba,\u4e0a\u4f20\u65f6\u95f4";
            String filePath = null;
            try {
                filePath = ExcelUtil.CreateExcel(data, (String)tempDir, (String)fileName, (String)col, (String)colName, (String)"\u65e5\u5fd7\u5bfc\u51fa");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String sendObjName = "taskManagerUploadLog/" + fileName1;
            String downloadPath = this.ossOperatorService.sendObject2Oss(sendObjName, filePath);
            TbgstDataLog tbgstDataLog = (TbgstDataLog)this.tbgstDataLogRepository.findById((Object)tbgstDataLogId).get();
            tbgstDataLog.setLogurl(downloadPath);
            tbgstDataLog.setLogName(fileName1);
            tbgstDataLog.setEndTime(new Date());
            tbgstDataLog.setStatus(Integer.valueOf("success".equals(state) ? 3 : 4));
            this.tbgstDataLogRepository.save((Object)tbgstDataLog);
        } else {
            TbgstDataLog tbgstDataLog = (TbgstDataLog)this.tbgstDataLogRepository.findById((Object)tbgstDataLogId).get();
            tbgstDataLog.setEndTime(new Date());
            tbgstDataLog.setStatus(Integer.valueOf("success".equals(state) ? 3 : 4));
            this.tbgstDataLogRepository.save((Object)tbgstDataLog);
        }
    }
}

