/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.task.TaskNoticeNewService;
import com.geoway.landteam.customtask.service.task.thread.TaskSendMsgNewThread;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilAssert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MTaskManageService {
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    TskTaskBizService tskTaskBizService1;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    TaskNoticeNewService taskNoticeNewService;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;

    public void deleteByTaskId(String taskId, Long userId) throws Exception {
        GutilAssert.hasLength((String)taskId, (String)"\u53c2\u6570\u9519\u8bef");
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
        GutilAssert.notNull((Object)taskBiz, (String)"\u672a\u67e5\u5230\u76f8\u5e94\u4efb\u52a1");
        GutilAssert.isTrue((!new Integer(1).equals(taskBiz.getIsPublic()) ? 1 : 0) != 0, (String)"\u9ed8\u8ba4\u4efb\u52a1\u4e0d\u80fd\u5220\u9664");
        if (StringUtils.isNotBlank((CharSequence)taskBiz.getTableId())) {
            TbtskObjectinfo tableInfo = this.tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
            if (StringUtils.isNotBlank((CharSequence)tableInfo.getfTablename()) && this.dataBizService.isExistTableName(tableInfo.getfTablename()) && this.dataBizService.getCount(tableInfo.getfTablename(), " 1=1 ") > 0) {
                throw new GwValidateException("\u4efb\u52a1\u4e2d\u5b58\u5728\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            if (taskBiz.getIsTmpl() == null || taskBiz.getIsTmpl() == 0) {
                ArrayList<String> fList = new ArrayList<String>();
                fList.add("f_id");
                fList.add("f_xzqdm");
                fList.add("f_xzqdmsys");
                if (StringUtils.isNotBlank((CharSequence)tableInfo.getfTablename()) && this.dataBizService.isExistTableName(tableInfo.getfTablename())) {
                    List<Map> dataList = this.dataBizService.queryAllData(tableInfo.getfTablename(), fList, "");
                    Map<String, List<String>> dataMaps = this.converXzqdmsys(dataList, taskBiz);
                    this.sendDeleteMessageNew(taskBiz, tableInfo, dataMaps, userId, null, 15);
                }
            }
        }
        this.tskTaskBizService.delByTaskId(taskId);
    }

    public void deleteBatchTb(String dataIds, String taskId, Long userId) throws Exception {
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = this.tskTaskBizService.getTableByTableId(taskBiz.getTableId());
        StringBuilder builder = new StringBuilder();
        JSONArray array = JSONArray.parseArray((String)dataIds, (Feature[])new Feature[0]);
        for (int i = 0; i < array.size(); ++i) {
            String string = array.getString(i);
            if (builder.length() > 0) {
                builder.append(",").append("'").append(string).append("'");
                continue;
            }
            builder.append("'").append(string).append("'");
        }
        ArrayList<String> fieldsList = new ArrayList<String>();
        fieldsList.add("f_id");
        fieldsList.add("f_xzqdm");
        fieldsList.add("f_xzqdmsys");
        List<Map> dataList = this.dataBizService.queryAllData(tableInfo.getfTablename(), fieldsList, "f_id in (" + builder + ")");
        Map<String, List<String>> dataMaps = this.converXzqdmsys(dataList, taskBiz);
        this.sendDeleteMessageNew(taskBiz, tableInfo, dataMaps, userId, dataIds, 14);
        this.tskTaskBizService.deleteBatchByDataIds(dataIds, taskId);
        Integer count = this.dataBizService.getCount(tableInfo.getfTablename(), "");
        taskBiz.setTotal(count);
        this.tskTaskBizService.update(taskBiz);
    }

    public void deleteTb(String dataId, String taskId, Long userId) throws Exception {
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = this.tskTaskBizService.getTableByTableId(taskBiz.getTableId());
        JSONArray array = new JSONArray();
        array.add((Object)dataId);
        ArrayList<String> fieldsList = new ArrayList<String>();
        fieldsList.add("f_id");
        fieldsList.add("f_xzqdm");
        fieldsList.add("f_xzqdmsys");
        List<Map> dataList = this.dataBizService.queryAllData(tableInfo.getfTablename(), fieldsList, "f_id='" + dataId + "'");
        Map<String, List<String>> dataMaps = this.converXzqdmsys(dataList, taskBiz);
        this.sendDeleteMessageNew(taskBiz, tableInfo, dataMaps, userId, dataId, 14);
        this.tskTaskBizService.deleteByDataId(dataId, taskId);
        Integer count = this.dataBizService.getCount(tableInfo.getfTablename(), "");
        taskBiz.setTotal(count);
        this.tskTaskBizService.update(taskBiz);
    }

    private void sendDeleteMessageNew(TskTaskBiz taskBiz, TbtskObjectinfo table, Map<String, List<String>> dataMaps, Long sendUser, String dataIds, Integer deleteType) throws Exception {
        TaskSendMsgNewThread thread = new TaskSendMsgNewThread(this.tskTaskBizService1, this.userBiz2Repository, this.taskNoticeNewService, taskBiz, table, dataMaps, sendUser, dataIds, deleteType);
        this.threadPoolTaskExecutor.execute((Runnable)thread);
    }

    private Map<String, List<String>> converXzqdmsys(List<Map> dataList, TskTaskBiz taskBiz) {
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        HashMap<String, List<String>> dataMaps = new HashMap<String, List<String>>();
        for (Map m : dataList) {
            String xzqdm = String.valueOf(m.get("f_xzqdmsys"));
            if (taskBiz.getGranularity() != null && taskBiz.getGranularity() == 3) {
                xzqdm = xzqdm.substring(0, 6);
            } else if (taskBiz.getGranularity() != null && taskBiz.getGranularity() == 4) {
                RegionTown regionTown = this.regionTownRepository.getByCodeAndVersion(xzqdm = xzqdm.substring(0, 9), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                if (regionTown == null) {
                    xzqdm = xzqdm.substring(0, 6);
                }
            } else if (taskBiz.getGranularity() != null && taskBiz.getGranularity() == 5) {
                xzqdm = (String)m.get("f_xzqdmsys");
                RegionVillage village = this.regionVillageRepository.getByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                if (village == null) {
                    xzqdm = xzqdm.substring(0, 6);
                }
            } else {
                xzqdm = xzqdm.substring(0, 6);
            }
            if (dataMaps.containsKey(xzqdm)) {
                List strings = (List)dataMaps.get(xzqdm);
                strings.add(String.valueOf(m.get("f_id")));
                dataMaps.put(xzqdm, strings);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(String.valueOf(m.get("f_id")));
            dataMaps.put(xzqdm, list);
        }
        return dataMaps;
    }
}

