/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.pub.dto.TaskNoticeNewDTO;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeNew;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeSubscribe;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.repository.task.TaskNoticeNewRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeSubscribeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserNewRepository;
import com.geoway.landteam.landcloud.servface.pub.MITaskNoticeNewService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MTaskNoticeNewService
implements MITaskNoticeNewService {
    @Autowired
    TaskNoticeSubscribeRepository taskNoticeSubscribeRepository;
    @Autowired
    TaskNoticeNewRepository taskNoticeNewRepository;
    @Autowired
    TaskNoticeUserNewRepository taskNoticeUserNewRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public void addSubscribe(String userId, String topic) {
        try {
            List taskNoticeSubscribeByUseridAndTopic = this.taskNoticeSubscribeRepository.getTaskNoticeSubscribeByUseridAndTopic(userId, topic);
            if (taskNoticeSubscribeByUseridAndTopic == null || taskNoticeSubscribeByUseridAndTopic.size() < 1) {
                TaskNoticeSubscribe taskNoticeSubscribe = new TaskNoticeSubscribe();
                taskNoticeSubscribe.setId(UUID.randomUUID().toString());
                taskNoticeSubscribe.setUserid(userId);
                taskNoticeSubscribe.setTopic(topic);
                taskNoticeSubscribe.setDate(new Date());
                this.taskNoticeSubscribeRepository.save((Object)taskNoticeSubscribe);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSubscribe(List<TaskNoticeSubscribe> subscribeList) {
        this.taskNoticeSubscribeRepository.saveAll(subscribeList);
    }

    public void deleteSubscribeByUserId(String userid) {
        this.taskNoticeSubscribeRepository.deleteTaskNoticeSubscribesByUserid(userid);
    }

    public void deleteSubscribeByUserIdAndTopic(String userid, String topic) {
        this.taskNoticeSubscribeRepository.deleteTaskNoticeSubscribesByUseridAndTopic(userid, topic);
    }

    public void deleteSubscribeByUserIdAndBizId(String userid, String bizId) {
        this.taskNoticeSubscribeRepository.deleteTaskNoticeSubscribesByUserIdAndBizId(userid, "tsk|" + bizId + "%", "tsk|" + bizId);
    }

    public void deleteSubscribeByUserIdsAndBizId(List<String> userids, String bizId) {
        this.taskNoticeSubscribeRepository.deleteTaskNoticeSubscribesByUserIdsAndBizId(userids, "tsk|" + bizId + "%", "tsk|" + bizId);
    }

    public void deleteSubscribeByUserIdAndBizIdLike(String userId, String bizId) {
        this.taskNoticeSubscribeRepository.deleteTaskNoticeSubscribesByUserIdAndBizIdLike(userId, "tsk|" + bizId + "%");
    }

    public List<String> getTopicsByUserId(String userId) {
        return this.taskNoticeSubscribeRepository.getTopicsByUserID(userId);
    }

    public List<String> getTopicsByTopicLike(String userId, String bizId) {
        return this.taskNoticeSubscribeRepository.getTopicsByTopicLike(userId, bizId);
    }

    public List<TaskNoticeSubscribe> getSubscribeByUserIdAndTopic(String userId, String topic) {
        return this.taskNoticeSubscribeRepository.getTaskNoticeSubscribeByUseridAndTopic(userId, topic);
    }

    public List<TaskNoticeNewDTO> getTaskNoticeNewList(String userId, List<String> bizIds, List<String> topics, Date date) {
        List taskNoticeObjs = this.taskNoticeNewRepository.getTaskNoticeNew(userId, bizIds, topics, date);
        ArrayList<TaskNoticeNewDTO> list = new ArrayList<TaskNoticeNewDTO>();
        if (taskNoticeObjs != null && taskNoticeObjs.size() > 0) {
            try {
                for (Map taskNoticeObj : taskNoticeObjs) {
                    TaskNoticeNewDTO taskNoticeNewDTO = new TaskNoticeNewDTO();
                    taskNoticeNewDTO.setId(taskNoticeObj.get("f_id").toString());
                    taskNoticeNewDTO.setData(taskNoticeObj.get("f_data").toString());
                    taskNoticeNewDTO.setCount(Integer.valueOf(taskNoticeObj.get("f_count") != null ? Integer.valueOf(taskNoticeObj.get("f_count").toString()) : 0));
                    taskNoticeNewDTO.setAction(Integer.valueOf(taskNoticeObj.get("f_action") != null ? Integer.valueOf(taskNoticeObj.get("f_action").toString()) : 0));
                    if (taskNoticeObj.get("f_senddate") != null) {
                        Date datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(taskNoticeObj.get("f_senddate").toString());
                        taskNoticeNewDTO.setSenddate(datetime);
                    } else {
                        taskNoticeNewDTO.setSenddate(null);
                    }
                    taskNoticeNewDTO.setBizId(taskNoticeObj.get("f_bizid").toString());
                    taskNoticeNewDTO.setTitle(taskNoticeObj.get("f_title").toString());
                    taskNoticeNewDTO.setContent(taskNoticeObj.get("f_content").toString());
                    taskNoticeNewDTO.setTaskmode(Integer.valueOf(taskNoticeObj.get("f_taskmode") != null ? Integer.valueOf(taskNoticeObj.get("f_taskmode").toString()) : 0));
                    list.add(taskNoticeNewDTO);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public TaskNoticeNew addTaskNoticeNew(TaskNoticeNew taskNoticeNew) {
        return (TaskNoticeNew)this.taskNoticeNewRepository.save((Object)taskNoticeNew);
    }

    public List<TaskNoticeNewDTO> getAllTaskNoticeNewByBizId(String bizId, List<String> topics, String userId, Date date) {
        List taskNoticeObjs = this.taskNoticeNewRepository.getTaskNoticeNewByBizIdAndUserId(bizId, topics, userId, date);
        ArrayList<TaskNoticeNewDTO> list = new ArrayList<TaskNoticeNewDTO>();
        if (taskNoticeObjs != null && taskNoticeObjs.size() > 0) {
            try {
                for (Map taskNoticeObj : taskNoticeObjs) {
                    TaskNoticeNewDTO taskNoticeNewDTO = new TaskNoticeNewDTO();
                    taskNoticeNewDTO.setId(taskNoticeObj.get("f_id").toString());
                    taskNoticeNewDTO.setData(taskNoticeObj.get("f_data").toString());
                    taskNoticeNewDTO.setCount(Integer.valueOf(taskNoticeObj.get("f_count") != null ? Integer.valueOf(taskNoticeObj.get("f_count").toString()) : 0));
                    taskNoticeNewDTO.setAction(Integer.valueOf(taskNoticeObj.get("f_action") != null ? Integer.valueOf(taskNoticeObj.get("f_action").toString()) : 0));
                    if (taskNoticeObj.get("f_senddate") != null) {
                        Date datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(taskNoticeObj.get("f_senddate").toString());
                        taskNoticeNewDTO.setSenddate(datetime);
                        taskNoticeNewDTO.setSendtime(taskNoticeObj.get("senddate") != null ? Long.valueOf(datetime.getTime()) : null);
                    } else {
                        taskNoticeNewDTO.setSenddate(null);
                    }
                    taskNoticeNewDTO.setBizId(taskNoticeObj.get("f_bizid").toString());
                    taskNoticeNewDTO.setTitle(taskNoticeObj.get("f_title").toString());
                    taskNoticeNewDTO.setContent(taskNoticeObj.get("f_content").toString());
                    taskNoticeNewDTO.setTaskmode(Integer.valueOf(taskNoticeObj.get("f_taskmode") != null ? Integer.valueOf(taskNoticeObj.get("f_taskmode").toString()) : 0));
                    list.add(taskNoticeNewDTO);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<TaskNoticeNewDTO> getAllTaskNoticeNewByBizIdAndregionCode(String bizId, List<String> topics, String userId, String operAreas, Date date) {
        List<Map<String, Object>> taskNotices = this.getTaskNoticeData(bizId, topics, userId, operAreas, date);
        ArrayList<TaskNoticeNewDTO> list = new ArrayList<TaskNoticeNewDTO>();
        if (taskNotices != null && taskNotices.size() > 0) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (Map<String, Object> map : taskNotices) {
                    TaskNoticeNewDTO taskNoticeNewDTO = new TaskNoticeNewDTO();
                    taskNoticeNewDTO.setId(String.valueOf(map.get("ID")));
                    taskNoticeNewDTO.setData(String.valueOf(map.get("DATA")));
                    taskNoticeNewDTO.setCount(Integer.valueOf(map.get("COUNT") != null ? Integer.valueOf(map.get("COUNT").toString()) : 0));
                    taskNoticeNewDTO.setAction(Integer.valueOf(map.get("ACTION") != null ? Integer.valueOf(map.get("ACTION").toString()) : 0));
                    taskNoticeNewDTO.setSenddate(df.parse(map.get("senddate").toString()));
                    taskNoticeNewDTO.setSendtime(map.get("senddate") != null ? Long.valueOf(df.parse(map.get("senddate").toString()).getTime()) : null);
                    taskNoticeNewDTO.setBizId(String.valueOf(map.get("bizId")));
                    taskNoticeNewDTO.setTitle(String.valueOf(map.get("title")));
                    taskNoticeNewDTO.setContent(String.valueOf(map.get("CONTENT")));
                    taskNoticeNewDTO.setXzqdmsys(String.valueOf(map.get("XZQDMSYS")));
                    taskNoticeNewDTO.setTaskmode(map.get("taskmode") != null ? Integer.valueOf(map.get("taskmode").toString()) : null);
                    list.add(taskNoticeNewDTO);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<Map<String, Object>> getTaskNoticeData(String bizId, List<String> topics, String userId, String operAreas, Date date) {
        StringBuffer sb = new StringBuffer();
        String sqlOne = "( SELECT b.f_id AS ID,\nb.f_data AS DATA,\nb.f_count AS COUNT,\nb.f_action AS ACTION,\nb.f_senddate AS senddate,\nb.f_bizid AS bizId,\nb.f_title AS title,\nb.f_content AS CONTENT,\nsubstring(b.f_topic,42,length(b.f_topic)-1) AS XZQDMSYS,\nb.f_taskmode AS taskmode \nFROM tb_tasknotice_subscribe A LEFT JOIN tb_tasknotice_new b ON A.f_topic = b.f_topic WHERE ";
        sb.append(sqlOne);
        if (userId != null) {
            sb.append(" A.f_userid ='" + userId + "' and ( ");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)operAreas, (Feature[])new Feature[0]);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            sb.append(" ( b.f_topic = 'tsk|" + bizId + "|" + object.getString("regionCode") + "'");
            sb.append(" and b.f_senddate > '" + new Date(Long.parseLong(object.getString("time"))) + "'");
            sb.append(") or ");
        }
        sb.append(" ( b.f_topic = 'tsk|" + bizId + "'))");
        String sqlTwo = ") UNION ( SELECT f_id AS ID,\n\tf_data AS DATA,\n\tf_count AS COUNT,\n\tf_action AS ACTION,\n\tf_senddate AS senddate,\n\tf_bizid AS bizId,\n\tf_title AS title,\n\tf_content AS CONTENT,\n\tf_xzqdmsys AS XZQDMSYS,\n\tf_taskmode AS taskmode \nFROM tb_tasknotice_user_new WHERE ";
        sb.append(sqlTwo);
        if (userId != null) {
            sb.append(" f_receiveuser ='" + userId + "'");
        }
        if (bizId != null) {
            sb.append(" AND f_bizid = '" + bizId + "' and ( ");
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object1 = jsonArray.getJSONObject(i);
            sb.append(" ( f_xzqdmsys = '" + object1.getString("regionCode") + "'");
            sb.append(" and f_senddate > '" + new Date(Long.parseLong(object1.getString("time"))) + "'");
            sb.append(") or ");
        }
        sb.append(" ( f_xzqdmsys  is null ))");
        String sqlThree = " ORDER BY senddate )";
        sb.append(sqlThree);
        List list = this.jdbcTemplate.queryForList(sb.toString());
        return list;
    }

    public void addTaskNoticeNewList(List<TaskNoticeNew> taskNoticeNewList) {
        this.taskNoticeNewRepository.saveAll(taskNoticeNewList);
    }

    public TaskNoticeUserNew addTaskNoticeUserNew(TaskNoticeUserNew taskNoticeUserNew) {
        return (TaskNoticeUserNew)this.taskNoticeUserNewRepository.save((Object)taskNoticeUserNew);
    }

    public void addTaskNoticeUserNewList(List<TaskNoticeUserNew> taskNoticeUserNewList) {
        this.taskNoticeUserNewRepository.saveAll(taskNoticeUserNewList);
    }

    public TaskNoticeNewDTO findLastedTaskNotice(String userid) {
        return null;
    }

    public List<TaskNoticeNew> findTaskNoticeUserNewBybizIdAndTopic(String bizId, String topic) {
        return this.taskNoticeNewRepository.getTaskNoticeNewsByBizidAndtAndTopic(bizId, topic);
    }
}

