/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TaskNoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserRepository;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.dto.TaskBizDTO;
import com.geoway.landteam.landcloud.core.model.pub.dto.TaskNoticeDTO;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MTaskNoticeService {
    @Autowired
    TaskNoticeRepository taskNoticeDao;
    @Autowired
    TaskNoticeUserRepository taskNoticeUserDao;
    @Autowired
    LandUserRepository landtaskNoticeUserDao;

    public Page<TaskNotice> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page results = this.taskNoticeDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public List<TaskNoticeUser> findUserNoticeByFilter(String filterParam) {
        List userNotices = this.taskNoticeUserDao.findAll((Specification)new QuerySpecification(filterParam));
        return userNotices;
    }

    public void deleteTaskNoticeByIds(String ids) {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            if (id[i].isEmpty()) continue;
            this.taskNoticeDao.deleteById((Object)id[i]);
            this.taskNoticeUserDao.delUserByNoticeId(id[i]);
        }
    }

    public TaskNotice save(TaskNotice notice) {
        return (TaskNotice)this.taskNoticeDao.save((Object)notice);
    }

    public Iterable<TaskNotice> saveList(List<TaskNotice> noticeList) {
        return this.taskNoticeDao.saveAll(noticeList);
    }

    public TaskNoticeUser save(TaskNoticeUser user) {
        return (TaskNoticeUser)this.taskNoticeUserDao.save((Object)user);
    }

    public Iterable<TaskNoticeUser> saveTaskNoticeUserList(List<TaskNoticeUser> userList) {
        return this.taskNoticeUserDao.saveAll(userList);
    }

    public void addTextNotice(String title, String content, long sendUserId, long receiveUserId) {
        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        notice.setSendTime(new Date());
        notice.setSendUser(Long.valueOf(sendUserId));
        notice.setState(Integer.valueOf(1));
        notice.setType(Integer.valueOf(1));
        notice.setContent(content);
        notice = (TaskNotice)this.taskNoticeDao.save((Object)notice);
        TaskNoticeUser noticeUser = new TaskNoticeUser();
        noticeUser.setNoticeId(notice.getId());
        noticeUser.setUserId(String.valueOf(receiveUserId));
        noticeUser.setState(Integer.valueOf(0));
        this.taskNoticeUserDao.save((Object)noticeUser);
    }

    public TaskNotice addTaskNotice(String title, String content, long sendUserId, int state, int type, String receiveIds, String xzqdm, int action) {
        Date time = new Date();
        TaskNotice taskNotice = null;
        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        notice.setSendTime(time);
        notice.setSendUser(Long.valueOf(sendUserId));
        notice.setState(Integer.valueOf(state));
        notice.setType(Integer.valueOf(type));
        notice.setRegion(xzqdm);
        notice.setAction(Integer.valueOf(action));
        if (type == 3) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] ids = content.split(",");
            for (int j = 0; j < ids.length; ++j) {
                arrayList.add(ids[j]);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tag", (Object)1);
            jsonObject.put("data", arrayList);
            notice.setContent(jsonObject.toString());
        } else {
            notice.setContent(content);
        }
        taskNotice = (TaskNotice)this.taskNoticeDao.save((Object)notice);
        String[] receiveId = receiveIds.split(",");
        String noticeId = taskNotice.getId();
        for (int i = 0; i < receiveId.length; ++i) {
            if (receiveId[i].isEmpty()) continue;
            long userId = Long.parseLong(receiveId[i]);
            TaskNoticeUser noticeUser = new TaskNoticeUser();
            noticeUser.setNoticeId(noticeId);
            noticeUser.setUserId(String.valueOf(userId));
            noticeUser.setState(Integer.valueOf(0));
            this.taskNoticeUserDao.save((Object)noticeUser);
        }
        return taskNotice;
    }

    public void updateTaskNotice(String noticeId, String title, String content, int state, String receiveIds) {
        Date time = new Date();
        this.taskNoticeDao.updateTaskNoticeById(title, content, time, state, noticeId);
        this.taskNoticeUserDao.delUserByNoticeId(noticeId);
        String[] receiveId = receiveIds.split(",");
        for (int i = 0; i < receiveId.length; ++i) {
            if (receiveId[i].isEmpty()) continue;
            long userId = Long.parseLong(receiveId[i]);
            TaskNoticeUser noticeUser = new TaskNoticeUser();
            noticeUser.setNoticeId(noticeId);
            noticeUser.setUserId(String.valueOf(userId));
            noticeUser.setState(Integer.valueOf(0));
            this.taskNoticeUserDao.save((Object)noticeUser);
        }
    }

    public Map getNavStatistics(Long userId, String params) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (params != null && !params.isEmpty()) {
            String[] temp = params.split(",");
            for (int i = 0; i < temp.length; ++i) {
                ArrayList<Integer> type = new ArrayList<Integer>();
                int count = 0;
                if (temp[i].equals("send")) {
                    type.add(1);
                    type.add(4);
                    count = this.taskNoticeDao.queryCountByStateType(userId, 1, type);
                } else if (temp[i].equals("received")) {
                    count = this.taskNoticeUserDao.queryCountByUserId(userId);
                } else if (temp[i].equals("draft")) {
                    type.add(1);
                    count = this.taskNoticeDao.queryCountByStateType(userId, 0, type);
                }
                map.put(temp[i], count);
            }
        }
        return map;
    }

    public void addAssignNotice2User(String layerId, String layerName, List<String> ids, Long sendUser, Long wyry, String title, String content, String xzqdm, Integer action) {
        Date now = new Date();
        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        notice.setSendTime(now);
        notice.setSendUser(sendUser);
        notice.setState(Integer.valueOf(1));
        notice.setType(Integer.valueOf(1));
        notice.setContent(content);
        notice.setRegion(xzqdm);
        notice.setAction(action);
        if (ids != null && ids.size() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("time", (Object)now.getTime());
            jsonObject.put("layerId", (Object)layerId);
            jsonObject.put("layerName", (Object)layerName);
            jsonObject.put("arr", ids);
            notice.setData(jsonObject.toString());
        }
        TaskNotice taskNotice = (TaskNotice)this.taskNoticeDao.save((Object)notice);
        TaskNoticeUser noticeUser = new TaskNoticeUser();
        noticeUser.setNoticeId(taskNotice.getId());
        noticeUser.setUserId(String.valueOf(wyry));
        noticeUser.setState(Integer.valueOf(0));
        this.taskNoticeUserDao.save((Object)noticeUser);
    }

    public List<TaskNoticeDTO> getMyTaskNoticeList(Long userId, String oriType) {
        ArrayList<TaskNoticeDTO> taskNotices = new ArrayList<TaskNoticeDTO>();
        List taskNoticeUsers = this.taskNoticeUserDao.queryByUserIdAndOriType(userId.toString(), "%\"oriType\":\"" + oriType + "\"%");
        if (taskNoticeUsers == null || taskNoticeUsers.isEmpty()) {
            return taskNotices;
        }
        TaskNotice taskNotice = null;
        for (TaskNoticeUser taskNoticeUser : taskNoticeUsers) {
            String noticeId = taskNoticeUser.getNoticeId();
            if (StringUtils.isNotBlank((CharSequence)noticeId)) {
                taskNotice = this.taskNoticeDao.findById((Object)noticeId).orElse(null);
            }
            if (taskNotice == null) continue;
            TaskNoticeDTO taskNoticeDTO = new TaskNoticeDTO();
            BeanUtil.copyProperties((Object)taskNotice, (Object)taskNoticeDTO);
            taskNotices.add(taskNoticeDTO);
        }
        return taskNotices;
    }

    public List<TaskNoticeDTO> getTaskNotices(String region, String bizId, String startDate, String endDate) {
        ArrayList<TaskNoticeDTO> rlist = new ArrayList<TaskNoticeDTO>();
        try {
            List list = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                Date start = new Date(Long.parseLong(startDate));
                Date end = new Date(Long.parseLong(endDate));
                list = this.taskNoticeDao.queryByRegionAndBizId(region, bizId, start, end, "1");
            } else {
                list = this.taskNoticeDao.queryByRegionAndBizId(region, bizId, "1");
            }
            for (TaskNotice tn : list) {
                TaskNoticeDTO tnd = new TaskNoticeDTO();
                BeanUtil.copyProperties((Object)tn, (Object)tnd);
                tnd.setRegion(tn.getRegion1());
                rlist.add(tnd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rlist;
    }

    public List<TaskNoticeDTO> getTaskNoticesByUserId(String userid, String bizId, String startDate, String endDate) {
        ArrayList<TaskNoticeDTO> rlist = new ArrayList<TaskNoticeDTO>();
        try {
            List list = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)startDate) && !"0".equals(startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                Date start = new Date(Long.parseLong(startDate));
                Date end = new Date(Long.parseLong(endDate));
                list = this.taskNoticeUserDao.queryByUserIdAndBizId(userid, start, end);
            } else {
                list = this.taskNoticeUserDao.queryByUserIdAndBizId(userid);
            }
            for (TaskNoticeUser tn : list) {
                if (tn.getNotice() == null || !bizId.equalsIgnoreCase(tn.getNotice().getBizId())) continue;
                TaskNoticeDTO tnd = new TaskNoticeDTO();
                BeanUtil.copyProperties((Object)tn.getNotice(), (Object)tnd);
                tnd.setUserData(tn.getData());
                rlist.add(tnd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rlist;
    }

    public List<TaskBizDTO> getTaskNoticeBizs(String region) {
        List rlist = this.taskNoticeDao.queryTasksByRegion(region);
        return rlist;
    }

    public List<TaskNoticeDTO> getMyTaskNoticesByUserId(String userid, String bizId, String startDate, String endDate) {
        ArrayList<TaskNoticeDTO> rlist = new ArrayList<TaskNoticeDTO>();
        try {
            List list = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)startDate) && !"0".equals(startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                Date start = new Date(Long.parseLong(startDate));
                Date end = new Date(Long.parseLong(endDate));
                list = this.taskNoticeUserDao.queryMyTaskByUserIdAndBizId(userid, bizId, start, end);
            } else {
                list = this.taskNoticeUserDao.queryMyTaskByUserIdAndBizId(userid, bizId);
            }
            for (TaskNoticeUser tn : list) {
                TaskNoticeDTO tnd = new TaskNoticeDTO();
                BeanUtil.copyProperties((Object)tn.getNotice(), (Object)tnd);
                tnd.setUserData(tn.getData());
                rlist.add(tnd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rlist;
    }

    public TaskNotice getTaskNoticeByBizId(String bizId) {
        List list = this.taskNoticeDao.findNoticByBizId(bizId, Integer.valueOf(3), Integer.valueOf(17));
        TaskNotice notice = null;
        if (list != null && list.size() > 0) {
            notice = (TaskNotice)list.get(0);
        }
        return notice;
    }

    public List<TaskNotice> getTaskNoticeByBizIdAndXzqdm(String bizId, Set<String> set) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(set);
        List notices = this.taskNoticeDao.findTaskNoticeByBizIdAndXzqdm(bizId, list);
        return notices;
    }

    public void createNoticeForUser(String xzqdm, String bizId, String userid) {
        List taskNotices = this.taskNoticeDao.queryByBeforeNotice(xzqdm, bizId, new Date());
        List deltaskNotices = this.taskNoticeDao.queryTaskDelNotice(bizId, Integer.valueOf(15));
        taskNotices.addAll(deltaskNotices);
        ArrayList<TaskNoticeUser> arrayList = new ArrayList<TaskNoticeUser>();
        for (int i = 0; i < taskNotices.size(); ++i) {
            String noticeId = ((TaskNotice)taskNotices.get(i)).getId();
            List list = this.taskNoticeUserDao.queryByNoticeIdAndUserId(noticeId, userid, Integer.valueOf(1));
            if (list != null && list.size() > 0) continue;
            TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
            taskNoticeUser.setId(UUID.randomUUID().toString());
            taskNoticeUser.setUserId(userid);
            taskNoticeUser.setData(((TaskNotice)taskNotices.get(i)).getData());
            taskNoticeUser.setNoticeId(((TaskNotice)taskNotices.get(i)).getId());
            taskNoticeUser.setState(Integer.valueOf(1));
            taskNoticeUser.setCreatetime(new Date());
            taskNoticeUser.setType(Integer.valueOf(1));
            arrayList.add(taskNoticeUser);
        }
        this.taskNoticeUserDao.saveAll(arrayList);
    }

    public List<Long> queryByTaskId(String taskId) {
        return this.taskNoticeUserDao.queryByTaskId(taskId);
    }
}

