/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TaskNoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserRepository;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.constants.TaskNoticeConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MTaskNoticeServiceBg {
    @Autowired
    TaskNoticeRepository taskNoticeDao;
    @Autowired
    TaskNoticeUserRepository taskNoticeUserDao;

    public void addAssignDataNotice(Long sendUser, Long wyry, List<String> ids, String xzqdm, Integer action) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        TaskNotice notice = new TaskNotice();
        String title = "\u6307\u6d3e\u4efb\u52a1\u901a\u77e5";
        if (action == TaskNoticeConstants.ACTION_CONFIRMED) {
            title = "\u533a\u53bf\u5df2\u786e\u8ba4\u901a\u77e5";
        } else if (action == TaskNoticeConstants.ACTION_REVOKE) {
            title = "\u4efb\u52a1\u64a4\u9500\u901a\u77e5";
        } else if (action == TaskNoticeConstants.ACTION_REPROOF) {
            title = "\u91cd\u65b0\u4e3e\u8bc1\u901a\u77e5";
        } else if (action == TaskNoticeConstants.ACTION_CONFIRMED_CANCEL) {
            title = "\u533a\u53bf\u786e\u8ba4\u53d6\u6d88\u901a\u77e5";
        } else if (action == TaskNoticeConstants.ACTION_AFTER_SUBMIT) {
            title = "\u6210\u679c\u6570\u636e\u63d0\u4ea4\u8fd4\u56de\u901a\u77e5";
        }
        notice.setTitle(title);
        Date now = new Date();
        notice.setSendTime(now);
        notice.setSendUser(sendUser);
        notice.setState(Integer.valueOf(1));
        notice.setType(TaskNoticeConstants.TYPE_SYS);
        notice.setRegion(xzqdm);
        notice.setAction(action);
        JSONObject jsonObject = new JSONObject();
        if (action == TaskNoticeConstants.ACTION_CONFIRMED) {
            jsonObject.put("tag", (Object)88);
        } else if (action == TaskNoticeConstants.ACTION_ASSIGN) {
            jsonObject.put("tag", (Object)99);
        } else if (action == TaskNoticeConstants.ACTION_REPROOF) {
            jsonObject.put("tag", (Object)99);
        } else if (action == TaskNoticeConstants.ACTION_REVOKE) {
            jsonObject.put("tag", (Object)1);
        }
        jsonObject.put("time", (Object)now.getTime());
        jsonObject.put("data", ids);
        notice.setContent(jsonObject.toString());
        TaskNotice taskNotice = (TaskNotice)this.taskNoticeDao.save((Object)notice);
        TaskNoticeUser noticeUser = new TaskNoticeUser();
        noticeUser.setNoticeId(taskNotice.getId());
        noticeUser.setUserId(String.valueOf(wyry));
        noticeUser.setState(Integer.valueOf(0));
        this.taskNoticeUserDao.save((Object)noticeUser);
    }

    public void addAssignNotice2User(Long sendUser, Long wyry, String title, String content, String xzqdm, Integer action) {
        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        Date now = new Date();
        notice.setSendTime(now);
        notice.setSendUser(sendUser);
        notice.setState(Integer.valueOf(1));
        notice.setType(TaskNoticeConstants.TYPE_NOTICE);
        notice.setContent(content);
        notice.setRegion(xzqdm);
        notice.setAction(action);
        TaskNotice taskNotice = (TaskNotice)this.taskNoticeDao.save((Object)notice);
        TaskNoticeUser noticeUser = new TaskNoticeUser();
        noticeUser.setNoticeId(taskNotice.getId());
        noticeUser.setUserId(String.valueOf(wyry));
        noticeUser.setState(Integer.valueOf(0));
        this.taskNoticeUserDao.save((Object)noticeUser);
    }

    public List<String> combineAssginNotice(Long wyry, String xzqdm, Integer action) {
        ArrayList<String> results = new ArrayList<String>();
        String filterParam = "Q_notice.action_N_EQ=" + action + ";Q_notice.region_S_EQ=" + xzqdm;
        filterParam = filterParam + ";(Q_state_N_EQ=0;QOR_state_N_EQ=NULL);Q_userId_N_EQ=" + wyry;
        List userNotices = this.taskNoticeUserDao.findAll((Specification)new QuerySpecification(filterParam));
        for (TaskNoticeUser userNotice : userNotices) {
            TaskNotice notice = userNotice.getNotice();
            if (notice.getType() == TaskNoticeConstants.TYPE_NOTICE) {
                this.taskNoticeDao.deleteById((Object)userNotice.getNoticeId());
                this.taskNoticeUserDao.deleteById((Object)userNotice.getId());
                continue;
            }
            if (notice.getType() != TaskNoticeConstants.TYPE_SYS) continue;
            String jsonContent = notice.getContent();
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonContent));
            results.addAll(jsonObject.getJSONArray("data").toJavaList(String.class));
            this.taskNoticeDao.deleteById((Object)userNotice.getNoticeId());
            this.taskNoticeUserDao.deleteById((Object)userNotice.getId());
        }
        return results;
    }

    public List<TaskNoticeUser> findUserNoticeByFilter(String filterParam) {
        List userNotices = this.taskNoticeUserDao.findAll((Specification)new QuerySpecification(filterParam));
        return userNotices;
    }

    public TaskNotice addTaskNotice(String title, String content, String param, long sendUserId, int type, long receiveUserId, String xzqdm, int action) {
        Date time = new Date();
        TaskNotice taskNotice = null;
        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        notice.setSendTime(time);
        notice.setSendUser(Long.valueOf(sendUserId));
        notice.setState(Integer.valueOf(1));
        notice.setType(Integer.valueOf(type));
        notice.setRegion(xzqdm);
        notice.setAction(Integer.valueOf(action));
        notice.setData(param);
        notice.setContent(content);
        taskNotice = (TaskNotice)this.taskNoticeDao.save((Object)notice);
        TaskNoticeUser noticeUser = new TaskNoticeUser();
        noticeUser.setNoticeId(taskNotice.getId());
        noticeUser.setUserId(String.valueOf(receiveUserId));
        noticeUser.setState(Integer.valueOf(0));
        this.taskNoticeUserDao.save((Object)noticeUser);
        return taskNotice;
    }
}

