/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.TaskRecordRepository;
import com.geoway.landteam.customtask.repository.task.TaskRecordTempRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.task.dto.AssignRecordDTO;
import com.geoway.landteam.customtask.task.entity.TskAssignRecord;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MTaskRecordService {
    private final GiLoger logger = GwLoger.getLoger(MTaskRecordService.class);
    @Autowired
    TaskRecordRepository taskRecordRepository;
    @Autowired
    TaskRecordTempRepository taskRecordTempRepository;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;

    public List<TaskRecord> findByTypeAndState(Integer type, Integer state) {
        return this.taskRecordRepository.findByTypeAndState(type, state, "v2");
    }

    public int findByTypeAndParamAndStarttime(Integer type, String params, Date starttime) {
        return this.taskRecordRepository.findByTypeAndParamAndStarttime(type, params, starttime);
    }

    public void state2Success(String id) {
        this.taskRecordRepository.updateState(JobConstants.JOB_STATE_SUCCESS, id);
    }

    public void state2Fail(String id, String error) {
        this.taskRecordRepository.updateStateAndRemark(JobConstants.JOB_STATE_FAILED, error, id);
    }

    public void state2FailAndRemarkError(String id, String error) {
        this.taskRecordRepository.updateStateAndRemark(JobConstants.JOB_STATE_FAILED, error, id);
    }

    public void stateSuccess(String id) {
        this.taskRecordRepository.updateStateAndTime(JobConstants.JOB_STATE_SUCCESS, new Date(), id);
    }

    public TaskRecord save(TaskRecord taskRecord) {
        taskRecord.setVersion("v2");
        TaskRecord record = (TaskRecord)this.taskRecordRepository.save((Object)taskRecord);
        return record;
    }

    public TaskRecord findOne(String id) {
        return this.taskRecordRepository.findById((Object)id).orElse(null);
    }

    public Iterable<TaskRecordTemp> saveTaskRecordTemp(List<TaskRecordTemp> list) {
        return this.taskRecordTempRepository.saveAll(list);
    }

    public List<String> getDataIdListByRecordId(String recordId) {
        return this.taskRecordTempRepository.getDataIdByRecordId(recordId);
    }

    public List<TaskRecord> findByTypeAndStateAndBizId(Integer type, Integer state, String bizId) {
        return this.taskRecordRepository.findByTypeAndStateAndBizId(type, state, "v1", bizId);
    }

    public Page<TaskRecord> findByUseridAndTasktypeAndBizId(Long userid, String taskType, String bizId, Integer page, Integer size) throws Exception {
        String filterParam = String.format("Q_userid_N_EQ=%s;Q_tasktype_N_IN=%s;Q_bizId_S_EQ=%s", userid, taskType, bizId);
        String sortParam = "SORT_starttime_DESC";
        Page result = null;
        try {
            result = this.taskRecordRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), new Object[0]);
            throw new GwValidateException("\u67e5\u8be2\u51fa\u9519:findByUseridAndTasktypeAndBizId");
        }
        return result;
    }

    public Page<TaskRecord> findByTasktypeAndBizId(final Long userId, final String taskType, final String bizId, Integer page, Integer size) {
        Page result = null;
        Specification spec = new Specification(){

            public Predicate toPredicate(Root root, CriteriaQuery cq, CriteriaBuilder cb) {
                Predicate p2;
                ArrayList<Predicate> list = new ArrayList<Predicate>();
                if (taskType != null) {
                    p2 = cb.equal((Expression)root.get("tasktype"), (Object)taskType);
                    list.add(p2);
                }
                if (userId != null) {
                    list.add(cb.equal((Expression)root.get("userid"), (Object)userId));
                }
                if (bizId != null) {
                    p2 = cb.equal((Expression)root.get("bizId"), (Object)bizId);
                    list.add(p2);
                }
                return cb.and(list.toArray(new Predicate[list.size()]));
            }
        };
        result = this.taskRecordRepository.findAll(spec, (Pageable)PageRequest.of((int)(page - 1), (int)size));
        return result;
    }

    public Map<String, Object> queryAssignUserRecord(String taskId, String dataId, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<AssignRecordDTO> list = new ArrayList<AssignRecordDTO>();
        List taskRecords = this.taskRecordRepository.queryByTaskIdAndDataId(taskId, dataId, (page - 1) * rows, rows);
        for (Object[] tskAssignRecord : taskRecords) {
            AssignRecordDTO assignRecordDTO = new AssignRecordDTO();
            LandUser assignTo = this.landUserRepository.findById((Object)Long.valueOf(tskAssignRecord[0].toString())).orElse(null);
            assignRecordDTO.setAssignUser(assignTo != null ? assignTo.getName() : null);
            LandUser optUser = this.landUserRepository.findById((Object)Long.valueOf(tskAssignRecord[1].toString())).orElse(null);
            assignRecordDTO.setOptUser(optUser != null ? optUser.getName() : null);
            assignRecordDTO.setAssignDate((Date)tskAssignRecord[2]);
            list.add(assignRecordDTO);
        }
        Long count = 0L;
        count = this.taskRecordRepository.queryByTaskIdAndDataIdCount(taskId, dataId);
        map.put("list", list);
        map.put("count", count);
        return map;
    }

    public Map<String, Object> getAssignRecordList(String taskId, String dataId, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List taskRecords = this.tskAssignRecordRepository.getTaskIdAndDataId(taskId, dataId, (page - 1) * rows, rows);
        JSONArray jsonArray = new JSONArray();
        for (TskAssignRecord tskAssignRecord : taskRecords) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)tskAssignRecord.getId());
            jsonObject.put("assignto", (Object)tskAssignRecord.getAssignto());
            jsonObject.put("assignUserName", (Object)this.getUserName(tskAssignRecord.getAssignto() != null ? tskAssignRecord.getAssignto() : "0"));
            jsonObject.put("dataId", (Object)tskAssignRecord.getDataId());
            jsonObject.put("taskId", (Object)tskAssignRecord.getTaskId());
            jsonObject.put("createTime", (Object)tskAssignRecord.getCreateTime().getTime());
            jsonObject.put("optUserId", (Object)tskAssignRecord.getOptUserId());
            jsonObject.put("optUserName", (Object)this.getUserName(tskAssignRecord.getOptUserId() != null ? tskAssignRecord.getOptUserId() : "0"));
            jsonObject.put("sourceId", (Object)tskAssignRecord.getSourceId());
            jsonObject.put("sourceType", (Object)tskAssignRecord.getSourceType());
            jsonObject.put("status", (Object)tskAssignRecord.getStatus());
            jsonObject.put("tableId", (Object)tskAssignRecord.getTableId());
            jsonObject.put("pasteUserId", (Object)tskAssignRecord.getPasteUserId());
            jsonObject.put("pasteUserName", (Object)this.getUserName(tskAssignRecord.getPasteUserId() != null ? tskAssignRecord.getPasteUserId() : "0"));
            jsonObject.put("updateTime", tskAssignRecord.getUpdateTime() != null ? Long.valueOf(tskAssignRecord.getUpdateTime().getTime()) : null);
            jsonArray.add((Object)jsonObject);
        }
        Integer count = this.tskAssignRecordRepository.getCountByTaskIdAndDataId(taskId, dataId);
        map.put("list", jsonArray);
        map.put("count", count);
        return map;
    }

    public String getUserName(String userId) {
        String name = "";
        LandUser landUser = this.landUserRepository.queryUserById(Long.valueOf(Long.parseLong(userId)));
        if (landUser != null) {
            name = landUser.getName();
        }
        return name;
    }

    public Page<TaskRecord> findByUserId(Long userId, String param, Integer page, Integer size) throws Exception {
        String filterParam = String.format("Q_userid_N_EQ=%s", userId);
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            filterParam = filterParam + ";" + param;
        }
        String sortParam = "SORT_starttime_DESC";
        Page result = null;
        try {
            result = this.taskRecordRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), new Object[0]);
            throw new GwValidateException("\u67e5\u8be2\u51fa\u9519");
        }
        return result;
    }

    public void updateRecordRead(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.taskRecordRepository.updateRecordRead(Integer.valueOf(1), idList);
    }
}

