/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.pub.entity.TaskTransformData;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMediaMetaImg;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.user.LandUserRoleinfoService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MTaskTransMediaService {
    @Value(value="${jfunbox.userName:}")
    protected String adminLoginName;
    @Value(value="${obsSignatureEnable:false}")
    protected boolean obsSignatureEnable;
    protected String tempDir;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    LandUserRoleinfoService landUserRoleinfoService;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    private final GiLoger logger = GwLoger.getLoger(MTaskTransMediaService.class);
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    public static TaskTransformMediaMetaImg getTaskTransMetaImgFromJson(JSONObject mediaMetaObj) {
        String time;
        TaskTransformMediaMetaImg sevenFeatures = new TaskTransformMediaMetaImg();
        if (mediaMetaObj.containsKey((Object)"psry")) {
            sevenFeatures.setPsry(mediaMetaObj.get((Object)"psry").toString());
        }
        if (mediaMetaObj.containsKey((Object)"pssj") && StringUtils.isNotBlank((CharSequence)(time = mediaMetaObj.get((Object)"pssj").toString()))) {
            Long timeLong = null;
            try {
                timeLong = Long.valueOf(time);
            }
            catch (NumberFormatException e) {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                    timeLong = date.getTime();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (timeLong != null) {
                sevenFeatures.setPssj(String.valueOf(timeLong));
            }
        }
        if (mediaMetaObj.containsKey((Object)"psjd") && StringUtils.isNotBlank((CharSequence)mediaMetaObj.get((Object)"psjd").toString())) {
            try {
                sevenFeatures.setPsjd(Double.valueOf(mediaMetaObj.get((Object)"psjd").toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (mediaMetaObj.containsKey((Object)"longitude") && StringUtils.isNotBlank((CharSequence)mediaMetaObj.get((Object)"longitude").toString())) {
            try {
                sevenFeatures.setLongitude(Double.valueOf(mediaMetaObj.get((Object)"longitude").toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (mediaMetaObj.containsKey((Object)"latitude") && StringUtils.isNotBlank((CharSequence)mediaMetaObj.get((Object)"latitude").toString())) {
            try {
                sevenFeatures.setLatitude(Double.valueOf(mediaMetaObj.get((Object)"latitude").toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (mediaMetaObj.containsKey((Object)"height") && StringUtils.isNotBlank((CharSequence)mediaMetaObj.get((Object)"height").toString())) {
            try {
                sevenFeatures.setHeight(Double.valueOf(mediaMetaObj.get((Object)"height").toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (mediaMetaObj.containsKey((Object)"psfyj") && StringUtils.isNotBlank((CharSequence)mediaMetaObj.get((Object)"psfyj").toString())) {
            try {
                sevenFeatures.setPsfyj(Double.valueOf(mediaMetaObj.get((Object)"psfyj").toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return sevenFeatures;
    }

    public static TaskTransformData convertToTaskTransDataFromJson(Object json) {
        TaskTransformData taskTransformData = new TaskTransformData();
        JSONObject jsonRecord = JSONObject.parseObject((String)JSONObject.toJSONString((Object)json));
        if (jsonRecord != null) {
            JSONArray jsonArray;
            if (jsonRecord.containsKey((Object)"tbid")) {
                taskTransformData.setTbId(jsonRecord.getString("tbid"));
            }
            if (jsonRecord.containsKey((Object)"tbname")) {
                taskTransformData.setTbName(jsonRecord.getString("tbname"));
            }
            if (jsonRecord.containsKey((Object)"prjnum")) {
                taskTransformData.setPrjNum(jsonRecord.getString("prjnum"));
            }
            if (jsonRecord.containsKey((Object)"prjname")) {
                taskTransformData.setPrjName(jsonRecord.getString("prjname"));
            }
            if (jsonRecord.containsKey((Object)"regioncode")) {
                taskTransformData.setRegionCode(jsonRecord.getString("regioncode"));
            }
            if (!jsonRecord.containsKey((Object)"extent")) {
                if (jsonRecord.containsKey((Object)"tbname")) {
                    throw new RuntimeException(String.format("%s\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e(shape)\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u8f6c\u6362", jsonRecord.getString("tbname")));
                }
                throw new RuntimeException(String.format("\u56fe\u6591\u7684\u56fe\u5f62\u6570\u636e(shape)\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u8f6c\u6362", new Object[0]));
            }
            taskTransformData.setExtent(jsonRecord.getString("extent"));
            if (jsonRecord.containsKey((Object)"md5")) {
                taskTransformData.setMd5(jsonRecord.getString("md5"));
            }
            if (jsonRecord.containsKey((Object)"requestid")) {
                taskTransformData.setRequestId(jsonRecord.getString("requestid"));
            }
            if (jsonRecord.containsKey((Object)"analysisid")) {
                taskTransformData.setAnalysisId(jsonRecord.getString("analysisid"));
            }
            if (jsonRecord.containsKey((Object)"tbmj") && StringUtils.isNotBlank((CharSequence)jsonRecord.get((Object)"tbmj").toString())) {
                try {
                    taskTransformData.setTbmj(Double.valueOf(jsonRecord.get((Object)"tbmj").toString()).doubleValue());
                }
                catch (NumberFormatException e) {
                    taskTransformData.setTbmj(0.0);
                }
            }
            if (jsonRecord.containsKey((Object)"tbbh")) {
                taskTransformData.setTbbh(jsonRecord.getString("tbbh"));
            }
            ArrayList<TaskTransformMedia> mediaList = new ArrayList<TaskTransformMedia>();
            if (jsonRecord.containsKey((Object)"medias") && (jsonArray = JSONArray.parseArray((String)jsonRecord.getString("medias"), (Feature[])new Feature[0])) != null) {
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(obj));
                    if (jsonObject == null) continue;
                    TaskTransformMedia taskTransformMedia = MTaskTransMediaService.convertTaskTransMediaFromJson(jsonObject);
                    mediaList.add(taskTransformMedia);
                }
            }
            if (mediaList.size() > 0) {
                taskTransformData.setMedias(JSONArray.parseArray((String)JSONObject.toJSONString(mediaList), (Feature[])new Feature[0]));
            } else {
                taskTransformData.setMedias(JSONArray.parseArray((String)"[]", (Feature[])new Feature[0]));
            }
        }
        return taskTransformData;
    }

    public static TaskTransformMedia convertTaskTransMediaFromJson(JSONObject jsonMedia) {
        TaskTransformMedia taskTransformMedia = new TaskTransformMedia();
        if (jsonMedia != null) {
            if (jsonMedia.containsKey((Object)"attachid")) {
                taskTransformMedia.setAttachId(jsonMedia.getString("attachid"));
            } else if (jsonMedia.containsKey((Object)"attachId")) {
                taskTransformMedia.setAttachId(jsonMedia.getString("attachId"));
            }
            if (jsonMedia.containsKey((Object)"mediasource")) {
                try {
                    taskTransformMedia.setMediaSource(Integer.valueOf(jsonMedia.getString("mediasource")));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else if (jsonMedia.containsKey((Object)"mediaSource")) {
                try {
                    taskTransformMedia.setMediaSource(Integer.valueOf(jsonMedia.getString("mediaSource")));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (jsonMedia.containsKey((Object)"mediaformat")) {
                taskTransformMedia.setMediaFormat(jsonMedia.getString("mediaformat"));
            } else if (jsonMedia.containsKey((Object)"mediaFormat")) {
                taskTransformMedia.setMediaFormat(jsonMedia.getString("mediaFormat"));
            }
            if (jsonMedia.containsKey((Object)"mediatype")) {
                taskTransformMedia.setMediaType(jsonMedia.getString("mediatype"));
            } else if (jsonMedia.containsKey((Object)"mediaType")) {
                taskTransformMedia.setMediaType(jsonMedia.getString("mediaType"));
            }
            if (jsonMedia.containsKey((Object)"url")) {
                taskTransformMedia.setUrl(jsonMedia.getString("url"));
            }
            if (jsonMedia.containsKey((Object)"viewurl")) {
                taskTransformMedia.setViewUrl(jsonMedia.getString("viewurl"));
            } else if (jsonMedia.containsKey((Object)"viewUrl")) {
                taskTransformMedia.setViewUrl(jsonMedia.getString("viewUrl"));
            }
            if (jsonMedia.containsKey((Object)"mediameta")) {
                taskTransformMedia.setMediaMeta((Object)jsonMedia.getString("mediameta"));
            } else if (jsonMedia.containsKey((Object)"mediaMeta")) {
                taskTransformMedia.setMediaMeta((Object)jsonMedia.getString("mediaMeta"));
            }
            if (jsonMedia.containsKey((Object)"jym")) {
                taskTransformMedia.setJym(jsonMedia.getString("jym"));
            }
            if (jsonMedia.containsKey((Object)"status")) {
                taskTransformMedia.setStatus(jsonMedia.getString("status"));
            }
            if (jsonMedia.containsKey((Object)"othermetadata")) {
                taskTransformMedia.setOtherMetaData(jsonMedia.getString("othermetadata"));
            } else if (jsonMedia.containsKey((Object)"otherMetaData")) {
                taskTransformMedia.setOtherMetaData(jsonMedia.getString("otherMetaData"));
            }
            if (jsonMedia.containsKey((Object)"username")) {
                taskTransformMedia.setUserName(jsonMedia.getString("username"));
            } else if (jsonMedia.containsKey((Object)"userName")) {
                taskTransformMedia.setUserName(jsonMedia.getString("userName"));
            }
        }
        return taskTransformMedia;
    }

    public static TaskTransformMedia convertAppMediaToTaskTranMedia(AppMedia appMedia) {
        TaskTransformMedia taskTransformMedia = new TaskTransformMedia();
        taskTransformMedia.setAttachId(appMedia.getId() != null ? appMedia.getId() : "");
        taskTransformMedia.setMediaSource(appMedia.getDeviceSource());
        if (appMedia.getType() == 1) {
            taskTransformMedia.setMediaFormat("jpg");
            taskTransformMedia.setMediaMeta((Object)MTaskTransMediaService.get7FeaturesFromAppMedia(appMedia));
            JSONObject json4Points = new JSONObject();
            json4Points.put("xmin", (Object)"");
            json4Points.put("ymin", (Object)"");
            json4Points.put("xmax", (Object)"");
            json4Points.put("ymax", (Object)"");
            taskTransformMedia.setOtherMetaData(json4Points.toString());
        } else if (appMedia.getType() == 2) {
            taskTransformMedia.setMediaFormat("mp4");
            taskTransformMedia.setMediaMeta(MTaskTransMediaService.getVideoMediaMetaFromAppMedia(appMedia));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("psry", (Object)"");
            taskTransformMedia.setOtherMetaData(jsonObject.toString());
        } else if (appMedia.getType() == 3) {
            taskTransformMedia.setMediaFormat("mp3");
            taskTransformMedia.setMediaMeta((Object)JSONArray.parseArray((String)"[]", (Feature[])new Feature[0]));
            taskTransformMedia.setOtherMetaData(appMedia.getMediatimelength().toString());
        } else if (appMedia.getType() == 4) {
            taskTransformMedia.setMediaFormat("osgb");
            taskTransformMedia.setMediaMeta((Object)MTaskTransMediaService.get7FeaturesFromAppMedia(appMedia));
        }
        if (appMedia.getDeviceSource().equals(0)) {
            taskTransformMedia.setMediaType("J");
        } else if (appMedia.getDeviceSource().equals(1)) {
            taskTransformMedia.setMediaType("Y");
        }
        taskTransformMedia.setUrl(appMedia.getServerpath() != null ? appMedia.getServerpath() : "");
        taskTransformMedia.setViewUrl(StringUtils.isNotBlank((CharSequence)appMedia.getViewUrl()) ? appMedia.getViewUrl() : "");
        taskTransformMedia.setJym(StringUtils.isNotBlank((CharSequence)appMedia.getJym()) ? appMedia.getJym() : "");
        taskTransformMedia.setUserName(appMedia.getUsername() != null ? appMedia.getUsername() : "");
        if (appMedia.getTypetype() == 0) {
            taskTransformMedia.setStatus("-1");
        } else if (appMedia.getTypetype() == 101) {
            taskTransformMedia.setStatus("0");
        } else if (appMedia.getTypetype() == 102) {
            taskTransformMedia.setStatus("1");
        }
        return taskTransformMedia;
    }

    public static Object getVideoMediaMetaFromAppMedia(AppMedia appMedia) {
        JSONArray jsonArray;
        block7: {
            if (StringUtils.isBlank((CharSequence)appMedia.getVideorecord())) {
                return null;
            }
            jsonArray = new JSONArray();
            try {
                String startTimeStr;
                JSONObject jsonObject = JSONObject.parseObject((String)appMedia.getVideorecord());
                if (jsonObject == null || !jsonObject.containsKey((Object)"starttime") || !StringUtils.isNotBlank((CharSequence)(startTimeStr = jsonObject.get((Object)"starttime").toString())) || !jsonObject.containsKey((Object)"items")) break block7;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Calendar calendar = Calendar.getInstance();
                try {
                    Date startTime = new Date(new Long(startTimeStr));
                    JSONArray itemsArrary = JSONArray.parseArray((String)JSONArray.toJSONString((Object)jsonObject.get((Object)"items")), (Feature[])new Feature[0]);
                    if (itemsArrary != null && itemsArrary.size() > 0) {
                        for (Object o : itemsArrary) {
                            JSONObject itemJsonObj = JSONObject.parseObject((String)JSONObject.toJSONString(o));
                            if (itemJsonObj == null || !itemJsonObj.containsKey((Object)"position")) continue;
                            int position = new Integer(itemJsonObj.get((Object)"position").toString());
                            calendar.setTime(startTime);
                            calendar.add(13, position);
                            JSONObject newItem = new JSONObject();
                            newItem.put("position", (Object)sdf.format(calendar.getTime()));
                            newItem.put("x", itemJsonObj.get((Object)"x"));
                            newItem.put("y", itemJsonObj.get((Object)"y"));
                            newItem.put("angle", itemJsonObj.get((Object)"angel"));
                            newItem.put("height", (Object)1.7);
                            newItem.put("pitch", (Object)0);
                            jsonArray.add((Object)newItem);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                return JSONArray.parse((String)appMedia.getVideorecord(), (Feature[])new Feature[0]);
            }
        }
        return jsonArray;
    }

    public static JSONObject get7FeaturesFromAppMedia(AppMedia appMedia) {
        JSONObject json7Features = new JSONObject();
        json7Features.put("psry", (Object)"");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        json7Features.put("pssj", (Object)sdf.format(new Date()));
        json7Features.put("psjd", (Object)appMedia.getAzimuth());
        json7Features.put("longitude", (Object)appMedia.getLon());
        json7Features.put("latitude", (Object)appMedia.getLat());
        json7Features.put("height", (Object)1.7);
        if (StringUtils.isBlank((CharSequence)appMedia.getPitch())) {
            json7Features.put("psfyj", (Object)"0");
        } else {
            json7Features.put("psfyj", (Object)appMedia.getPitch());
        }
        return json7Features;
    }

    private long getUserIdParma(long userId) {
        List roles = this.landUserRoleinfoService.findRoleIdsByUserId(Long.valueOf(userId));
        long userIdParma = userId;
        userIdParma = !roles.contains("10012") ? Long.valueOf(this.adminLoginName) : userId;
        return userIdParma;
    }

    public Object saveAttach(long userId, String tbId, String tbShape, List<TaskTransformMedia> mediaList, String token) {
        String folderName = "AppBasicFiles";
        ArrayList<AppMedia> attachList = new ArrayList<AppMedia>();
        if (mediaList != null && mediaList.size() > 0) {
            for (TaskTransformMedia media : mediaList) {
                AppMedia appMedia;
                block42: {
                    if (media == null) continue;
                    appMedia = new AppMedia();
                    appMedia.setId(media.getAttachId());
                    appMedia.setGalleryid(tbId);
                    appMedia.setShape(tbShape);
                    if (media.getMediaSource().equals(1)) {
                        appMedia.setDeviceSource(Integer.valueOf(0));
                    } else if (media.getMediaSource().equals(1)) {
                        appMedia.setDeviceSource(Integer.valueOf(1));
                    }
                    if (StringUtils.isNotBlank((CharSequence)media.getMediaFormat())) {
                        if (media.getMediaFormat().equalsIgnoreCase("jpg")) {
                            appMedia.setType(Integer.valueOf(1));
                            try {
                                TaskTransformMediaMetaImg sevenFeatures;
                                JSONObject mediaMetaObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)media.getMediaMeta()));
                                if (mediaMetaObj == null || (sevenFeatures = MTaskTransMediaService.getTaskTransMetaImgFromJson(mediaMetaObj)) == null) break block42;
                                appMedia.setLon(sevenFeatures.getLongitude());
                                appMedia.setLat(sevenFeatures.getLatitude());
                                appMedia.setAzimuth(sevenFeatures.getPsjd().toString());
                                appMedia.setUsername(StringUtils.isNotBlank((CharSequence)sevenFeatures.getPsry()) ? sevenFeatures.getPsry() : "");
                                appMedia.setTime(StringUtils.isNotBlank((CharSequence)sevenFeatures.getPssj()) ? sevenFeatures.getPssj() : String.valueOf(System.currentTimeMillis()));
                                if (StringUtils.isNotBlank((CharSequence)sevenFeatures.getPsfyj().toString())) {
                                    appMedia.setPitch(sevenFeatures.getPsfyj().toString());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.logger.error(e.getMessage(), new Object[0]);
                            }
                        } else if (media.getMediaFormat().equalsIgnoreCase("mp4")) {
                            appMedia.setType(Integer.valueOf(2));
                            if (media.getMediaMeta() != null) {
                                appMedia.setVideorecord(media.getMediaMeta().toString());
                            }
                            appMedia.setTime(StringUtils.isNotBlank((CharSequence)appMedia.getTime()) ? appMedia.getTime() : String.valueOf(System.currentTimeMillis()));
                        } else if (media.getMediaFormat().equalsIgnoreCase("osgb")) {
                            appMedia.setType(Integer.valueOf(4));
                            appMedia.setTime(StringUtils.isNotBlank((CharSequence)appMedia.getTime()) ? appMedia.getTime() : String.valueOf(System.currentTimeMillis()));
                            appMedia.setServerpath(StringUtils.isNotBlank((CharSequence)media.getViewUrl()) ? media.getViewUrl() : "");
                        } else if (media.getMediaFormat().equalsIgnoreCase("mp3")) {
                            appMedia.setType(Integer.valueOf(3));
                            appMedia.setTime(StringUtils.isNotBlank((CharSequence)appMedia.getTime()) ? appMedia.getTime() : String.valueOf(System.currentTimeMillis()));
                            if (media.getOtherMetaData() != null) {
                                try {
                                    appMedia.setMediatimelength(Integer.valueOf(media.getOtherMetaData()));
                                }
                                catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    } else {
                        throw new RuntimeException("\u56fe\u6591id\uff1a" + tbId + " \u9644\u4ef6id\uff1a" + media.getAttachId() + " \u9644\u4ef6\u7c7b\u578b\u5b57\u6bb5mediaFormat\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)media.getStatus())) {
                    if (media.getStatus().equalsIgnoreCase("-1")) {
                        appMedia.setTypetype(Integer.valueOf(0));
                    } else if (media.getStatus().equalsIgnoreCase("0")) {
                        appMedia.setTypetype(Integer.valueOf(101));
                    } else if (media.getStatus().equalsIgnoreCase("1")) {
                        appMedia.setTypetype(Integer.valueOf(102));
                    }
                } else {
                    throw new RuntimeException("\u56fe\u6591id\uff1a" + tbId + " \u9644\u4ef6id\uff1a" + media.getAttachId() + " \u9644\u4ef6\u72b6\u6001\u5b57\u6bb5status\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
                }
                appMedia.setCreateTime(String.valueOf(System.currentTimeMillis()));
                appMedia.setUsername(media.getUserName());
                if (StringUtils.isNotBlank((CharSequence)media.getStatus())) {
                    if (media.getStatus().equalsIgnoreCase("-1")) {
                        appMedia.setTypetype(Integer.valueOf(0));
                    } else if (media.getStatus().equalsIgnoreCase("0")) {
                        appMedia.setTypetype(Integer.valueOf(101));
                    } else if (media.getStatus().equalsIgnoreCase("1")) {
                        appMedia.setTypetype(Integer.valueOf(102));
                    }
                } else {
                    throw new RuntimeException("\u56fe\u6591id\uff1a" + tbId + " \u9644\u4ef6id\uff1a" + media.getAttachId() + " \u9644\u4ef6\u72b6\u6001\u5b57\u6bb5status\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
                }
                appMedia.setJym(StringUtils.isNotBlank((CharSequence)media.getJym()) ? media.getJym() : "");
                File tempFile = null;
                try {
                    this.tempDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
                    String tempUrl = this.getSignedUrl(token, media.getUrl());
                    tempFile = new File(this.tempDir + File.separator + UUID.randomUUID().toString() + media.getMediaFormat());
                    FileUtils.copyURLToFile((URL)new URL(tempUrl), (File)tempFile);
                    String url = this.defaultOssOperatorService.sendObject2Oss("media/" + userId + "/" + UUID.randomUUID().toString() + media.getMediaFormat(), tempFile);
                    if (StringUtils.isNotBlank((CharSequence)url)) {
                        appMedia.setServerpath(url);
                        appMedia.setViewUrl(url);
                    }
                    try {
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                    throw new RuntimeException("\u590d\u5236\u6587\u4ef6\u5f02\u5e38\uff01" + e.getMessage());
                }
                attachList.add(appMedia);
            }
        }
        if (attachList.size() > 0) {
            this.appMediaRepository.saveAll(attachList);
        }
        return null;
    }

    private String getSignedUrl(String token, String downloadPath) {
        if (this.obsSignatureEnable) {
            return this.temporarySignedUrlService.getTemporarySignedUrl(this.defaultOssOperatorService.getServerId().toString(), downloadPath, new HashMap());
        }
        if (StringUtils.isNotBlank((CharSequence)downloadPath)) {
            String newUrl = downloadPath;
            if (!newUrl.startsWith("https") && !newUrl.startsWith("HTTPS")) {
                if (newUrl.startsWith("http")) {
                    newUrl = newUrl.replace("http", "https");
                } else if (newUrl.startsWith("HTTP")) {
                    newUrl = newUrl.replace("HTTP", "https");
                }
            }
            return newUrl;
        }
        return "";
    }

    private File getFileFromUrl(String url) throws Exception {
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        this.tempDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        File file = new File(this.tempDir + File.separator + fileName);
        FileUtils.copyURLToFile((URL)new URL(url), (File)file);
        return file;
    }
}

