/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.pub.enm.ByteOperator;
import com.geoway.landteam.customtask.pub.entity.TbSyncStatus;
import com.geoway.landteam.customtask.repository.pub.TbSyncStatusRepository;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbSyncStatusService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MTbSyncStatusServiceImpl
implements MTbSyncStatusService {
    private static final String SYNC_STATUS = "sync.status";
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbSyncStatusRepository tbSyncStatusRepository;

    public void changeStatus(@NotNull Integer objectType, @NotNull String taskId, @NotNull String tbid, @NotNull Integer status, @NotNull ByteOperator operator) {
        String key = String.format("%s.%s.%s", objectType, taskId, tbid);
        String optString = "f_status";
        if (this.redisTemplate.opsForHash().hasKey((Object)SYNC_STATUS, (Object)key).booleanValue()) {
            Integer i = (Integer)this.redisTemplate.opsForHash().get((Object)SYNC_STATUS, (Object)key);
            optString = String.valueOf(operator.applyAsInt(i.intValue(), status.intValue()));
        } else {
            optString = operator.getOptString("EXCLUDED.f_status", status.toString());
        }
        String insertValues = String.format("('%s',%s,'%s','%s',%s)", UUID.randomUUID().toString(), objectType, taskId, tbid, optString);
        String sql = "INSERT INTO  tb_sync_status (f_id,f_object_type,f_objectid,f_tbid,f_status) VALUES " + insertValues + " ON CONFLICT (f_object_type,f_objectid,f_tbid) DO UPDATE SET f_status = " + optString + ";";
        this.jdbcTemplate.update(sql);
        this.redisTemplate.opsForHash().put((Object)SYNC_STATUS, (Object)key, (Object)status);
        this.redisTemplate.expire((Object)SYNC_STATUS, 10L, TimeUnit.MINUTES);
    }

    public void changeStatus(@NotNull Integer objectType, @NotNull String taskId, @NotNull List<String> tbids, @NotNull Integer status, @NotNull ByteOperator operator) {
        ArrayList<String> batchList = new ArrayList<String>();
        int batchNum = 0;
        for (int i = 0; i < tbids.size(); ++i) {
            batchList.add(tbids.get(i));
            if (++batchNum < 5000) continue;
            this.batchChangeStatus(objectType, taskId, tbids, status, operator);
            batchList.clear();
            batchNum = 0;
        }
        if (!batchList.isEmpty()) {
            this.batchChangeStatus(objectType, taskId, tbids, status, operator);
        }
    }

    @Transactional
    public void batchChangeStatus(@NotNull Integer objectType, @NotNull String taskId, @NotNull List<String> tbids, @NotNull Integer status, @NotNull ByteOperator operator) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, Integer> chche = new HashMap<String, Integer>();
        for (String tbid : tbids) {
            String key = String.format("%s.%s.%s", objectType, taskId, tbid);
            String valueString = "";
            if (this.redisTemplate.opsForHash().hasKey((Object)SYNC_STATUS, (Object)key).booleanValue()) {
                Integer i = (Integer)this.redisTemplate.opsForHash().get((Object)SYNC_STATUS, (Object)key);
                valueString = String.valueOf(operator.applyAsInt(i.intValue(), status.intValue()));
                chche.put(key, i);
            } else {
                valueString = operator.getOptString("EXCLUDED.f_status", status.toString());
            }
            String insertValues = String.format("('%s',%s,'%s','%s',%s)", UUID.randomUUID().toString(), objectType, taskId, tbid, status);
            sb.append("INSERT INTO  tb_sync_status (f_id,f_object_type,f_objectid,f_tbid,f_status) VALUES ").append(insertValues).append(" ON CONFLICT (f_object_type,f_objectid,f_tbid) DO UPDATE SET f_status = ").append(valueString).append(";");
        }
        this.jdbcTemplate.update(sb.toString());
        this.redisTemplate.opsForHash().putAll((Object)SYNC_STATUS, chche);
        this.redisTemplate.expire((Object)SYNC_STATUS, 12L, TimeUnit.HOURS);
    }

    public List<TbSyncStatus> getStatusByObjectIdAndTbids(Integer objectType, String objectId, List<String> tbids) {
        return this.tbSyncStatusRepository.findByObjectIdAndTbids(objectType, objectId, tbids);
    }

    public Integer getStatusByTbid(@NotNull Integer objectType, @NotNull String objectId, @NotNull String tbid) {
        String key = String.format("%s.%s.%s", objectType, objectId, tbid);
        if (this.redisTemplate.opsForHash().hasKey((Object)SYNC_STATUS, (Object)key).booleanValue()) {
            Integer i = (Integer)this.redisTemplate.opsForHash().get((Object)SYNC_STATUS, (Object)key);
            this.redisTemplate.expire((Object)SYNC_STATUS, 10L, TimeUnit.MINUTES);
            return i;
        }
        Integer i = this.tbSyncStatusRepository.findByTbid(objectType, objectId, tbid);
        this.redisTemplate.opsForHash().put((Object)SYNC_STATUS, (Object)key, (Object)i);
        this.redisTemplate.expire((Object)SYNC_STATUS, 10L, TimeUnit.MINUTES);
        return i;
    }

    public List<TbSyncStatus> getStatusByTaskAndMask(@NotNull Integer objectType, @NotNull String objectid, @NotNull Integer status, @NotNull ByteOperator operator) {
        if (operator.equals((Object)ByteOperator.ADD)) {
            return this.tbSyncStatusRepository.findByObjectidAndIncludeMask(objectType, objectid, status);
        }
        if (operator.equals((Object)ByteOperator.ERASE)) {
            return this.tbSyncStatusRepository.findByObjectidAndExcludeMask(objectType, objectid, status);
        }
        return this.tbSyncStatusRepository.findByObjectidAndStatus(objectType, objectid, status);
    }
}

