/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskAuditAssignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskAuditRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskFlowRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskUserAreaRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.enm.ReviewStageEnum;
import com.geoway.landteam.customtask.task.entity.TbtskAuditRecord;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskRejectDef;
import com.geoway.landteam.customtask.task.entity.TbtskTaskFlow;
import com.geoway.landteam.customtask.task.entity.TbtskTaskUserArea;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskRejectDefService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MTbtskAuditService {
    private static final GiLoger log = GwLoger.getLoger();
    @Autowired
    MTbtskRejectDefService mTbtskRejectDefService;
    @Autowired
    TbtskTaskFlowRepository tbtskTaskFlowRepository;
    @Autowired
    TbtskAuditRecordRepository tbtskAuditRecordRepository;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    TbtskAuditAssignRecordRepository tbtskAuditAssignRecordRepository;
    @Autowired
    TbtskTaskUserAreaRepository tbtskTaskUserAreaRepository;

    public List<TbtskTaskFlow> findTaskFlowByTaskId(String taskId) {
        List taskFlowByTaskId = this.tbtskTaskFlowRepository.findTaskFlowByTaskId(taskId);
        return taskFlowByTaskId;
    }

    public TbtskTaskFlow findByTaskIdAndAndIndex(String taskId, Integer index) {
        TbtskTaskFlow taskFlow = this.tbtskTaskFlowRepository.findByTaskIdAndAndIndex(taskId, index);
        return taskFlow;
    }

    public List<TbtskAuditRecord> findAuditRecordsByTaskIdAndTbId(String taskId, String tbId) {
        List auditRecordsByTaskIdAndTbId = this.tbtskAuditRecordRepository.findAuditRecordsByTaskIdAndTbId(taskId, tbId);
        return auditRecordsByTaskIdAndTbId;
    }

    public List<TbtskAuditRecord> findAuditRecordsByTaskIdAndTbIdAndType(String taskId, String tbId, Integer type) {
        List auditRecordsByTaskIdAndTbId = this.tbtskAuditRecordRepository.findAuditRecordsByTaskIdAndTbIdAndType(taskId, tbId, type);
        return auditRecordsByTaskIdAndTbId;
    }

    public Map checkAuditPermission(Long userId, String taskId, String tbId, String childTbId, String type) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("hasPermission", false);
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return resultMap;
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return resultMap;
        }
        List<String> fieldNameList = this.getAuditFieldNameCollection();
        Map data = this.dataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u4e0d\u5b58\u5728");
            return resultMap;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)childTbId) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getSplitTableName()) && this.dataBizService.isExistTableName(tbtskObjectinfo.getSplitTableName()) && null == (data = this.dataBizService.selectFieldByID(tbtskObjectinfo.getSplitTableName(), fieldNameList, "f_id", "'" + childTbId + "'"))) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u4e0d\u5b58\u5728");
            return resultMap;
        }
        Integer status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
        String xzqdm = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
        Integer reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
        Integer rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
        Integer rejectStatus = MapUtils.getInteger((Map)data, (Object)"f_reject_status", null);
        if (status == null || status < TbStatusEnum.WAITING_VERIFY.getCode()) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u672a\u63d0\u62a5\uff0c\u4e0d\u80fd\u5ba1\u6838");
            return resultMap;
        }
        if (reviewStage != null && reviewStage.equals(ReviewStageEnum.OVER_VERIFY)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u5ba1\u6838\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u5ba1\u6838");
            return resultMap;
        }
        List taskFlowByTaskId = this.tbtskTaskFlowRepository.findTaskFlowByTaskId(taskId);
        TbtskTaskFlow currentStep = null;
        for (TbtskTaskFlow taskFlow : taskFlowByTaskId) {
            if (!taskFlow.getPreStages().contains(status.toString()) || !taskFlow.getPreStages().contains(reviewStage.toString())) continue;
            currentStep = taskFlow;
            break;
        }
        if (currentStep == null) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "\u56fe\u6591\u672a\u627e\u5230\u5bf9\u5e94\u5ba1\u6838\u9636\u6bb5");
            return resultMap;
        }
        boolean flag = false;
        Pair<Integer, String> levelAndRegion = this.processRegionCode(xzqdm, currentStep.getName());
        List byTaskIdAndUserId = this.tbtskTaskUserAreaRepository.findByTaskIdAndUserId(taskId, userId);
        for (TbtskTaskUserArea taskUserArea : byTaskIdAndUserId) {
            if (taskUserArea.getLevel() != levelAndRegion.getLeft()) continue;
            flag = true;
            break;
        }
        if (flag) {
            resultMap.put("hasPermission", true);
            resultMap.put("stepIndex", currentStep.getIndex());
            resultMap.put("stepName", currentStep.getName());
            resultMap.put("flowId", currentStep.getId());
            TbtskRejectDef rejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
            if (rejectDef != null) {
                resultMap.put("canReject", rejectDef.getRejectType() != 0);
                resultMap.put("rejectType", rejectDef.getRejectType());
            } else {
                resultMap.put("canReject", false);
            }
        }
        return resultMap;
    }

    public Pair<Integer, String> processRegionCode(String dataRegionCode, String name) {
        String result = "";
        Integer level = 1;
        if (StringUtils.isNotBlank((CharSequence)dataRegionCode)) {
            result = dataRegionCode;
            switch (name) {
                case "\u6751\u7ea7\u5ba1\u6838": 
                case "\u6751\u7ea7\u590d\u6838": {
                    result = dataRegionCode;
                    level = 5;
                    break;
                }
                case "\u4e61\u9547\u5ba1\u6838": 
                case "\u4e61\u9547\u590d\u6838": {
                    result = dataRegionCode.substring(0, 9);
                    level = 4;
                    break;
                }
                case "\u533a\u53bf\u5ba1\u6838": 
                case "\u533a\u53bf\u590d\u6838": {
                    result = dataRegionCode.substring(0, 6);
                    level = 3;
                    break;
                }
                case "\u5e02\u7ea7\u5ba1\u6838": 
                case "\u5e02\u7ea7\u590d\u6838": {
                    result = dataRegionCode.substring(0, 4) + "00";
                    level = 2;
                    break;
                }
                case "\u7701\u7ea7\u5ba1\u6838": 
                case "\u7701\u7ea7\u590d\u6838": {
                    result = dataRegionCode.substring(0, 2) + "0000";
                    level = 1;
                    break;
                }
                case "\u56fd\u5bb6\u5ba1\u6838": 
                case "\u56fd\u5bb6\u590d\u6838": {
                    result = "1";
                    level = 0;
                    break;
                }
            }
        }
        return Pair.of((Object)level, (Object)result);
    }

    private List<String> getAuditFieldNameCollection() {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        fieldNameList.add("f_id");
        fieldNameList.add("f_status");
        fieldNameList.add("f_xzqdmsys");
        fieldNameList.add("f_reject_status");
        fieldNameList.add("f_review_stage");
        fieldNameList.add("f_reject_count");
        return fieldNameList;
    }
}

