/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskFieldsGroupViewRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskGroupRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskSysFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTemplateRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.dto.AppConfigDTO;
import com.geoway.landteam.customtask.task.dto.FieldDisPlay;
import com.geoway.landteam.customtask.task.dto.FieldGroup;
import com.geoway.landteam.customtask.task.entity.TbtskFieldGroupView;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskGroup;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskSysFields;
import com.geoway.landteam.customtask.task.entity.TbtskTemplate;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilAssert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MTbtskFieldsService {
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    TbtskSysFieldsRepository tbtskSysFieldsRepository;
    @Autowired
    TbtskFieldsGroupViewRepository tbtskFieldsGroupViewRepository;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskGroupRepository tbtskGroupRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskTemplateRepository tbtskTemplateDao;
    final String LISTCODE = "100";
    final String FILTERCODE = "101";
    final String DETAILCODE = "202";
    final String SEARCHCODE = "102";
    final String MAINCODE = "103";
    final String FILTERSYSCODE = "104";
    final String ORDERCODE = "105";
    final String AUDITQXCODE = "301";
    final String AUDITCITYCODE = "302";
    final String AUDITSJCODE = "303";

    public List<TbtskFields> getAllFieldsByTableID(String tableid) {
        List tbtskFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tableid);
        return tbtskFields;
    }

    public List<TbtskSysFields> getAllSysFields() {
        List tbtskSysFields = this.tbtskSysFieldsRepository.findAllOrder();
        return tbtskSysFields;
    }

    public List<TbtskFields> getAllFieldsByTables(String tableNames) {
        List<String> tableList = Arrays.asList(tableNames.split(","));
        List tbtskFields = this.tbtskFieldsRepository.getTbtskFieldsByTables(tableList);
        return tbtskFields;
    }

    public List<TbtskFieldGroupView> getTbtskViewFields(String sysCode, String tableid, String groupCode) {
        List tbtskFields = this.tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(tableid, sysCode, groupCode);
        return tbtskFields;
    }

    public List<TbtskGroup> getAuditField(String sysCode, String tableid, String groupCode) {
        List tbtskGroups = null;
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.findById((Object)tableid).orElse(null);
        if (tbtskObjectinfo != null) {
            tbtskGroups = this.tbtskGroupRepository.selectAuditFields(sysCode, tbtskObjectinfo.getfTablename(), groupCode);
        }
        return tbtskGroups;
    }

    public List<TbtskGroup> getTbtskGroupFields(String sysCode, String tableid, String groupCode) {
        List tbtskFields = null;
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.findById((Object)tableid).orElse(null);
        if (tbtskObjectinfo != null) {
            tbtskFields = this.tbtskGroupRepository.selectByTableNameAndGroupcode(sysCode, tbtskObjectinfo.getfTablename(), groupCode);
        }
        return tbtskFields;
    }

    public List<String> getTbtskGroupFieldsName(String sysCode, String tableid, String groupCode) {
        List tbtskFields = null;
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.findById((Object)tableid).orElse(null);
        if (tbtskObjectinfo != null) {
            tbtskFields = this.tbtskGroupRepository.selectFieldNameByTableNameAndGroupcode(tableid, sysCode, groupCode);
        }
        return tbtskFields;
    }

    public List<String> getTbtskFieldsNameListBySysCodeAndGroupCode(String sysCode, String tableid, String groupCode) {
        List tbtskFieldsNameList = this.tbtskFieldsGroupViewRepository.getTbtskFieldsNameListBySysCodeAndGroupCode(tableid, sysCode, groupCode);
        return tbtskFieldsNameList;
    }

    public List<TbtskGroup> selectFieldGroupByTbId(String tableId) {
        List fields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tableId);
        ArrayList<String> fieldIdList = new ArrayList<String>();
        for (TbtskFields field : fields) {
            fieldIdList.add(field.getfId());
        }
        return this.tbtskGroupRepository.selectByFieldList(fieldIdList);
    }

    public List<TbtskGroup> getFieldbyTableNameAndGroupCode(String tableName, String groupCode, String sysCode) {
        return this.tbtskGroupRepository.getFieldByTbnameGroupSys(tableName, groupCode, sysCode);
    }

    @Transactional
    public Iterable<TbtskGroup> saveGroupCode(List<TbtskGroup> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        String tableName = list.get(0).getfTablename();
        String groupcode = list.get(0).getfGroupcode();
        String sysCode = list.get(0).getfSyscode();
        ArrayList<String> ids = new ArrayList<String>();
        for (TbtskGroup group : list) {
            if (group.getfId() != null) {
                ids.add(group.getfId());
                continue;
            }
            this.tbtskGroupRepository.deleteByTbnameGroupSys(tableName, groupcode, sysCode);
        }
        if (ids.size() > 0) {
            this.tbtskGroupRepository.deleteNotInList(tableName, groupcode, ids);
        }
        return this.tbtskGroupRepository.saveAll(list);
    }

    public void deleteById(String id) {
        this.tbtskFieldsRepository.deleteById((Object)id);
        this.tbtskGroupRepository.deleteInFieldIds(Arrays.asList(id));
    }

    public TbtskFields saveField(TbtskFields field) {
        return (TbtskFields)this.tbtskFieldsRepository.save((Object)field);
    }

    public List<TbtskFields> sortTbtskFields(String id, String type) {
        TbtskFields one = this.tbtskFieldsRepository.findById((Object)id).orElse(null);
        switch (type) {
            case "up": {
                List before = this.tbtskFieldsRepository.findBefore(one.getfTableid(), one.getfOrder());
                if (before != null && before.size() > 0) {
                    TbtskFields beforeField = (TbtskFields)before.get(0);
                    beforeField.setfOrder(Integer.valueOf(beforeField.getfOrder() + 1));
                    one.setfOrder(Integer.valueOf(one.getfOrder() - 1));
                    this.tbtskFieldsRepository.save((Object)one);
                    this.tbtskFieldsRepository.save((Object)beforeField);
                    break;
                }
                throw new RuntimeException("\u8be5\u5b57\u6bb5\u5df2\u4f4d\u4e8e\u7b2c\u4e00\u884c");
            }
            case "down": {
                List before = this.tbtskFieldsRepository.findAfter(one.getfTableid(), one.getfOrder());
                if (before != null && before.size() > 0) {
                    TbtskFields afterField = (TbtskFields)before.get(0);
                    afterField.setfOrder(Integer.valueOf(afterField.getfOrder() - 1));
                    one.setfOrder(Integer.valueOf(one.getfOrder() + 1));
                    this.tbtskFieldsRepository.save((Object)one);
                    this.tbtskFieldsRepository.save((Object)afterField);
                    break;
                }
                throw new RuntimeException("\u8be5\u5b57\u6bb5\u5df2\u4f4d\u4e8e\u6700\u540e\u4e00\u884c");
            }
            case "bottom": {
                List after = this.tbtskFieldsRepository.findAfter(one.getfTableid(), one.getfOrder());
                if (after != null && after.size() > 0) {
                    TbtskFields bottom = (TbtskFields)after.get(after.size() - 1);
                    one.setfOrder(bottom.getfOrder());
                    bottom.setfOrder(Integer.valueOf(bottom.getfOrder() - 1));
                    this.tbtskFieldsRepository.save((Object)one);
                    this.tbtskFieldsRepository.save((Object)bottom);
                    break;
                }
                throw new RuntimeException("\u8be5\u5b57\u6bb5\u5df2\u4f4d\u4e8e\u6700\u540e\u4e00\u884c");
            }
            case "top": {
                List before = this.tbtskFieldsRepository.findBefore(one.getfTableid(), one.getfOrder());
                if (before != null && before.size() > 0) {
                    TbtskFields top = (TbtskFields)before.get(before.size() - 1);
                    top.setfOrder(Integer.valueOf(top.getfOrder() + 1));
                    one.setfOrder(top.getfOrder());
                    this.tbtskFieldsRepository.save((Object)one);
                    this.tbtskFieldsRepository.save((Object)top);
                    break;
                }
                throw new RuntimeException("\u8be5\u5b57\u6bb5\u5df2\u4f4d\u4e8e\u7b2c\u4e00\u884c");
            }
        }
        return this.getAllFieldsByTableID(one.getfTableid());
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAppConfigByTableId(AppConfigDTO appConfig, String tableId, String sysCode, Integer isApprove) {
        List fieldInOrder;
        FieldGroup group;
        List fieldInDetailMain;
        String regEx;
        TbtskGroup tbtskGroup;
        TbtskFields field;
        FieldDisPlay fieldDisPlay;
        int i2;
        List fields;
        FieldGroup group2;
        int j;
        List fieldInSearch;
        List fieldInFilter;
        TbtskObjectinfo table = this.tbtskObjectinfoRepository.getObjectByTableId(tableId);
        if (table != null) {
            this.tbtskObjectinfoRepository.updateTableVersion(Integer.valueOf(table.getfTableversion() == null ? 1 : table.getfTableversion() + 1), table.getfId());
        }
        this.tbtskGroupRepository.deleteByTbIdSys(tableId, sysCode);
        List fieldInList = appConfig.getFieldInList();
        ArrayList<Object> groupTotal = new ArrayList<Object>();
        String tableName = Optional.ofNullable(table.getfTablename()).orElse("");
        if (fieldInList.size() > 0) {
            IntStream.range(0, fieldInList.size()).forEach(i -> {
                TbtskFields field = this.tbtskFieldsRepository.findById(fieldInList.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode("100");
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(Integer.valueOf(i));
                if ("1".equalsIgnoreCase(field.getRuleReg())) {
                    group.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                    group.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                }
                groupTotal.add(group);
            });
        }
        if ((fieldInFilter = appConfig.getFieldInFilter()).size() > 0) {
            IntStream.range(0, fieldInFilter.size()).forEach(i -> {
                TbtskFields field = this.tbtskFieldsRepository.findById(fieldInFilter.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode("101");
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(Integer.valueOf(i));
                groupTotal.add(group);
            });
        }
        if ((fieldInSearch = appConfig.getFieldInSearch()).size() > 0) {
            IntStream.range(0, fieldInSearch.size()).forEach(i -> {
                TbtskFields field = this.tbtskFieldsRepository.findById(fieldInSearch.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode("102");
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(Integer.valueOf(i));
                groupTotal.add(group);
            });
        }
        if (appConfig.getFieldInQxAudit() != null) {
            for (j = 0; j < appConfig.getFieldInQxAudit().size(); ++j) {
                group2 = (FieldGroup)appConfig.getFieldGroup().get(j);
                fields = group2.getFields();
                for (i2 = 0; i2 < fields.size(); ++i2) {
                    fieldDisPlay = (FieldDisPlay)fields.get(i2);
                    field = this.tbtskFieldsRepository.findById((Object)fieldDisPlay.getFieldId()).orElse(null);
                    if (field.getfNullable() != null && field.getfNullable() == 0 && fieldDisPlay.getVisible() == 0) {
                        throw new GwValidateException(field.getfFieldname() + "\u5b57\u6bb5\u4fe1\u606f\u914d\u7f6e\u662f\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u914d\u7f6e\u4e3a\u4e0d\u663e\u793a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\uff01");
                    }
                    tbtskGroup = new TbtskGroup();
                    tbtskGroup.setfSyscode(sysCode);
                    tbtskGroup.setfTablename(tableName);
                    tbtskGroup.setfFieldname(field.getfFieldname());
                    tbtskGroup.setfFieldid(field.getfId());
                    tbtskGroup.setfAlias(field.getfAlias());
                    tbtskGroup.setfFieldorder(Integer.valueOf(i2));
                    tbtskGroup.setfGrouporder(Integer.valueOf(j));
                    tbtskGroup.setfGroupcode("301");
                    tbtskGroup.setfSubgroupname(group2.getTitle());
                    tbtskGroup.setfControltype(fieldDisPlay.getDisplayType());
                    tbtskGroup.setfTip(fieldDisPlay.getTips());
                    tbtskGroup.setfCode(fieldDisPlay.getEditAble());
                    tbtskGroup.setNotNull(fieldDisPlay.getNotNull());
                    tbtskGroup.setConnection(fieldDisPlay.getConnection());
                    tbtskGroup.setVisible(fieldDisPlay.getVisible());
                    tbtskGroup.setItemGroupName(fieldDisPlay.getItemGroupName());
                    tbtskGroup.setfRegexp(fieldDisPlay.getRuleReg());
                    regEx = "/[#\\\\$%\\\\^&\\\\*\u3010\u3011@!\uff01\uffe5?|\u2018\uff1b\uff1a\u201d\u201c\\'<>+=:]+/g";
                    if (sysCode.equals("web") && (field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2")) && (field.getfCodetableid() == null || field.getfCodetableid().equals(""))) {
                        tbtskGroup.setfRegexp(regEx);
                    }
                    if ("1".equalsIgnoreCase(field.getRuleReg())) {
                        tbtskGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                    } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                        tbtskGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                    }
                    groupTotal.add(tbtskGroup);
                }
            }
        }
        if (appConfig.getFieldInCityAudit() != null) {
            for (j = 0; j < appConfig.getFieldInCityAudit().size(); ++j) {
                group2 = (FieldGroup)appConfig.getFieldGroup().get(j);
                fields = group2.getFields();
                for (i2 = 0; i2 < fields.size(); ++i2) {
                    fieldDisPlay = (FieldDisPlay)fields.get(i2);
                    field = this.tbtskFieldsRepository.findById((Object)fieldDisPlay.getFieldId()).orElse(null);
                    if (field.getfNullable() != null && field.getfNullable() == 0 && fieldDisPlay.getVisible() == 0) {
                        throw new GwValidateException(field.getfFieldname() + "\u5b57\u6bb5\u4fe1\u606f\u914d\u7f6e\u662f\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u914d\u7f6e\u4e3a\u4e0d\u663e\u793a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\uff01");
                    }
                    tbtskGroup = new TbtskGroup();
                    tbtskGroup.setfSyscode(sysCode);
                    tbtskGroup.setfTablename(tableName);
                    tbtskGroup.setfFieldname(field.getfFieldname());
                    tbtskGroup.setfFieldid(field.getfId());
                    tbtskGroup.setfAlias(field.getfAlias());
                    tbtskGroup.setfFieldorder(Integer.valueOf(i2));
                    tbtskGroup.setfGrouporder(Integer.valueOf(j));
                    tbtskGroup.setfGroupcode("302");
                    tbtskGroup.setfSubgroupname(group2.getTitle());
                    tbtskGroup.setfControltype(fieldDisPlay.getDisplayType());
                    tbtskGroup.setfTip(fieldDisPlay.getTips());
                    tbtskGroup.setfCode(fieldDisPlay.getEditAble());
                    tbtskGroup.setNotNull(fieldDisPlay.getNotNull());
                    tbtskGroup.setConnection(fieldDisPlay.getConnection());
                    tbtskGroup.setVisible(fieldDisPlay.getVisible());
                    tbtskGroup.setItemGroupName(fieldDisPlay.getItemGroupName());
                    tbtskGroup.setfRegexp(fieldDisPlay.getRuleReg());
                    regEx = "/[#\\\\$%\\\\^&\\\\*\u3010\u3011@!\uff01\uffe5?|\u2018\uff1b\uff1a\u201d\u201c\\'<>+=:]+/g";
                    if (sysCode.equals("web") && (field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2")) && (field.getfCodetableid() == null || field.getfCodetableid().equals(""))) {
                        tbtskGroup.setfRegexp(regEx);
                    }
                    if ("1".equalsIgnoreCase(field.getRuleReg())) {
                        tbtskGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                    } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                        tbtskGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                    }
                    groupTotal.add(tbtskGroup);
                }
            }
        }
        if (appConfig.getFieldInSJAudit() != null) {
            for (j = 0; j < appConfig.getFieldInSJAudit().size(); ++j) {
                group2 = (FieldGroup)appConfig.getFieldGroup().get(j);
                fields = group2.getFields();
                for (i2 = 0; i2 < fields.size(); ++i2) {
                    fieldDisPlay = (FieldDisPlay)fields.get(i2);
                    field = this.tbtskFieldsRepository.findById((Object)fieldDisPlay.getFieldId()).orElse(null);
                    if (field.getfNullable() != null && field.getfNullable() == 0 && fieldDisPlay.getVisible() == 0) {
                        throw new GwValidateException(field.getfFieldname() + "\u5b57\u6bb5\u4fe1\u606f\u914d\u7f6e\u662f\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u914d\u7f6e\u4e3a\u4e0d\u663e\u793a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\uff01");
                    }
                    tbtskGroup = new TbtskGroup();
                    tbtskGroup.setfSyscode(sysCode);
                    tbtskGroup.setfTablename(tableName);
                    tbtskGroup.setfFieldname(field.getfFieldname());
                    tbtskGroup.setfFieldid(field.getfId());
                    tbtskGroup.setfAlias(field.getfAlias());
                    tbtskGroup.setfFieldorder(Integer.valueOf(i2));
                    tbtskGroup.setfGrouporder(Integer.valueOf(j));
                    tbtskGroup.setfGroupcode("303");
                    tbtskGroup.setfSubgroupname(group2.getTitle());
                    tbtskGroup.setfControltype(fieldDisPlay.getDisplayType());
                    tbtskGroup.setfTip(fieldDisPlay.getTips());
                    tbtskGroup.setfCode(fieldDisPlay.getEditAble());
                    tbtskGroup.setNotNull(fieldDisPlay.getNotNull());
                    tbtskGroup.setConnection(fieldDisPlay.getConnection());
                    tbtskGroup.setVisible(fieldDisPlay.getVisible());
                    tbtskGroup.setItemGroupName(fieldDisPlay.getItemGroupName());
                    tbtskGroup.setfRegexp(fieldDisPlay.getRuleReg());
                    regEx = "/[#\\\\$%\\\\^&\\\\*\u3010\u3011@!\uff01\uffe5?|\u2018\uff1b\uff1a\u201d\u201c\\'<>+=:]+/g";
                    if (sysCode.equals("web") && (field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2")) && (field.getfCodetableid() == null || field.getfCodetableid().equals(""))) {
                        tbtskGroup.setfRegexp(regEx);
                    }
                    if ("1".equalsIgnoreCase(field.getRuleReg())) {
                        tbtskGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                    } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                        tbtskGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                    }
                    groupTotal.add(tbtskGroup);
                }
            }
        }
        if ((fieldInDetailMain = appConfig.getFieldInDetailMain()) != null && fieldInDetailMain.size() > 0) {
            IntStream.range(0, fieldInDetailMain.size()).forEach(i -> {
                TbtskFields field = this.tbtskFieldsRepository.findById(fieldInDetailMain.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode("103");
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(Integer.valueOf(i));
                groupTotal.add(group);
            });
        }
        this.tbtskGroupRepository.deleteByTbnameGroupSys(StringUtils.isNotBlank((CharSequence)tableName) ? tableName : tableId, "104", sysCode);
        List fieldInSysFilter = appConfig.getFieldInSysFilter();
        if (fieldInSysFilter != null && fieldInSysFilter.size() > 0) {
            fieldInSysFilter = fieldInSysFilter.stream().distinct().collect(Collectors.toList());
            for (int i3 = 0; i3 < fieldInSysFilter.size(); ++i3) {
                TbtskSysFields field2 = this.tbtskSysFieldsRepository.findById(fieldInSysFilter.get(i3)).orElse(null);
                if (isApprove == 0 && field2.getfAlias().contains("\u5ba1\u6838")) continue;
                group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode("104");
                group.setfTablename(tableName);
                group.setfFieldname(field2.getfFieldname());
                group.setfFieldid(field2.getfId());
                group.setfFieldtype(field2.getfFieldtype());
                group.setfAlias(field2.getfAlias());
                group.setfFieldorder(Integer.valueOf(i3));
                groupTotal.add(group);
            }
        }
        if ((fieldInOrder = appConfig.getFieldInOrder()) != null && fieldInOrder.size() > 0) {
            IntStream.range(0, fieldInOrder.size()).forEach(i -> {
                TbtskFields field = this.tbtskFieldsRepository.findById(fieldInOrder.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode("105");
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(Integer.valueOf(i));
                groupTotal.add(group);
            });
        }
        for (int j2 = 0; j2 < appConfig.getFieldGroup().size(); ++j2) {
            group = (FieldGroup)appConfig.getFieldGroup().get(j2);
            List fields2 = group.getFields();
            for (int i4 = 0; i4 < fields2.size(); ++i4) {
                FieldDisPlay fieldDisPlay2 = (FieldDisPlay)fields2.get(i4);
                TbtskFields field3 = this.tbtskFieldsRepository.findById((Object)fieldDisPlay2.getFieldId()).orElse(null);
                if (field3.getfNullable() != null && field3.getfNullable() == 0 && fieldDisPlay2.getVisible() == 0) {
                    throw new GwValidateException(field3.getfFieldname() + "\u5b57\u6bb5\u4fe1\u606f\u914d\u7f6e\u662f\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u914d\u7f6e\u4e3a\u4e0d\u663e\u793a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\uff01");
                }
                TbtskGroup tbtskGroup2 = new TbtskGroup();
                tbtskGroup2.setfSyscode(sysCode);
                tbtskGroup2.setfTablename(tableName);
                tbtskGroup2.setfFieldname(field3.getfFieldname());
                tbtskGroup2.setfFieldid(field3.getfId());
                tbtskGroup2.setfAlias(field3.getfAlias());
                tbtskGroup2.setfFieldorder(Integer.valueOf(i4));
                tbtskGroup2.setfGrouporder(Integer.valueOf(j2));
                tbtskGroup2.setfGroupcode("202");
                tbtskGroup2.setfSubgroupname(group.getTitle());
                tbtskGroup2.setfControltype(fieldDisPlay2.getDisplayType());
                tbtskGroup2.setfTip(fieldDisPlay2.getTips());
                tbtskGroup2.setfCode(fieldDisPlay2.getEditAble());
                tbtskGroup2.setNotNull(fieldDisPlay2.getNotNull());
                tbtskGroup2.setConnection(fieldDisPlay2.getConnection());
                tbtskGroup2.setVisible(fieldDisPlay2.getVisible());
                tbtskGroup2.setItemGroupName(fieldDisPlay2.getItemGroupName());
                tbtskGroup2.setfRegexp(fieldDisPlay2.getRuleReg());
                String regEx2 = "/[#\\\\$%\\\\^&\\\\*\u3010\u3011@!\uff01\uffe5?|\u2018\uff1b\uff1a\u201d\u201c\\'<>+=:]+/g";
                if (sysCode.equals("web") && (field3.getfFieldtype().equals("1") || field3.getfFieldtype().equals("2")) && (field3.getfCodetableid() == null || field3.getfCodetableid().equals(""))) {
                    tbtskGroup2.setfRegexp(regEx2);
                }
                if ("1".equalsIgnoreCase(field3.getRuleReg())) {
                    tbtskGroup2.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                } else if ("2".equalsIgnoreCase(field3.getRuleReg())) {
                    tbtskGroup2.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                }
                groupTotal.add(tbtskGroup2);
            }
            this.tbtskGroupRepository.deleteBySysAndTablename(tableName, sysCode, "202");
            if (group.getButton() == null) continue;
            TbtskGroup tbtskGroup3 = new TbtskGroup();
            tbtskGroup3.setfSyscode(sysCode);
            tbtskGroup3.setfTablename(tableName);
            tbtskGroup3.setfFieldname(group.getButton());
            tbtskGroup3.setfGroupcode("202");
            tbtskGroup3.setfSubgroupname(group.getTitle());
            groupTotal.add(tbtskGroup3);
        }
        this.tbtskGroupRepository.saveAll(groupTotal);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAppConfigByTemplate(AppConfigDTO appConfig, String sysCode) {
        TbtskTemplate taskTemplate = this.tbtskTemplateDao.findById((Object)appConfig.getBizId()).orElse(null);
        this.saveAppConfigByTableId(appConfig, taskTemplate.getTableId(), sysCode, 1);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAppConfigByTaskId(AppConfigDTO appConfig, String sysCode) {
        GutilAssert.hasLength((String)appConfig.getBizId(), (String)"\u4e0d\u80fd\u4e3a\u7a7a");
        TskTaskBiz one = this.tskTaskBizRepository.findById((Object)appConfig.getBizId()).orElse(null);
        GutilAssert.isTrue((one != null ? 1 : 0) != 0, (String)"\u4efb\u52a1\u67e5\u627e\u5931\u8d25");
        if (StringUtils.isBlank((CharSequence)appConfig.getTableId())) {
            appConfig.setTableId(one.getTableId());
        }
        if (StringUtils.isNotBlank((CharSequence)one.getStructDbUrl())) {
            one.setStructDbUrl(null);
            this.tskTaskBizRepository.save((Object)one);
        }
        this.saveAppConfigByTableId(appConfig, appConfig.getTableId(), sysCode, one.getIsApprove() == null ? 0 : one.getIsApprove());
    }

    public AppConfigDTO findGroupFieldByTaskIdAndSysCode(String taskId, String sys, String tableId) {
        GutilAssert.hasLength((String)taskId, (String)"\u4e0d\u80fd\u4e3a\u7a7a");
        String tableName = "";
        if (StringUtils.isNotBlank((CharSequence)tableId)) {
            TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.findById((Object)tableId).orElse(null);
            GutilAssert.isTrue((tbtskObjectinfo != null ? 1 : 0) != 0, (String)"\u4efb\u52a1\u67e5\u627e\u5931\u8d25");
            tableName = tbtskObjectinfo.getfTablename();
        } else {
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
            TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.findById((Object)tskTaskBiz.getTableId()).orElse(null);
            GutilAssert.isTrue((tbtskObjectinfo != null ? 1 : 0) != 0, (String)"\u4efb\u52a1\u67e5\u627e\u5931\u8d25");
            tableId = tskTaskBiz.getTableId();
            tableName = tbtskObjectinfo.getfTablename();
        }
        AppConfigDTO appconfigDTO = this.getAppconfigDTO(tableId, StringUtils.isNotBlank((CharSequence)tableName) ? tableName : tableId, sys);
        appconfigDTO.setBizId(taskId);
        return appconfigDTO;
    }

    public AppConfigDTO findGroupFieldBySysCode(String templateId, String sys) {
        TbtskTemplate template = this.tbtskTemplateDao.findById((Object)templateId).orElse(null);
        String tableId = template.getTableId();
        AppConfigDTO appconfigDTO = this.getAppconfigDTO(tableId, tableId, sys);
        appconfigDTO.setBizId(templateId);
        return appconfigDTO;
    }

    private AppConfigDTO getAppconfigDTO(String tableId, String tableName, String sys) {
        List detailGroupAuditFields;
        GutilAssert.hasLength((String)tableId, (String)"\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        GutilAssert.hasLength((String)sys, (String)"sys\u4e0d\u80fd\u4e3a\u7a7a");
        List listGroup = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, "100");
        List filterGroup = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, "101");
        List searchGroup = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, "102");
        List fieldInQxAudit = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, "301");
        List fieldInCityAudit = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, "302");
        List fieldInSjAudit = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, "202");
        List detailGroup = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, "202");
        List detailMainGroup = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, "103");
        List fieldInSysFilter = this.tbtskGroupRepository.selectSysByTableNameAndGroupcode(sys, tableName, "104");
        List fieldInOrder = this.tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableName, "105");
        AppConfigDTO appConfigDTO = new AppConfigDTO();
        appConfigDTO.setFieldInList(listGroup.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInFilter(filterGroup.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInSearch(searchGroup.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInDetailMain(detailMainGroup.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInSysFilter(fieldInSysFilter.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInOrder(fieldInOrder.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        ArrayList fieldGroupsQx = new ArrayList();
        HashMap mapQx = new HashMap();
        fieldInQxAudit.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!mapQx.containsKey(title)) {
                ArrayList fields = new ArrayList();
                mapQx.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroupsQx.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getConnection());
            field.setVisible(group.getVisible());
            field.setItemGroupName(group.getItemGroupName());
            ((List)mapQx.get(title)).add(field);
        });
        for (FieldGroup fieldGroup : fieldGroupsQx) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields((List)mapQx.get(key));
        }
        appConfigDTO.setFieldInQxAudit(fieldGroupsQx);
        ArrayList fieldGroupsCity = new ArrayList();
        HashMap mapCity = new HashMap();
        fieldInCityAudit.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!mapCity.containsKey(title)) {
                ArrayList fields = new ArrayList();
                mapCity.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroupsCity.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getConnection());
            field.setVisible(group.getVisible());
            field.setItemGroupName(group.getItemGroupName());
            ((List)mapCity.get(title)).add(field);
        });
        for (FieldGroup fieldGroup : fieldGroupsCity) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields((List)mapCity.get(key));
        }
        appConfigDTO.setFieldInCityAudit(fieldGroupsCity);
        ArrayList fieldGroupsSJ = new ArrayList();
        HashMap mapSJ = new HashMap();
        fieldInSjAudit.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!mapSJ.containsKey(title)) {
                ArrayList fields = new ArrayList();
                mapSJ.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroupsSJ.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getConnection());
            field.setVisible(group.getVisible());
            field.setItemGroupName(group.getItemGroupName());
            ((List)mapSJ.get(title)).add(field);
        });
        for (FieldGroup fieldGroup : fieldGroupsSJ) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields((List)mapSJ.get(key));
        }
        appConfigDTO.setFieldInSJAudit(fieldGroupsSJ);
        ArrayList fieldGroups = new ArrayList();
        HashMap map = new HashMap();
        HashMap btnMap = new HashMap();
        detailGroup.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!map.containsKey(title)) {
                ArrayList fields = new ArrayList();
                map.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroups.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getConnection());
            field.setVisible(group.getVisible());
            field.setItemGroupName(group.getItemGroupName());
            ((List)map.get(title)).add(field);
        });
        if (detailGroup.size() > 0 && (detailGroupAuditFields = this.tbtskGroupRepository.selectAuditFields(sys, ((TbtskGroup)detailGroup.get(0)).getfTablename(), "202")).size() > 0) {
            detailGroupAuditFields.stream().filter(r -> r.getfFieldid() == null).forEach(button -> btnMap.put(button.getfSubgroupname(), button.getfFieldname()));
        }
        for (FieldGroup fieldGroup : fieldGroups) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields((List)map.get(key));
            if (!btnMap.containsKey(key)) continue;
            fieldGroup.setButton((String)btnMap.get(key));
        }
        appConfigDTO.setFieldGroup(fieldGroups);
        return appConfigDTO;
    }

    public List<TbtskFields> getNyFields(String bizId) {
        return null;
    }

    public List<TbtskFieldGroupView> getTaskFieldsMateWeb(String taskId, String tableId, String groupCode) {
        if (StringUtils.isBlank((CharSequence)tableId)) {
            TskTaskBiz task = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
            tableId = task.getTableId();
        }
        return this.tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(tableId, "web", groupCode);
    }

    public List<TbtskFieldGroupView> getTaskFieldsMateWebByTableId(String tableId, String groupCode) {
        return this.tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(tableId, "web", groupCode);
    }

    public List<TbtskGroup> selectSysByTableNameAndGroupcode(String taskId, String tableId, String groupCode) {
        String tableName = "";
        if (StringUtils.isNotBlank((CharSequence)tableId)) {
            TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.findById((Object)tableId).orElse(null);
            tableName = tbtskObjectinfo.getfTablename();
        } else {
            TskTaskBiz task = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
            TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.findById((Object)task.getTableId()).orElse(null);
            tableId = tbtskObjectinfo.getfId();
            tableName = tbtskObjectinfo.getfTablename();
        }
        return this.tbtskGroupRepository.selectSysByTableNameAndGroupcode("web", StringUtils.isNotBlank((CharSequence)tableName) ? tableName : tableId, groupCode);
    }

    public List<TbtskGroup> selectSysByTableIdAndGroupcode(String tableId, String groupCode) {
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.findById((Object)tableId).orElse(null);
        String tableName = tbtskObjectinfo.getfTablename();
        return this.tbtskGroupRepository.selectSysByTableNameAndGroupcode("web", StringUtils.isNotBlank((CharSequence)tableName) ? tableName : tableId, groupCode);
    }
}

