/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.mapper.task.TbtskRejectDefMapper;
import com.geoway.landteam.customtask.mapper.task.TbtskTaskBizFlowMapper;
import com.geoway.landteam.customtask.pub.dto.ApproveRecordDTO;
import com.geoway.landteam.customtask.pub.dto.FlowDefInfoDTO;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskApproveRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFlowDefRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskRejectRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskSubmitReportRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.task.TbtskTaskBizFlowService;
import com.geoway.landteam.customtask.task.enm.FlowTypeEnum;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.customtask.task.entity.TbtskApproveRecord;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskFlowDef;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskRejectDef;
import com.geoway.landteam.customtask.task.entity.TbtskRejectRecord;
import com.geoway.landteam.customtask.task.entity.TbtskRevokeRecord;
import com.geoway.landteam.customtask.task.entity.TbtskSubmitReportRecord;
import com.geoway.landteam.customtask.task.entity.TbtskTaskBiz;
import com.geoway.landteam.customtask.task.entity.TbtskTaskBizFlow;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.TaskBasicRelation;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.TaskBasicRelationRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.SystemConfigCacheService;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskRejectDefService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskRevokeRecordService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserAuditAreaService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserReviewAreaService;
import com.geoway.landteam.landcloud.service.customtask.task.MConfigTaskReviewService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskNoticeService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.javatuples.Triplet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MTbtskFlowService {
    private static final GiLoger log = GwLoger.getLoger();
    private static final int BATCH_COMMIT_COUNT = 100;
    private static final String TABLE_NAME_LZGD_FW = "tb_app_task_lzgd_zd";
    private static final String TABLE_NAME_LZGD_TB = "tb_app_task_lzgd_prj";
    public static final String TASK_ID_LZGD = "gxlzgd";
    public static final String TYPE_TB = "TB";
    public static final String TYPE_FW = "FW";
    private final ReviewStageEnum[] AuditStageArray = new ReviewStageEnum[]{ReviewStageEnum.VILLAGE_VERIFY, ReviewStageEnum.TOWN_VERIFY, ReviewStageEnum.COUNTY_VERIFY, ReviewStageEnum.CITY_VERIFY, ReviewStageEnum.PROVINCE_VERIFY, ReviewStageEnum.COUNTRY_VERIFY, ReviewStageEnum.OVER_VERIFY};
    private final ReviewStageEnum[] AuditReviewStageArray = new ReviewStageEnum[]{ReviewStageEnum.VILLAGE_VERIFY, ReviewStageEnum.VILLAGE_VERIFY, ReviewStageEnum.TOWN_VERIFY, ReviewStageEnum.TOWN_VERIFY, ReviewStageEnum.COUNTY_VERIFY, ReviewStageEnum.COUNTY_VERIFY, ReviewStageEnum.CITY_VERIFY, ReviewStageEnum.CITY_VERIFY, ReviewStageEnum.PROVINCE_VERIFY, ReviewStageEnum.PROVINCE_VERIFY, ReviewStageEnum.COUNTRY_VERIFY, ReviewStageEnum.COUNTRY_VERIFY, ReviewStageEnum.OVER_VERIFY};
    @Autowired
    SystemConfigCacheService systemConfigCacheService;
    @Autowired
    TbtskFlowDefRepository tbtskFlowDefRepository;
    @Autowired
    TbtskTaskBizFlowService tbtskTaskBizFlowService;
    @Autowired
    TbtskTaskBizFlowMapper tbtskTaskBizFlowMapper;
    @Autowired
    TbtskRejectDefMapper tbtskRejectDefMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Autowired
    TbtskSubmitReportRecordRepository tbtskSubmitReportRecordRepository;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;
    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TaskBasicRelationRepository taskBasicRelationRepository;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    TbtskRejectRecordRepository tbtskRejectRecordRepository;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    MTaskNoticeService mTaskNoticeService;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    MTbtskRejectDefService mTbtskRejectDefService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    MTaskRecordService mTaskRecordService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    MTbtskUserReviewAreaService tbtskUserReviewAreaService;
    @Autowired
    MTbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    MTbtskRevokeRecordService tbtskRevokeRecordService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    MConfigTaskReviewService mConfigTaskReviewService;

    public List<TbtskFlowDef> findFlow(String taskId, Integer type) {
        return this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, type);
    }

    public List<FlowStep> findFlowSteps(String taskId, FlowTypeEnum flowType) {
        List flows = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, Integer.valueOf(flowType.getCode()));
        if (flows == null || flows.size() == 0) {
            return null;
        }
        Gson gson = new Gson();
        List steps = (List)gson.fromJson(((TbtskFlowDef)flows.get(0)).getSteps(), new TypeToken<List<FlowStep>>(){}.getType());
        return steps;
    }

    public FlowStep getFlowStep(TbtskFlowDef tbtskFlowDef, String name, boolean returnFirstStepIfNX) {
        JSONArray steps = JSONArray.parseArray((String)tbtskFlowDef.getSteps(), (Feature[])new Feature[0]);
        for (int i = 0; i < steps.size(); ++i) {
            FlowStep flowStep = (FlowStep)new Gson().fromJson(String.valueOf(steps.getJSONObject(i)), FlowStep.class);
            if (!flowStep.getName().equals(name)) continue;
            return flowStep;
        }
        if (returnFirstStepIfNX) {
            if (steps != null && steps.size() > 0) {
                return (FlowStep)new Gson().fromJson(String.valueOf(steps.getJSONObject(0)), FlowStep.class);
            }
            return null;
        }
        return null;
    }

    public FlowStep findFlow(String taskId, Integer type, Integer step) {
        List flows = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, type);
        if (flows == null || flows.size() == 0) {
            return null;
        }
        JSONArray steps = JSONArray.parseArray((String)((TbtskFlowDef)flows.get(0)).getSteps(), (Feature[])new Feature[0]);
        FlowStep flowStep = (FlowStep)new Gson().fromJson(String.valueOf(steps.getJSONObject(step.intValue())), FlowStep.class);
        flowStep.setContainReview(Boolean.valueOf(((TbtskFlowDef)flows.get(0)).getContainsReview().equals(1)));
        return flowStep;
    }

    public String operatorSubmit(String taskId, String tbIds, String type, Long userId) {
        String result = "\u63d0\u62a5\u6210\u529f";
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)tbIds), (String)"tbIds \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        result = this.mConfigTaskReviewService.operatorSubmit(taskId, tbIds, type, userId);
        return result;
    }

    public String operatorSubmitFwByFilter(String taskId, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt, String tbzt, String xmhj, String shfh, String sfdh, Date startTime, Date endTime, Long userId, String ywzp) throws Exception {
        String result = "\u63d0\u62a5\u6210\u529f";
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        GutilAssert.state((StringUtils.isNoneBlank((CharSequence)xzqdm) && xzqdm.length() >= 6 && xzqdm.length() <= 12 ? 1 : 0) != 0, (String)"regionCode \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u957f\u5ea66-12\u4f4d.");
        result = "\u63d0\u62a5\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u914d\u7f6e\u4efb\u52a1\u4e1a\u52a1\u7c7b\u578b";
        return result;
    }

    public String submitByConditionFilter(String taskId, Long userId, TaskQueryParameter taskQueryParameter) throws Exception {
        String result = "\u63d0\u62a5\u6210\u529f";
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"conditionFilter");
        params.put("userId", (Object)userId);
        params.put("taskQueryParameter", (Object)taskQueryParameter);
        this.addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_SUBMIT_BATCH, taskId);
        return result;
    }

    public void addTaskRecord(JSONObject params, Long userId, Integer taskType, String bizId) {
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(taskType);
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        record.setBizId(bizId);
        this.mTaskRecordService.save(record);
    }

    public String statusUpdateFwByFilter(String taskId, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt, String tbzt, String xmhj, String shfh, String sfdh, Date startTime, Date endTime, Long userId, String ywzp) throws Exception {
        String result = "";
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        result = "\u72b6\u6001\u5237\u65b0\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u914d\u7f6e\u4efb\u52a1\u4e1a\u52a1\u7c7b\u578b";
        return result;
    }

    private JSONObject getJsonObject(List<String> idList) {
        JSONObject jsonObject = new JSONObject();
        if (!GutilCollection.isEmpty(idList)) {
            jsonObject.put("total", (Object)idList.size());
            jsonObject.put("idList", (Object)StringUtils.join(idList, (CharSequence)","));
        } else {
            jsonObject.put("total", (Object)0);
            jsonObject.put("idList", (Object)"");
        }
        return jsonObject;
    }

    public String queryCountOfNotSubmitByFilter(String taskId, TaskQueryParameter taskQueryParameter) throws Exception {
        String result = "\u67e5\u8be2\u5b8c\u6210,\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u56fe\u6591\u6570\u636e\u6216\u672a\u4e0b\u53d1\u7ed9\u5f53\u524d\u7528\u6237";
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        List<Map> dataList = this.getConfigTaskDataList(taskQueryParameter);
        if (dataList.size() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            for (Map data : dataList) {
                if (data.get("f_status") != null && Integer.parseInt(data.get("f_status").toString()) >= TbStatusEnum.SUBMIT.getCode()) continue;
                idList.add(StringUtils.isNotBlank((CharSequence)data.get("f_tbbh").toString()) ? data.get("f_tbbh").toString() : "");
            }
            JSONObject jsonObject = this.getJsonObject(idList);
            result = jsonObject.toString();
        } else {
            result = "\u67e5\u8be2\u5b8c\u6210,\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u56fe\u6591\u6570\u636e\u6216\u672a\u4e0b\u53d1\u7ed9\u5f53\u524d\u7528\u6237";
        }
        return result;
    }

    public String queryCountOfNotSubmitByIds(String taskId, String tbIds, Long userId) throws Exception {
        String result = "\u67e5\u8be2\u5b8c\u6210,\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u56fe\u6591\u6570\u636e\u6216\u672a\u4e0b\u53d1\u7ed9\u5f53\u524d\u7528\u6237";
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)tbIds), (String)"tbIds \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        List<String> idList = Arrays.asList(tbIds.split(","));
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        if (null == tskTaskBiz) {
            throw new RuntimeException("\u63d0\u62a5\u5931\u8d25\uff0c\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            throw new RuntimeException("\u63d0\u62a5\u5931\u8d25\uff0c\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        List<String> fieldNameList = this.getAuditFieldNameCollection();
        fieldNameList.add("f_tbbh");
        List<Map> dataList = this.mDataBizService.selectFieldByIds(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", idList);
        if (dataList.size() > 0) {
            ArrayList<String> idLists = new ArrayList<String>();
            for (Map data : dataList) {
                if (data.get("f_status") != null && Integer.parseInt(data.get("f_status").toString()) >= TbStatusEnum.SUBMIT.getCode()) continue;
                idLists.add(StringUtils.isNotBlank((CharSequence)data.get("f_tbbh").toString()) ? data.get("f_tbbh").toString() : "");
            }
            JSONObject jsonObject = this.getJsonObject(idLists);
            result = jsonObject.toString();
        } else {
            result = "\u67e5\u8be2\u5b8c\u6210,\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u56fe\u6591\u6570\u636e\u6216\u672a\u4e0b\u53d1\u7ed9\u5f53\u524d\u7528\u6237";
        }
        return result;
    }

    public String exportSubmitData(Long userId, List<Map<String, Object>> resultData) {
        String resultUrl = "";
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = UUID.randomUUID().toString() + ".xls";
            ArrayList headers = new ArrayList();
            ArrayList<KeyValuePair> headersOne = new ArrayList<KeyValuePair>();
            headersOne.add(KeyValuePair.newBuilder().setKey("totalNum").setValue("\u603b\u6570").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("successNum").setValue("\u63d0\u62a5\u6210\u529f\u603b\u6570").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("failNum").setValue("\u63d0\u62a5\u5931\u8d25\u603b\u6570").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("fwbh").setValue(resultData.get(0).get("uniqueFieldName").toString()).build());
            headersOne.add(KeyValuePair.newBuilder().setKey("result").setValue("\u63d0\u62a5\u7ed3\u679c").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("userId").setValue("\u63d0\u62a5\u4eba").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("uploadDate").setValue("\u63d0\u62a5\u65f6\u95f4").build());
            List fieldNamesOne = headersOne.stream().map(KeyValuePair::getKey).collect(Collectors.toList());
            List fieldAliasOne = headersOne.stream().map(KeyValuePair::getValue).collect(Collectors.toList());
            List<Map<String, Object>> resultDataOne = this.resultDataConversion(resultData, userId);
            String excelPath = null;
            excelPath = ExcelUtil.CreateExcel(resultDataOne, (String)tempDir, (String)fileName, (String)String.join((CharSequence)",", fieldNamesOne), (String)String.join((CharSequence)",", fieldAliasOne), (String)"\u6279\u91cf\u63d0\u62a5\u7ed3\u679c");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = sdf.format(new Date());
            String obsFilePath = "submitTaskData/" + userId + "/" + dateString + "/" + fileName.replace(".xls", "_\u63d0\u62a5\u4fe1\u606f\u7ed3\u679c.xls");
            resultUrl = this.defaultOssOperatorService.sendObject2Oss(obsFilePath, excelPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultUrl;
    }

    private List<Map<String, Object>> resultDataConversion(List<Map<String, Object>> resultData, Long userId) {
        ArrayList<Map<String, Object>> resultDataOne = new ArrayList<Map<String, Object>>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = sdf.format(new Date());
        for (int i = 0; i < resultData.size(); ++i) {
            Map<String, Object> oldMap = resultData.get(i);
            HashMap<String, Object> tmpMap = new HashMap<String, Object>();
            if (resultDataOne.size() > 0) {
                boolean isContain = false;
                for (int j = 0; j < resultDataOne.size(); ++j) {
                    Map newMap = (Map)resultDataOne.get(j);
                    if (!newMap.get("result").equals(oldMap.get("result")) || !"\u63d0\u62a5\u6210\u529f".equals(newMap.get("result"))) continue;
                    ((Map)resultDataOne.get(j)).put("totalNum", Integer.parseInt(newMap.get("totalNum").toString()) + 1);
                    ((Map)resultDataOne.get(j)).put("successNum", oldMap.get("result").toString().contains("\u6210\u529f") ? Integer.parseInt(newMap.get("successNum").toString()) + 1 : Integer.parseInt(newMap.get("successNum").toString()) + 0);
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                tmpMap.put("totalNum", 1);
                tmpMap.put("successNum", oldMap.get("result").toString().contains("\u6210\u529f") ? 1 : 0);
                tmpMap.put("failNum", oldMap.get("result").toString().contains("\u5931\u8d25") ? 1 : 0);
                tmpMap.put("fwbh", oldMap.get("result").toString().contains("\u5931\u8d25") ? oldMap.get("fwbh").toString() : "");
                tmpMap.put("result", oldMap.get("result").toString());
                tmpMap.put("userId", userId);
                tmpMap.put("uploadDate", dateString);
                resultDataOne.add(tmpMap);
                continue;
            }
            tmpMap.put("totalNum", 1);
            tmpMap.put("successNum", oldMap.get("result").toString().contains("\u6210\u529f") ? 1 : 0);
            tmpMap.put("failNum", oldMap.get("result").toString().contains("\u5931\u8d25") ? 1 : 0);
            tmpMap.put("fwbh", oldMap.get("result").toString().contains("\u5931\u8d25") ? oldMap.get("fwbh").toString() : "");
            tmpMap.put("result", oldMap.get("result").toString());
            tmpMap.put("userId", userId);
            tmpMap.put("uploadDate", dateString);
            resultDataOne.add(tmpMap);
        }
        return resultDataOne;
    }

    private TbtskSubmitReportRecord saveSubmitReportRecord(String taskId, String id, String xzqdm, Integer rejectCount, Long userId) {
        TbtskSubmitReportRecord submitReportRecord = new TbtskSubmitReportRecord();
        submitReportRecord.setTaskid(taskId);
        submitReportRecord.setDataid(id);
        submitReportRecord.setSubmitTime(new Date());
        submitReportRecord.setSubmitUserid(userId);
        submitReportRecord.setXzqdm(xzqdm);
        submitReportRecord.setRejectCount(Integer.valueOf(rejectCount != null ? rejectCount : 0));
        return submitReportRecord;
    }

    public List<ApproveRecordDTO> findApproveRecordBySC(String basicId) {
        List<ApproveRecordDTO> resultList = new ArrayList<ApproveRecordDTO>();
        TaskBasicRelation taskBasicRelation = this.taskBasicRelationRepository.queryByBasicId(basicId);
        if (taskBasicRelation != null) {
            resultList = this.getApproveRecordsAndRejectRecords(taskBasicRelation.getBizId(), taskBasicRelation.getDataId());
        }
        if (!GutilCollection.isEmpty(resultList)) {
            Collections.sort(resultList, new Comparator<ApproveRecordDTO>(){

                @Override
                public int compare(ApproveRecordDTO o1, ApproveRecordDTO o2) {
                    int flag = o2.getApproveTime().compareTo(o1.getApproveTime());
                    return flag;
                }
            });
        }
        return resultList;
    }

    public List<Map<String, Object>> findApproveRecordBySCBasicIds(String basicIds) {
        String[] basiclist;
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (String basicId : basiclist = basicIds.split(",")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("basicId", basicId);
            List<ApproveRecordDTO> temp = this.findApproveRecordBySC(basicId);
            if (!temp.isEmpty()) {
                TbtskTaskBizFlow tbtskTaskBizFlow = this.tbtskTaskBizFlowService.selectByTaskId(temp.get(0).getTaskid());
                TbtskFlowDef flowDef = this.tbtskFlowDefRepository.findById((Object)tbtskTaskBizFlow.getFlowId()).orElse(null);
                if (flowDef.getStepcount().equals(temp.get(0).getNextstep())) {
                    temp.get(0).setStepindex(flowDef.getStepcount());
                }
                map.put("record", (String)temp.get(0));
            } else {
                ApproveRecordDTO approveRecordDTO = new ApproveRecordDTO();
                approveRecordDTO.setStepindex(Integer.valueOf(-1));
                map.put("record", (String)approveRecordDTO);
            }
            mapList.add(map);
        }
        return mapList;
    }

    public List<ApproveRecordDTO> findApproveRecord(String taskId, String tbId, String type, Long UserId, Integer userRole) {
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        ArrayList<ApproveRecordDTO> resultList = new ArrayList();
        resultList = this.mConfigTaskReviewService.findApproveRecord(taskId, tbId, type, UserId, userRole);
        if (!GutilCollection.isEmpty(resultList)) {
            Collections.sort(resultList, new Comparator<ApproveRecordDTO>(){

                @Override
                public int compare(ApproveRecordDTO o1, ApproveRecordDTO o2) {
                    int flag = o2.getApproveTime().compareTo(o1.getApproveTime());
                    return flag;
                }
            });
        }
        return resultList;
    }

    private List<ApproveRecordDTO> getRejectRecords(String taskId, String tbId) {
        ArrayList<ApproveRecordDTO> resultList = new ArrayList<ApproveRecordDTO>();
        List rejectRecords = this.tbtskRejectRecordRepository.findByTaskIdAndTbId(taskId, tbId);
        if (!GutilCollection.isEmpty((Collection)rejectRecords)) {
            for (TbtskRejectRecord rejectRecord : rejectRecords) {
                if (!rejectRecord.getTargetStage().equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) continue;
                ApproveRecordDTO approveRecord = this.convertRejectRecord2ApproveRecord(rejectRecord);
                resultList.add(approveRecord);
            }
        }
        return resultList;
    }

    private List<ApproveRecordDTO> getApproveRecordsAndRejectRecords(String taskId, String tbId) {
        List revokeRecords;
        List rejectRecords;
        ArrayList<ApproveRecordDTO> resultList = new ArrayList<ApproveRecordDTO>();
        List approveRecords = this.tbtskApproveRecordRepository.findApproveRecordOrderByTime(taskId, tbId);
        if (!GutilCollection.isEmpty((Collection)approveRecords)) {
            for (Object tbtskApproveRecord : approveRecords) {
                ApproveRecordDTO approveRecord = this.convertApproveRecord2ApproveRecordDTO((TbtskApproveRecord)tbtskApproveRecord);
                resultList.add(approveRecord);
            }
        }
        if (!GutilCollection.isEmpty((Collection)(rejectRecords = this.tbtskRejectRecordRepository.findByTaskIdAndTbId(taskId, tbId)))) {
            for (TbtskRejectRecord rejectRecord : rejectRecords) {
                ApproveRecordDTO approveRecord = this.convertRejectRecord2ApproveRecord(rejectRecord);
                resultList.add(approveRecord);
            }
        }
        if (!GutilCollection.isEmpty((Collection)(revokeRecords = this.tbtskRevokeRecordService.selectByTaskIdAndTbId(taskId, tbId)))) {
            for (TbtskRevokeRecord revokeRecord : revokeRecords) {
                ApproveRecordDTO approveRecord = this.convertRevokeRecord2ApproveRecord(revokeRecord);
                resultList.add(approveRecord);
            }
        }
        return resultList;
    }

    private ApproveRecordDTO convertApproveRecord2ApproveRecordDTO(TbtskApproveRecord approveRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(approveRecord.getStatus());
        dto.setOption(approveRecord.getOption());
        dto.setApproveUserId(approveRecord.getApproveUserId());
        dto.setApproveUser(approveRecord.getApproveUser());
        dto.setApproveTime(approveRecord.getApproveTime());
        dto.setDescription(approveRecord.getDescription());
        dto.setId(approveRecord.getId());
        dto.setRemark(approveRecord.getRemark());
        dto.setTaskid(approveRecord.getTaskid());
        dto.setTbid(approveRecord.getTbid());
        dto.setStepname(approveRecord.getStepname());
        dto.setStepindex(approveRecord.getStepindex());
        dto.setNextstep(approveRecord.getNextstep());
        dto.setWflx(approveRecord.getWflx());
        dto.setType(Integer.valueOf(1));
        return dto;
    }

    private ApproveRecordDTO convertRevokeRecord2ApproveRecord(TbtskRevokeRecord revokeRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(Integer.valueOf(1));
        dto.setOption(Integer.valueOf(1));
        dto.setApproveUserId(revokeRecord.getUserId());
        dto.setApproveUser(revokeRecord.getUserName());
        dto.setApproveTime(revokeRecord.getRevokeTime());
        dto.setDescription("");
        dto.setId(revokeRecord.getId());
        dto.setRemark(revokeRecord.getRemark());
        dto.setTaskid(revokeRecord.getTaskId());
        dto.setTbid(revokeRecord.getTbId());
        dto.setStepname(revokeRecord.getStepName());
        dto.setStepindex(Integer.valueOf(0));
        dto.setNextstep(Integer.valueOf(1));
        dto.setType(Integer.valueOf(3));
        return dto;
    }

    private ApproveRecordDTO convertRejectRecord2ApproveRecord(TbtskRejectRecord rejectRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(Integer.valueOf(1));
        dto.setOption(Integer.valueOf(2));
        dto.setApproveUserId(rejectRecord.getUserId());
        dto.setApproveUser(rejectRecord.getUserName());
        dto.setApproveTime(rejectRecord.getRejectTime());
        dto.setDescription(rejectRecord.getDescription());
        dto.setId(rejectRecord.getId());
        dto.setRemark(rejectRecord.getRemark());
        dto.setTaskid(rejectRecord.getTaskid());
        dto.setTbid(rejectRecord.getTbid());
        dto.setStepname(rejectRecord.getStepName());
        dto.setStepindex(Integer.valueOf(0));
        dto.setNextstep(Integer.valueOf(1));
        dto.setType(Integer.valueOf(2));
        return dto;
    }

    public List<Integer> getUserRole(String taskId, Long userId) {
        GutilAssert.state((boolean)StringUtils.isNoneBlank((CharSequence)taskId), (String)"taskId \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        ArrayList<Integer> result = new ArrayList();
        result = this.mConfigTaskReviewService.getUserRole(taskId, userId);
        return result;
    }

    public Map checkApprovePermission(String taskId, String tbId, String type, Long userId) {
        Map<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("hasPermission", false);
        Integer rejectCount = 0;
        resultMap = this.mConfigTaskReviewService.checkAuditPermission(taskId, tbId, userId);
        return resultMap;
    }

    private Map getPermissionByFilter(String taskId, String tbId, String type, Long userId, Integer rejectCount) {
        Map<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("hasPermission", false);
        List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (flowSteps == null || flowSteps.size() == 0) {
            return resultMap;
        }
        Triplet triplet = this.getRegionCodeAndStatus(tbId, type);
        if (triplet.getValue0() == null || triplet.getValue1() == null || triplet.getValue2() == null) {
            return resultMap;
        }
        String dataRegionCode = triplet.getValue0().toString();
        Integer status = (Integer)triplet.getValue1();
        Integer stage = (Integer)triplet.getValue2();
        resultMap = this.mConfigTaskReviewService.validateFlowStage(taskId, tbId, userId, dataRegionCode, status, stage, rejectCount, resultMap, flowSteps);
        return resultMap;
    }

    private Triplet getRegionCodeAndStatus(String tbId, String type) {
        String regionCode = "";
        Object status = null;
        Object stage = null;
        return new Triplet((Object)regionCode, status, stage);
    }

    public TbtskApproveRecord submitApproveRecord(TbtskApproveRecord approveRecord, String type, Long userId) throws Exception {
        TbtskApproveRecord result = null;
        if (approveRecord == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)approveRecord.getTaskid())) {
            throw new RuntimeException("taskId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        result = this.mConfigTaskReviewService.submitApproveRecord(approveRecord, type, userId);
        return result;
    }

    public List<TbtskFlowDef> getAllFlow() {
        return this.tbtskFlowDefRepository.getAll();
    }

    public String reject(String taskId, String tbId, Long userId, String remark, String description, String userName, String stepName, String targetStepName) throws Exception {
        String result = "\u6253\u56de\u5931\u8d25";
        result = this.mConfigTaskReviewService.reject(taskId, tbId, userId, remark, description, userName, stepName, result, targetStepName);
        return result;
    }

    public String rejectBatch(Integer type, String taskId, String tbIds, Long userId, String remark, String description, String userName, String stepName) {
        String result = "\u6253\u56de\u6210\u529f";
        try {
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
            if (tskTaskBiz.getIsApprove() == 0) {
                return "\u8be5\u4efb\u52a1\u6ca1\u6709\u5ba1\u6838\u590d\u6838\u6d41\u7a0b";
            }
            TbtskRejectDef tbtskRejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
            if (tbtskRejectDef.getRejectType() == 0) {
                return "\u8be5\u4efb\u52a1\u65e0\u6253\u56de\u914d\u7f6e\uff0c\u4e0d\u80fd\u6253\u56de";
            }
            JSONObject params = new JSONObject();
            params.put("filterType", (Object)"checkFilter");
            params.put("tbIds", (Object)tbIds);
            params.put("taskId", (Object)taskId);
            params.put("type", (Object)type);
            params.put("description", (Object)description);
            params.put("remark", (Object)remark);
            params.put("userName", (Object)userName);
            params.put("stepName", (Object)stepName);
            params.put("userId", (Object)userId);
            params.put("result", (Object)result);
            this.addTaskRecord(params, userId, TASK_ID_LZGD.equalsIgnoreCase(taskId) ? JobConstants.JOB_TYPE_LZGD_BATCH_REJECT : JobConstants.JOB_TYPE_CONFIG_TASK_REJECT_BATCH, TASK_ID_LZGD.equalsIgnoreCase(taskId) ? "7" : taskId);
        }
        catch (Exception e) {
            result = "\u6253\u56de\u5931\u8d25";
            e.printStackTrace();
        }
        return result;
    }

    public String rejectBatchByConditionFilter(Integer type, String taskId, Long userId, String remark, String description, String userName, String stepName, TaskQueryParameter parameter) {
        String result = "\u6253\u56de\u6210\u529f";
        try {
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
            if (tskTaskBiz.getIsApprove() == 0) {
                return "\u8be5\u4efb\u52a1\u6ca1\u6709\u5ba1\u6838\u590d\u6838\u6d41\u7a0b";
            }
            TbtskRejectDef tbtskRejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
            if (tbtskRejectDef == null || tbtskRejectDef.getRejectType() == 0) {
                return "\u8be5\u4efb\u52a1\u65e0\u6253\u56de\u914d\u7f6e\uff0c\u4e0d\u80fd\u6253\u56de";
            }
            JSONObject params = new JSONObject();
            params.put("filterType", (Object)"conditionFilter");
            params.put("userId", (Object)userId);
            params.put("taskQueryParameter", (Object)parameter);
            params.put("taskId", (Object)taskId);
            params.put("type", (Object)type);
            params.put("description", (Object)description);
            params.put("remark", (Object)remark);
            params.put("userName", (Object)userName);
            params.put("stepName", (Object)stepName);
            params.put("result", (Object)result);
            this.addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_REJECT_BATCH, taskId);
        }
        catch (Exception e) {
            result = "\u6253\u56de\u5f02\u5e38";
            e.printStackTrace();
        }
        return result;
    }

    public String rejectBatchByFilter(Integer type, String taskId, Long userId, String remark, String description, String userName, String stepName, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt, Date startTime, Date endTime, String tbzt, String xmhj, String shfh, String sfdh, String ywzp) throws Exception {
        String result = "\u6253\u56de\u6210\u529f";
        result = this.mConfigTaskReviewService.rejectBatchByFilter(type, taskId, userId, remark, description, userName, stepName, xzqdm, fwbh, jslx, xfzt, tjzt, startTime, endTime, tbzt, xmhj, shfh, sfdh, ywzp);
        return result;
    }

    private TbtskRejectRecord saveRejectRecordNew(String taskId, Long userId, String remark, String description, String userName, String stepName, String id, Integer reviewStage) {
        TbtskRejectRecord rejectRecord = new TbtskRejectRecord();
        rejectRecord.setTaskid(taskId);
        rejectRecord.setTbid(id);
        rejectRecord.setUserId(userId);
        rejectRecord.setRejectTime(new Date());
        rejectRecord.setRemark(remark);
        rejectRecord.setDescription(description);
        rejectRecord.setUserName(userName);
        rejectRecord.setSourceStage(reviewStage);
        rejectRecord.setTargetStage(Integer.valueOf(ReviewStageEnum.OPERATOR_VERIFY.getCode()));
        rejectRecord.setStepName(stepName);
        return rejectRecord;
    }

    private TbtskRejectRecord saveRejectRecord(String taskId, Long userId, String remark, String description, String userName, String stepName, String id, Integer sourceStage, Integer targetStage) {
        TbtskRejectRecord rejectRecord = new TbtskRejectRecord();
        rejectRecord.setTaskid(taskId);
        rejectRecord.setTbid(id);
        rejectRecord.setUserId(userId);
        rejectRecord.setRejectTime(new Date());
        rejectRecord.setRemark(remark);
        rejectRecord.setDescription(description);
        rejectRecord.setUserName(userName);
        rejectRecord.setSourceStage(sourceStage);
        rejectRecord.setTargetStage(targetStage);
        rejectRecord.setStepName(stepName);
        return (TbtskRejectRecord)this.tbtskRejectRecordRepository.save((Object)rejectRecord);
    }

    public void sendRejectMessageToAPPByPlatform(List<String> ids, Long userId, List<String> submitUserIds, String description, String remark, JSONArray id2RejectIdArray, TbtskObjectinfo tableInfo, String taskId) {
        String content = String.format("\u3010\u4efb\u52a1\u56fe\u6591\u6253\u56de\u901a\u77e5\u3011\u3002\u4efb\u52a1\u540d\u79f0\uff1a" + tableInfo.getfTablealias() + "\uff1b\u6253\u56de\u4e86%s\u4e2a\u56fe\u6591", ids.size());
        if (StringUtils.isNotBlank((CharSequence)description)) {
            content = content + "  \u539f\u56e0\uff1a" + description + "";
        }
        if (StringUtils.isNotBlank((CharSequence)remark)) {
            content = content + "  \u5907\u6ce8\uff1a" + remark;
        }
        TaskNotice taskNotice = new TaskNotice();
        taskNotice.setData(StringUtils.join((Object[])ids.toArray(), (char)','));
        taskNotice.setContent(content);
        taskNotice.setId(UUID.randomUUID().toString());
        taskNotice.setState(Integer.valueOf(1));
        taskNotice.setSendUser(null);
        taskNotice.setTitle("\u4efb\u52a1\u56fe\u6591\u6253\u56de\u901a\u77e5");
        taskNotice.setSendTime(new Date());
        taskNotice.setType(Integer.valueOf(2));
        taskNotice.setAction(Integer.valueOf(19));
        taskNotice.setRegion("");
        taskNotice.setRegion1("");
        taskNotice.setMsgtype("0");
        taskNotice.setBizId(taskId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)ids.size());
        if (id2RejectIdArray != null) {
            jsonObject.put("rejectIds", (Object)id2RejectIdArray);
        }
        taskNotice.setAddition(jsonObject.toString());
        taskNotice = this.mTaskNoticeService.save(taskNotice);
        ArrayList<String> alias = new ArrayList<String>();
        for (int i = 0; i < submitUserIds.size(); ++i) {
            String userid = submitUserIds.get(i);
            TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
            taskNoticeUser.setId(UUID.randomUUID().toString());
            taskNoticeUser.setData(StringUtils.join((Object[])ids.toArray(), (char)','));
            taskNoticeUser.setState(Integer.valueOf(0));
            taskNoticeUser.setCreatetime(new Date());
            taskNoticeUser.setNoticeId(taskNotice.getId());
            taskNoticeUser.setUserId(userid);
            this.mTaskNoticeService.save(taskNoticeUser);
            alias.add(userid);
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", 2);
        message.put("bizid", taskId);
        try {
            MixPushServer.sendNotifyToAlias(alias, (String)taskNotice.getTitle(), (String)taskNotice.getContent(), (String)JSON.toJSONString(message));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<TbtskApproveRecord> queryLatestApproveRecord(String taskId, String tbId, Long userId, Integer type) {
        ArrayList<Object> resultList = null;
        List approveRecordList = this.tbtskApproveRecordRepository.findApproveRecordOrderByTime(taskId, tbId);
        if (!GutilCollection.isEmpty((Collection)approveRecordList)) {
            if (type != null) {
                if (type.equals(0) || type.equals(1)) {
                    TbtskApproveRecord latestRecord = this.getTbtskApproveRecord(type, approveRecordList, userId);
                    if (latestRecord != null) {
                        if (resultList == null) {
                            resultList = new ArrayList<TbtskApproveRecord>();
                        }
                        resultList.add(latestRecord);
                    }
                    return resultList;
                }
                if (type.equals(2)) {
                    TbtskApproveRecord latestRecord2;
                    TbtskApproveRecord latestRecord = this.getTbtskApproveRecord(0, approveRecordList, userId);
                    if (latestRecord != null) {
                        if (resultList == null) {
                            resultList = new ArrayList();
                        }
                        resultList.add(latestRecord);
                    }
                    if ((latestRecord2 = this.getTbtskApproveRecord(1, approveRecordList, userId)) != null) {
                        if (resultList == null) {
                            resultList = new ArrayList();
                        }
                        resultList.add(latestRecord2);
                    }
                    return resultList;
                }
            } else {
                return null;
            }
        }
        return resultList;
    }

    private TbtskApproveRecord getTbtskApproveRecord(Integer type, List<TbtskApproveRecord> approveRecordList, Long userId) {
        if (!GutilCollection.isEmpty(approveRecordList)) {
            for (TbtskApproveRecord approveRecord : approveRecordList) {
                if (!(type.equals(0) ? approveRecord.getStepname().contains("\u5ba1\u6838") && approveRecord.getApproveUserId() != null && approveRecord.getApproveUserId().equals(userId) : type.equals(1) && approveRecord.getStepname().contains("\u590d\u6838") && approveRecord.getApproveUserId() != null && approveRecord.getApproveUserId().equals(userId))) continue;
                return approveRecord;
            }
        }
        return null;
    }

    public Object submitApproveRecordBatch(String taskId, String tbId, Integer option, String description, String remark, Long userId, String approveUser, Integer type) {
        String result = "\u6279\u91cf\u5ba1\u6838/\u590d\u6838\u6210\u529f";
        result = this.mConfigTaskReviewService.submitApproveRecordBatch(taskId, tbId, option, description, remark, userId, approveUser, type);
        return result;
    }

    public Object submitApproveRecordBatchByFilter(String taskId, Integer option, String description, String remark, Long userId, String approveUser, Integer type, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt, Date startTime, Date endTime, String tbzt, String xmhj, String shfh, String sfdh, String ywzp) throws Exception {
        String result = "\u6279\u91cf\u5ba1\u6838/\u590d\u6838\u6210\u529f";
        result = this.mConfigTaskReviewService.submitApproveRecordBatchByFilter(taskId, option, description, remark, userId, approveUser, type, xzqdm, fwbh, jslx, xfzt, tjzt, startTime, endTime, tbzt, xmhj, shfh, sfdh, ywzp);
        return result;
    }

    public Object submitApproveRecordBatchByConditionFilter(String taskId, Integer option, String description, String remark, Long userId, String approveUser, Integer type, String xzqdm, TaskQueryParameter taskQueryParameter) {
        String result = "\u6279\u91cf\u5ba1\u6838/\u590d\u6838\u6210\u529f";
        try {
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
            if (tskTaskBiz.getIsApprove() == 0) {
                return "\u8be5\u4efb\u52a1\u6ca1\u6709\u5ba1\u6838\u590d\u6838\u6d41\u7a0b";
            }
            JSONObject params = new JSONObject();
            params.put("filterType", (Object)"conditionFilter");
            params.put("xzqdm", (Object)xzqdm);
            params.put("userId", (Object)userId);
            params.put("taskQueryParameter", (Object)taskQueryParameter);
            params.put("taskId", (Object)taskId);
            params.put("option", (Object)option);
            params.put("description", (Object)description);
            params.put("remark", (Object)remark);
            params.put("approveUser", (Object)approveUser);
            params.put("type", (Object)type);
            this.addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_AUDIT_BATCH, taskId);
        }
        catch (Exception e) {
            result = "\u6279\u91cf\u5ba1\u6838/\u590d\u6838\u5931\u8d25";
            e.printStackTrace();
        }
        return result;
    }

    @Transactional
    public Pair<Boolean, String> createFlowDefine(String taskId, String flowName, String nodes, FlowTypeEnum flowTypeEnum, boolean onlyAudit, String rejectType, Integer canRevoke) throws Exception {
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)taskId), (String)"parameter [taskId] can not be null or empty.");
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)flowName), (String)"parameter [flowName] can not be null or empty.");
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)nodes), (String)"parameter [nodes] can not be null or empty.");
        Object[] nodeArray = nodes.split(",");
        if (ArrayUtils.isEmpty((Object[])nodeArray)) {
            throw new RuntimeException("\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List tbtskFlowDefs = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, Integer.valueOf(flowTypeEnum.getCode()));
        if (!GutilCollection.isEmpty((Collection)tbtskFlowDefs)) {
            throw new RuntimeException("\u6b64\u4efb\u52a1\u5df2\u7ecf\u521b\u5efa\u8fc7\u5ba1\u6838\u6d41\u7a0b\uff0c\u4e0d\u80fd\u5728\u91cd\u590d\u5b9a\u4e49\u6d41\u7a0b");
        }
        Object[] sortedNodes = Arrays.stream(nodeArray).sorted().toArray();
        JSONArray flowStepsArray = this.getFlowSteps(onlyAudit, sortedNodes);
        TbtskFlowDef flowDef = new TbtskFlowDef();
        flowDef.setId(UUID.randomUUID().toString());
        flowDef.setName(flowName);
        flowDef.setFlowtype(Integer.valueOf(flowTypeEnum.getCode()));
        flowDef.setStepcount(Integer.valueOf(onlyAudit ? nodeArray.length : nodeArray.length * 2));
        flowDef.setSteps(flowStepsArray.toString());
        flowDef.setContainsReview(Integer.valueOf(onlyAudit ? 0 : 1));
        flowDef = (TbtskFlowDef)this.tbtskFlowDefRepository.save((Object)flowDef);
        TbtskTaskBizFlow bizFlow = new TbtskTaskBizFlow();
        bizFlow.setId(UUID.randomUUID().toString());
        bizFlow.setFlowId(flowDef.getId());
        bizFlow.setTaskId(taskId);
        this.tbtskTaskBizFlowService.insert(bizFlow);
        TbtskRejectDef rejectDef = new TbtskRejectDef();
        rejectDef.setId(UUID.randomUUID().toString());
        rejectDef.setTaskid(taskId);
        rejectDef.setRejectType(Integer.valueOf(Integer.parseInt(rejectType)));
        rejectDef.setCustomSetting("");
        this.tbtskRejectDefMapper.insert((Object)rejectDef);
        this.mTskTaskBizService.updateCanRevoke(taskId, canRevoke);
        JSONObject resultJson = new JSONObject();
        resultJson.put("id", (Object)flowDef.getId());
        resultJson.put("name", (Object)flowDef.getName());
        return Pair.of((Object)true, (Object)resultJson.toJSONString());
    }

    private JSONArray getFlowSteps(boolean onlyAudit, Object[] sortedNodes) throws Exception {
        JSONArray nodesJsonArray = new JSONArray();
        JSONObject auditNodeJsonObj = null;
        int auditNodeIndex = 0;
        if (onlyAudit) {
            for (Object sortedNode : sortedNodes) {
                auditNodeJsonObj = this.getAuditNodeJsonObj(sortedNodes, auditNodeIndex, sortedNode, auditNodeIndex == 0, auditNodeIndex == sortedNodes.length - 1, true, false);
                ++auditNodeIndex;
                nodesJsonArray.add((Object)auditNodeJsonObj);
            }
        } else {
            JSONObject reviewNodeJsonObj = null;
            int reviewNodeIndex = 1;
            for (Object currentNode : sortedNodes) {
                auditNodeJsonObj = this.getAuditNodeJsonObj(sortedNodes, auditNodeIndex, currentNode, auditNodeIndex == 0, auditNodeIndex == sortedNodes.length * 2 - 1, true, true);
                nodesJsonArray.add((Object)auditNodeJsonObj);
                reviewNodeJsonObj = this.getReviewNodeJsonObj(sortedNodes, reviewNodeIndex, currentNode, auditNodeIndex == sortedNodes.length * 2 - 2, false);
                nodesJsonArray.add((Object)reviewNodeJsonObj);
                auditNodeIndex += 2;
                reviewNodeIndex += 2;
            }
        }
        return nodesJsonArray;
    }

    private JSONObject getAuditNodeJsonObj(Object[] sortedNodes, int auditNodeIndex, Object sortedNode, boolean isFirstStep, boolean isLastStep, boolean isAudit, boolean containsReview) throws Exception {
        JSONObject auditNodeJsonObj = new JSONObject();
        auditNodeJsonObj.put("index", (Object)auditNodeIndex);
        auditNodeJsonObj.put("name", (Object)this.getNodeAuditName(sortedNode));
        auditNodeJsonObj.put("is_start", (Object)isFirstStep);
        auditNodeJsonObj.put("is_end", (Object)isLastStep);
        auditNodeJsonObj.put("pre_status", (Object)this.getPreStatus(isAudit));
        if (!containsReview) {
            auditNodeJsonObj.put("post_status", (Object)String.valueOf(TbStatusEnum.WAITING_VERIFY.getCode()));
        } else {
            auditNodeJsonObj.put("post_status", (Object)String.valueOf(isAudit ? TbStatusEnum.WAITING_REVIEW.getCode() : TbStatusEnum.WAITING_VERIFY.getCode()));
        }
        auditNodeJsonObj.put("pre_stages", (Object)this.getAuditPreStage(sortedNodes, sortedNode, isFirstStep, isAudit));
        auditNodeJsonObj.put("post_stage", (Object)this.getPostStage(sortedNode, isLastStep, containsReview, isAudit));
        auditNodeJsonObj.put("filter", (Object)this.getNodeFilter(true));
        return auditNodeJsonObj;
    }

    private JSONObject getReviewNodeJsonObj(Object[] sortedNodes, int reviewNodeIndex, Object currentNode, boolean isLastStep, boolean isAuditNode) throws Exception {
        JSONObject reviewNodeJsonObj = new JSONObject();
        reviewNodeJsonObj.put("index", (Object)reviewNodeIndex);
        reviewNodeJsonObj.put("name", (Object)this.getNodeReviewName(currentNode));
        reviewNodeJsonObj.put("is_start", (Object)false);
        reviewNodeJsonObj.put("is_end", (Object)isLastStep);
        reviewNodeJsonObj.put("pre_status", (Object)(TbStatusEnum.WAITING_REVIEW.getCode() + "," + TbStatusEnum.REVIEW_NOT_PASS.getCode()));
        reviewNodeJsonObj.put("post_status", (Object)String.valueOf(TbStatusEnum.WAITING_VERIFY.getCode()));
        reviewNodeJsonObj.put("pre_stages", (Object)this.getReviewPreStage(sortedNodes, currentNode, isAuditNode));
        reviewNodeJsonObj.put("post_stage", (Object)this.getPostStage(currentNode, isLastStep, true, isAuditNode));
        reviewNodeJsonObj.put("filter", (Object)this.getNodeFilter(false));
        return reviewNodeJsonObj;
    }

    private String getNodeAuditName(Object currentNode) {
        switch (currentNode.toString()) {
            case "1": {
                return "\u6751\u7ea7\u5ba1\u6838";
            }
            case "2": {
                return "\u4e61\u9547\u5ba1\u6838";
            }
            case "3": {
                return "\u533a\u53bf\u5ba1\u6838";
            }
            case "4": {
                return "\u5e02\u7ea7\u5ba1\u6838";
            }
            case "5": {
                return "\u7701\u7ea7\u5ba1\u6838";
            }
            case "6": {
                return "\u56fd\u5bb6\u5ba1\u6838";
            }
        }
        return "";
    }

    private String getNodeReviewName(Object currentNode) {
        switch (currentNode.toString()) {
            case "1": {
                return "\u6751\u7ea7\u590d\u6838";
            }
            case "2": {
                return "\u4e61\u9547\u590d\u6838";
            }
            case "3": {
                return "\u533a\u53bf\u590d\u6838";
            }
            case "4": {
                return "\u5e02\u7ea7\u590d\u6838";
            }
            case "5": {
                return "\u7701\u7ea7\u590d\u6838";
            }
            case "6": {
                return "\u56fd\u5bb6\u590d\u6838";
            }
        }
        return "";
    }

    private String getPreStatus(boolean isAudit) {
        String result = "";
        result = isAudit ? TbStatusEnum.WAITING_VERIFY.getCode() + "," + TbStatusEnum.VERIFY_NOT_PASS.getCode() : TbStatusEnum.WAITING_REVIEW.getCode() + "," + TbStatusEnum.REVIEW_NOT_PASS.getCode();
        return result;
    }

    private String getNodeStage(Object currentNode) {
        switch (currentNode.toString()) {
            case "1": {
                return String.valueOf(ReviewStageEnum.VILLAGE_VERIFY.getCode());
            }
            case "2": {
                return String.valueOf(ReviewStageEnum.TOWN_VERIFY.getCode());
            }
            case "3": {
                return String.valueOf(ReviewStageEnum.COUNTY_VERIFY.getCode());
            }
            case "4": {
                return String.valueOf(ReviewStageEnum.CITY_VERIFY.getCode());
            }
            case "5": {
                return String.valueOf(ReviewStageEnum.PROVINCE_VERIFY.getCode());
            }
            case "6": {
                return String.valueOf(ReviewStageEnum.COUNTRY_VERIFY.getCode());
            }
        }
        return "";
    }

    private String getAuditPreStage(Object[] sortedNodes, Object currentNode, boolean currentIsFirstStep, boolean isOnlyAudit) throws Exception {
        String result = "";
        if (currentIsFirstStep) {
            result = ReviewStageEnum.OPERATOR_VERIFY.getCode() + "," + this.getNodeStage(currentNode);
        } else {
            int index = -1;
            Object preNode = "";
            if (ArrayUtils.isNotEmpty((Object[])sortedNodes)) {
                for (int i = 0; i < sortedNodes.length; ++i) {
                    if (!sortedNodes[i].equals(currentNode)) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    throw new RuntimeException("\u5f53\u524d\u8282\u70b9\u4e0d\u5728\u8282\u70b9\u6570\u636e\u96c6\u5408\u4e2d\u3002");
                }
                if (isOnlyAudit) {
                    preNode = index > 0 ? sortedNodes[index - 1] : sortedNodes[0];
                    result = this.getNodeStage(preNode) + "," + this.getNodeStage(currentNode);
                } else if (index > 0) {
                    result = this.getNodeStage(currentNode);
                } else {
                    preNode = sortedNodes[0];
                    result = this.getNodeStage(preNode) + "," + this.getNodeStage(currentNode);
                }
            } else {
                throw new RuntimeException("\u8282\u70b9\u6570\u636e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
        }
        return result;
    }

    private String getPostStage(Object currentNode, boolean isLastNode, boolean isContainsReview, boolean isAuditNode) {
        String result = "";
        result = isLastNode ? String.valueOf(ReviewStageEnum.OVER_VERIFY.getCode()) : (!isContainsReview ? String.valueOf(this.AuditStageArray[Integer.parseInt(currentNode.toString())].getCode()) : (isAuditNode ? String.valueOf(this.AuditReviewStageArray[Integer.parseInt(currentNode.toString()) * 2 - 1].getCode()) : String.valueOf(this.AuditReviewStageArray[Integer.parseInt(currentNode.toString()) * 2].getCode())));
        return result;
    }

    private String getReviewPreStage(Object[] sortedNodes, Object currentNode, boolean isAuditNode) throws Exception {
        String result = "";
        int index = -1;
        Object preNode = "";
        if (ArrayUtils.isNotEmpty((Object[])sortedNodes)) {
            for (int i = 0; i < sortedNodes.length; ++i) {
                if (!sortedNodes[i].equals(currentNode)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                throw new RuntimeException("\u5f53\u524d\u8282\u70b9\u4e0d\u5728\u8282\u70b9\u6570\u636e\u96c6\u5408\u4e2d\u3002");
            }
            if (isAuditNode) {
                preNode = index > 0 ? sortedNodes[index - 1] : sortedNodes[0];
                result = this.getNodeStage(preNode);
            } else if (index > 0) {
                result = this.getNodeStage(currentNode);
            } else {
                preNode = sortedNodes[0];
                result = this.getNodeStage(preNode);
            }
        } else {
            throw new RuntimeException("\u8282\u70b9\u6570\u636e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        return result;
    }

    private String getNodeFilter(boolean isAudit) {
        StringBuilder sb = new StringBuilder();
        sb.append(" LEFT JOIN tbsys_user_biz2 b on u.f_userid = b.f_userid ");
        if (isAudit) {
            sb.append(" LEFT JOIN tbtsk_user_audit_area a on CAST (u.f_userid AS text) = a.f_userid ");
        } else {
            sb.append(" LEFT JOIN tbtsk_user_review_area a on CAST (u.f_userid AS text) = a.f_userid ");
        }
        sb.append(" WHERE b.f_role = ").append(isAudit ? 2 : 4).append(" ");
        sb.append(" AND b.f_bizid = '%TaskId%' ");
        sb.append(" AND a.f_taskid = '%TaskId%' AND a.f_regioncode = '%DataRegionCode%';");
        return sb.toString();
    }

    public Pair<Boolean, String> updateFlowDefine(String flowId, String flowName, String nodes, FlowTypeEnum flowTypeEnum, boolean onlyAudit, String rejectType, Integer canRevoke) throws Exception {
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)flowId), (String)"parameter [flowId] can not be null or empty.");
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)flowName), (String)"parameter [flowName] can not be null or empty.");
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)nodes), (String)"parameter [nodes] can not be null or empty.");
        Object[] nodeArray = nodes.split(",");
        if (ArrayUtils.isEmpty((Object[])nodeArray)) {
            throw new RuntimeException("\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TbtskFlowDef flowDef = this.tbtskFlowDefRepository.findById((Object)flowId).orElse(null);
        if (flowDef == null) {
            return Pair.of((Object)false, (Object)("\u4e0d\u5b58\u5728Id\u4e3a[" + flowId + "]\u7684\u6d41\u7a0b"));
        }
        if (flowTypeEnum == FlowTypeEnum.AUDIT) {
            if (flowDef.getFlowtype() != null && flowDef.getFlowtype().intValue() == flowTypeEnum.getCode()) {
                boolean isUsing = false;
                List tskTaskBizs = flowDef.getTskTaskBizs();
                TbtskTaskBiz taskBiz = null;
                if (!GutilCollection.isEmpty((Collection)tskTaskBizs)) {
                    taskBiz = (TbtskTaskBiz)tskTaskBizs.get(0);
                    for (TbtskTaskBiz biz : tskTaskBizs) {
                        TbtskApproveRecord approveRecord = this.tbtskApproveRecordRepository.findOneByTaskId(biz.getId());
                        if (approveRecord == null) continue;
                        isUsing = true;
                        break;
                    }
                }
                if (isUsing) {
                    return Pair.of((Object)false, (Object)"\u6b64\u6d41\u7a0b\u5b58\u5728\u5ba1\u6838\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
                }
                Object[] sortedNodes = Arrays.stream(nodeArray).sorted().toArray();
                JSONArray flowStepsArray = this.getFlowSteps(onlyAudit, sortedNodes);
                flowDef.setName(flowName);
                flowDef.setStepcount(Integer.valueOf(onlyAudit ? nodeArray.length : nodeArray.length * 2));
                flowDef.setSteps(flowStepsArray.toString());
                flowDef.setContainsReview(Integer.valueOf(onlyAudit ? 0 : 1));
                this.tbtskFlowDefRepository.save((Object)flowDef);
                if (taskBiz != null) {
                    List rejectDefList = this.tbtskRejectDefMapper.queryByTaskid(taskBiz.getId());
                    if (!GutilCollection.isEmpty((Collection)rejectDefList)) {
                        TbtskRejectDef rejectDef = (TbtskRejectDef)rejectDefList.get(0);
                        rejectDef.setRejectType(Integer.valueOf(Integer.parseInt(rejectType)));
                        rejectDef.setCustomSetting("");
                        this.tbtskRejectDefMapper.updateByPrimaryKeySelective((Object)rejectDef);
                    }
                    this.mTskTaskBizService.updateCanRevoke(taskBiz.getId(), canRevoke);
                }
                JSONObject resultJson = new JSONObject();
                resultJson.put("id", (Object)flowDef.getId());
                resultJson.put("name", (Object)flowDef.getName());
                return Pair.of((Object)true, (Object)resultJson.toJSONString());
            }
            return Pair.of((Object)false, (Object)("\u4e0d\u5b58\u5728Id\u4e3a[" + flowId + "]\u7684\u5ba1\u6838\u6d41\u7a0b"));
        }
        return Pair.of((Object)false, (Object)"\u4e0b\u53d1\u6d41\u7a0b\u4fee\u6539\u6682\u672a\u5b9e\u73b0");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<Boolean, String> deleteFlowDefine(String flowId, FlowTypeEnum flowTypeEnum, Long userId) {
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)flowId), (String)"parameter [flowId] can not be null or empty.");
        TbtskFlowDef flowDef = this.tbtskFlowDefRepository.findById((Object)flowId).orElse(null);
        if (flowDef == null) {
            return Pair.of((Object)false, (Object)("\u4e0d\u5b58\u5728Id\u4e3a[" + flowId + "]\u7684\u6d41\u7a0b"));
        }
        if (flowTypeEnum == FlowTypeEnum.AUDIT) {
            if (flowDef.getFlowtype() == null || flowDef.getFlowtype().intValue() != flowTypeEnum.getCode()) return Pair.of((Object)false, (Object)("\u4e0d\u5b58\u5728Id\u4e3a[" + flowId + "]\u7684\u5ba1\u6838\u6d41\u7a0b"));
            boolean isUsing = false;
            List tskTaskBizs = flowDef.getTskTaskBizs();
            for (TbtskTaskBiz taskBiz : tskTaskBizs) {
                TbtskApproveRecord approveRecord = this.tbtskApproveRecordRepository.findOneByTaskId(taskBiz.getId());
                if (approveRecord == null) continue;
                isUsing = true;
                break;
            }
            if (isUsing) {
                return Pair.of((Object)false, (Object)"\u6b64\u6d41\u7a0b\u5b58\u5728\u5ba1\u6838\u8bb0\u5f55\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            this.tbtskFlowDefRepository.deleteById((Object)flowId);
            this.tbtskTaskBizFlowService.deleteByFlowId(flowId);
            return Pair.of((Object)true, (Object)"\u5220\u9664\u6d41\u7a0b\u6210\u529f");
        } else {
            this.tbtskFlowDefRepository.deleteById((Object)flowId);
            this.tbtskTaskBizFlowService.deleteByFlowId(flowId);
        }
        return Pair.of((Object)true, (Object)"\u5220\u9664\u6d41\u7a0b\u6210\u529f");
    }

    public Pair<Boolean, Object> findOneFlowDefine(String taskId, FlowTypeEnum flowTypeEnum, Long userId) {
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)taskId), (String)"parameter [taskId] can not be null or empty.");
        GutilAssert.state((flowTypeEnum != FlowTypeEnum.UNDEFINED ? 1 : 0) != 0, (String)"parameter [flowTypeEnum] undefined.");
        List flowDefs = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, new Integer(flowTypeEnum.getCode()));
        if (!GutilCollection.isEmpty((Collection)flowDefs)) {
            return Pair.of((Object)true, flowDefs.get(0));
        }
        return Pair.of((Object)false, (Object)"\u672a\u67e5\u8be2\u5230\u6d41\u7a0b");
    }

    public Pair<Boolean, Object> findOneFlowDefineById(String flowId, FlowTypeEnum flowTypeEnum, Long userId) {
        GutilAssert.state((boolean)StringUtils.isNotBlank((CharSequence)flowId), (String)"parameter [taskId] can not be null or empty.");
        GutilAssert.state((flowTypeEnum != FlowTypeEnum.UNDEFINED ? 1 : 0) != 0, (String)"parameter [flowTypeEnum] undefined.");
        TbtskFlowDef tbtskFlowDef = this.tbtskFlowDefRepository.findById((Object)flowId).orElse(null);
        if (tbtskFlowDef != null) {
            return Pair.of((Object)true, (Object)tbtskFlowDef);
        }
        return Pair.of((Object)false, (Object)"\u672a\u67e5\u8be2\u5230\u6d41\u7a0b");
    }

    public List<Map> getConfigTaskDataList(TaskQueryParameter queryParameter) {
        List<Map> dataList = new ArrayList<Map>();
        try {
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)queryParameter.getTaskId()).orElse(null);
            if (null == tskTaskBiz) {
                throw new RuntimeException("\u63d0\u62a5\u5931\u8d25\uff0c\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            if (null == tbtskObjectinfo) {
                throw new RuntimeException("\u63d0\u62a5\u5931\u8d25\uff0c\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            Pair<String, String> queryParamPair = this.mTskTaskBizService.parseQueryParameter(queryParameter);
            String tableName = (String)queryParamPair.getLeft();
            String where = (String)queryParamPair.getRight();
            List<String> fieldNameList = this.getAuditFieldNameCollection();
            fieldNameList.add("f_tbbh");
            List mustFields = this.tbtskFieldsRepository.queryNotNullFieldsByTableId(tbtskObjectinfo.getfId());
            if (mustFields != null && mustFields.size() > 0) {
                mustFields.forEach(a -> fieldNameList.add(a.getfFieldname()));
            }
            dataList = this.mDataBizService.queryAllData(tableName, fieldNameList, where);
        }
        catch (Exception e) {
            log.error(e.getMessage(), new Object[]{e});
        }
        return dataList;
    }

    public List<Map> getConfigTaskDataListNew(TaskQueryParameter queryParameter) {
        List<Map> dataList = new ArrayList<Map>();
        try {
            TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)queryParameter.getTaskId()).orElse(null);
            if (null == tskTaskBiz) {
                throw new RuntimeException("\u63d0\u62a5\u5931\u8d25\uff0c\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            if (null == tbtskObjectinfo) {
                throw new RuntimeException("\u63d0\u62a5\u5931\u8d25\uff0c\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            Pair<String, String> queryParamPair = this.mTskTaskBizService.parseQueryParameter(queryParameter);
            String tableName = (String)queryParamPair.getLeft();
            String where = (String)queryParamPair.getRight();
            List fields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
            ArrayList<String> fieldNameList = new ArrayList<String>();
            fields.forEach(a -> fieldNameList.add(a.getfFieldname()));
            dataList = this.mDataBizService.queryAllData(tableName, fieldNameList, where);
        }
        catch (Exception e) {
            log.error(e.getMessage(), new Object[]{e});
        }
        return dataList;
    }

    public String operatorSubmitReportBatch(String taskId, List<Map> dataList, Long userid) {
        String result = "";
        int successNum = 0;
        int failNum = 0;
        if (!GutilCollection.isEmpty(dataList)) {
            String msg = "";
            StringBuilder sb = new StringBuilder();
            ArrayList<TbtskSubmitReportRecord> tbtskSubmitReportRecords = new ArrayList<TbtskSubmitReportRecord>();
            ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>();
            String id = "";
            Integer status = null;
            String xzqdm = "";
            Integer rejectCount = 0;
            Integer rejectStatus = null;
            TskTaskBiz taskBiz = this.mTskTaskBizService.findByTaskId(taskId);
            TbtskObjectinfo tableInfo = this.mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
            for (Map data : dataList) {
                if (data != null) {
                    id = MapUtils.getString((Map)data, (Object)"f_id", (String)"");
                    status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
                    xzqdm = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
                    rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
                    rejectStatus = MapUtils.getInteger((Map)data, (Object)"f_reject_status", null);
                    if (status != null) {
                        if (status >= TbStatusEnum.SUBMIT.getCode() && status < TbStatusEnum.WAITING_VERIFY.getCode() || status.intValue() == TbStatusEnum.INIT.getCode()) {
                            Triplet checkResult = this.mConfigTaskReviewService.checkDataBeforeSubmit(data, tableInfo, taskId);
                            if (((Boolean)checkResult.getValue0()).booleanValue()) {
                                ReviewStageEnum reviewStage = this.getFirstStageOfFlow(taskId);
                                HashMap<String, Object> updateMap = new HashMap<String, Object>();
                                updateMap.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
                                updateMap.put("f_reject_status", 0);
                                updateMap.put("f_review_stage", reviewStage.getCode());
                                updateMap.put("f_updatetime", System.currentTimeMillis());
                                this.mDataBizService.updateData(tableInfo.getfTablename(), updateMap, "f_id='" + id + "'");
                                msg = "\u63d0\u62a5\u6210\u529f";
                                ++successNum;
                                tbtskSubmitReportRecords.add(this.saveSubmitReportRecord(taskId, id, xzqdm, rejectCount, userid));
                                if (tbtskSubmitReportRecords.size() >= 100) {
                                    this.tbtskSubmitReportRecordRepository.saveAll(tbtskSubmitReportRecords);
                                    tbtskSubmitReportRecords.clear();
                                }
                            } else {
                                String error = (String)checkResult.getValue2();
                                msg = StringUtils.isNotBlank((CharSequence)error) ? "\u63d0\u62a5\u5931\u8d25:" + error : "\u63d0\u62a5\u5931\u8d25";
                            }
                        } else if (status < TbStatusEnum.SUBMIT.getCode()) {
                            msg = "\u63d0\u62a5\u5931\u8d25\uff0c\u672a\u63d0\u4ea4\u7684\u56fe\u6591\u4e0d\u652f\u6301\u63d0\u62a5";
                        } else if (status >= TbStatusEnum.WAITING_VERIFY.getCode()) {
                            msg = "\u63d0\u62a5\u5931\u8d25\uff0c\u56fe\u6591\u5df2\u63d0\u62a5\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u62a5";
                        }
                    }
                } else {
                    msg = "\u63d0\u62a5\u5931\u8d25\uff0c\u56fe\u6591\u4e0d\u5b58\u5728";
                }
                if (StringUtils.isNotBlank((CharSequence)msg) && msg.startsWith("\u63d0\u62a5\u5931\u8d25")) {
                    sb.append("\u56fe\u6591id\uff1a").append(id).append(" ").append(msg);
                    ++failNum;
                }
                List uniqueFields = this.tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), Integer.valueOf(1));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fwbh", uniqueFields.size() > 0 ? data.get(((TbtskFields)uniqueFields.get(0)).getfFieldname()).toString() : id);
                map.put("uniqueFieldName", uniqueFields.size() > 0 ? ((TbtskFields)uniqueFields.get(0)).getfAlias() : "");
                map.put("result", msg);
                resultData.add(map);
            }
            if (!tbtskSubmitReportRecords.isEmpty()) {
                this.tbtskSubmitReportRecordRepository.saveAll(tbtskSubmitReportRecords);
                tbtskSubmitReportRecords.clear();
            }
            result = StringUtils.isNotBlank((CharSequence)sb.toString()) ? sb.toString() : "\u63d0\u62a5\u6210\u529f";
            result = this.exportSubmitData(userid, resultData);
        }
        return "\u63d0\u62a5\u6210\u529f," + successNum + "," + failNum + "," + result;
    }

    private ReviewStageEnum getFirstStageOfFlow(String taskId) {
        JSONObject jsonObject;
        Object firstStepObj;
        JSONArray jsonArray;
        TbtskFlowDef flowDef;
        List flowDefList = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, Integer.valueOf(FlowTypeEnum.AUDIT.getCode()));
        if (!GutilCollection.isEmpty((Collection)flowDefList) && StringUtils.isNotBlank((CharSequence)(flowDef = (TbtskFlowDef)flowDefList.get(0)).getSteps()) && (jsonArray = JSONArray.parseArray((String)flowDef.getSteps(), (Feature[])new Feature[0])) != null && !jsonArray.isEmpty() && (firstStepObj = jsonArray.get(0)) != null && (jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)firstStepObj))) != null && jsonObject.containsKey((Object)"name") && StringUtils.isNotBlank((CharSequence)jsonObject.get((Object)"name").toString())) {
            switch (jsonObject.get((Object)"name").toString()) {
                case "\u6751\u7ea7\u5ba1\u6838": {
                    return ReviewStageEnum.VILLAGE_VERIFY;
                }
                case "\u4e61\u9547\u5ba1\u6838": {
                    return ReviewStageEnum.TOWN_VERIFY;
                }
                case "\u533a\u53bf\u5ba1\u6838": {
                    return ReviewStageEnum.COUNTY_VERIFY;
                }
                case "\u5e02\u7ea7\u5ba1\u6838": {
                    return ReviewStageEnum.CITY_VERIFY;
                }
                case "\u7701\u7ea7\u5ba1\u6838": {
                    return ReviewStageEnum.PROVINCE_VERIFY;
                }
                case "\u56fd\u5bb6\u5ba1\u6838": {
                    return ReviewStageEnum.COUNTRY_VERIFY;
                }
            }
            return ReviewStageEnum.VILLAGE_VERIFY;
        }
        return ReviewStageEnum.VILLAGE_VERIFY;
    }

    public String submitAuditRecordBatch(List<Map> dataList, String taskId, Integer option, String description, String remark, Long userId, String approveUser, Integer type) {
        String result = "\u6279\u91cf\u5ba1\u6838/\u590d\u6838\u5931\u8d25";
        if (dataList == null || dataList.size() == 0) {
            result = "\u56fe\u6591\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
            return result;
        }
        int userLevel = 0;
        List userRegions = this.landUser2AreaRepository.queryAreas(userId);
        if (!GutilCollection.isEmpty((Collection)userRegions)) {
            String regionCode = (String)userRegions.get(0);
            userLevel = "1".equalsIgnoreCase(regionCode) ? 1 : (regionCode.endsWith("0000") ? 2 : (regionCode.endsWith("00") ? 3 : 4));
        } else {
            result = "\u7528\u6237\u65e0\u5de5\u4f5c\u533a\uff0c\u65e0\u6cd5\u5ba1\u6838/\u590d\u6838";
            return result;
        }
        String ynbgdcBizId = this.systemConfigCacheService.querySysConfig("ynbgdcBizId", "");
        ArrayList<TbtskApproveRecord> approveRecordCacheList = new ArrayList<TbtskApproveRecord>();
        String id = "";
        Integer status = null;
        String xzqdm = "";
        Integer reviewStage = null;
        Integer rejectCount = 0;
        TskTaskBiz taskBiz = this.mTskTaskBizService.findByTaskId(taskId);
        if (null == taskBiz) {
            result = "\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u5ba1\u6838/\u590d\u6838";
            return result;
        }
        TbtskObjectinfo tableInfo = this.mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        if (null == tableInfo) {
            result = "\u4e1a\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u5ba1\u6838/\u590d\u6838";
            return result;
        }
        for (Map data : dataList) {
            id = MapUtils.getString((Map)data, (Object)"f_id", (String)"");
            status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
            xzqdm = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
            reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
            rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
            if (data != null && status >= TbStatusEnum.WAITING_VERIFY.getCode()) {
                TbtskApproveRecord approveRecord = new TbtskApproveRecord();
                approveRecord.setApproveUserId(userId);
                approveRecord.setApproveTime(new Date());
                approveRecord.setStatus(Integer.valueOf(1));
                approveRecord.setTaskid(taskId);
                approveRecord.setXzqdm(xzqdm);
                approveRecord.setDescription(description);
                approveRecord.setRemark(remark);
                approveRecord.setOption(option);
                approveRecord.setTbid(id);
                approveRecord.setApproveUser(approveUser);
                approveRecord.setRejectCount(Integer.valueOf(rejectCount != null ? rejectCount : 0));
                Integer index = null;
                List recordList = this.tbtskApproveRecordRepository.findApproveRecordOrderByTime(approveRecord.getTaskid(), approveRecord.getTbid());
                TbtskRejectRecord tbtskRejectRecord = this.tbtskRejectRecordRepository.findTopOneByTbIdOrderByRejectTime(approveRecord.getTaskid(), approveRecord.getTbid());
                if (recordList.size() > 0) {
                    index = ((TbtskApproveRecord)recordList.get(0)).getStepindex();
                }
                if (tbtskRejectRecord != null && tbtskRejectRecord.getRejectTime().compareTo(((TbtskApproveRecord)recordList.get(0)).getApproveTime()) == 1) {
                    index = null;
                }
                List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
                index = index == null ? 0 : index + 1;
                FlowStep flowStep = flowSteps.get(index);
                boolean isAudit = false;
                if (reviewStage != null) {
                    if (type == 0) {
                        if (flowStep.getName().equalsIgnoreCase("\u6751\u7ea7\u5ba1\u6838")) {
                            if (reviewStage.equals(ReviewStageEnum.VILLAGE_VERIFY.getCode()) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("\u4e61\u9547\u5ba1\u6838")) {
                            if ((reviewStage.equals(ReviewStageEnum.TOWN_VERIFY.getCode()) || reviewStage.equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("\u533a\u53bf\u5ba1\u6838")) {
                            if (reviewStage.equals(ReviewStageEnum.COUNTY_VERIFY.getCode()) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("\u5e02\u7ea7\u5ba1\u6838")) {
                            if (reviewStage.equals(ReviewStageEnum.CITY_VERIFY.getCode()) && userLevel == 3) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("\u7701\u7ea7\u5ba1\u6838") && reviewStage.equals(ReviewStageEnum.PROVINCE_VERIFY.getCode()) && userLevel == 2) {
                            isAudit = true;
                        }
                    } else if (flowStep.getName().equalsIgnoreCase("\u6751\u7ea7\u590d\u6838")) {
                        if (reviewStage.equals(ReviewStageEnum.VILLAGE_VERIFY.getCode()) && userLevel == 4) {
                            isAudit = true;
                        }
                    } else if (flowStep.getName().equalsIgnoreCase("\u4e61\u9547\u590d\u6838")) {
                        if ((reviewStage.equals(ReviewStageEnum.TOWN_VERIFY.getCode()) || reviewStage.equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) && userLevel == 4) {
                            isAudit = true;
                        }
                    } else if (flowStep.getName().equalsIgnoreCase("\u533a\u53bf\u590d\u6838")) {
                        if (reviewStage.equals(ReviewStageEnum.COUNTY_VERIFY.getCode()) && userLevel == 4) {
                            isAudit = true;
                        }
                    } else if (flowStep.getName().equalsIgnoreCase("\u5e02\u7ea7\u590d\u6838")) {
                        if (reviewStage.equals(ReviewStageEnum.CITY_VERIFY.getCode()) && userLevel == 3) {
                            isAudit = true;
                        }
                    } else if (flowStep.getName().equalsIgnoreCase("\u7701\u7ea7\u590d\u6838") && reviewStage.equals(ReviewStageEnum.PROVINCE_VERIFY.getCode()) && userLevel == 2) {
                        isAudit = true;
                    }
                    if (isAudit) {
                        approveRecord.setStepindex(flowStep.getIndex());
                        approveRecord.setStepname(flowStep.getName());
                        approveRecord.setNextstep(Integer.valueOf(flowStep.getIndex() + 1));
                    }
                }
                if (approveRecord.getStepindex() != null && approveRecord.getStepname() != null && (type == 0 && status >= 10 && !status.equals(TbStatusEnum.WAITING_REVIEW.getCode()) && !status.equals(TbStatusEnum.REVIEW_NOT_PASS.getCode()) || type == 1 && (status.equals(TbStatusEnum.WAITING_REVIEW.getCode()) || status.equals(TbStatusEnum.REVIEW_NOT_PASS.getCode())))) {
                    approveRecordCacheList.add(approveRecord);
                    if (!GutilCollection.isEmpty(flowSteps)) {
                        for (int i = 0; i < flowSteps.size(); ++i) {
                            FlowStep flowStep1 = flowSteps.get(i);
                            if (!index.equals(flowStep1.getIndex())) continue;
                            String stage = flowStep1.getPost_stage();
                            if (approveRecord.getStepindex() % 2 == 0) {
                                if (approveRecord.getOption().equals(1)) {
                                    data.put("f_status", TbStatusEnum.WAITING_REVIEW.getCode());
                                    continue;
                                }
                                if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                    data.put("f_status", TbStatusEnum.WAITING_REVIEW.getCode());
                                    continue;
                                }
                                data.put("f_status", TbStatusEnum.VERIFY_NOT_PASS.getCode());
                                continue;
                            }
                            if (approveRecord.getOption().equals(1)) {
                                if (!StringUtils.isNotBlank((CharSequence)stage)) continue;
                                data.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
                                data.put("f_review_stage", Integer.valueOf(stage));
                                continue;
                            }
                            if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                if (!StringUtils.isNotBlank((CharSequence)stage)) continue;
                                data.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
                                data.put("f_review_stage", Integer.valueOf(stage));
                                continue;
                            }
                            data.put("f_status", TbStatusEnum.REVIEW_NOT_PASS.getCode());
                        }
                    }
                    data.put("f_updatetime", System.currentTimeMillis());
                    this.mDataBizService.updateData(tableInfo.getfTablename(), data, "f_id='" + id + "'");
                }
            }
            if (approveRecordCacheList.size() != 100) continue;
            this.tbtskApproveRecordRepository.saveAll(approveRecordCacheList);
            approveRecordCacheList.clear();
        }
        if (!approveRecordCacheList.isEmpty()) {
            this.tbtskApproveRecordRepository.saveAll(approveRecordCacheList);
            approveRecordCacheList.clear();
        }
        result = "\u6279\u91cf\u5ba1\u6838/\u590d\u6838\u5b8c\u6210";
        return result;
    }

    public String rejectBatchByList(List<Map> dataList, Integer type, String taskId, Long userId, String remark, String description, String userName, String stepName, String result) {
        List list;
        result = "\u6253\u56de\u5931\u8d25";
        if (dataList == null || dataList.size() == 0) {
            result = "\u56fe\u6591\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
            return result;
        }
        boolean userLevel = false;
        List<Object> areaList = new ArrayList();
        if (type == 0) {
            list = this.tbtskUserAuditAreaService.listAuditAreas(taskId, userId.toString());
            areaList = list.stream().map(a -> a.getRegionCode()).collect(Collectors.toList());
        } else if (type == 1) {
            list = this.tbtskUserReviewAreaService.listReviewAreas(taskId, userId.toString());
            areaList = list.stream().map(a -> a.getRegionCode()).collect(Collectors.toList());
        }
        ArrayList<String> submitUserIds = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<TbtskRejectRecord> tbtskRejectRecordCacheData = new ArrayList<TbtskRejectRecord>();
        if (dataList != null && dataList.size() > 0) {
            JSONArray id2RejectIdArray = new JSONArray();
            String id = "";
            Integer status = null;
            Integer reviewStage = null;
            Integer rejectCount = 0;
            String xzqdm = "";
            String submitUserId = null;
            TskTaskBiz taskBiz = this.mTskTaskBizService.findByTaskId(taskId);
            if (taskBiz.getIsApprove() == 1) {
                TbtskRejectDef tbtskRejectDef = this.mTbtskRejectDefService.selectByTaskId(taskId);
                TbtskObjectinfo tableInfo = this.mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
                for (Map data : dataList) {
                    if (data == null) continue;
                    id = MapUtils.getString((Map)data, (Object)"f_id", (String)"");
                    status = MapUtils.getInteger((Map)data, (Object)"f_status", null);
                    reviewStage = MapUtils.getInteger((Map)data, (Object)"f_review_stage", null);
                    rejectCount = MapUtils.getInteger((Map)data, (Object)"f_reject_count", (Integer)0);
                    submitUserId = MapUtils.getString((Map)data, (Object)"f_submit_userid", (String)"");
                    xzqdm = MapUtils.getString((Map)data, (Object)"f_xzqdmsys", (String)"");
                    boolean booleanarea = false;
                    for (String string : areaList) {
                        if (string.endsWith("0000")) {
                            if (!string.substring(0, 2).equals(xzqdm.substring(0, 2))) continue;
                            booleanarea = true;
                            break;
                        }
                        if (string.endsWith("00")) {
                            if (!string.substring(0, 4).equals(xzqdm.substring(0, 4))) continue;
                            booleanarea = true;
                            break;
                        }
                        if (!string.equals(xzqdm.substring(0, string.length()))) continue;
                        booleanarea = true;
                        break;
                    }
                    Integer index = null;
                    List list2 = this.tbtskApproveRecordRepository.findApproveRecordOrderByTime(taskId, id);
                    TbtskRejectRecord tbtskRejectRecord = this.tbtskRejectRecordRepository.findTopOneByTbIdOrderByRejectTime(taskId, id);
                    if (list2.size() > 0) {
                        index = ((TbtskApproveRecord)list2.get(0)).getStepindex();
                    }
                    if (tbtskRejectRecord != null && tbtskRejectRecord.getRejectTime().compareTo(((TbtskApproveRecord)list2.get(0)).getApproveTime()) == 1) {
                        index = null;
                    }
                    List<FlowStep> flowSteps = this.findFlowSteps(taskId, FlowTypeEnum.AUDIT);
                    index = index == null ? 0 : index + 1;
                    FlowStep flowStep = flowSteps.get(index);
                    if (status != null && status >= TbStatusEnum.WAITING_VERIFY.getCode()) {
                        int currentCount = rejectCount != null ? rejectCount : 0;
                        boolean isReject = false;
                        if (type == 0 && status >= TbStatusEnum.WAITING_VERIFY.getCode() && !status.equals(TbStatusEnum.WAITING_REVIEW.getCode()) && !status.equals(TbStatusEnum.REVIEW_NOT_PASS.getCode()) || type == 1 && (status.equals(TbStatusEnum.WAITING_REVIEW.getCode()) || status.equals(TbStatusEnum.REVIEW_NOT_PASS.getCode()))) {
                            if (type == 0) {
                                if (flowStep.getPre_stages().contains(reviewStage.toString()) && booleanarea && flowStep.getName().contains("\u5ba1\u6838")) {
                                    isReject = true;
                                }
                            } else if (flowStep.getPre_stages().contains(reviewStage.toString()) && booleanarea && flowStep.getName().contains("\u590d\u6838")) {
                                isReject = true;
                            }
                            if (isReject) {
                                List tbtskApproveRecords;
                                if (tbtskRejectDef != null && tbtskRejectDef.getRejectType() == 1) {
                                    HashMap<String, Object> updateMap = new HashMap<String, Object>();
                                    updateMap.put("f_reject_count", currentCount + 1);
                                    updateMap.put("f_status", TbStatusEnum.SUBMIT.getCode());
                                    updateMap.put("f_review_stage", ReviewStageEnum.OPERATOR_VERIFY.getCode());
                                    updateMap.put("f_updatetime", System.currentTimeMillis());
                                    this.mDataBizService.updateData(tableInfo.getfTablename(), updateMap, "f_id='" + id + "'");
                                    ids.add(id);
                                    tbtskRejectRecordCacheData.add(this.saveRejectRecordNew(taskId, userId, remark, description, userName, flowStep.getName(), id, reviewStage));
                                    submitUserIds.add(submitUserId != null ? submitUserId : "");
                                } else if (tbtskRejectDef != null && tbtskRejectDef.getRejectType() == 2 && (tbtskApproveRecords = this.tbtskApproveRecordRepository.findApproveRecordOrderByStepAndTime(taskId, id)).size() > 0) {
                                    FlowStep flow = this.findFlow(taskId, 1, ((TbtskApproveRecord)tbtskApproveRecords.get(0)).getStepindex() - 1);
                                    HashMap<String, Object> updateMap = new HashMap<String, Object>();
                                    updateMap.put("f_reject_count", currentCount + 1);
                                    updateMap.put("f_status", flow.getPost_status());
                                    updateMap.put("f_review_stage", flow.getPost_stage());
                                    updateMap.put("f_updatetime", System.currentTimeMillis());
                                    this.mDataBizService.updateData(tableInfo.getfTablename(), updateMap, "f_id='" + id + "'");
                                    ids.add(id);
                                    tbtskRejectRecordCacheData.add(this.saveRejectRecordNew(taskId, userId, remark, description, userName, flowStep.getName(), id, reviewStage));
                                    submitUserIds.add(submitUserId != null ? submitUserId : "");
                                }
                            }
                        }
                    }
                    if (tbtskRejectRecordCacheData.size() < 100) continue;
                    List tbtskRejectRecords = this.tbtskRejectRecordRepository.saveAll(tbtskRejectRecordCacheData);
                    for (TbtskRejectRecord tbtskRejectRecord1 : tbtskRejectRecords) {
                        id2RejectIdArray.add((Object)(tbtskRejectRecord1.getTbid() + ":" + tbtskRejectRecord1.getId()));
                    }
                    tbtskRejectRecordCacheData.clear();
                }
                if (tbtskRejectRecordCacheData.size() > 0) {
                    List tbtskRejectRecords = this.tbtskRejectRecordRepository.saveAll(tbtskRejectRecordCacheData);
                    for (TbtskRejectRecord tbtskRejectRecord : tbtskRejectRecords) {
                        id2RejectIdArray.add((Object)(tbtskRejectRecord.getTbid() + ":" + tbtskRejectRecord.getId()));
                    }
                    tbtskRejectRecordCacheData.clear();
                }
                if (submitUserIds.size() > 0) {
                    this.sendRejectMessageToAPPByPlatform(ids, userId, submitUserIds, description, remark, id2RejectIdArray, tableInfo, taskId);
                }
                result = "\u6253\u56de\u6210\u529f";
            }
        }
        return result;
    }

    public static String getNodeAuditNum(Object currentNode) {
        switch (currentNode.toString()) {
            case "\u6751\u7ea7\u5ba1\u6838": {
                return "1";
            }
            case "\u4e61\u9547\u5ba1\u6838": {
                return "2";
            }
            case "\u533a\u53bf\u5ba1\u6838": {
                return "3";
            }
            case "\u5e02\u7ea7\u5ba1\u6838": {
                return "4";
            }
            case "\u7701\u7ea7\u5ba1\u6838": {
                return "5";
            }
            case "\u56fd\u5bb6\u5ba1\u6838": {
                return "6";
            }
        }
        return "";
    }

    public Pair<Boolean, Object> queryTaskFlowInfo(String taskId, FlowTypeEnum audit, Long userId) {
        FlowDefInfoDTO flowDefInfoDTO = new FlowDefInfoDTO();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TskTaskBiz tskTaskBiz;
            List tbtskRejectDefs;
            flowDefInfoDTO.setTaskId(taskId);
            List tbtskFlowDefs = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, Integer.valueOf(FlowTypeEnum.AUDIT.getCode()));
            if (!GutilCollection.isEmpty((Collection)tbtskFlowDefs)) {
                TbtskFlowDef flowDef = (TbtskFlowDef)tbtskFlowDefs.get(0);
                flowDefInfoDTO.setFlowId(flowDef.getId());
                flowDefInfoDTO.setFlowName(flowDef.getName());
                flowDefInfoDTO.setFlowAuditType(Integer.valueOf(1));
                if (StringUtils.isNotBlank((CharSequence)flowDef.getSteps())) {
                    flowDefInfoDTO.setFlowAuditType(Integer.valueOf(1));
                    ArrayList<String> nodes = new ArrayList<String>();
                    JSONArray stepsArray = JSON.parseArray((String)flowDef.getSteps(), (Feature[])new Feature[0]);
                    if (stepsArray != null && !stepsArray.isEmpty()) {
                        for (Object o : stepsArray) {
                            String num;
                            JSONObject jsonObject = JSONObject.parseObject((String)o.toString());
                            if (jsonObject == null || !jsonObject.containsKey((Object)"name") || !StringUtils.isNotBlank((CharSequence)jsonObject.get((Object)"name").toString())) continue;
                            if (jsonObject.get((Object)"name").toString().contains("\u590d\u6838")) {
                                flowDefInfoDTO.setFlowAuditType(Integer.valueOf(2));
                            }
                            if (!StringUtils.isNotBlank((CharSequence)(num = MTbtskFlowService.getNodeAuditNum(jsonObject.get((Object)"name").toString())))) continue;
                            nodes.add(num);
                        }
                    }
                    flowDefInfoDTO.setFlowNodes(StringUtils.join(nodes, (CharSequence)","));
                }
            }
            if (!GutilCollection.isEmpty((Collection)(tbtskRejectDefs = this.tbtskRejectDefMapper.queryByTaskid(taskId)))) {
                TbtskRejectDef rejectDef = (TbtskRejectDef)tbtskRejectDefs.get(0);
                flowDefInfoDTO.setRejectId(rejectDef.getId());
                flowDefInfoDTO.setFlowAuditType(rejectDef.getRejectType());
            }
            if ((tskTaskBiz = this.mTskTaskBizService.findOne(taskId)) != null) {
                flowDefInfoDTO.setCanRevoke(tskTaskBiz.getCanRevoke());
            }
        }
        return Pair.of((Object)false, null);
    }

    private List<String> getAuditFieldNameCollection() {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        fieldNameList.add("f_id");
        fieldNameList.add("f_status");
        fieldNameList.add("f_xzqdmsys");
        fieldNameList.add("f_reject_status");
        fieldNameList.add("f_review_stage");
        fieldNameList.add("f_reject_count");
        return fieldNameList;
    }

    public JSONArray queryCustomRejectAvailableStages(String taskId, String tbId, String currentStepName, Long userId) {
        JSONArray jsonArray;
        TbtskFlowDef flowDef;
        JSONArray resultArray = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("index", (Object)-1);
        jsonObj.put("name", (Object)"\u4f5c\u4e1a\u5458");
        resultArray.add((Object)jsonObj);
        List tbtskFlowDefs = this.tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, Integer.valueOf(FlowTypeEnum.AUDIT.getCode()));
        if (!GutilCollection.isEmpty((Collection)tbtskFlowDefs) && (flowDef = (TbtskFlowDef)tbtskFlowDefs.get(0)) != null && StringUtils.isNotBlank((CharSequence)flowDef.getSteps()) && (jsonArray = JSONArray.parseArray((String)flowDef.getSteps(), (Feature[])new Feature[0])) != null) {
            JSONObject jsonObject;
            for (int i = 0; i < jsonArray.size() && !(jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonArray.get(i)))).get((Object)"name").toString().equals(currentStepName); ++i) {
                JSONObject stepJsonObj = new JSONObject();
                stepJsonObj.put("index", jsonObject.get((Object)"index"));
                stepJsonObj.put("name", jsonObject.get((Object)"name"));
                resultArray.add((Object)stepJsonObj);
            }
        }
        return resultArray;
    }
}

