/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskImageScreenshotRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskImageScreenshot;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Service
@Transactional(rollbackFor={Exception.class})
public class MTbtskImageScreenshotService {
    private static final Logger log = LoggerFactory.getLogger(MTbtskImageScreenshotService.class);
    @Autowired
    TbtskImageScreenshotRepository tbtskImageScreenshotRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    DataBizService dataBizService;

    public void importTaskScreenshotData(HttpServletRequest request, String taskId, Long userId) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        ArrayList tbtskImageScreenshots = new ArrayList();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                File[] oldfiles;
                MultipartFile imageFile = multiRequest.getFile((String)iter.next());
                if (imageFile == null) continue;
                File zipFile = null;
                File dir = new File(this.uploadDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                zipFile = File.createTempFile("tmp", ".zip", dir);
                FileUtils.copyInputStreamToFile((InputStream)imageFile.getInputStream(), (File)zipFile);
                String zipName = zipFile.getAbsolutePath();
                String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
                MTbtskImageScreenshotService.unzip(zipName, unzipFileDir);
                File file = new File(unzipFileDir);
                if (file.isDirectory() && (oldfiles = file.listFiles()) != null) {
                    for (File f : oldfiles) {
                        String tbbh = f.getName();
                        File[] files = f.listFiles();
                        if (files == null) continue;
                        for (File f1 : files) {
                            if (!f1.isDirectory()) continue;
                            String type = f1.getName();
                            File[] imagefiles = f1.listFiles();
                            if (files == null) continue;
                            for (File image : imagefiles) {
                                String fileName = image.getName();
                                String ext = fileName.substring(fileName.lastIndexOf("."), fileName.length());
                                if (!ext.equals(".tif")) continue;
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                String dateString = sdf.format(new Date());
                                String obsFilePath = "taskScreenshot/" + taskId + "/" + tbbh + "/" + dateString + "/" + fileName;
                                List dataList = this.dataBizService.queryAllData(tableInfo.getfTablename(), Arrays.asList("f_id"), "f_dkbh='" + tbbh + "'");
                                if (dataList == null || dataList.size() <= 0) continue;
                                List tbtskImageScreenshotList = this.tbtskImageScreenshotRepository.findByTaskIdAndTbIdAndType(taskId, ((Map)dataList.get(0)).get("f_id").toString(), Integer.valueOf(type));
                                if (tbtskImageScreenshotList.size() > 0) {
                                    FileInputStream fileInputStream = new FileInputStream(image);
                                    String imgUrl = this.ossOperatorService.sendObject2Oss(obsFilePath, (InputStream)fileInputStream);
                                    ((TbtskImageScreenshot)tbtskImageScreenshotList.get(0)).setUrl(imgUrl);
                                    ((TbtskImageScreenshot)tbtskImageScreenshotList.get(0)).setUpdateTime(new Date());
                                    tbtskImageScreenshots.add(tbtskImageScreenshotList.get(0));
                                    continue;
                                }
                                TbtskImageScreenshot tbtskImageScreenshot = new TbtskImageScreenshot();
                                tbtskImageScreenshot.setTaskId(taskId);
                                tbtskImageScreenshot.setTbId(((Map)dataList.get(0)).get("f_id").toString());
                                tbtskImageScreenshot.setType(Integer.valueOf(type));
                                tbtskImageScreenshot.setCreateTime(new Date());
                                FileInputStream fileInputStream = new FileInputStream(image);
                                String imgUrl = this.ossOperatorService.sendObject2Oss(obsFilePath, (InputStream)fileInputStream);
                                tbtskImageScreenshot.setUrl(imgUrl);
                                tbtskImageScreenshot.setUserId(userId);
                                tbtskImageScreenshot.setName(fileName);
                                tbtskImageScreenshots.add(tbtskImageScreenshot);
                            }
                        }
                    }
                }
                FileUtils.deleteQuietly((File)new File(unzipFileDir));
                FileUtils.deleteQuietly((File)zipFile);
            }
        }
        this.tbtskImageScreenshotRepository.saveAll(tbtskImageScreenshots);
    }

    public List<TbtskImageScreenshot> findImageScreenshots(String taskId, String tbId) {
        List tbtskImageScreenshots = this.tbtskImageScreenshotRepository.findByTaskIdAndTbIdOrderByCreateTime(taskId, tbId);
        for (TbtskImageScreenshot tbtskImageScreenshot : tbtskImageScreenshots) {
            if (tbtskImageScreenshot.getUrl() == null || tbtskImageScreenshot.getUrl().contains("AccessKeyId")) continue;
            String temporarySignedUrl = this.temporarySignedUrlService.getTemporarySignedUrl("", tbtskImageScreenshot.getUrl(), null);
            tbtskImageScreenshot.setTemporaryUrl(temporarySignedUrl);
        }
        return tbtskImageScreenshots;
    }

    public static void unzip(String zipFilePath, String destDir) throws IOException {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ZipFile zipFile = new ZipFile(zipFilePath);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            String entryName = entry.getName();
            String fileDestPath = destDir + File.separator + entryName;
            if (!entry.isDirectory()) {
                int bytesRead;
                File destFile = new File(fileDestPath);
                destFile.getParentFile().mkdirs();
                InputStream inputStream = zipFile.getInputStream(entry);
                FileOutputStream outputStream = new FileOutputStream(destFile);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                continue;
            }
            File dirToCreate = new File(fileDestPath);
            dirToCreate.mkdirs();
        }
        zipFile.close();
    }
}

