/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.BizAreaRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskGroupRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTemplateAreaRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTemplateRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskGroup;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTemplate;
import com.geoway.landteam.customtask.task.entity.TbtskTemplateArea;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.PinYinUtil;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilStr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MTbtskTemplateService {
    @Autowired
    TbtskTemplateRepository tbtskTemplateDao;
    @Autowired
    BizAreaRepository bizAreaRepository;
    @Autowired
    TbtskObjectinfoRepository objectDao;
    @Autowired
    TbtskFieldsRepository fieldsDao;
    @Autowired
    TbtskGroupRepository groupDao;
    @Autowired
    TskTaskBizRepository taskBizDao;
    @Autowired
    TbtskTemplateAreaRepository templateAreaDao;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    TbtskGroupRepository tbtskGroupRepository;
    @Autowired
    TbtskTemplateAreaRepository tbtskTemplateAreaRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    final String LISTCODE = "100";
    final String FILTERCODE = "101";
    final String DETAILCODE = "202";
    final String SEARCHCODE = "102";
    final String MAINCODE = "103";
    final String FILTERSYSCODE = "104";
    final String ORDERCODE = "105";

    @Transactional(rollbackFor={Exception.class})
    public TbtskTemplate save(TbtskTemplate template, String regions, String username, Long userId) {
        if (GutilStr.isEmpty((CharSequence)template.getId())) {
            template.setFinish(Integer.valueOf(0));
            template.setCreateTime(new Date());
            template.setCreator(userId.toString());
            TbtskObjectinfo table = new TbtskObjectinfo();
            table = (TbtskObjectinfo)this.objectDao.save((Object)table);
            template.setTableId(table.getfId());
            template = (TbtskTemplate)this.tbtskTemplateDao.save((Object)template);
            table.setParentId(template.getId());
            table.setfTablename(table.getfId());
            this.objectDao.save((Object)table);
            this.addDefaultFieldsToTemplate(template);
        } else {
            TbtskTemplate oldTemplate = this.tbtskTemplateDao.findById((Object)template.getId()).orElse(null);
            oldTemplate.setDesc(template.getDesc());
            oldTemplate.setName(template.getName());
            oldTemplate.setScope(template.getScope());
            oldTemplate.setEnable(template.getEnable());
            oldTemplate.setClassId(template.getClassId());
            oldTemplate.setProjectType(template.getProjectType());
            this.tbtskTemplateDao.save((Object)oldTemplate);
        }
        String id = template.getId();
        if (regions != null) {
            JSONArray regionJson = JSONArray.parseArray((String)regions, (Feature[])new Feature[0]);
            ArrayList<TbtskTemplateArea> templateAreas = new ArrayList<TbtskTemplateArea>();
            for (int i = 0; i < regionJson.size(); ++i) {
                JSONObject jsonObject = regionJson.getJSONObject(i);
                templateAreas.add(new TbtskTemplateArea(jsonObject.getString("code"), id, jsonObject.getInteger("type")));
            }
            this.templateAreaDao.deleteByTemplateId(id);
            this.templateAreaDao.saveAll(templateAreas);
        }
        return template;
    }

    @Transactional
    public TbtskTemplate save(TbtskTemplate template) {
        template = (TbtskTemplate)this.tbtskTemplateDao.save((Object)template);
        return template;
    }

    public TbtskTemplate findById(String id) {
        return this.tbtskTemplateDao.findById((Object)id).orElse(null);
    }

    public Page<TbtskTemplate> findPages(String filterParam, String sortParam, int page, int limit) {
        return this.tbtskTemplateDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
    }

    public List<TbtskTemplateArea> getTemplateAreas(String id) {
        return this.templateAreaDao.getAllByTemplateId(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTemplate(String id) throws Exception {
        TbtskTemplate template = this.tbtskTemplateDao.findById((Object)id).orElse(null);
        if (template == null) {
            throw new RuntimeException("\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        TbtskObjectinfo tbtskObjectinfo = this.objectDao.findById((Object)template.getId()).orElse(null);
        if (tbtskObjectinfo != null) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(tbtskObjectinfo.getfId());
            this.fieldsDao.deleteInTableIds(ids);
            this.groupDao.deleteByFTablename(tbtskObjectinfo.getfTablename());
            this.objectDao.delete((Object)tbtskObjectinfo);
        }
        this.tbtskTemplateDao.deleteById((Object)id);
        this.templateAreaDao.deleteByTemplateId(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void instantiateTemplate(TskTaskBiz task, String templateId) {
        if (task.getTemplateId() == null || !task.getTemplateId().equals(templateId)) {
            Object configArgsObject;
            TbtskTemplate template = this.tbtskTemplateDao.findById((Object)templateId).orElse(null);
            TbtskObjectinfo tableTemplate = this.objectDao.findById((Object)template.getTableId()).orElse(null);
            TbtskObjectinfo table = null;
            if (GutilStr.isBlank((CharSequence)task.getTableId())) {
                TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
                tbtskObjectinfo.setfTablealias(task.getName());
                tbtskObjectinfo.setfIsspatial(tableTemplate.getfIsspatial());
                tbtskObjectinfo.setfState("1");
                tbtskObjectinfo.setfVersion("1");
                tbtskObjectinfo.setfTableversion(Integer.valueOf(0));
                tbtskObjectinfo.setParentId("-1");
                tbtskObjectinfo.setTemplateId(templateId);
                table = (TbtskObjectinfo)this.objectDao.save((Object)tbtskObjectinfo);
            } else {
                boolean existTableName;
                table = this.objectDao.findById((Object)task.getTableId()).orElse(null);
                if (GutilStr.isNotBlank((CharSequence)table.getfTablename()) && (existTableName = this.mDataBizService.isExistTableName(table.getfTablename())) && this.mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0 && !task.getTemplateId().equals(templateId)) {
                    throw new GwValidateException("\u4efb\u52a1\u8868\u5df2\u7ecf\u521b\u5efa,\u5e76\u4e14\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4efb\u52a1\u6a21\u677f");
                }
                table.setParentId("-1");
                table.setTemplateId(templateId);
                table.setfVersion(Integer.valueOf(table.getfVersion()) + 1 + "");
                table.setfTableversion(Integer.valueOf(table.getfTableversion() == null ? 1 : table.getfTableversion() + 1));
                this.objectDao.save((Object)table);
            }
            task.setTemplateId(templateId);
            String tableId = table.getfId();
            String tableName = Optional.ofNullable(table.getfTablename()).orElse("");
            task.setTableId(table.getfId());
            task.setStatus("0");
            this.taskBizDao.save((Object)task);
            List fields = this.fieldsDao.getTbtskFieldsByTableid(template.getTableId());
            List oldfields = this.fieldsDao.getTbtskFieldsByTableid(table.getfId());
            List fieldIds = oldfields.stream().map(r -> r.getfId()).collect(Collectors.toList());
            List listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismy")).collect(Collectors.toList());
            ArrayList<TbtskFields> tbtskFields = new ArrayList<TbtskFields>();
            if (listTemp == null || listTemp.size() < 1) {
                TbtskFields temp = new TbtskFields();
                temp.setfId(UUID.randomUUID().toString());
                temp.setfFieldname("f_ismy");
                temp.setfTableid(tableId);
                temp.setfAlias("\u662f\u5426\u81ea\u5df1\u56fe\u6591\uff08app\u7aef\u4f7f\u7528\uff09");
                temp.setfFieldtype("8");
                temp.setfNullable(Integer.valueOf(0));
                temp.setfDefaultvalue("0");
                temp.setfIsBase(Integer.valueOf(0));
                temp.setfIsOutwork(Integer.valueOf(0));
                temp.setfIsListShow(Integer.valueOf(0));
                temp.setfIsWebCheck(Integer.valueOf(0));
                temp.setfIsStatis(Integer.valueOf(0));
                temp.setfIsWebEdit(Integer.valueOf(0));
                temp.setfIsMust(Integer.valueOf(0));
                temp.setfFieldInnerOuterSys(Integer.valueOf(4));
                tbtskFields.add(temp);
            }
            if (StringUtils.isNotBlank((CharSequence)task.getConfigArgs()) && ((configArgsObject = JSONObject.parseObject((String)task.getConfigArgs())).getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot") == 1 || configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot") == 1)) {
                TbtskFields temp;
                listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_issplitted")).collect(Collectors.toList());
                if (listTemp == null || listTemp.size() < 1) {
                    temp = new TbtskFields();
                    temp.setfId(UUID.randomUUID().toString());
                    temp.setfFieldname("f_issplitted");
                    temp.setfTableid(tableId);
                    temp.setfAlias("\u662f\u5426\u5206\u5272(\u7cfb\u7edf)");
                    temp.setfFieldtype("8");
                    temp.setfNullable(Integer.valueOf(1));
                    temp.setfDefaultvalue("0");
                    temp.setfIsBase(Integer.valueOf(0));
                    temp.setfIsOutwork(Integer.valueOf(0));
                    temp.setfIsListShow(Integer.valueOf(0));
                    temp.setfIsWebCheck(Integer.valueOf(0));
                    temp.setfIsStatis(Integer.valueOf(0));
                    temp.setfIsWebEdit(Integer.valueOf(0));
                    temp.setfIsMust(Integer.valueOf(0));
                    temp.setfFieldInnerOuterSys(Integer.valueOf(4));
                    fields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_splitedid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    temp = new TbtskFields();
                    temp.setfId(UUID.randomUUID().toString());
                    temp.setfFieldname("f_splitedid");
                    temp.setfTableid(tableId);
                    temp.setfAlias("\u88ab\u5206\u5272\u539f\u59cb\u56fe\u6591id(\u7cfb\u7edf)");
                    temp.setfFieldtype("1");
                    temp.setfNullable(Integer.valueOf(1));
                    temp.setfIsBase(Integer.valueOf(0));
                    temp.setfIsOutwork(Integer.valueOf(0));
                    temp.setfIsListShow(Integer.valueOf(0));
                    temp.setfIsWebCheck(Integer.valueOf(0));
                    temp.setfIsStatis(Integer.valueOf(0));
                    temp.setfIsWebEdit(Integer.valueOf(0));
                    temp.setfIsMust(Integer.valueOf(0));
                    temp.setfFieldInnerOuterSys(Integer.valueOf(4));
                    fields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_mergeid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    temp = new TbtskFields();
                    temp.setfId(UUID.randomUUID().toString());
                    temp.setfFieldname("f_mergeid");
                    temp.setfTableid(tableId);
                    temp.setfAlias("\u5408\u5e76\u7684\u56fe\u6591id(\u7cfb\u7edf)");
                    temp.setfFieldtype("1");
                    temp.setfNullable(Integer.valueOf(1));
                    temp.setfIsBase(Integer.valueOf(0));
                    temp.setfIsOutwork(Integer.valueOf(0));
                    temp.setfIsListShow(Integer.valueOf(0));
                    temp.setfIsWebCheck(Integer.valueOf(0));
                    temp.setfIsStatis(Integer.valueOf(0));
                    temp.setfIsWebEdit(Integer.valueOf(0));
                    temp.setfIsMust(Integer.valueOf(0));
                    temp.setfFieldInnerOuterSys(Integer.valueOf(4));
                    fields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_pid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    temp = new TbtskFields();
                    temp.setfId(UUID.randomUUID().toString());
                    temp.setfFieldname("f_pid");
                    temp.setfTableid(tableId);
                    temp.setfAlias("\u591a\u90e8\u4ef6\u4e0a\u7ea7\u56fe\u6591id(\u7cfb\u7edf)");
                    temp.setfFieldtype("1");
                    temp.setfNullable(Integer.valueOf(1));
                    temp.setfIsBase(Integer.valueOf(0));
                    temp.setfIsOutwork(Integer.valueOf(0));
                    temp.setfIsListShow(Integer.valueOf(0));
                    temp.setfIsWebCheck(Integer.valueOf(0));
                    temp.setfIsStatis(Integer.valueOf(0));
                    temp.setfIsWebEdit(Integer.valueOf(0));
                    temp.setfIsMust(Integer.valueOf(0));
                    temp.setfFieldInnerOuterSys(Integer.valueOf(4));
                    fields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismultipart")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    temp = new TbtskFields();
                    temp.setfId(UUID.randomUUID().toString());
                    temp.setfFieldname("f_ismultipart");
                    temp.setfTableid(tableId);
                    temp.setfAlias("\u662f\u5426\u591a\u90e8\u4ef6(\u7cfb\u7edf)");
                    temp.setfFieldtype("1");
                    temp.setfNullable(Integer.valueOf(1));
                    temp.setfIsBase(Integer.valueOf(0));
                    temp.setfIsOutwork(Integer.valueOf(0));
                    temp.setfIsListShow(Integer.valueOf(0));
                    temp.setfIsWebCheck(Integer.valueOf(0));
                    temp.setfIsStatis(Integer.valueOf(0));
                    temp.setfIsWebEdit(Integer.valueOf(0));
                    temp.setfIsMust(Integer.valueOf(0));
                    temp.setfFieldInnerOuterSys(Integer.valueOf(4));
                    fields.add(temp);
                }
            }
            this.fieldsDao.deleteInTableIds(Arrays.asList(table.getfId()));
            if (!fieldIds.isEmpty()) {
                this.groupDao.deleteInFieldIds(fieldIds);
            }
            this.groupDao.deleteByFTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
            for (Object r2 : fields) {
                TbtskFields field = new TbtskFields();
                BeanUtil.copyProperties((Object)r2, (Object)field, (String[])new String[]{"fId", "fTableid", "fTablename"});
                field.setfTableid(tableId);
                field.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                tbtskFields.add(field);
                this.fieldsDao.save((Object)field);
                List groups = this.groupDao.findByFFieldid(r2.getfId());
                for (TbtskGroup g : groups) {
                    TbtskGroup tg = new TbtskGroup();
                    BeanUtil.copyProperties((Object)g, (Object)tg, (String[])new String[]{"fId", "fFieldid"});
                    tg.setfFieldid(field.getfId());
                    tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                    tg.setConnection(this.changeConnectionFomat(g.getConnection(), (TbtskFields)r2));
                    tg.setVisible(g.getVisible());
                    this.groupDao.save((Object)tg);
                }
            }
            List groups = this.groupDao.getFiledIdIsNull(template.getTableId());
            for (TbtskGroup g : groups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties((Object)g, (Object)tg, (String[])new String[]{"fId"});
                tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                this.groupDao.save((Object)tg);
            }
            List sysFieldGroups = this.groupDao.selectByTableNameAndGroupcode("web", template.getTableId(), "104");
            for (TbtskGroup g1 : sysFieldGroups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties((Object)g1, (Object)tg, (String[])new String[]{"fId"});
                tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                this.groupDao.save((Object)tg);
            }
        } else {
            this.taskBizDao.save((Object)task);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveTaksTemplateConfig(TskTaskBiz task, JSONObject param) {
        String templateId = param.getString("templateId");
        if (task.getTemplateId() == null || !task.getTemplateId().equals(templateId)) {
            Object configArgsObject;
            TbtskTemplate template = this.tbtskTemplateDao.findById((Object)templateId).orElse(null);
            TbtskObjectinfo tableTemplate = this.objectDao.findById((Object)template.getTableId()).orElse(null);
            TbtskObjectinfo table = null;
            if (GutilStr.isBlank((CharSequence)task.getTableId())) {
                TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
                tbtskObjectinfo.setfTablealias(task.getName());
                tbtskObjectinfo.setfIsspatial(tableTemplate.getfIsspatial());
                tbtskObjectinfo.setfState("1");
                tbtskObjectinfo.setfVersion("1");
                tbtskObjectinfo.setfTableversion(Integer.valueOf(0));
                tbtskObjectinfo.setParentId("-1");
                tbtskObjectinfo.setTaskId(task.getId());
                tbtskObjectinfo.setTemplateId(task.getTemplateId());
                table = (TbtskObjectinfo)this.objectDao.save((Object)tbtskObjectinfo);
            } else {
                boolean existTableName;
                table = this.objectDao.findById((Object)task.getTableId()).orElse(null);
                if (GutilStr.isNotBlank((CharSequence)table.getfTablename()) && (existTableName = this.mDataBizService.isExistTableName(table.getfTablename())) && this.mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0 && !task.getTemplateId().equals(templateId)) {
                    throw new GwValidateException("\u4efb\u52a1\u8868\u5df2\u7ecf\u521b\u5efa,\u5e76\u4e14\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4efb\u52a1\u6a21\u677f");
                }
                table.setParentId("-1");
                table.setTemplateId(templateId);
                table.setfVersion(Integer.valueOf(table.getfVersion()) + 1 + "");
                table.setfTableversion(Integer.valueOf(table.getfTableversion() == null ? 1 : table.getfTableversion() + 1));
                this.objectDao.save((Object)table);
            }
            task.setTemplateId(templateId);
            String tableId = table.getfId();
            String tableName = Optional.ofNullable(table.getfTablename()).orElse("");
            task.setTableId(table.getfId());
            task.setStatus("0");
            task.setFinish(Integer.valueOf(0));
            this.taskBizDao.save((Object)task);
            List fields = this.fieldsDao.getTbtskFieldsByTableid(template.getTableId());
            List oldfields = this.fieldsDao.getTbtskFieldsByTableid(table.getfId());
            List fieldIds = oldfields.stream().map(r -> r.getfId()).collect(Collectors.toList());
            List listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismy")).collect(Collectors.toList());
            ArrayList<TbtskFields> tbtskFields = new ArrayList<TbtskFields>();
            if (listTemp == null || listTemp.size() < 1) {
                TbtskFields temp = this.filedObject(tableId, "f_ismy", "\u662f\u5426\u81ea\u5df1\u56fe\u6591\uff08app\u7aef\u4f7f\u7528)", "8", 0, "0");
                tbtskFields.add(temp);
            }
            if (StringUtils.isNotBlank((CharSequence)task.getConfigArgs()) && ((configArgsObject = JSONObject.parseObject((String)task.getConfigArgs())).getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot") == 1 || configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot") == 1)) {
                TbtskFields temp;
                listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_issplitted")).collect(Collectors.toList());
                if (listTemp == null || listTemp.size() < 1) {
                    temp = this.filedObject(tableId, "f_issplitted", "\u662f\u5426\u5206\u5272(\u7cfb\u7edf)", "8", 1, null);
                    fields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_splitedid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    temp = this.filedObject(tableId, "f_splitedid", "\u88ab\u5206\u5272\u539f\u59cb\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                    fields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_mergeid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    temp = this.filedObject(tableId, "f_mergeid", "\u5408\u5e76\u7684\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                    fields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_pid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    temp = this.filedObject(tableId, "f_pid", "\u591a\u90e8\u4ef6\u4e0a\u7ea7\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                    fields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismultipart")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    temp = this.filedObject(tableId, "f_ismultipart", "\u662f\u5426\u591a\u90e8\u4ef6(\u7cfb\u7edf)", "1", 1, null);
                    fields.add(temp);
                }
            }
            this.fieldsDao.deleteInTableIds(Arrays.asList(table.getfId()));
            if (!fieldIds.isEmpty()) {
                this.groupDao.deleteInFieldIds(fieldIds);
            }
            this.groupDao.deleteByFTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
            for (Object r2 : fields) {
                TbtskFields field = new TbtskFields();
                BeanUtil.copyProperties((Object)r2, (Object)field, (String[])new String[]{"fId", "fTableid", "fTablename"});
                field.setfTableid(tableId);
                field.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                tbtskFields.add(field);
                this.fieldsDao.save((Object)field);
                List groups = this.groupDao.findByFFieldid(r2.getfId());
                for (TbtskGroup g : groups) {
                    TbtskGroup tg = new TbtskGroup();
                    BeanUtil.copyProperties((Object)g, (Object)tg, (String[])new String[]{"fId", "fFieldid"});
                    tg.setfFieldid(field.getfId());
                    tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                    tg.setConnection(this.changeConnectionFomat(g.getConnection(), (TbtskFields)r2));
                    tg.setVisible(g.getVisible());
                    this.groupDao.save((Object)tg);
                }
            }
            List groups = this.groupDao.getFiledIdIsNull(template.getTableId());
            for (TbtskGroup g : groups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties((Object)g, (Object)tg, (String[])new String[]{"fId"});
                tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                this.groupDao.save((Object)tg);
            }
            List sysFieldGroups = this.groupDao.selectByTableNameAndGroupcode("web", template.getTableId(), "104");
            for (TbtskGroup g1 : sysFieldGroups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties((Object)g1, (Object)tg, (String[])new String[]{"fId"});
                tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                this.groupDao.save((Object)tg);
            }
        } else {
            this.taskBizDao.save((Object)task);
        }
        JSONArray dkParam = param.getJSONArray("dkParam");
        List objectbyTaskId = this.tbtskObjectinfoRepository.getObjectbyTaskId(task.getId());
        if (objectbyTaskId.size() > 0) {
            for (TbtskObjectinfo tbtskObjectinfo : objectbyTaskId) {
                boolean existTableName;
                if (tbtskObjectinfo.getfId().equals(task.getTableId())) continue;
                this.fieldsDao.deleteInTableIds(Arrays.asList(tbtskObjectinfo.getfId()));
                this.groupDao.deleteByFTablename(StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfTablename()) ? tbtskObjectinfo.getfTablename() : tbtskObjectinfo.getfId());
                if (GutilStr.isNotBlank((CharSequence)tbtskObjectinfo.getfTablename()) && (existTableName = this.mDataBizService.isExistTableName(tbtskObjectinfo.getfTablename()))) {
                    String sql1 = "DROP TABLE IF EXISTS " + tbtskObjectinfo.getfTablename() + ";";
                    this.jdbcTemplate.execute(sql1);
                }
                this.tbtskObjectinfoRepository.deleteById((Object)tbtskObjectinfo.getfId());
            }
        }
        if (dkParam.size() > 0) {
            for (Object o : dkParam) {
                JSONObject item = JSONObject.parseObject((String)JSONObject.toJSONString(o));
                this.handlyDkTemplateConfig(task, item);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveTaskConfig(TskTaskBiz task, String configArgs) {
        TbtskObjectinfo tbtskObjectinfo = this.objectDao.findById((Object)task.getTableId()).orElse(null);
        List fields = this.fieldsDao.getTbtskFieldsByTableid(tbtskObjectinfo.getfId());
        List<Object> listTemp = new ArrayList();
        ArrayList<TbtskFields> newFields = new ArrayList<TbtskFields>();
        if (StringUtils.isNotBlank((CharSequence)configArgs)) {
            boolean existTableName;
            JSONObject configArgsObject = JSONObject.parseObject((String)configArgs);
            JSONObject configArgsObject1 = JSONObject.parseObject((String)task.getConfigArgs());
            if ((configArgsObject1 == null || configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject1.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot") != configArgsObject1.getInteger("allowWebSplitSpot") || configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject1.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot") != configArgsObject1.getInteger("allowAppSplitSpot")) && GutilStr.isNotBlank((CharSequence)tbtskObjectinfo.getfTablename()) && (existTableName = this.mDataBizService.isExistTableName(tbtskObjectinfo.getfTablename())) && this.mDataBizService.getCount(tbtskObjectinfo.getfTablename(), " 1=1 ") > 0) {
                throw new GwValidateException("\u4efb\u52a1\u8868\u5df2\u7ecf\u521b\u5efa,\u5e76\u4e14\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4efb\u52a1\u914d\u7f6e");
            }
            task.setConfigArgs(configArgs);
            if (configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot") == 1 || configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot") == 1) {
                listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_issplitted")).collect(Collectors.toList());
                if (listTemp == null || listTemp.size() < 1) {
                    TbtskFields temp = this.filedObject(tbtskObjectinfo.getfId(), "f_issplitted", "\u662f\u5426\u5206\u5272(\u7cfb\u7edf)", "8", 1, null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_splitedid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    TbtskFields temp = this.filedObject(tbtskObjectinfo.getfId(), "f_splitedid", "\u88ab\u5206\u5272\u539f\u59cb\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_mergeid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    TbtskFields temp = this.filedObject(tbtskObjectinfo.getfId(), "f_mergeid", "\u5408\u5e76\u7684\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_pid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    TbtskFields temp = this.filedObject(tbtskObjectinfo.getfId(), "f_pid", "\u591a\u90e8\u4ef6\u4e0a\u7ea7\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismultipart")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                    TbtskFields temp = this.filedObject(tbtskObjectinfo.getfId(), "f_ismultipart", "\u662f\u5426\u591a\u90e8\u4ef6(\u7cfb\u7edf)", "1", 1, null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                task.setFinish(Integer.valueOf(0));
            }
        }
        task.setStructDbUrl(null);
        tbtskObjectinfo.setfVersion(Integer.valueOf(tbtskObjectinfo.getfVersion()) + 1 + "");
        tbtskObjectinfo.setfTableversion(Integer.valueOf(tbtskObjectinfo.getfTableversion() == null ? 1 : tbtskObjectinfo.getfTableversion() + 1));
        this.objectDao.save((Object)tbtskObjectinfo);
        this.taskBizDao.save((Object)task);
        this.fieldsDao.gwAccessSelective(newFields);
    }

    public void handlyDkTemplateConfig(TskTaskBiz task, JSONObject item) {
        Object configArgsObject;
        String templateId = item.get((Object)"templateId").toString();
        String tableId = item.containsKey((Object)"tableId") ? item.get((Object)"tableId").toString() : "";
        String name = item.get((Object)"name").toString();
        String spatialType = item.get((Object)"spatialType").toString();
        JSONObject relfield = item.getJSONObject("relfield");
        TbtskTemplate template = this.tbtskTemplateDao.findById((Object)templateId).orElse(null);
        TbtskObjectinfo tableTemplate = this.objectDao.findById((Object)template.getTableId()).orElse(null);
        TbtskObjectinfo table = null;
        if (StringUtils.isNotBlank((CharSequence)tableId)) {
            boolean existTableName;
            table = this.objectDao.findById((Object)task.getTableId()).orElse(null);
            if (GutilStr.isNotBlank((CharSequence)table.getfTablename()) && (existTableName = this.mDataBizService.isExistTableName(table.getfTablename())) && this.mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0 && !task.getTemplateId().equals(templateId)) {
                throw new GwValidateException("\u4efb\u52a1\u8868\u5df2\u7ecf\u521b\u5efa,\u5e76\u4e14\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4efb\u52a1\u6a21\u677f");
            }
            if (table.getTemplateId() == null || !table.getTemplateId().equals(templateId)) {
                table.setParentId(task.getTableId());
                table.setParentObjId(task.getTableId());
                table.setTaskId(task.getId());
                table.setTemplateId(templateId);
                table.setfTablealias(name);
                table.setfSpatialtype(spatialType);
                table.setRelfield(relfield.toJSONString());
                table.setfVersion(Integer.valueOf(table.getfVersion()) + 1 + "");
                table.setfTableversion(Integer.valueOf(table.getfTableversion() == null ? 1 : table.getfTableversion() + 1));
                this.objectDao.save((Object)table);
            }
        } else {
            TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
            tbtskObjectinfo.setfTablealias(name);
            tbtskObjectinfo.setfIsspatial(tableTemplate.getfIsspatial());
            tbtskObjectinfo.setfState("1");
            tbtskObjectinfo.setfVersion("1");
            tbtskObjectinfo.setfTableversion(Integer.valueOf(0));
            tbtskObjectinfo.setParentId(task.getTableId());
            tbtskObjectinfo.setParentObjId(task.getTableId());
            tbtskObjectinfo.setTaskId(task.getId());
            tbtskObjectinfo.setRelfield(relfield.toJSONString());
            tbtskObjectinfo.setfSpatialtype(spatialType);
            tbtskObjectinfo.setTemplateId(templateId);
            table = (TbtskObjectinfo)this.objectDao.save((Object)tbtskObjectinfo);
        }
        tableId = table.getfId();
        List fields = this.fieldsDao.getTbtskFieldsByTableid(template.getTableId());
        List oldfields = this.fieldsDao.getTbtskFieldsByTableid(table.getfId());
        List fieldIds = oldfields.stream().map(r -> r.getfId()).collect(Collectors.toList());
        List listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismy")).collect(Collectors.toList());
        ArrayList<TbtskFields> tbtskFields = new ArrayList<TbtskFields>();
        if (listTemp == null || listTemp.size() < 1) {
            TbtskFields temp = this.filedObject(tableId, "f_ismy", "\u662f\u5426\u81ea\u5df1\u56fe\u6591\uff08app\u7aef\u4f7f\u7528)", "8", 0, "0");
            tbtskFields.add(temp);
        }
        if (StringUtils.isNotBlank((CharSequence)task.getConfigArgs()) && ((configArgsObject = JSONObject.parseObject((String)task.getConfigArgs())).getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot") == 1 || configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot") == 1)) {
            TbtskFields temp;
            listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_issplitted")).collect(Collectors.toList());
            if (listTemp == null || listTemp.size() < 1) {
                temp = this.filedObject(tableId, "f_issplitted", "\u662f\u5426\u5206\u5272(\u7cfb\u7edf)", "8", 1, null);
                fields.add(temp);
            }
            if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_splitedid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                temp = this.filedObject(tableId, "f_splitedid", "\u88ab\u5206\u5272\u539f\u59cb\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                fields.add(temp);
            }
            if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_mergeid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                temp = this.filedObject(tableId, "f_mergeid", "\u5408\u5e76\u7684\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                fields.add(temp);
            }
            if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_pid")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                temp = this.filedObject(tableId, "f_pid", "\u591a\u90e8\u4ef6\u4e0a\u7ea7\u56fe\u6591id(\u7cfb\u7edf)", "1", 1, null);
                fields.add(temp);
            }
            if ((listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismultipart")).collect(Collectors.toList())) == null || listTemp.size() < 1) {
                temp = this.filedObject(tableId, "f_ismultipart", "\u662f\u5426\u591a\u90e8\u4ef6(\u7cfb\u7edf)", "1", 1, null);
                fields.add(temp);
            }
        }
        this.fieldsDao.deleteInTableIds(Arrays.asList(table.getfId()));
        if (!fieldIds.isEmpty()) {
            this.groupDao.deleteInFieldIds(fieldIds);
        }
        this.groupDao.deleteByFTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
        for (Object r2 : fields) {
            TbtskFields field = new TbtskFields();
            BeanUtil.copyProperties((Object)r2, (Object)field, (String[])new String[]{"fId", "fTableid", "fTablename"});
            field.setfTableid(tableId);
            field.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
            tbtskFields.add(field);
            this.fieldsDao.save((Object)field);
            List groups = this.groupDao.findByFFieldid(r2.getfId());
            for (TbtskGroup g : groups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties((Object)g, (Object)tg, (String[])new String[]{"fId", "fFieldid"});
                tg.setfFieldid(field.getfId());
                tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
                tg.setConnection(this.changeConnectionFomat(g.getConnection(), (TbtskFields)r2));
                tg.setVisible(g.getVisible());
                this.groupDao.save((Object)tg);
            }
        }
        List groups = this.groupDao.getFiledIdIsNull(template.getTableId());
        for (TbtskGroup g : groups) {
            TbtskGroup tg = new TbtskGroup();
            BeanUtil.copyProperties((Object)g, (Object)tg, (String[])new String[]{"fId"});
            tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
            this.groupDao.save((Object)tg);
        }
        List sysFieldGroups = this.groupDao.selectByTableNameAndGroupcode("web", template.getTableId(), "104");
        for (TbtskGroup g1 : sysFieldGroups) {
            TbtskGroup tg = new TbtskGroup();
            BeanUtil.copyProperties((Object)g1, (Object)tg, (String[])new String[]{"fId"});
            tg.setfTablename(StringUtils.isNotBlank((CharSequence)table.getfTablename()) ? table.getfTablename() : table.getfId());
            this.groupDao.save((Object)tg);
        }
    }

    public TbtskFields filedObject(String tableId, String fFieldname, String fAlias, String fFieldtype, Integer fNullable, String fDefaultvalue) {
        TbtskFields temp = new TbtskFields();
        temp.setfId(UUID.randomUUID().toString());
        temp.setfFieldname(fFieldname);
        temp.setfTableid(tableId);
        temp.setfAlias(fAlias);
        temp.setfFieldtype(fFieldtype);
        temp.setfNullable(fNullable);
        if (StringUtils.isNotBlank((CharSequence)fDefaultvalue)) {
            temp.setfDefaultvalue(fDefaultvalue);
        }
        temp.setfIsBase(Integer.valueOf(0));
        temp.setfIsOutwork(Integer.valueOf(0));
        temp.setfIsListShow(Integer.valueOf(0));
        temp.setfIsWebCheck(Integer.valueOf(0));
        temp.setfIsStatis(Integer.valueOf(0));
        temp.setfIsWebEdit(Integer.valueOf(0));
        temp.setfIsMust(Integer.valueOf(0));
        temp.setfFieldInnerOuterSys(Integer.valueOf(4));
        return temp;
    }

    @Transactional(rollbackFor={Exception.class})
    public void instantiateTemplateByXC(TskTaskBiz task, String templateId) {
        if (task.getTemplateId() == null || !task.getTemplateId().equals(templateId)) {
            List objectbyTaskId;
            TbtskTemplate template = this.tbtskTemplateDao.findById((Object)templateId).orElse(null);
            TbtskObjectinfo tableTemplate = this.objectDao.findById((Object)template.getTableId()).orElse(null);
            TbtskObjectinfo table = null;
            if (GutilStr.isBlank((CharSequence)task.getTableId())) {
                TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
                tbtskObjectinfo.setfTablealias(task.getName());
                tbtskObjectinfo.setfIsspatial(tableTemplate.getfIsspatial());
                tbtskObjectinfo.setfState("1");
                tbtskObjectinfo.setfVersion("1");
                tbtskObjectinfo.setfTableversion(Integer.valueOf(0));
                tbtskObjectinfo.setParentId(templateId);
                tbtskObjectinfo.setTaskId(task.getId());
                table = (TbtskObjectinfo)this.objectDao.save((Object)tbtskObjectinfo);
            } else {
                table = this.objectDao.findById((Object)task.getTableId()).orElse(null);
                if (GutilStr.isNotBlank((CharSequence)table.getfTablename())) {
                    String sql1;
                    boolean existTableName = this.mDataBizService.isExistTableName(table.getfTablename());
                    if (existTableName && this.mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0 && !task.getTemplateId().equals(templateId)) {
                        throw new GwValidateException("\u4efb\u52a1\u8868\u5df2\u7ecf\u521b\u5efa,\u5e76\u4e14\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4efb\u52a1\u6a21\u677f");
                    }
                    if (existTableName) {
                        String sql = "DROP TABLE IF EXISTS " + table.getfTablename() + ";";
                        this.jdbcTemplate.execute(sql);
                    }
                    if (this.mDataBizService.isExistTableName(table.getfTablename() + "_gzqk")) {
                        sql1 = "DROP TABLE IF EXISTS " + table.getfTablename() + "_gzqk;";
                        this.jdbcTemplate.execute(sql1);
                    }
                    if (this.mDataBizService.isExistTableName(table.getfTablename() + "_wtsj")) {
                        sql1 = "DROP TABLE IF EXISTS " + table.getfTablename() + "_wtsj;";
                        this.jdbcTemplate.execute(sql1);
                    }
                    this.groupDao.deleteByFTablename(table.getfTablename());
                }
                table.setParentId(templateId);
                table.setfVersion(Integer.valueOf(table.getfVersion()) + 1 + "");
                table.setfTableversion(Integer.valueOf(table.getfTableversion() == null ? 1 : table.getfTableversion() + 1));
                table.setTaskId(task.getId());
                table.setfTablename(null);
                this.objectDao.save((Object)table);
            }
            task.setTemplateId(templateId);
            String tableId = table.getfId();
            String tableName = Optional.ofNullable(table.getfTablename()).orElse("");
            task.setTableId(table.getfId());
            task.setStatus("0");
            task.setFinish(Integer.valueOf(0));
            this.taskBizDao.save((Object)task);
            List fields = this.fieldsDao.getTbtskFieldsByTableid(template.getTableId());
            List oldfields = this.fieldsDao.getTbtskFieldsByTableid(table.getfId());
            List fieldIds = oldfields.stream().map(r -> r.getfId()).collect(Collectors.toList());
            List listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismy")).collect(Collectors.toList());
            ArrayList<TbtskFields> tbtskFields = new ArrayList<TbtskFields>();
            if (listTemp == null || listTemp.size() < 1) {
                TbtskFields temp = new TbtskFields();
                temp.setfId(UUID.randomUUID().toString());
                temp.setfFieldname("f_ismy");
                temp.setfTableid(tableId);
                temp.setfAlias("\u662f\u5426\u81ea\u5df1\u56fe\u6591\uff08app\u7aef\u4f7f\u7528\uff09");
                temp.setfFieldtype("8");
                temp.setfNullable(Integer.valueOf(0));
                temp.setfDefaultvalue("0");
                temp.setfIsBase(Integer.valueOf(0));
                temp.setfIsOutwork(Integer.valueOf(0));
                temp.setfIsListShow(Integer.valueOf(0));
                temp.setfIsWebCheck(Integer.valueOf(0));
                temp.setfIsStatis(Integer.valueOf(0));
                temp.setfIsWebEdit(Integer.valueOf(0));
                temp.setfIsMust(Integer.valueOf(0));
                temp.setfFieldInnerOuterSys(Integer.valueOf(4));
                tbtskFields.add(temp);
            }
            boolean isExist2 = false;
            boolean isExist3 = false;
            for (TbtskFields fields1 : fields) {
                if (StringUtils.isNotBlank((CharSequence)fields1.getfFieldAttribution()) && "2".equals(fields1.getfFieldAttribution())) {
                    isExist2 = true;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)fields1.getfFieldAttribution()) || !"3".equals(fields1.getfFieldAttribution())) continue;
                isExist3 = true;
            }
            if (isExist2) {
                TbtskFields temp = new TbtskFields();
                temp.setfId(UUID.randomUUID().toString());
                temp.setfFieldname("f_title");
                temp.setfTableid(tableId);
                temp.setfAlias("\u6807\u9898");
                temp.setfFieldtype("1");
                temp.setfNullable(Integer.valueOf(0));
                temp.setfDefaultvalue("0");
                temp.setfIsBase(Integer.valueOf(0));
                temp.setfIsOutwork(Integer.valueOf(0));
                temp.setfIsListShow(Integer.valueOf(0));
                temp.setfIsWebCheck(Integer.valueOf(0));
                temp.setfIsStatis(Integer.valueOf(0));
                temp.setfIsWebEdit(Integer.valueOf(0));
                temp.setfIsMust(Integer.valueOf(0));
                temp.setfFieldInnerOuterSys(Integer.valueOf(4));
                temp.setfFieldAttribution("2");
                tbtskFields.add(temp);
                TbtskFields temp1 = new TbtskFields();
                temp1.setfId(UUID.randomUUID().toString());
                temp1.setfFieldname("f_desc");
                temp1.setfTableid(tableId);
                temp1.setfAlias("\u8bf4\u660e");
                temp1.setfFieldtype("1");
                temp1.setfNullable(Integer.valueOf(0));
                temp1.setfDefaultvalue("0");
                temp1.setfIsBase(Integer.valueOf(0));
                temp1.setfIsOutwork(Integer.valueOf(0));
                temp1.setfIsListShow(Integer.valueOf(0));
                temp1.setfIsWebCheck(Integer.valueOf(0));
                temp1.setfIsStatis(Integer.valueOf(0));
                temp1.setfIsWebEdit(Integer.valueOf(0));
                temp1.setfIsMust(Integer.valueOf(0));
                temp1.setfFieldInnerOuterSys(Integer.valueOf(4));
                temp1.setfFieldAttribution("2");
                tbtskFields.add(temp1);
            }
            this.fieldsDao.deleteInTableIds(Arrays.asList(table.getfId()));
            if (!fieldIds.isEmpty()) {
                this.groupDao.deleteInFieldIds(fieldIds);
            }
            if (StringUtils.isNotBlank((CharSequence)table.getfId())) {
                this.groupDao.deleteByFTablename(table.getfId());
            }
            if ((objectbyTaskId = this.tbtskObjectinfoRepository.getObjectbyTaskId(task.getId())).size() > 0) {
                for (TbtskObjectinfo objectinfo : objectbyTaskId) {
                    if (objectinfo.getfId().equals(task.getTableId())) continue;
                    this.fieldsDao.deleteInTableIds(Arrays.asList(objectinfo.getfId()));
                    List fields1 = this.fieldsDao.getTbtskFieldsByTableid(objectinfo.getfId());
                    List ids = fields1.stream().map(r -> r.getfId()).collect(Collectors.toList());
                    if (!ids.isEmpty()) {
                        this.groupDao.deleteInFieldIds(ids);
                    }
                    this.tbtskObjectinfoRepository.deleteById((Object)objectinfo.getfId());
                }
            }
            for (TbtskFields r2 : fields) {
                TbtskFields field = new TbtskFields();
                BeanUtil.copyProperties((Object)r2, (Object)field, (String[])new String[]{"fId", "fTableid", "fTablename"});
                field.setfTableid(tableId);
                field.setfTablename(tableName);
                this.fieldsDao.save((Object)field);
                List groups = this.groupDao.findByFFieldid(r2.getfId());
                for (TbtskGroup g : groups) {
                    TbtskGroup tg = new TbtskGroup();
                    BeanUtil.copyProperties((Object)g, (Object)tg, (String[])new String[]{"fId", "fFieldid"});
                    tg.setfFieldid(field.getfId());
                    tg.setfTablename(table.getfId());
                    tg.setConnection(this.changeConnectionFomat(g.getConnection(), r2));
                    tg.setVisible(g.getVisible());
                    this.groupDao.save((Object)tg);
                }
            }
        } else {
            this.taskBizDao.save((Object)task);
        }
    }

    private String changeConnectionFomat(String oldStr, TbtskFields field) {
        try {
            if (GutilStr.isBlank((CharSequence)oldStr)) {
                return null;
            }
            if (oldStr.contains("conditionsName")) {
                return oldStr;
            }
            JSONObject object = JSONObject.parseObject((String)oldStr);
            if (object.containsKey((Object)"type") && new Integer(1).equals(object.getInteger("type"))) {
                JSONArray refs = object.getJSONArray("ref");
                JSONArray triggers = new JSONArray();
                for (int i = 0; i < refs.size(); ++i) {
                    String originEffect;
                    JSONObject ref = refs.getJSONObject(i);
                    JSONObject condition = new JSONObject();
                    condition.put("judge", (Object)ref.getString("case"));
                    condition.put("type", (Object)TskTaskBizDBUtil.getDBAppType((String)field.getfFieldtype()));
                    condition.put("value", (Object)ref.getString("val"));
                    JSONObject effect = new JSONObject();
                    TbtskFields connectedField = this.fieldsDao.findById((Object)ref.getString("field")).orElse(null);
                    effect.put("targetFiled", (Object)connectedField.getfFieldname());
                    switch (originEffect = ref.getString("effect")) {
                        case "uneditshow": {
                            effect.put("editable", (Object)0);
                            effect.put("visiable", (Object)1);
                            break;
                        }
                        case "unedithide": {
                            effect.put("editable", (Object)0);
                            effect.put("visiable", (Object)0);
                            break;
                        }
                        case "edithide": {
                            effect.put("editable", (Object)1);
                            effect.put("visiable", (Object)0);
                            break;
                        }
                        case "editshow": {
                            effect.put("editable", (Object)1);
                            effect.put("visiable", (Object)1);
                        }
                    }
                    JSONObject trigger = new JSONObject();
                    trigger.put("condition", (Object)condition);
                    trigger.put("effects", (Object)new JSONArray());
                    trigger.getJSONArray("effects").add((Object)effect);
                    triggers.add((Object)trigger);
                }
                return triggers.toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TbtskFields saveField(TbtskFields field) {
        TskTaskBiz task;
        if (!field.getfTableid().equalsIgnoreCase(field.getfTablename()) && StringUtils.isNotBlank((CharSequence)field.getfTablename())) {
            return this.saveTaskField(field);
        }
        String oldName = "";
        if (!GutilStr.isEmpty((CharSequence)field.getfId())) {
            TbtskFields oldField = this.fieldsDao.findById((Object)field.getfId()).orElse(null);
            oldName = oldField.getfFieldname();
            if (!oldField.getfAlias().equals(field.getfAlias())) {
                field = this.changeFileName(field);
            }
        } else {
            field = this.changeFileName(field);
        }
        if (!GutilStr.isEmpty((CharSequence)field.getfId())) {
            List groups = this.groupDao.findByFFieldid(field.getfId());
            for (TbtskGroup g : groups) {
                g.setfFieldname(field.getfFieldname());
                g.setfAlias(field.getfAlias());
                g.setfFieldtype(field.getfFieldtype());
                if ("1".equalsIgnoreCase(field.getRuleReg())) {
                    g.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                    continue;
                }
                if (!"2".equalsIgnoreCase(field.getRuleReg())) continue;
                g.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
            }
            this.groupDao.saveAll((Iterable)groups);
        }
        TbtskObjectinfo objectByTableId = this.objectDao.getObjectByTableId(field.getfTableid());
        field.setfTablename(objectByTableId.getfTablename());
        if (this.mDataBizService.isExistTableName(objectByTableId.getfTablename())) {
            if (StringUtils.isNotBlank((CharSequence)field.getfId())) {
                List tbtskFields = this.fieldsDao.queryFieldInIds(Arrays.asList(field.getfId()), objectByTableId.getfTablename());
                if (!tbtskFields.isEmpty() && !oldName.equals(field.getfFieldname())) {
                    String update = "ALTER TABLE " + objectByTableId.getfTablename() + " RENAME COLUMN " + oldName + " TO " + field.getfFieldname();
                    this.jdbcTemplate.execute(update);
                }
            } else {
                String sql;
                String ftype = this.conType(field.getfFieldtype());
                if (ftype.equals("decimal")) {
                    sql = "alter table " + objectByTableId.getfTablename() + " add  " + field.getfFieldname() + " " + ftype + "(" + field.getfLength() + "," + field.getfPrecision() + ") NULL";
                    this.jdbcTemplate.execute(sql);
                } else if (field.getfLength() != null) {
                    sql = "alter table " + objectByTableId.getfTablename() + " add  " + field.getfFieldname() + " " + ftype + "(" + field.getfLength() + ") NULL";
                    this.jdbcTemplate.execute(sql);
                } else {
                    sql = "alter table " + objectByTableId.getfTablename() + " add " + field.getfFieldname() + " " + ftype + " NULL";
                    this.jdbcTemplate.execute(sql);
                }
            }
        }
        if ((task = this.taskBizDao.findByTableId((field = (TbtskFields)this.fieldsDao.save((Object)field)).getfTableid())) != null && StringUtils.isNotBlank((CharSequence)task.getStructDbUrl())) {
            task.setStructDbUrl(null);
            this.taskBizDao.save((Object)task);
            TbtskObjectinfo tbtskObjectinfo = this.objectDao.getObjectByTableId(field.getfTableid());
            tbtskObjectinfo.setfVersion(Integer.valueOf(tbtskObjectinfo.getfVersion()) + 1 + "");
            tbtskObjectinfo.setfTableversion(Integer.valueOf(tbtskObjectinfo.getfTableversion() == null ? 1 : tbtskObjectinfo.getfTableversion() + 1));
            this.objectDao.save((Object)tbtskObjectinfo);
        }
        return field;
    }

    public String conType(String fieldType) {
        HashMap<String, String> FIELD_TYPE_DIC = new HashMap<String, String>();
        FIELD_TYPE_DIC.put("1", "text");
        FIELD_TYPE_DIC.put("2", "varchar");
        FIELD_TYPE_DIC.put("3", "decimal");
        FIELD_TYPE_DIC.put("4", "timestamp");
        FIELD_TYPE_DIC.put("5", "timestamp");
        FIELD_TYPE_DIC.put("6", "varchar");
        FIELD_TYPE_DIC.put("7", "decimal");
        FIELD_TYPE_DIC.put("8", "int4");
        FIELD_TYPE_DIC.put("9", "geometry");
        FIELD_TYPE_DIC.put("10", "text");
        return FIELD_TYPE_DIC.getOrDefault(fieldType, "varchar");
    }

    @Transactional(rollbackFor={Exception.class})
    public TbtskFields saveTaskField(TbtskFields field) {
        TbtskObjectinfo table;
        String temStr = " ADD COLUMN ";
        if (!GutilStr.isEmpty((CharSequence)field.getfTableid()) && (table = (TbtskObjectinfo)this.tbtskObjectinfoRepository.findById((Object)field.getfTableid()).orElse(null)) != null) {
            field.setfTablename(table.getfTablename());
            this.tbtskObjectinfoRepository.updateTableVersion(Integer.valueOf(table.getfTableversion() == null ? 1 : table.getfTableversion() + 1), table.getfId());
        }
        if (!GutilStr.isEmpty((CharSequence)field.getfId())) {
            TbtskFields oldField = this.fieldsDao.findById((Object)field.getfId()).orElse(null);
            if (!oldField.getfAlias().equals(field.getfAlias())) {
                field = this.changeFileName(field);
                this.jdbcTemplate.execute("ALTER TABLE " + field.getfTablename() + " RENAME " + oldField.getfFieldname() + " to " + field.getfFieldname());
            }
            temStr = " alter  COLUMN ";
        } else {
            field = this.changeFileName(field);
        }
        if (!GutilStr.isEmpty((CharSequence)field.getfId())) {
            List groups = this.groupDao.findByFFieldid(field.getfId());
            for (TbtskGroup g : groups) {
                g.setfFieldname(field.getfFieldname());
                g.setfAlias(field.getfAlias());
                g.setfFieldtype(field.getfFieldtype());
                if ("1".equalsIgnoreCase(field.getRuleReg())) {
                    g.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                    continue;
                }
                if (!"2".equalsIgnoreCase(field.getRuleReg())) continue;
                g.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
            }
            this.groupDao.saveAll((Iterable)groups);
        }
        field = (TbtskFields)this.fieldsDao.save((Object)field);
        ArrayList<TbtskFields> fields = new ArrayList<TbtskFields>();
        fields.add(field);
        StringBuilder sbSql = new StringBuilder();
        sbSql.append(" ALTER TABLE ");
        sbSql.append(field.getfTablename());
        sbSql.append(temStr);
        String sql = TskTaskBizDBUtil.generateFieldSql(null, fields);
        if (temStr.equals(" alter  COLUMN ")) {
            sql = field.getfFieldname() + " TYPE " + sql.replace(field.getfFieldname(), "") + "  USING ( " + field.getfFieldname() + "::" + sql.replace(field.getfFieldname(), "") + ")";
        }
        sbSql.append(sql);
        this.jdbcTemplate.execute(sbSql.toString());
        return field;
    }

    private TbtskFields changeFileName(TbtskFields field) {
        String alias = field.getfAlias();
        String pinYin = PinYinUtil.getFirstSpell((String)alias);
        if (pinYin.length() > 8) {
            pinYin = pinYin.substring(0, 8);
        }
        pinYin = "f_" + pinYin;
        Long count = this.fieldsDao.countStartWithPinyin(field.getfTableid(), pinYin + "%");
        if (count > 0L && pinYin.length() > 7) {
            count = count + this.fieldsDao.countStartWithPinyin(field.getfTableid(), pinYin.substring(0, pinYin.length() - 3) + "_n%");
        }
        if (count > 0L) {
            pinYin = pinYin.length() + 3 <= 10 ? pinYin + "_n" + count : pinYin.substring(0, pinYin.length() - 3) + "_n" + count;
        }
        field.setfFieldname(pinYin);
        return field;
    }

    public TbtskTemplate finishTemplate(String taskId) {
        TbtskTemplate template = this.tbtskTemplateDao.findById((Object)taskId).orElse(null);
        template.setFinish(Integer.valueOf(1));
        template = (TbtskTemplate)this.tbtskTemplateDao.save((Object)template);
        return template;
    }

    void addDefaultFieldsToTemplate(TbtskTemplate template) {
        TbtskObjectinfo table = this.objectDao.findById((Object)template.getTableId()).orElse(null);
        this.addField(table, "f_id", "\u4e3b\u952e", "2", 100, null, 0, 4);
        this.addField(table, "f_status", "\u72b6\u6001(\u7cfb\u7edf)", "8", null, null, 1, 4);
        this.addField(table, "f_ismycreate", "\u662f\u5426\u81ea\u5df1\u521b\u5efa(\u7cfb\u7edf)", "8", null, null, 1, 4);
        this.addField(table, "f_jhid", "\u8ba1\u5212id(\u7cfb\u7edf)", "2", 100, null, 1, 4);
        this.addField(table, "f_xsrwid", "\u7ebf\u7d22\u4efb\u52a1id(\u7cfb\u7edf)", "2", 100, null, 1, 4);
        this.addField(table, "f_xmid", "\u9879\u76eeid(\u7cfb\u7edf)", "2", 100, null, 1, 4);
        this.addField(table, "f_sfzdsx", "\u662f\u5426\u91cd\u5927\u4e8b\u9879(\u7cfb\u7edf)", "2", 100, null, 1, 4);
        this.addField(table, "f_requestid", "\u4e91\u67e5\u8be2id(\u7cfb\u7edf)", "2", 100, null, 1, 4);
        this.addField(table, "f_ismy", "\u662f\u5426\u81ea\u5df1\u56fe\u6591\uff08app\u7aef\u4f7f\u7528\uff09", "8", null, null, 1, 4);
        this.addField(table, "f_xzqdmcity", "\u884c\u653f\u533a\u4ee3\u7801\u5e02(\u7cfb\u7edf)", "2", 20, null, 1, 4);
        this.addField(table, "f_xzqdmcounty", "\u884c\u653f\u533a\u4ee3\u7801\u53bf(\u7cfb\u7edf)", "2", 20, null, 1, 4);
        this.addField(table, "f_xzqdmtown", "\u884c\u653f\u533a\u4ee3\u7801\u9547(\u7cfb\u7edf)", "2", 20, null, 1, 4);
        this.addField(table, "f_xzqdmsys", "\u884c\u653f\u533a\u4ee3\u7801\u6751(\u7cfb\u7edf)", "2", 20, null, 1, 4);
        this.addField(table, "f_submit_userid", "\u63d0\u4ea4\u4eba\u5458(\u7cfb\u7edf)", "2", 32, null, 1, 4);
        this.addField(table, "f_reject_count", "\u6253\u56de\u6b21\u6570(\u7cfb\u7edf)", "8", null, null, 1, 4);
        this.addField(table, "f_review_stage", "\u5ba1\u6838\u9636\u6bb5(\u7cfb\u7edf)", "8", null, null, 1, 4);
        this.addField(table, "f_reject_status", "\u6253\u56de\u72b6\u6001(\u7cfb\u7edf)", "8", null, null, 1, 4);
        this.addField(table, "f_shape", "shape(\u7cfb\u7edf)", "9", null, null, 0, 5);
        this.addField(table, "f_shape1", "shape1(\u7cfb\u7edf)", "9", null, null, 0, 5);
        this.addField(table, "f_lat", "\u4e2d\u5fc3\u70b9Y\u5750\u6807(\u7cfb\u7edf)", "3", 12, 6, 0, 5);
        this.addField(table, "f_lon", "\u4e2d\u5fc3\u70b9X\u5750\u6807(\u7cfb\u7edf)", "3", 12, 6, 0, 5);
        this.addField(table, "f_shape_b", "\u767e\u5ea6shape(\u7cfb\u7edf)", "9", null, null, 1, 5);
        this.addField(table, "f_lat_b", "\u767e\u5ea6\u4e2d\u5fc3\u70b9Y\u5750\u6807(\u7cfb\u7edf)", "3", 12, 6, 1, 5);
        this.addField(table, "f_lon_b", "\u767e\u5ea6\u4e2d\u5fc3\u70b9X\u5750\u6807(\u7cfb\u7edf)", "3", 12, 6, 1, 5);
        this.addField(table, "f_shape_g", "\u8c37\u6b4cshape(\u7cfb\u7edf)", "9", null, null, 1, 5);
        this.addField(table, "f_tbmc", "\u56fe\u6591\u540d\u79f0", "2", 100, null, 1, 1);
        this.addField(table, "f_tbbh", "\u56fe\u6591\u7f16\u53f7", "2", 100, null, 1, 1);
        this.addField(table, "f_xzqdm", "\u884c\u653f\u533a\u4ee3\u7801", "2", 20, null, 1, 1);
        this.addField(table, "f_tbmj", "\u56fe\u6591\u9762\u79ef(\u4ea9)", "3", 12, 2, 1, 1);
        this.addField(table, "f_xzqmc", "\u884c\u653f\u533a\u540d\u79f0", "2", 100, null, 1, 1);
        this.addField(table, "f_xzqmc1", "\u884c\u653f\u533a\u540d\u79f0(\u7cfb\u7edf)", "2", 100, null, 1, 5);
        this.addField(table, "f_lat_g", "\u8c37\u6b4c\u4e2d\u5fc3\u70b9Y\u5750\u6807(\u7cfb\u7edf)", "3", 12, 6, 1, 5);
        this.addField(table, "f_lon_g", "\u8c37\u6b4c\u4e2d\u5fc3\u70b9X\u5750\u6807(\u7cfb\u7edf)", "3", 12, 6, 1, 5);
        this.addField(table, "f_userid", "\u64cd\u4f5c\u4eba(\u7cfb\u7edf)", "2", 100, null, 1, 5);
        this.addField(table, "f_createtime", "\u521b\u5efa\u65f6\u95f4(\u7cfb\u7edf)", "2", 100, null, 1, 5);
        this.addField(table, "f_updatetime", "\u66f4\u65b0\u65f6\u95f4(\u7cfb\u7edf)", "2", 100, null, 1, 5);
        this.addField(table, "f_committime", "\u63d0\u4ea4\u65f6\u95f4(\u7cfb\u7edf)", "2", 100, null, 1, 6);
        this.addField(table, "f_upload_userid", "\u6267\u884c\u4eba\u5458(\u7cfb\u7edf)", "2", 100, null, 1, 6);
        this.addField(table, "f_approvetime", "\u5ba1\u6838\u65f6\u95f4(\u7cfb\u7edf)", "2", 100, null, 1, 5);
        this.addField(table, "f_typical", "\u5178\u578b\u95ee\u9898(\u7cfb\u7edf)", "2", 100, null, 1, 5);
    }

    private void addField(TbtskObjectinfo tableInfo, String name, String alias, String fieldType, Integer length, Integer pricies, Integer nullAble, Integer code) {
        TbtskFields tbField = new TbtskFields();
        tbField.setfAlias(alias);
        tbField.setfFieldname(name);
        tbField.setfFieldtype(fieldType);
        tbField.setfLength(length);
        tbField.setfPrecision(pricies);
        tbField.setfNullable(nullAble);
        tbField.setfFieldInnerOuterSys(Integer.valueOf(1));
        tbField.setfTableid(tableInfo.getfId());
        tbField.setfTablename(tableInfo.getfTablename());
        tbField.setfFieldInnerOuterSys(code);
        this.fieldsDao.save((Object)tbField);
    }

    public boolean findNameExist(String id, String name) {
        TbtskTemplate template = this.tbtskTemplateDao.findFirstByName(name);
        if (template != null) {
            return !template.getId().equals(id);
        }
        return false;
    }

    public List<TbtskTemplate> getTbtskTemplateListByRegionCodeAndNameLike(String regionCode, String name, String classId, Integer projectType) {
        regionCode = "1".equals(regionCode) ? "%%" : (regionCode.length() <= 6 ? (regionCode.endsWith("0000") ? regionCode.substring(0, 2) + "%" : (regionCode.endsWith("00") ? regionCode.substring(0, 4) + "%" : regionCode + "%")) : regionCode + "%");
        name = StringUtils.isNotBlank((CharSequence)name) ? name + "%" : "%%";
        if (StringUtils.isNotBlank((CharSequence)classId)) {
            if (projectType != null) {
                return this.tbtskTemplateDao.getAllByCodeAndNameAndClassIdAndProjectType(regionCode, name, Long.valueOf(Long.parseLong(classId)), projectType);
            }
            return this.tbtskTemplateDao.getAllByCodeAndNameAndClassId(regionCode, name, Long.valueOf(Long.parseLong(classId)));
        }
        if (projectType != null) {
            return this.tbtskTemplateDao.getAllByCodeAndNameAndProjectType(regionCode, name, projectType);
        }
        return this.tbtskTemplateDao.getAllByCodeAndName(regionCode, name);
    }

    public List<String> queryTemplateIdsByUserRegionCode(String userRegionCode) {
        String sql = "select distinct(f_templateid) from tbtsk_template_area where f_code ='" + userRegionCode + "'";
        if (userRegionCode.length() <= 6) {
            if (!userRegionCode.endsWith("0000")) {
                sql = userRegionCode.endsWith("00") ? sql + " or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 2) + "0000')" : sql + " or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 2) + "0000') or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 4) + "00')";
            }
        } else if (userRegionCode.length() == 9) {
            sql = sql + " or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 2) + "0000') or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 4) + "00') or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 6) + "')";
        } else if (userRegionCode.length() == 12) {
            sql = sql + " or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 2) + "0000') or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 4) + "00') or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 6) + "') or (f_type = 1 and  f_code = '" + userRegionCode.substring(0, 9) + "')";
        }
        List maps = this.jdbcTemplate.queryForList(sql);
        ArrayList<String> ids = new ArrayList<String>();
        if (maps != null) {
            for (Map m : maps) {
                ids.add(m.get("f_templateid").toString());
            }
        }
        return ids;
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeTabName(String tempId, String oldName, String newName, String sys) {
        TbtskTemplate tbtskTemplate = this.tbtskTemplateDao.findById((Object)tempId).orElse(null);
        if (tbtskTemplate == null) {
            throw new RuntimeException("\u65e0\u8be5\u4efb\u52a1\u6a21\u677f");
        }
        List tbtskGroups = this.groupDao.selectByTableIdAndGroupcode(sys, tbtskTemplate.getTableId(), "202");
        List tabNames = tbtskGroups.stream().map(r -> r.getfSubgroupname()).distinct().collect(Collectors.toList());
        if (tabNames.indexOf(newName) > -1) {
            throw new RuntimeException("\u5f53\u524d\u6a21\u677f\u5b58\u5728\u91cd\u590dtab\u540d\u79f0");
        }
        if (tabNames.indexOf(oldName) < 0) {
            throw new RuntimeException("\u65e0\u540d\u5b57\u4e3a" + oldName + "\u7684tab\u9875");
        }
        List groupIds = tbtskGroups.stream().filter(r -> r.getfSubgroupname().equals(oldName)).map(r -> r.getfId()).collect(Collectors.toList());
        if (!groupIds.isEmpty()) {
            this.groupDao.updateGroupNameByName(groupIds, newName);
        }
    }

    public void copyTaskTemplate(Long userId, String templateId, String newName) {
        TbtskTemplate one = this.tbtskTemplateDao.findById((Object)templateId).orElse(null);
        if (one == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u8be5\u6a21\u677f");
        }
        TbtskTemplate firstByName = this.tbtskTemplateDao.findFirstByName(newName);
        if (firstByName != null) {
            throw new RuntimeException("\u5df2\u5b58\u5728\u3010" + newName + "\u3011\u7684\u6a21\u677f");
        }
        List sourceFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(one.getTableId());
        if (sourceFields.isEmpty()) {
            throw new RuntimeException("\u672a\u627e\u5230\u5b57\u6bb5\u4fe1\u606f");
        }
        List sourceGroup = this.tbtskGroupRepository.findByFTablename(one.getTableId());
        if (sourceGroup.isEmpty()) {
            throw new RuntimeException("\u672a\u627e\u5230\u5c55\u793a\u4fe1\u606f");
        }
        List allTemplateAreas = this.tbtskTemplateAreaRepository.getAllByTemplateId(templateId);
        if (allTemplateAreas.isEmpty()) {
            throw new RuntimeException("\u6a21\u677f\u6ca1\u6709\u533a\u57df\u4fe1\u606f");
        }
        TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
        tbtskObjectinfo = (TbtskObjectinfo)this.tbtskObjectinfoRepository.save((Object)tbtskObjectinfo);
        String newTableId = tbtskObjectinfo.getfId();
        TbtskTemplate newTemplate = new TbtskTemplate();
        newTemplate = (TbtskTemplate)this.tbtskTemplateDao.save((Object)newTemplate);
        String newTempId = newTemplate.getId();
        tbtskObjectinfo.setfTablename(newTableId);
        tbtskObjectinfo.setfTableversion(Integer.valueOf(2));
        tbtskObjectinfo.setParentId(newTempId);
        this.tbtskObjectinfoRepository.save((Object)tbtskObjectinfo);
        BeanUtil.copyProperties((Object)one, (Object)newTemplate);
        newTemplate.setId(newTempId);
        newTemplate.setName(newName);
        newTemplate.setCreateTime(new Date());
        newTemplate.setCreator(userId.toString());
        newTemplate.setTableId(newTableId);
        this.tbtskTemplateDao.save((Object)newTemplate);
        ArrayList<TbtskTemplateArea> newTemplateAreas = new ArrayList<TbtskTemplateArea>();
        for (Object templateArea : allTemplateAreas) {
            TbtskTemplateArea area = new TbtskTemplateArea();
            BeanUtil.copyProperties((Object)templateArea, (Object)area);
            area.setId(UUID.randomUUID().toString());
            area.setTemplateId(newTempId);
            newTemplateAreas.add(area);
        }
        this.tbtskTemplateAreaRepository.saveAll(newTemplateAreas);
        List<TbtskFields> newFields = new ArrayList();
        for (TbtskFields sourceField : sourceFields) {
            TbtskFields tempFields = new TbtskFields();
            BeanUtil.copyProperties((Object)sourceField, (Object)tempFields);
            tempFields.setfId(UUID.randomUUID().toString());
            tempFields.setfTablename(newTableId);
            tempFields.setfTableid(newTableId);
            newFields.add(tempFields);
        }
        this.tbtskFieldsRepository.saveAll(newFields);
        ArrayList<TbtskGroup> newGroups = new ArrayList<TbtskGroup>();
        newFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(newTableId);
        for (TbtskGroup group : sourceGroup) {
            List collect = newFields.stream().filter(r -> r.getfFieldname().equals(group.getfFieldname())).collect(Collectors.toList());
            if (collect.isEmpty()) continue;
            TbtskGroup tbtskGroup = new TbtskGroup();
            BeanUtil.copyProperties((Object)group, (Object)tbtskGroup);
            tbtskGroup.setfId(UUID.randomUUID().toString());
            tbtskGroup.setfFieldid(((TbtskFields)collect.get(0)).getfId());
            tbtskGroup.setfTablename(newTableId);
            newGroups.add(tbtskGroup);
        }
        this.tbtskGroupRepository.saveAll(newGroups);
    }

    public TbtskTemplate getByBizId(String bizId) {
        TskTaskBiz tskTaskBiz = this.taskBizDao.findById((Object)bizId).orElse(null);
        if (tskTaskBiz == null) {
            return new TbtskTemplate();
        }
        TbtskTemplate list = this.tbtskTemplateDao.findById((Object)tskTaskBiz.getTemplateId()).orElse(null);
        return list;
    }
}

