/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.dao.pub.AppMediaGjDao;
import com.geoway.landteam.landcloud.model.pub.entity.AppMediaGj;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtAssignRepository;
import com.geoway.landteam.landcloud.service.customtask.task.GjhtAssignService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SharedDataService {
    private final GiLoger logger = GwLoger.getLoger(SharedDataService.class);
    @Autowired
    TbGjhtAssignRepository tbGjhtAssignRepository;
    @Resource
    GjhtAssignService gjhtAssignService;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    MDataBizService dataBizService;
    @Resource
    AppMediaGjDao appMediaGjDao;
    String MEDIA_FROM = "FROM_GJ";

    public JSONObject findSharedData(String range, Integer buffer, String begintime, String endtime, Integer limit) throws Exception {
        int min = 1;
        int max = 50000;
        if (StringUtils.isBlank((CharSequence)range) || ObjectUtils.isEmpty((Object)buffer)) {
            System.out.println("range\u4e0ebuffer \u6570\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01");
            this.logger.info("range\u4e0ebuffer \u6570\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01", new Object[0]);
            return null;
        }
        if (buffer == null || buffer <= min || buffer >= max) {
            System.out.println("\u7f13\u51b2\u533a\u8303\u56f4\u8d85\u754c\u3001\u7cfb\u7edf\u4e0d\u652f\u6301\uff01");
            this.logger.info("\u7f13\u51b2\u533a\u8303\u56f4\u8d85\u754c\u3001\u7cfb\u7edf\u4e0d\u652f\u6301\uff01", new Object[0]);
            return null;
        }
        JSONObject resultData = new JSONObject();
        JSONObject dataJson = new JSONObject();
        dataJson.put("range", (Object)range);
        dataJson.put("buffer", (Object)buffer);
        if (StringUtils.isNotBlank((CharSequence)begintime)) {
            dataJson.put("begintime", (Object)begintime);
        }
        if (StringUtils.isNotBlank((CharSequence)endtime)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date end = df.parse(endtime);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(end);
                calendar.add(5, 1);
                endtime = df.format(calendar.getTime());
            }
            catch (Exception end) {
                // empty catch block
            }
            dataJson.put("endtime", (Object)endtime);
        }
        if (ObjectUtils.isNotEmpty((Object)limit)) {
            dataJson.put("limit", (Object)limit);
        }
        if (StringUtils.isBlank((CharSequence)this.gjhtAssignService.getKeyPublic()) || StringUtils.isBlank((CharSequence)this.gjhtAssignService.getKeyPrivate()) || StringUtils.isBlank((CharSequence)this.gjhtAssignService.getGtUrl())) {
            System.out.println("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01");
            this.logger.info("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01", new Object[0]);
            return null;
        }
        SM2 sm2 = new SM2(this.gjhtAssignService.getKeyPrivate(), this.gjhtAssignService.getKeyPublic());
        sm2.usePlainEncoding();
        byte[] sm4Key = SecureUtil.generateKey((String)"SM4").getEncoded();
        String token = this.gjhtAssignService.getToken(sm2);
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        String secret = this.gjhtAssignService.getSecret(sm2, sm4Key);
        if (StringUtils.isBlank((CharSequence)secret)) {
            return null;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-lc-secret", secret);
        headerMap.put("x-lc-token", token);
        String returnJsonObjectData = dataJson.toString();
        String dataEncrypt = this.gjhtAssignService.getEncrypt(returnJsonObjectData, sm4Key);
        HttpResponse httpResponse = ((HttpRequest)HttpUtil.createPost((String)(this.gjhtAssignService.getGtUrl() + "/EvidenceShare/CreateTask")).contentType("application/json").addHeaders(headerMap)).body(dataEncrypt).execute();
        if (ObjectUtils.isEmpty((Object)httpResponse)) {
            this.logger.info("\u670d\u52a1\u53d1\u8d77\u67e5\u8be2\u672a\u8fd4\u56de\u4efb\u4f55\u7ed3\u679c\uff01", new Object[0]);
            return null;
        }
        String result = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");
        if (StringUtils.isNotBlank((CharSequence)result) && (result.indexOf("\"code\": 200") != -1 || result.indexOf("\"code\":200") != -1)) {
            resultData = JSONObject.parseObject((String)result);
            String taskDataId = resultData.get((Object)"data").toString();
            String data = this.gjhtAssignService.getDecrypt(sm2, taskDataId, xLcSecret);
            if (StringUtils.isNotBlank((CharSequence)data)) {
                resultData.put("data", (Object)data);
            }
        } else {
            resultData = null;
        }
        return resultData;
    }

    public JSONObject getState(String taskDataId) throws Exception {
        JSONObject resultData = new JSONObject();
        if (StringUtils.isBlank((CharSequence)taskDataId)) {
            this.logger.info("taskDataId\u4efb\u52a1\u7f16\u53f7\u4e0d\u5b58\u5728\uff01", new Object[0]);
            return resultData;
        }
        if (StringUtils.isBlank((CharSequence)this.gjhtAssignService.getKeyPublic()) || StringUtils.isBlank((CharSequence)this.gjhtAssignService.getKeyPrivate()) || StringUtils.isBlank((CharSequence)this.gjhtAssignService.getGtUrl())) {
            System.out.println("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01");
            this.logger.info("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01", new Object[0]);
            return null;
        }
        SM2 sm2 = new SM2(this.gjhtAssignService.getKeyPrivate(), this.gjhtAssignService.getKeyPublic());
        sm2.usePlainEncoding();
        byte[] sm4Key = SecureUtil.generateKey((String)"SM4").getEncoded();
        String token = this.gjhtAssignService.getToken(sm2);
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-lc-token", token);
        String getUrl = this.gjhtAssignService.getGtUrl() + "/EvidenceShare/GetState?requestid=" + taskDataId;
        this.logger.info("\u83b7\u53d6\u67e5\u8be2\u72b6\u6001:" + getUrl, new Object[0]);
        HttpResponse httpResponse = ((HttpRequest)HttpUtil.createGet((String)getUrl).contentType("application/json").addHeaders(headerMap)).execute();
        if (ObjectUtils.isEmpty((Object)httpResponse)) {
            this.logger.info("\u670d\u52a1\u53d1\u8d77\u67e5\u8be2\u672a\u8fd4\u56de\u4efb\u4f55\u7ed3\u679c\uff01", new Object[0]);
            return null;
        }
        String resultState = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");
        if (StringUtils.isNotBlank((CharSequence)resultState) && (resultState.indexOf("\"code\": 200") != -1 || resultState.indexOf("\"code\":200") != -1)) {
            resultData = JSONObject.parseObject((String)resultState);
            String stateData = resultData.get((Object)"data").toString();
            String data = this.gjhtAssignService.getDecrypt(sm2, stateData, xLcSecret);
            resultData.put("data", (Object)data);
        } else {
            resultData = null;
        }
        return resultData;
    }

    public JSONObject getResult(String taskDataId, String resize, String tbId) throws Exception {
        JSONObject resultData = new JSONObject();
        if (StringUtils.isBlank((CharSequence)taskDataId)) {
            this.logger.info("taskDataId\u4efb\u52a1\u7f16\u53f7\u4e0d\u5b58\u5728\uff01", new Object[0]);
            return resultData;
        }
        SM2 sm2 = new SM2(this.gjhtAssignService.getKeyPrivate(), this.gjhtAssignService.getKeyPublic());
        sm2.usePlainEncoding();
        byte[] sm4Key = SecureUtil.generateKey((String)"SM4").getEncoded();
        String token = this.gjhtAssignService.getToken(sm2);
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-lc-token", token);
        String getUrl = this.gjhtAssignService.getGtUrl() + "/EvidenceShare/GetResult?requestid=" + taskDataId;
        this.logger.info("\u83b7\u53d6\u67e5\u8be2\u7ed3\u679c:" + getUrl, new Object[0]);
        HttpResponse httpResponse = ((HttpRequest)HttpUtil.createGet((String)getUrl).contentType("application/json").addHeaders(headerMap)).execute();
        if (ObjectUtils.isEmpty((Object)httpResponse)) {
            this.logger.info("\u670d\u52a1\u53d1\u8d77\u67e5\u8be2\u672a\u8fd4\u56de\u4efb\u4f55\u7ed3\u679c\uff01", new Object[0]);
            return null;
        }
        String data = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");
        if (StringUtils.isNotBlank((CharSequence)data) && (data.indexOf("\"code\": 200") != -1 || data.indexOf("\"code\":200") != -1)) {
            resultData = JSONObject.parseObject((String)data);
            String resultDataSecret = resultData.getString("data");
            String dataSecret = this.gjhtAssignService.getDecrypt(sm2, resultDataSecret, xLcSecret);
            List appMediaList = null;
            if (StringUtils.isNotBlank((CharSequence)tbId)) {
                appMediaList = this.appMediaDao.queryALLByGid(tbId);
            }
            JSONArray jsonArrayList = JSONObject.parseArray((String)dataSecret, (Feature[])new Feature[0]);
            jsonArrayList = this.setId(jsonArrayList);
            jsonArrayList = this.restore(jsonArrayList, resize);
            jsonArrayList = this.setIsAttach(jsonArrayList, appMediaList);
            resultData.put("data", (Object)jsonArrayList);
        } else {
            resultData = null;
        }
        return resultData;
    }

    public List<AppMedia> saveSharedData(String taskId, String tbbhId, JSONArray jsonArray) throws Exception {
        ArrayList<AppMedia> returnMediaList = null;
        if (StringUtils.isEmpty((CharSequence)taskId) || ObjectUtils.isEmpty((Object)jsonArray) || StringUtils.isBlank((CharSequence)tbbhId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List appMediaList = this.appMediaDao.queryALLByGid(tbbhId);
        HttpURLConnection httpURLConnection = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (ObjectUtils.isEmpty(returnMediaList)) {
                returnMediaList = new ArrayList<AppMedia>();
            }
            String tbybh = jsonObject.getString("tbybh") != null ? jsonObject.getString("tbybh") : "";
            String tcbm = jsonObject.getString("tcbm") != null ? jsonObject.getString("tcbm") : "";
            String url = jsonObject.getString("url") != null ? jsonObject.getString("url") : "";
            String xzqdm = jsonObject.getString("xzqdm") != null ? jsonObject.getString("xzqdm") : "";
            String psry = jsonObject.getString("psry") != null ? jsonObject.getString("psry") : "";
            Integer lysb = jsonObject.getInteger("lysb") != null ? jsonObject.getInteger("lysb") : null;
            String pssj = jsonObject.getString("pssj") != null ? jsonObject.getString("pssj") : "";
            String psfyj = jsonObject.getString("psfyj") != null ? jsonObject.getString("psfyj") : "";
            Double psjj = jsonObject.getDouble("psjj") != null ? jsonObject.getDouble("psjj") : null;
            Integer pshgj = jsonObject.getInteger("pshgj") != null ? jsonObject.getInteger("pshgj") : null;
            String psjd = jsonObject.getString("psjd") != null ? jsonObject.getString("psjd") : "";
            Double longitude = jsonObject.getDouble("longitude") != null ? jsonObject.getDouble("longitude") : null;
            Double latitude = jsonObject.getDouble("latitude") != null ? jsonObject.getDouble("latitude") : null;
            String filepath = StringUtils.split((String)url, (String)"?")[0];
            String name = filepath.substring(filepath.lastIndexOf("/") + 1);
            name = StringUtils.split((String)name, (String)".")[0];
            String id = this.getId(name, tcbm, tbybh);
            if (appMediaList != null && appMediaList.stream().filter(t -> id.equals(t.getCopyid())).findFirst().isPresent()) continue;
            AppMediaGj appMediaGj = (AppMediaGj)this.appMediaGjDao.gwSearchByPK((Serializable)((Object)id));
            String fjmc = UUID.randomUUID().toString();
            String suffix = "";
            AppMedia media = new AppMedia();
            media.setCopyid(id);
            media.setFromSource(this.MEDIA_FROM);
            if (url.contains(".jpg")) {
                media.setType(Integer.valueOf(1));
                fjmc = fjmc + ".jpg";
                suffix = ".jpg";
            } else if (url.contains(".png")) {
                media.setType(Integer.valueOf(1));
                fjmc = fjmc + ".png";
                suffix = ".png";
            } else if (url.contains(".mp4")) {
                media.setType(Integer.valueOf(2));
                fjmc = fjmc + ".mp4";
                suffix = ".mp4";
            } else if (url.contains(".mp3")) {
                media.setType(Integer.valueOf(3));
                fjmc = fjmc + ".mp3";
                suffix = ".mp3";
            } else if (url.contains(".osgb")) {
                media.setType(Integer.valueOf(4));
                fjmc = fjmc + ".osgb";
                suffix = ".osgb";
            } else if (url.contains(".pdf")) {
                media.setType(Integer.valueOf(5));
                fjmc = fjmc + ".pdf";
                suffix = ".pdf";
            } else {
                media.setType(Integer.valueOf(1));
                fjmc = fjmc + ".jpg";
                suffix = ".jpg";
            }
            String result = "";
            Double size = 0.0;
            if (appMediaGj == null) {
                String objectname = "media/" + taskId + "/" + tbbhId + "/" + fjmc;
                URL httpUrl = new URL(url);
                URLConnection urlConnection = httpUrl.openConnection();
                httpURLConnection = (HttpURLConnection)urlConnection;
                httpURLConnection.setConnectTimeout(600000);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                httpURLConnection.connect();
                int sizeInt = httpURLConnection.getContentLength();
                size = Double.parseDouble(String.valueOf(sizeInt));
                InputStream inputStream = httpURLConnection.getInputStream();
                String uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
                File dir = new File(uploadDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File temFile = File.createTempFile("tmp", suffix, dir);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)temFile);
                result = this.defaultOssOperatorService.sendObject2Oss(objectname, temFile);
                if (inputStream != null) {
                    inputStream.close();
                }
                httpURLConnection.disconnect();
                if (ObjectUtils.isNotEmpty((Object)temFile)) {
                    FileUtils.delete((File)temFile);
                }
                if (StringUtils.isBlank((CharSequence)result)) {
                    continue;
                }
            } else {
                result = appMediaGj.getUrl();
                size = appMediaGj.getSize();
            }
            media.setId(UUID.randomUUID().toString());
            media.setGalleryid(tbbhId);
            media.setCreateTime(String.valueOf(System.currentTimeMillis()));
            media.setServerpath(result);
            media.setMediasize(size);
            media.setMark(Integer.valueOf(0));
            media.setTypetype(Integer.valueOf(0));
            if (StringUtils.isNotBlank((CharSequence)psry)) {
                media.setUsername(psry);
            }
            if (ObjectUtils.isNotEmpty((Object)lysb)) {
                media.setDeviceSource(lysb);
            }
            if (ObjectUtils.isNotEmpty((Object)longitude)) {
                media.setLon(longitude);
            }
            if (ObjectUtils.isNotEmpty((Object)latitude)) {
                media.setLat(latitude);
            }
            media.setBizId(taskId);
            if (StringUtils.isNotBlank((CharSequence)pssj)) {
                try {
                    Date date = df.parse(pssj);
                    media.setTime(String.valueOf(date.getTime()));
                }
                catch (Exception ex) {
                    media.setTime(pssj);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)psfyj)) {
                media.setPsfyj(psfyj);
                media.setPitch(psfyj);
            }
            if (ObjectUtils.isNotEmpty((Object)pssj)) {
                media.setFocal(psjj);
            }
            if (ObjectUtils.isNotEmpty((Object)pshgj)) {
                media.setRoll(pshgj);
            }
            if (StringUtils.isNotBlank((CharSequence)psjd)) {
                media.setAzimuth(psjd);
            }
            if (StringUtils.isBlank((CharSequence)media.getUsername())) {
                media.setUsername("\u590d\u7528\u56fd\u5bb6");
            }
            AppMedia returnMedia = (AppMedia)this.appMediaDao.save((Object)media);
            returnMediaList.add(returnMedia);
        }
        if (ObjectUtils.isNotEmpty(httpURLConnection)) {
            httpURLConnection.disconnect();
        }
        return returnMediaList;
    }

    private JSONArray restore(JSONArray jsonArray, String resize) {
        String tempUrl;
        String url;
        JSONObject jsonObject;
        int i;
        if (jsonArray == null || jsonArray.isEmpty()) {
            return jsonArray;
        }
        ArrayList<AppMediaGj> appMediaGjs = new ArrayList<AppMediaGj>();
        List<String> urls = new ArrayList<String>();
        for (i = 0; i < jsonArray.size(); ++i) {
            jsonObject = jsonArray.getJSONObject(i);
            url = jsonObject.getString("url");
            if (StringUtils.isBlank((CharSequence)url)) continue;
            if (url.contains(this.gjhtAssignService.getGjObs())) {
                String id = jsonObject.getString("id");
                AppMediaGj appMediaGj = (AppMediaGj)this.appMediaGjDao.gwSearchByPK((Serializable)((Object)id));
                if (appMediaGj != null) {
                    tempUrl = this.temporarySignedUrlService.getTemporarySignedUrl(null, appMediaGj.getUrl(), null);
                    jsonObject.put("url", (Object)tempUrl);
                    continue;
                }
                urls.add(url);
                continue;
            }
            urls.add(url);
        }
        urls = this.getTempUrl(urls, resize);
        for (i = 0; i < jsonArray.size(); ++i) {
            jsonObject = jsonArray.getJSONObject(i);
            url = jsonObject.getString("url");
            url = StringUtils.split((String)url, (String)"?")[0];
            String path = url.replace("http", "https").replace("HTTP", "https").replace("https://", "");
            String finalUrl = path = path.substring(path.indexOf("/") + 1);
            tempUrl = urls.stream().filter(t -> t.contains(finalUrl)).findFirst().orElse(null);
            if (StringUtils.isBlank((CharSequence)tempUrl)) continue;
            jsonObject.put("url", (Object)tempUrl);
            if (!tempUrl.contains(this.gjhtAssignService.getGjObs())) continue;
            String tcbm = jsonObject.getString("tcbm");
            if (StringUtils.isBlank((CharSequence)tcbm)) {
                tcbm = "tcbm";
            }
            String filepath = StringUtils.split((String)url, (String)"?")[0];
            String name = filepath.substring(filepath.lastIndexOf("/") + 1);
            byte[] bytes = this.getDownload(tempUrl);
            int size = bytes.length;
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            String sendObjName = "media/fromgj/" + tcbm + "/" + name;
            String newUrl = this.defaultOssOperatorService.sendObject2Oss(sendObjName, (InputStream)is);
            try {
                is.close();
            }
            catch (Exception ex) {
                this.logger.error("\u5173\u95ed oss file InputStream error", new Object[]{ex});
            }
            tempUrl = this.temporarySignedUrlService.getTemporarySignedUrl(null, newUrl, null);
            jsonObject.put("url", (Object)tempUrl);
            String id = jsonObject.getString("id");
            AppMediaGj appMediaGj = new AppMediaGj();
            appMediaGj = new AppMediaGj();
            appMediaGj.setId(id);
            appMediaGj.setUrl(newUrl);
            appMediaGj.setSourceurl(url);
            appMediaGj.setJym(jsonObject.getString("jym"));
            appMediaGj.setArg(jsonObject.getString("arg"));
            appMediaGj.setPsfyj(jsonObject.getString("psfyj"));
            appMediaGj.setFjysgd(jsonObject.getString("fjysgd"));
            appMediaGj.setFjyskd(jsonObject.getString("fjyskd"));
            appMediaGj.setLatitude(jsonObject.getString("latitude"));
            appMediaGj.setLayername(jsonObject.getString("layername"));
            appMediaGj.setLongitude(jsonObject.getString("longitude"));
            appMediaGj.setLysb(jsonObject.getString("lysb"));
            appMediaGj.setPshgj(jsonObject.getString("pshgj"));
            appMediaGj.setPsjd(jsonObject.getString("psjd"));
            appMediaGj.setPsjj(jsonObject.getString("psjj"));
            appMediaGj.setPsry(jsonObject.getString("psry"));
            appMediaGj.setPssj(jsonObject.getString("pssj"));
            appMediaGj.setQuerytype(jsonObject.getString("querytype"));
            appMediaGj.setTbybh(jsonObject.getString("tbybh"));
            appMediaGj.setTcbm(jsonObject.getString("tcbm"));
            appMediaGj.setXzqdm(jsonObject.getString("xzqdm"));
            appMediaGj.setZsdm(jsonObject.getString("zsdm"));
            appMediaGj.setSize(Double.valueOf(Double.parseDouble(String.valueOf(size))));
            appMediaGjs.add(appMediaGj);
            bytes = null;
        }
        if (!appMediaGjs.isEmpty()) {
            this.appMediaGjDao.batchInsert(appMediaGjs);
        }
        return jsonArray;
    }

    private JSONArray setId(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return jsonArray;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String url = jsonObject.getString("url");
            if (StringUtils.isBlank((CharSequence)url)) continue;
            String tbybh = jsonObject.getString("tbybh");
            String tcbm = jsonObject.getString("tcbm");
            String filepath = StringUtils.split((String)url, (String)"?")[0];
            String name = filepath.substring(filepath.lastIndexOf("/") + 1);
            name = StringUtils.split((String)name, (String)".")[0];
            String id = this.getId(name, tcbm, tbybh);
            jsonObject.put("id", (Object)id);
        }
        JSONArray result = new JSONArray();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String id = jsonObject.getString("id");
            if (ids.contains(id)) continue;
            ids.add(id);
            result.add((Object)jsonObject);
        }
        return result;
    }

    private JSONArray setIsAttach(JSONArray jsonArray, List<AppMedia> appMediaList) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return jsonArray;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String id = jsonObject.getString("id");
            if (appMediaList != null && !appMediaList.isEmpty() && appMediaList.stream().filter(t -> id.equals(t.getCopyid())).findFirst().isPresent()) {
                jsonObject.put("isAttached", (Object)true);
                continue;
            }
            jsonObject.put("isAttached", (Object)false);
        }
        return jsonArray;
    }

    private List<String> getTempUrl(List<String> urls, String resize) {
        JSONObject paramJSONObject = new JSONObject();
        paramJSONObject.put("urls", urls);
        if (StringUtils.isBlank((CharSequence)resize)) {
            paramJSONObject.put("resize", (Object)"Original");
        } else {
            paramJSONObject.put("resize", (Object)resize);
        }
        HashMap<String, String> headerMap2 = new HashMap<String, String>();
        SM2 sm22 = new SM2(this.gjhtAssignService.getKeyPrivate(), this.gjhtAssignService.getKeyPublic());
        sm22.usePlainEncoding();
        byte[] sm4Key2 = SecureUtil.generateKey((String)"SM4").getEncoded();
        String token2 = this.gjhtAssignService.getToken(sm22);
        String secret2 = this.gjhtAssignService.getSecret(sm22, sm4Key2);
        headerMap2.put("x-lc-secret", secret2);
        headerMap2.put("x-lc-token", token2);
        String returnJsonObjectData = paramJSONObject.toString();
        String dataEncrypt = this.gjhtAssignService.getEncrypt(returnJsonObjectData, sm4Key2);
        HttpResponse httpResponse = ((HttpRequest)HttpUtil.createPost((String)(this.gjhtAssignService.getGtUrl() + "/landCloud/getTempSignature")).contentType("application/json").addHeaders(headerMap2)).body(dataEncrypt).execute();
        if (ObjectUtils.isEmpty((Object)httpResponse)) {
            this.logger.info("\u670d\u52a1\u53d1\u8d77\u67e5\u8be2\u672a\u8fd4\u56de\u4efb\u4f55\u7ed3\u679c\uff01", new Object[0]);
            return null;
        }
        String resultUrls = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");
        if (StringUtils.isNotBlank((CharSequence)resultUrls) && (resultUrls.indexOf("\"code\": 200") != -1 || resultUrls.indexOf("\"code\":200") != -1)) {
            JSONObject resultUrlData = JSONObject.parseObject((String)resultUrls);
            String resultDataSecret = resultUrlData.getString("data");
            String dataSecret = this.gjhtAssignService.getDecrypt(sm22, resultDataSecret, xLcSecret);
            JSONArray urlDatas = JSONObject.parseArray((String)dataSecret, (Feature[])new Feature[0]);
            if (urlDatas == null || urlDatas.isEmpty()) {
                return null;
            }
            ArrayList<String> tempUrls = new ArrayList<String>();
            for (int i = 0; i < urlDatas.size(); ++i) {
                tempUrls.add(urlDatas.getString(i));
            }
            return tempUrls;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] getDownload(String uploadurl) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        block12: {
            byte[] bytes;
            int length;
            InputStream inputStream = null;
            byteArrayOutputStream = null;
            HttpURLConnection httpURLConnection = null;
            URL url = new URL(uploadurl);
            URLConnection urlConnection = url.openConnection();
            httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(600000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            inputStream = httpURLConnection.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            inputStream.close();
            httpURLConnection.disconnect();
            byArray = bytes = byteArrayOutputStream.toByteArray();
            if (byteArrayOutputStream == null) break block12;
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception ex) {
                this.logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", new Object[]{ex});
            }
        }
        return byArray;
        catch (Exception e) {
            byte[] byArray2;
            block13: {
                try {
                    e.printStackTrace();
                    byArray2 = null;
                    if (byteArrayOutputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Exception ex) {
                            this.logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", new Object[]{ex});
                        }
                    }
                    throw throwable;
                }
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception ex) {
                    this.logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", new Object[]{ex});
                }
            }
            return byArray2;
        }
    }

    private String getId(String name, String tcbm, String tbybh) {
        String id = "";
        int hashCode = (tcbm + "_" + tbybh + "_" + name).hashCode();
        id = hashCode < 0 ? "1" + String.valueOf(hashCode *= -1) : "2" + String.valueOf(hashCode);
        return id;
    }
}

