/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TaskGeometrySplitService {
    private final GiLoger logger = GwLoger.getLoger(TaskGeometrySplitService.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${project.union.spatialAnalysis:false}")
    private Boolean spatialAnalysis;
    @Value(value="${project.union.spatialAnalysisUrl:}")
    private String spatialAnalysisUrl;

    public List<String> split(Geometry polygon, Geometry splitLine) throws Exception {
        if (polygon != null && splitLine != null && !polygon.intersects(splitLine)) {
            throw new RuntimeException("\u5206\u5272\u5931\u8d25");
        }
        WKTReader wktReader = new WKTReader();
        Coordinate[] coordinates = splitLine.getCoordinates();
        Point start = (Point)wktReader.read("POINT(" + coordinates[0].x + " " + coordinates[0].y + ")");
        Point end = (Point)wktReader.read("POINT(" + coordinates[coordinates.length - 1].x + " " + coordinates[coordinates.length - 1].y + ")");
        if (splitLine.getGeometryType().equals("LineString") && (start.within(polygon) || end.within(polygon))) {
            throw new RuntimeException("\u5206\u5272\u5931\u8d25");
        }
        String polygonWkt = polygon.toString();
        String splitLineWkt = splitLine.toString();
        if (this.spatialAnalysis.booleanValue()) {
            return this.splitByServer(polygonWkt, splitLineWkt);
        }
        String sql = "";
        if (splitLine instanceof LineString) {
            sql = sql + "SELECT ST_ASTEXT(";
            sql = sql + "(ST_DUMP(";
            sql = sql + "ST_SPLIT(";
            sql = sql + "ST_GEOMFROMTEXT('" + polygonWkt + "',0),";
            sql = sql + "ST_GEOMFROMTEXT('" + splitLineWkt + "',0)";
            sql = sql + ")";
            sql = sql + ")).geom) AS \"result\"";
        } else {
            sql = sql + "SELECT * from (SELECT (";
            sql = sql + "(ST_DUMP(";
            sql = sql + "ST_DIFFERENCE(";
            sql = sql + "ST_GEOMFROMTEXT('" + polygonWkt + "',0),";
            sql = sql + "ST_GEOMFROMTEXT('" + splitLineWkt + "',0)";
            sql = sql + ")";
            sql = sql + ")).geom) AS \"result\"";
            sql = sql + " UNION ALL ";
            sql = sql + "SELECT (";
            sql = sql + "ST_INTERSECTION(";
            sql = sql + "ST_GEOMFROMTEXT('" + polygonWkt + "',0),";
            sql = sql + "ST_GEOMFROMTEXT('" + splitLineWkt + "',0)";
            sql = sql + ")) AS \"result\" ) g where st_area(g.result)*power(10,15)>1 ";
        }
        this.logger.info(sql, new Object[0]);
        List list = this.jdbcTemplate.queryForList(sql);
        List wkts = list.stream().map(m -> m.get("result").toString()).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        Geometry geometry = null;
        GeometryFactory geometryFactory = new GeometryFactory();
        for (String wkt : wkts) {
            Polygon polygon1 = null;
            geometry = new WKTReader().read(wkt);
            polygon1 = (Polygon)geometry;
            if (polygon1.getNumInteriorRing() > 0) {
                result.add(wkt.replace("POLYGON", "MULTIPOLYGON(") + ")");
                continue;
            }
            result.add(wkt);
        }
        if (CollectionUtils.isNotEmpty(wkts) && wkts.size() <= 1) {
            throw new RuntimeException("\u5206\u5272\u5931\u8d25");
        }
        return result;
    }

    private List<String> splitByServer(String polygonWkt, String splitLineWkt) {
        String url = this.spatialAnalysisUrl + "/spatial/split";
        String response = HttpUtil.createPost((String)url).form("polygon", (Object)polygonWkt).form("splitLine", (Object)splitLineWkt).execute().body();
        JSONObject result = JSONObject.parseObject((String)response);
        JSONArray dataArray = result.getJSONArray("data");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < dataArray.size(); ++i) {
            list.add(dataArray.getString(i));
        }
        return list;
    }
}

