/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskTaskPiwenRelRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskPiwenRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskWpzfAttrRepository;
import com.geoway.landteam.customtask.task.dto.TbtskTaskPiwenDto;
import com.geoway.landteam.customtask.task.entity.TbtskTaskPiwen;
import com.geoway.landteam.customtask.task.entity.TbtskTaskPiwenRel;
import com.geoway.landteam.customtask.task.entity.TbtskTaskWpzfAttr;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class TbtskTaskPiwenService {
    private static final GiLoger log = GwLoger.getLoger();
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskTaskPiwenRepository tbtskTaskPiwenRepository;
    @Autowired
    TbtskTaskPiwenRelRepository tbtskTaskPiwenRelRepository;
    @Autowired
    TbtskTaskWpzfAttrRepository tbtskTaskWpzfAttrRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;

    public List<TbtskTaskPiwenDto> findPiwenByTaskIdAndDataId(String taskId, String tbId, String groupCode) {
        List dataList;
        String sql = " select rel.f_id relId,rel.f_tbid tbId,ttp.f_id  id,ttp.f_taskid taskId,ttp.f_dataid dataId,ttp.f_type as type,ttp   .f_pzjg pzjg,ttp.f_pzwh pzwh,ttp.f_pzrq pzrq,ttp.f_xmmc xmmc,ttp.f_pwly pwly,ttp.f_pzmj  pzmj,ttp.f_pznydmj pznydmj,ttp.f_pzgdmj pzgdmj,ttp.f_pzyjjbntmj pzyjjbntmj,ttp.f_pzjsydmj pzjsydmj,ttp.f_pzwlymj pzwlymj,ttp.f_pwfj pwfj,ttp.f_pwplfj pwplfj,ttp.f_wbayy wbayy,ttp.f_yxqz yxqz,ttp.f_dz dz,ttp.f_nz nz,ttp.f_xz xz,ttp.f_bz bz,ttp.f_userid userId,ttp.f_regioncode regionCode,ttp.f_pwlb pwlb,ttp.f_tdgylx tdgylx,ttp.f_onlyid onlyId,rel.f_groupcode groupCode from tbtsk_task_piwen_rel rel,tbtsk_task_piwen ttp  where rel.f_piwenid  = ttp.f_id and rel.f_taskid ='" + taskId + "' and rel.f_tbid ='" + tbId + "' ";
        if (StringUtils.isNotBlank((CharSequence)groupCode)) {
            sql = sql + " and rel.f_groupcode like '%" + groupCode + "%' ";
        }
        if ((dataList = this.jdbcTemplate.query(sql = sql + " order by rel.f_createtime asc", (RowMapper)new BeanPropertyRowMapper(TbtskTaskPiwenDto.class))).size() > 0) {
            for (TbtskTaskPiwenDto taskPiwenDto : dataList) {
                String url;
                taskPiwenDto.setIncrement(false);
                if (taskPiwenDto.getDataId().equals(taskPiwenDto.getTbId())) {
                    taskPiwenDto.setIncrement(true);
                }
                if (StringUtils.isNotBlank((CharSequence)taskPiwenDto.getPwfj()) && !taskPiwenDto.getPwfj().contains("AccessKeyId")) {
                    url = this.temporarySignedUrlService.getTemporarySignedUrl("", taskPiwenDto.getPwfj(), null);
                    taskPiwenDto.setPwfj(url);
                }
                if (!StringUtils.isNotBlank((CharSequence)taskPiwenDto.getPwplfj()) || taskPiwenDto.getPwplfj().contains("AccessKeyId")) continue;
                url = this.temporarySignedUrlService.getTemporarySignedUrl("", taskPiwenDto.getPwplfj(), null);
                taskPiwenDto.setPwplfj(url);
            }
        }
        return dataList;
    }

    public Map<String, Object> findPiwenList(Long userId, String taskId, String pzwh, String groupCode, int pageIndex, int pageSize) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = "select * from  tbtsk_task_piwen where 1 = 1  ";
        String countSql = "select count(1) from tbtsk_task_piwen where 1 = 1 ";
        if (StringUtils.isNotBlank((CharSequence)pzwh)) {
            sql = sql + " and f_pzwh like '%" + pzwh + "%'";
            countSql = countSql + " and f_pzwh like '%" + pzwh + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)groupCode)) {
            sql = sql + " and f_groupcode like '%" + groupCode + "%'";
            countSql = countSql + " and f_groupcode like '%" + groupCode + "%'";
        }
        int start = (pageIndex - 1) * pageSize;
        sql = sql + " order by f_createtime desc limit " + pageSize + " offset " + start;
        List mapList = this.jdbcTemplate.queryForList(sql);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(countSql, Integer.class);
        result.put("datas", mapList);
        result.put("totalNum", count);
        return result;
    }

    public TbtskTaskPiwenDto addTbPiwen(TbtskTaskPiwenDto tbtskTaskPiwenDto, MultipartFile pwfile, MultipartFile pwslfile) throws Exception {
        String result;
        String objectname;
        String ext;
        String fileName;
        TbtskTaskPiwen tbtskTaskPiwen = new TbtskTaskPiwen();
        BeanUtils.copyProperties((Object)tbtskTaskPiwenDto, (Object)tbtskTaskPiwen);
        tbtskTaskPiwen.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if (pwfile != null) {
            fileName = pwfile.getOriginalFilename();
            ext = fileName.substring(fileName.lastIndexOf("."));
            objectname = "media/" + tbtskTaskPiwenDto.getUserId() + "/" + tbtskTaskPiwenDto.getDataId() + "/" + System.currentTimeMillis() + "/" + fileName;
            result = this.defaultOssOperatorService.sendObject2Oss(objectname, pwfile.getInputStream());
            tbtskTaskPiwen.setPwfj(result);
        }
        if (pwslfile != null) {
            fileName = pwslfile.getOriginalFilename();
            ext = fileName.substring(fileName.lastIndexOf("."));
            objectname = "media/" + tbtskTaskPiwenDto.getUserId() + "/" + tbtskTaskPiwenDto.getDataId() + "/" + System.currentTimeMillis() + "/" + fileName;
            result = this.defaultOssOperatorService.sendObject2Oss(objectname, pwslfile.getInputStream());
            tbtskTaskPiwen.setPwplfj(result);
        }
        TbtskTaskPiwen tbtskTaskPiwen1 = (TbtskTaskPiwen)this.tbtskTaskPiwenRepository.save((Object)tbtskTaskPiwen);
        TbtskTaskPiwenRel tbtskTaskPiwenRel = new TbtskTaskPiwenRel();
        tbtskTaskPiwenRel.setPiwenId(tbtskTaskPiwen1.getId());
        tbtskTaskPiwenRel.setTaskId(tbtskTaskPiwen1.getTaskId());
        tbtskTaskPiwenRel.setTbId(tbtskTaskPiwen1.getDataId());
        tbtskTaskPiwenRel.setUserId(tbtskTaskPiwenDto.getUserId());
        tbtskTaskPiwenRel.setGroupCode(tbtskTaskPiwen1.getGroupCode());
        tbtskTaskPiwenRel.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.tbtskTaskPiwenRelRepository.save((Object)tbtskTaskPiwenRel);
        tbtskTaskPiwenDto.setId(tbtskTaskPiwen1.getId());
        tbtskTaskPiwenDto.setRelId(tbtskTaskPiwenRel.getId());
        tbtskTaskPiwenDto.setTbId(tbtskTaskPiwenRel.getTbId());
        tbtskTaskPiwenDto.setPwfj(tbtskTaskPiwen1.getPwfj());
        tbtskTaskPiwenDto.setPwplfj(tbtskTaskPiwen1.getPwplfj());
        return tbtskTaskPiwenDto;
    }

    public void relTbPiwen(Long userId, String piwenIds, String taskId, String tbId, String groupCode) {
        List<String> piwenIdList = Arrays.asList(piwenIds.split(","));
        ArrayList<TbtskTaskPiwenRel> tbtskTaskPiwenRels = new ArrayList<TbtskTaskPiwenRel>();
        for (String s : piwenIdList) {
            List rels = this.tbtskTaskPiwenRelRepository.findPiwenByTaskIdAndDataIdAndPiwenId(taskId, tbId, s);
            if (rels.size() > 0) continue;
            TbtskTaskPiwenRel tbtskTaskPiwenRel = new TbtskTaskPiwenRel();
            tbtskTaskPiwenRel.setPiwenId(s);
            tbtskTaskPiwenRel.setTaskId(taskId);
            tbtskTaskPiwenRel.setTbId(tbId);
            tbtskTaskPiwenRel.setUserId(userId);
            tbtskTaskPiwenRel.setCreateTime(new Timestamp(System.currentTimeMillis()));
            if (StringUtils.isNotBlank((CharSequence)groupCode)) {
                tbtskTaskPiwenRel.setGroupCode(groupCode);
            }
            tbtskTaskPiwenRels.add(tbtskTaskPiwenRel);
        }
        this.tbtskTaskPiwenRelRepository.saveAll(tbtskTaskPiwenRels);
    }

    public TbtskTaskPiwen updateTbPiwen(TbtskTaskPiwenDto tbtskTaskPiwenDto, MultipartFile pwfile, MultipartFile pwslfile) throws Exception {
        String result;
        String objectname;
        String ext;
        String fileName;
        if (StringUtils.isBlank((CharSequence)tbtskTaskPiwenDto.getId())) {
            throw new GwValidateException("\u4e3b\u952eid\u4e0d\u80fd\u4e3anull");
        }
        TbtskTaskPiwen tbtskTaskPiwen = this.tbtskTaskPiwenRepository.findById((Object)tbtskTaskPiwenDto.getId()).orElse(null);
        if (tbtskTaskPiwen == null) {
            throw new GwValidateException("\u672a\u627e\u5230\u6279\u6587\u8bb0\u5f55");
        }
        BeanUtils.copyProperties((Object)tbtskTaskPiwenDto, (Object)tbtskTaskPiwen, (String[])new String[]{"pwfj", "pwplfj"});
        tbtskTaskPiwen.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if (pwfile != null) {
            fileName = pwfile.getOriginalFilename();
            ext = fileName.substring(fileName.lastIndexOf("."));
            objectname = "media/" + tbtskTaskPiwenDto.getUserId() + "/" + tbtskTaskPiwenDto.getDataId() + "/" + System.currentTimeMillis() + "/" + fileName;
            result = this.defaultOssOperatorService.sendObject2Oss(objectname, pwfile.getInputStream());
            tbtskTaskPiwen.setPwfj(result);
        }
        if (pwslfile != null) {
            fileName = pwslfile.getOriginalFilename();
            ext = fileName.substring(fileName.lastIndexOf("."));
            objectname = "media/" + tbtskTaskPiwenDto.getUserId() + "/" + tbtskTaskPiwenDto.getDataId() + "/" + System.currentTimeMillis() + "/" + fileName;
            result = this.defaultOssOperatorService.sendObject2Oss(objectname, pwslfile.getInputStream());
            tbtskTaskPiwen.setPwplfj(result);
        }
        this.tbtskTaskPiwenRepository.save((Object)tbtskTaskPiwen);
        return tbtskTaskPiwen;
    }

    public void deleteTbPiwen(String relId) {
        TbtskTaskPiwenRel tbtskTaskPiwenRel = this.tbtskTaskPiwenRelRepository.findById((Object)relId).orElse(null);
        if (tbtskTaskPiwenRel == null) {
            throw new GwValidateException("\u672a\u627e\u5230\u6279\u6587\u5173\u8054\u8bb0\u5f55");
        }
        TbtskTaskPiwen tbtskTaskPiwen = this.tbtskTaskPiwenRepository.findById((Object)tbtskTaskPiwenRel.getPiwenId()).orElse(null);
        if (tbtskTaskPiwen == null) {
            throw new GwValidateException("\u672a\u627e\u5230\u6279\u6587\u8bb0\u5f55");
        }
        List rels = this.tbtskTaskPiwenRelRepository.findPiwenByPiwenId(tbtskTaskPiwenRel.getPiwenId());
        if (rels.size() == 1 && ((TbtskTaskPiwenRel)rels.get(0)).getTbId().equals(tbtskTaskPiwen.getDataId())) {
            this.tbtskTaskPiwenRelRepository.deleteById((Object)relId);
            this.tbtskTaskPiwenRepository.deleteById((Object)((TbtskTaskPiwenRel)rels.get(0)).getPiwenId());
        } else if (rels.size() > 1 && !tbtskTaskPiwenRel.getTbId().equals(tbtskTaskPiwen.getDataId())) {
            this.tbtskTaskPiwenRelRepository.deleteById((Object)relId);
        } else {
            throw new GwValidateException("\u8fd8\u6709\u5176\u4ed6\u6279\u6587\u5173\u8054\u8bb0\u5f55\u4e0d\u80fd\u5220\u9664\u6279\u6587");
        }
    }

    public List<TbtskTaskPiwenRel> findPiwenByTaskIdAndDataId(String taskId, String tbId) {
        return this.tbtskTaskPiwenRelRepository.findPiwenByTaskIdAndDataId(taskId, tbId);
    }

    public List<TbtskTaskPiwenRel> findPiwenByTaskIdAndDataIds(String taskId, List<String> tbIds) {
        return this.tbtskTaskPiwenRelRepository.findPiwenByTaskIdAndDataIds(taskId, tbIds);
    }

    public void uploadBatchAttachByWpzf(Long userId, String taskId, String tbId, String type, MultipartFile[] files) throws IOException {
        ArrayList<TbtskTaskWpzfAttr> tbtskTaskWpzfAttrs = new ArrayList<TbtskTaskWpzfAttr>();
        if (files.length > 0) {
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                String ext = fileName.substring(fileName.lastIndexOf("."));
                String objectname = "media/" + userId + "/" + tbId + "/" + System.currentTimeMillis() + "/" + fileName;
                String contentType = "";
                TbtskTaskWpzfAttr media = new TbtskTaskWpzfAttr();
                media.setTaskId(taskId);
                if (ext.contains("jpg") || ext.contains("png")) {
                    media.setType("1");
                } else if (ext.contains("mp4")) {
                    media.setType("2");
                } else if (ext.contains("mp3")) {
                    media.setType("3");
                } else if (ext.contains("osgb")) {
                    media.setType("4");
                } else if (ext.contains("pdf")) {
                    media.setType("5");
                    contentType = "application/pdf";
                } else {
                    media.setType("6");
                }
                String result = this.defaultOssOperatorService.sendObject2Oss(objectname, file.getInputStream(), contentType);
                media.setSort(type);
                media.setTbId(tbId);
                media.setCreateTime(new Timestamp(System.currentTimeMillis()));
                media.setServerPath(result);
                media.setUserId(userId);
                tbtskTaskWpzfAttrs.add(media);
            }
        } else {
            throw new GwValidateException("\u7f3a\u5931\u6587\u4ef6\u9644\u4ef6");
        }
        this.tbtskTaskWpzfAttrRepository.saveAll(tbtskTaskWpzfAttrs);
    }

    public void delAttachByWpzf(String attrId) {
        this.tbtskTaskWpzfAttrRepository.deleteById((Object)attrId);
    }

    public List<TbtskTaskWpzfAttr> findAttrsByWpzf(String taskId, String tbId, String sort) {
        List tbtskTaskWpzfAttrs = this.tbtskTaskWpzfAttrRepository.findByTaskIdAndTbIdAndType(taskId, tbId, sort);
        for (TbtskTaskWpzfAttr tbtskTaskWpzfAttr : tbtskTaskWpzfAttrs) {
            if (!StringUtils.isNotBlank((CharSequence)tbtskTaskWpzfAttr.getServerPath()) || tbtskTaskWpzfAttr.getServerPath().contains("AccessKeyId")) continue;
            String url = this.temporarySignedUrlService.getTemporarySignedUrl("", tbtskTaskWpzfAttr.getServerPath(), null);
            tbtskTaskWpzfAttr.setTemPath(url);
        }
        return tbtskTaskWpzfAttrs;
    }

    public List<TbtskTaskWpzfAttr> findByTaskIdAndTbIdAndSort(String taskId, String tbId, String sort) {
        List tbtskTaskWpzfAttrs = this.tbtskTaskWpzfAttrRepository.findByTaskIdAndTbIdAndType(taskId, tbId, sort);
        return tbtskTaskWpzfAttrs;
    }
}

