/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.pub.DataDownloadDailyTaskService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadZjdService;
import com.geoway.landteam.customtask.servface.pub.DownloadFileDailyTaskService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.task.MIDownloadService;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDataDownloadTakeHandService;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadExcelDailyTaskServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryDailyTaskKmlServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadGeometryDailyTaskShapeServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadTxtDailyTaskServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MMDownloadGeometryTakeHandKmlServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MMDownloadGeometryTakeHandShapeServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.patrolclue.pub.impl.MDownloadExcelDailyClueServiceImpl;
import com.geoway.landteam.landcloud.service.statistics.CgjcApproveRecordDetailService;
import com.geoway.landteam.landcloud.service.statistics.CgjcApproveRecordService;
import com.geoway.landteam.landcloud.service.statistics.CgjcProgressService;
import com.geoway.landteam.landcloud.service.statistics.GdLcTotalService;
import com.geoway.landteam.patrolclue.model.pub.DownloadParameter;
import com.geoway.landteam.patrolclue.service.pub.impl.JcClueDownloadService;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MDownloadServiceImpl
implements MIDownloadService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadServiceImpl.class);
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    DataDownloadDailyTaskService dataDownloadDailyTaskService;
    @Autowired
    MDataDownloadTakeHandService MDataDownloadTakeHandService;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    DataDownloadZjdService dataDownloadZjdService;
    @Autowired
    MMDownloadGeometryTakeHandKmlServiceImpl downloadGeometryTakeHandKmlService;
    @Autowired
    MMDownloadGeometryTakeHandShapeServiceImpl downloadGeometryTakeHandShapeService;
    @Autowired
    MDownloadGeometryDailyTaskKmlServiceImpl downloadGeometryDailyTaskKmlService;
    @Autowired
    MDownloadGeometryDailyTaskShapeServiceImpl downloadGeometryDailyTaskShapeService;
    @Autowired
    MDownloadExcelDailyTaskServiceImpl downloadExcelDailyTaskService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    MDownloadTxtDailyTaskServiceImpl downloadTxtDailyTaskService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;
    private DownloadGeometryService downloadGeometryService;
    @Autowired
    MDownloadExcelDailyClueServiceImpl downloadExcelDailyClueService;
    private JcClueDownloadService jcClueDownloadService;
    @Autowired
    DownloadFileDailyTaskService downloadFileDailyTaskService;
    @Autowired
    CgjcApproveRecordService cgjcApproveRecordService;
    @Autowired
    CgjcProgressService cgjcProgressService;
    @Autowired
    GdLcTotalService gdLcTotalService;
    @Autowired
    CgjcApproveRecordDetailService cgjcApproveRecordDetailService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    MTbtskFieldsService fieldsService;

    public boolean runDataDownload(TaskRecord record) throws Exception {
        com.geoway.landteam.customtask.pub.dto.DownloadParameter downloadParameter;
        JSONObject jsonObject;
        if (record == null) {
            return false;
        }
        this.logger.debug("runDataDownload \u6267\u884c----\u5f00\u59cb-----", new Object[0]);
        String parameter = record.getParam();
        if (StringUtils.isNotBlank((CharSequence)parameter) && (jsonObject = JSONObject.parseObject((String)parameter)) != null && (downloadParameter = (com.geoway.landteam.customtask.pub.dto.DownloadParameter)JSONObject.toJavaObject((JSON)jsonObject, com.geoway.landteam.customtask.pub.dto.DownloadParameter.class)) != null) {
            String dataType = downloadParameter.getDataType();
            String bizType = downloadParameter.getBizType();
            if (StringUtils.isNotBlank((CharSequence)bizType)) {
                block7 : switch (bizType.toLowerCase()) {
                    case "dailytask": {
                        if (!StringUtils.isNotBlank((CharSequence)dataType)) break;
                        switch (dataType.toLowerCase()) {
                            case "attach": {
                                DataDownloadRecord dataDownloadRecord = null;
                                Object value = this.redisTemplate.opsForValue().get((Object)downloadParameter.getRecordId());
                                if (value == null || (dataDownloadRecord = (DataDownloadRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)value.toString()), DataDownloadRecord.class)) == null) break block7;
                                this.dataDownloadDailyTaskService.downloadDailyTaskAttach(downloadParameter.getTaskId(), downloadParameter.getTbIds(), downloadParameter.getUserId(), dataDownloadRecord, downloadParameter.getDownloadType());
                                break block7;
                            }
                            case "kml": {
                                boolean initSuccess;
                                this.downloadGeometryService = this.downloadGeometryDailyTaskKmlService;
                                if (this.downloadGeometryService == null || !(initSuccess = this.downloadGeometryService.init(downloadParameter))) break block7;
                                this.downloadGeometryService.doDownload();
                                break block7;
                            }
                            case "shp": 
                            case "shape": {
                                boolean initSuccess;
                                this.downloadGeometryService = this.downloadGeometryDailyTaskShapeService;
                                if (this.downloadGeometryService == null || !(initSuccess = this.downloadGeometryService.init(downloadParameter))) break block7;
                                this.downloadGeometryService.doDownload();
                                break block7;
                            }
                            case "excel": {
                                boolean initSuccess;
                                if (downloadParameter.getType() != null && downloadParameter.getType().equals(DownloadTypeEnum.\u7ebf\u7d22.getCode())) {
                                    this.jcClueDownloadService = this.downloadExcelDailyClueService;
                                    if (this.jcClueDownloadService == null) break block7;
                                    DownloadParameter downloadParameterClue = new DownloadParameter();
                                    BeanUtils.copyProperties((Object)downloadParameter, (Object)downloadParameterClue);
                                    boolean initSuccess2 = this.jcClueDownloadService.init(downloadParameterClue);
                                    if (!initSuccess2) break block7;
                                    this.jcClueDownloadService.doDownloadClue();
                                    break block7;
                                }
                                this.downloadGeometryService = this.downloadExcelDailyTaskService;
                                if (this.downloadGeometryService == null || !(initSuccess = this.downloadGeometryService.init(downloadParameter))) break block7;
                                this.downloadGeometryService.doDownload();
                                break block7;
                            }
                            case "zjgg": {
                                if (downloadParameter == null) break block7;
                                this.downloadFileDailyTaskService.export(downloadParameter);
                                break block7;
                            }
                            case "txt": {
                                boolean initSuccess = this.downloadTxtDailyTaskService.init(downloadParameter);
                                if (!initSuccess) break block7;
                                this.downloadTxtDailyTaskService.doDownload();
                                break block7;
                            }
                            default: {
                                throw new GwValidateException("\u4efb\u52a1\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                            }
                        }
                    }
                    case "ssp": {
                        if (!StringUtils.isNotBlank((CharSequence)dataType)) break;
                        switch (dataType.toLowerCase()) {
                            case "attach": {
                                this.logger.debug("\u968f\u624b\u62cd\u4e0b\u8f7d\u6570\u636e\u5f00\u59cb\u5904\u7406", new Object[0]);
                                DataDownloadRecord dataDownloadRecord = null;
                                Object value = this.redisTemplate.opsForValue().get((Object)downloadParameter.getRecordId());
                                if (value == null || (dataDownloadRecord = (DataDownloadRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)value.toString()), DataDownloadRecord.class)) == null) break block7;
                                this.MDataDownloadTakeHandService.downloadTakeHandAttach(downloadParameter.getTbIds(), downloadParameter.getTbNames(), downloadParameter.getUserId(), dataDownloadRecord);
                                break block7;
                            }
                            case "kml": {
                                boolean initSuccess;
                                this.downloadGeometryService = this.downloadGeometryTakeHandKmlService;
                                if (this.downloadGeometryService == null || !(initSuccess = this.downloadGeometryService.init(downloadParameter))) break block7;
                                this.downloadGeometryService.doDownload();
                                break block7;
                            }
                            case "shp": 
                            case "shape": {
                                boolean initSuccess;
                                this.downloadGeometryService = this.downloadGeometryTakeHandShapeService;
                                if (this.downloadGeometryService != null && (initSuccess = this.downloadGeometryService.init(downloadParameter))) {
                                    this.downloadGeometryService.doDownload();
                                }
                            }
                            default: {
                                throw new GwValidateException("\u4efb\u52a1\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                            }
                        }
                    }
                    case "zjd": {
                        DataDownloadRecord dataDownloadRecord = null;
                        Object value = this.redisTemplate.opsForValue().get((Object)downloadParameter.getRecordId());
                        if (value == null || (dataDownloadRecord = (DataDownloadRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)value.toString()), DataDownloadRecord.class)) == null) break;
                        dataDownloadRecord.setBatchOpr(true);
                        this.dataDownloadZjdService.doDownloadData(downloadParameter.getTaskId(), downloadParameter.getTbIds(), downloadParameter.getUserId(), dataDownloadRecord, downloadParameter.getDownloadType());
                        break;
                    }
                    case "statistics": {
                        if (downloadParameter.getDataType().equals("approveRecord")) {
                            return this.cgjcApproveRecordService.runDownloadCgjcApprove(record, downloadParameter);
                        }
                        if (downloadParameter.getDataType().equals("approveRecordDetail")) {
                            return this.cgjcApproveRecordDetailService.runDownloadCgjcApproveDetail(record, downloadParameter);
                        }
                        if (downloadParameter.getDataType().equals("progressRecord")) {
                            this.cgjcProgressService.runDownloadCgjcProgress(record, downloadParameter);
                            break;
                        }
                        if (!downloadParameter.getDataType().equals("gdLrLcRecord")) break;
                        this.gdLcTotalService.runDownloadGdLrLcTotalExcel(record, downloadParameter);
                        break;
                    }
                    default: {
                        throw new GwValidateException("\u4efb\u52a1\u6570\u636e\u7c7b\u578b\u9519\u8bef");
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runDataDownloadByWpzf(TaskRecord record) throws Exception {
        DataDownloadRecord downloadRecord = this.dataDownloadRecordService.findeOne(record.getId());
        downloadRecord.setStartTime(new Date());
        downloadRecord.setState(DataDownloadStateEnum.PACKING);
        this.dataDownloadRecordService.update(downloadRecord);
        try {
            JSONObject paramsObject = JSONObject.parseObject((String)record.getParam());
            TaskQueryParameter queryParameter = (TaskQueryParameter)JSONObject.parseObject((String)paramsObject.getString("taskQueryParameter"), TaskQueryParameter.class);
            String taskId = queryParameter.getTaskId();
            TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
            TbtskObjectinfo tbtskObjectinfo = null;
            if (tskTaskBiz != null && StringUtils.isNotBlank((CharSequence)tskTaskBiz.getTableId())) {
                tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            ArrayList<Map<String, Object>> maps = new ArrayList();
            String fields = this.fieldList2(queryParameter.getTaskId());
            if (StringUtils.isNotBlank((CharSequence)queryParameter.getTbIds())) {
                String sql = " select " + fields + " from " + tbtskObjectinfo.getfTablename() + " where f_id in ( '" + queryParameter.getTbIds().replace(",", "','") + "' )";
                maps = this.jdbcTemplate.queryForList(sql);
            } else {
                Pair queryParamPair = this.tskTaskBizService.parseQueryParameter(queryParameter);
                String tableName = (String)queryParamPair.getKey();
                String where = (String)queryParamPair.getValue();
                String count = " select count(1) from " + tableName + " where " + where;
                Integer integer = (Integer)this.jdbcTemplate.queryForObject(count, Integer.class);
                int rows = 5000;
                int page = integer % rows == 0 ? integer / rows : integer / rows + 1;
                for (int i = 1; i <= page; ++i) {
                    String sql = " select " + fields + " from " + tableName + "  where  " + where + " limit " + rows + " offset " + (i - 1) * rows;
                    maps.addAll(this.jdbcTemplate.queryForList(sql));
                }
            }
            ClassPathResource tbjxlxfx = new ClassPathResource("/static/excel/\u536b\u7247\u6267\u6cd5\u5b9a\u5236\u660e\u7ec6\u8868.xlsx");
            InputStream tbjxlxfxInputStream = tbjxlxfx.getInputStream();
            String id = UUID.randomUUID().toString().replace("-", "");
            File tbjxlxfxFile = File.createTempFile("template_tbjxlxfx_copy" + id, ".xlsx");
            try {
                FileUtils.copyInputStreamToFile((InputStream)tbjxlxfxInputStream, (File)tbjxlxfxFile);
            }
            finally {
                IOUtils.closeQuietly((InputStream)tbjxlxfxInputStream);
            }
            File barray = this.exportExcel(maps, tbjxlxfxFile, tbtskObjectinfo.getSplitTableName(), tbtskObjectinfo.getfId());
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String dateString = sdf.format(new Date());
                String obsFilePath = "wpzfExcel/" + taskId + "/\u9879\u76ee\u660e\u7ec6_" + dateString + ".xlsx";
                String resultUrl = this.defaultOssOperatorService.sendObject2Oss(obsFilePath, barray);
                downloadRecord.setTbCount(Integer.valueOf(maps.size()));
                if (resultUrl != null) {
                    downloadRecord.setUrl(resultUrl);
                    downloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                    downloadRecord.setEndTime(new Date());
                    Double zipFileSize = (double)barray.length() / 1024.0;
                    downloadRecord.setAttachSize(zipFileSize);
                }
                this.dataDownloadRecordService.update(downloadRecord);
            }
            finally {
                if (barray != null) {
                    barray.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            downloadRecord.setState(DataDownloadStateEnum.FAILED);
            downloadRecord.setEndTime(new Date());
            this.dataDownloadRecordService.update(downloadRecord);
            throw e;
        }
        return true;
    }

    public File exportExcel(List<Map<String, Object>> maps, File templateFile, String splitTableName, String tableId) throws IOException {
        if (maps == null) {
            return null;
        }
        if (this.uploadDir == null) {
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        String tempFolderPath = this.uploadDir;
        FileUtil.creatDirectoryIfNotExist((String)tempFolderPath);
        String fileName = UUID.randomUUID() + ".xlsx";
        String filePath = this.uploadDir + File.separator + fileName;
        SXSSFWorkbook wb = null;
        XSSFWorkbook header = null;
        FileInputStream fileInputStream = null;
        Object barray = null;
        Object bos = null;
        OutputStream os = null;
        File file = null;
        try {
            fileInputStream = new FileInputStream(templateFile);
            header = new XSSFWorkbook((InputStream)fileInputStream);
            wb = new SXSSFWorkbook(header);
            this.tbjxlxfxSheet((Workbook)wb, maps, splitTableName, tableId);
            os = new FileOutputStream(filePath);
            wb.write(os);
            file = new File(filePath);
            this.logger.info("excel\u5b8c\u6210\uff01\uff01\uff01\uff01\uff01", new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    private void tbjxlxfxSheet(Workbook wb, List<Map<String, Object>> maps, String splitTableName, String tableId) {
        List<TbtskFields> list = this.fieldsService.getAllFieldsByTableID(tableId);
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tableId);
        ArrayList<String> StringList = new ArrayList<String>();
        ArrayList<String> numList = new ArrayList<String>();
        for (TbtskFields fields : list) {
            if (fields.getfFieldtype().equals("3")) {
                numList.add(fields.getfFieldname());
                continue;
            }
            if (!fields.getfFieldtype().equals("1") && !fields.getfFieldtype().equals("2")) continue;
            StringList.add(fields.getfFieldname());
        }
        Sheet workSheet = wb.getSheetAt(0);
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        List<String> fieldList = this.fieldList2List();
        String fields = this.fieldList2(tbtskObjectinfo.getTaskId());
        int dataRow = 3;
        List ids = maps.stream().map(r -> r.get("id").toString()).collect(Collectors.toList());
        int size = ids.size();
        int rows = 5000;
        int page = size % rows == 0 ? size / rows : size / rows + 1;
        ArrayList AllchildMaps = new ArrayList();
        for (int i = 1; i <= page; ++i) {
            String sql = " select  " + fields + ",f_splitedid from " + splitTableName + " tb where f_splitedid in ('" + ids.stream().skip((i - 1) * rows).limit(rows).collect(Collectors.joining("','")) + "') ";
            AllchildMaps.addAll(this.jdbcTemplate.queryForList(sql));
        }
        int count = 0;
        if (maps.size() > 0) {
            for (Map<String, Object> map : maps) {
                Row row;
                ++count;
                String f_issplitted = MapUtils.getString(map, (Object)"f_issplitted", (String)"");
                if (StringUtils.isNotBlank((CharSequence)f_issplitted) && "1".equals(f_issplitted)) {
                    String f_id = MapUtils.getString(map, (Object)"id", (String)"");
                    List<Object> childMaps = new ArrayList();
                    if (AllchildMaps.stream().filter(r -> f_id.equals(r.get("f_splitedid").toString())).collect(Collectors.toList()).isEmpty()) continue;
                    childMaps = AllchildMaps.stream().filter(r -> f_id.equals(r.get("f_splitedid").toString())).collect(Collectors.toList());
                    row = workSheet.createRow(dataRow);
                    for (int j = 0; j < fieldList.size(); ++j) {
                        String string = fieldList.get(j);
                        Cell cell0 = row.createCell(j);
                        if (j > 84 && j < 155) {
                            Object fieldValue;
                            if (StringList.contains(string)) {
                                fieldValue = "";
                                for (Map map2 : childMaps) {
                                    if (map2.get(string) == null) continue;
                                    fieldValue = (String)fieldValue + map2.get(string) + ";";
                                }
                                cell0.setCellValue((String)fieldValue);
                            } else if (numList.contains(string)) {
                                fieldValue = 0.0;
                                for (Map map3 : childMaps) {
                                    if (map3.get(string) == null) continue;
                                    fieldValue = (Double)fieldValue + Double.valueOf(map3.get(string).toString());
                                }
                                if ("0".equals(((Double)fieldValue).toString())) {
                                    cell0.setCellValue("");
                                } else {
                                    cell0.setCellValue(((Double)fieldValue).doubleValue());
                                }
                            }
                        } else if ("cf".equals(string)) {
                            cell0.setCellValue("\u88ab\u62c6\u5206");
                        } else {
                            cell0.setCellValue(map.get(string) != null ? map.get(string).toString() : null);
                        }
                        cell0.setCellStyle(cellStyle);
                    }
                    ++dataRow;
                    for (Map map4 : childMaps) {
                        row = workSheet.createRow(dataRow);
                        for (int j = 0; j < fieldList.size(); ++j) {
                            String fieldName = fieldList.get(j);
                            Cell cell0 = row.createCell(j);
                            if ("cf".equals(fieldName)) {
                                cell0.setCellValue("\u62c6\u5206");
                            } else {
                                cell0.setCellValue(map4.get(fieldName) != null ? map4.get(fieldName).toString() : null);
                            }
                            cell0.setCellStyle(cellStyle);
                        }
                        ++dataRow;
                    }
                    continue;
                }
                row = workSheet.createRow(dataRow);
                for (int j = 0; j < fieldList.size(); ++j) {
                    String fieldName = fieldList.get(j);
                    Cell cell0 = row.createCell(j);
                    cell0.setCellValue(map.get(fieldName) != null ? map.get(fieldName).toString() : null);
                    cell0.setCellStyle(cellStyle);
                }
                ++dataRow;
            }
        }
    }

    public String fieldList2(String taskId) {
        String field = " ROW_NUMBER() over() xh,f_sjxzqdm,f_sjxzqmc,f_xjxzqdm,f_xjxzqmc,f_xzqdm,f_xzqmc,f_jcbh,f_jcpc,f_xfsj,f_tblx,f_tbfl,f_zlwz,f_jcmj_n1,f_gdmj_n1,f_yjjbntmj,f_nydmj_n1,f_jsy_n1,f_wlydmj,f_stbhhxmj,f_gdbhmbmj,f_czkfbjmj,                 f_ydspmjm+f_tdgymjm+f_zjggjxzs+f_zjggjxdk+f_gkfqdjxm+f_bdcdjmjm pwth,f_bdcdjzgd,f_bdcdjzyj,f_ydspzb+f_tdgyzb+f_zjggj_n1+f_zjggj_n2+f_gkfqdjxz+f_bdcdjzb sxthbl,                   f_ydsppzwh||','||f_tdgypzwh||','||f_zjggj_n6||','||f_zjggj_n4||','||f_gkfqdpzw||','||f_bdcqzh sxthwh,                  f_ydspmjm,f_ydspzb,f_ydspxmmc,f_ydsppzwh,f_tdgymjm,f_tdgyzb,f_tdgyxmmc,f_tdgypzwh,f_zjggjxzs,f_zjggj_n1,f_zjggj_n3,f_zjggj_n6,f_zjggjxdk,f_zjggj_n2,f_zjggj_n4,f_zjggj_n5,f_gkfqdjxm,f_gkfqdjxz,f_gkfqdjxx,f_gkfqdpzw,f_zjggcjqm,f_zjggcjqz,f_zjggcjqx,' ' f_zjggcjqp,                  f_bdcdjxmm,f_bdcqzh,f_bdcdjmjm,f_bdcdjzgd,f_bdcdjzyj,f_bdcdjzb,f_ssnydxm,f_ssnydstr,f_ssnydmj,f_ssnydzgd,f_ssnydzyj,f_lsydxmmc,f_lsydpzwh,f_lsydmj,f_lsydzgdm,f_lsydz_n1,f_tdzzmj,f_tdzzzb,f_tdzzxmmc,f_tdzzpzwh,f_stxfmj,f_stxfzb,f_stxfxmmc,f_stxfpzwh,f_ckqmj,f_ckqzb,f_ckqxmmc,f_ckqpzwh,f_tkqmj,f_tkqzb,f_tkqxmmc,f_tkqpzwh,f_dkbh,                  '' cf,f_dkbs,f_dkmj,f_nydmj_n1,f_gdmj_n1,f_yjjbntmj,f_jsy_n1,f_wlydmj,to_char(to_timestamp(substr(f_submittime,1,10)::int8),'YYYY-mm-dd') tbsj,f_jzrq,                  ( select case when count > 0 then '\u662f' else '\u5426' end from (select count(1) from tbtsk_task_wpzf_tem wpzf where wpzf.f_taskid = '" + taskId + "' and wpzf.f_tbid = tb.f_id ) g ) sfcq,f_sfbgwjsy,f_tbjsqk,f_pdlx,f_hflx,                  (select string_agg(f_pzwh,',') from tbtsk_task_piwen where f_taskid = '" + taskId + "' and f_dataid = tb.f_id) pzwh,                 f_wflx,f_qtlx,f_yblqthfy,f_fnhwfydl,f_xzfnjswf,f_sdwbhlx,f_clfnjswf,f_pzsj,f_wgjylx,f_flhwfwgy,f_nyssjswf,f_sjfzlgyw,f_wfzdlx,f_wfpzzylx,f_wfgdlx,f_hfydsjyt,f_wfydsjyt,f_sfxzlzgd,f_sfwhzj,f_sfdpf,f_sfyfyhfz,f_sfbzxajz,f_sfjjxm,f_sfgefqc,f_sfwjbs,f_pdyjsm,f_xzwfpdyj,f_xmlx,f_xmmc,f_xmzt,f_lxpzjg,f_lxpzwh,f_clfs,f_labh,f_yjdbm,f_bylalx,f_bylasm,f_zglsqk,f_hftdy_n2,f_fgdwmj,f_ccyjj_n2,f_bbmjm_n1,f_bbgdmj,f_bbjbntmj,                  (select string_agg(f_pzwh,',') from tbtsk_task_piwen where f_taskid = '" + taskId + "' and f_dataid = tb.f_id) bbsxpzwh,f_bbsxlx,                 (select case when f_option = 1 then '\u901a\u8fc7' when f_option = 2 then '\u672a\u901a\u8fc7' when f_option = 3 then '\u6682\u5b58' when f_option = 0 then '\u9000\u56de' else '' end  from (select * from (select f_option,f_approve_time from  tbtsk_approve_record where f_stepname = '\u533a\u53bf\u5ba1\u6838' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '" + taskId + "' and tbtsk_approve_record.f_tbid=tb.f_id union all select 0 f_option,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '" + taskId + "' and f_stepname = '\u533a\u53bf\u5ba1\u6838' ) g order by f_approve_time desc limit 1 )g) xianshjg,                  (select f_remark  from (select * from (select f_remark,f_approve_time from  tbtsk_approve_record where f_stepname = '\u533a\u53bf\u5ba1\u6838' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '" + taskId + "' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_remark,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '" + taskId + "' and f_stepname = '\u533a\u53bf\u5ba1\u6838' ) g order by f_approve_time desc limit 1 )g) xianshyj,                  (select f_approve_time  from (select * from (select f_approve_time from  tbtsk_approve_record where f_stepname = '\u533a\u53bf\u5ba1\u6838' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '" + taskId + "' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '" + taskId + "' and f_stepname = '\u533a\u53bf\u5ba1\u6838' ) g order by f_approve_time desc limit 1 )g) xianshsj,                   (select f_approve_user  from (select * from (select f_approve_user,f_approve_time from  tbtsk_approve_record where f_stepname = '\u533a\u53bf\u5ba1\u6838' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '" + taskId + "' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_username f_approve_user,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '" + taskId + "' and f_stepname = '\u533a\u53bf\u5ba1\u6838' ) g order by f_approve_time desc limit 1 )g) xianshry,                  (select case when f_option = 1 then '\u901a\u8fc7' when f_option = 2 then '\u672a\u901a\u8fc7' when f_option = 3 then '\u6682\u5b58' when f_option = 0 then '\u9000\u56de' else '' end  from (select * from (select f_option,f_approve_time from  tbtsk_approve_record where f_stepname = '\u5e02\u7ea7\u5ba1\u6838' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '" + taskId + "' and tbtsk_approve_record.f_tbid=tb.f_id union all select 0 f_option,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '" + taskId + "' and f_stepname = '\u5e02\u7ea7\u5ba1\u6838' ) g order by f_approve_time desc limit 1 )g) shishjg,                  (select f_remark  from (select * from (select f_remark,f_approve_time from  tbtsk_approve_record where f_stepname = '\u5e02\u7ea7\u5ba1\u6838' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '" + taskId + "' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_remark,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '" + taskId + "' and f_stepname = '\u5e02\u7ea7\u5ba1\u6838' ) g order by f_approve_time desc limit 1 )g) shishyj,                  (select f_approve_time  from (select * from (select f_approve_time from  tbtsk_approve_record where f_stepname = '\u5e02\u7ea7\u5ba1\u6838' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '" + taskId + "' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '" + taskId + "' and f_stepname = '\u5e02\u7ea7\u5ba1\u6838' ) g order by f_approve_time desc limit 1 )g) shishsj,                   (select f_approve_user  from (select * from (select f_approve_user,f_approve_time from  tbtsk_approve_record where f_stepname = '\u5e02\u7ea7\u5ba1\u6838' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '" + taskId + "' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_username f_approve_user,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '" + taskId + "' and f_stepname = '\u5e02\u7ea7\u5ba1\u6838' ) g order by f_approve_time desc limit 1 )g) shishry,                  f_sjhfxpd,                case when f_sjhfxpd = '\u5408\u6cd5' then f_sjrdhfmj else null end sjpdhfmj,                   case when f_sjhfxpd = '\u5408\u6cd5' then f_sjrdhfgd else null end sjpdhfgdmj,                   case when f_sjhfxpd = '\u5408\u6cd5' then f_sjrdhfjb else null end sjpdhfjbntmj,                   case when f_sjhfxpd = '\u5408\u6cd5' then f_sjejl else null end sjpdhfejl,                   case when f_sjhfxpd = '\u5176\u4ed6' then f_sjrdqtmj else null end sjpdqtmj,                  case when f_sjhfxpd = '\u5176\u4ed6' then f_sjrdqtgd else null end sjpdqtgdmj,                   case when f_sjhfxpd = '\u5176\u4ed6' then f_sjrdqtjb else null end sjpdqtjbntmj,                   case when f_sjhfxpd = '\u5176\u4ed6' then f_sjejl else null end sjpdqtejl,                   case when f_sjhfxpd = '\u5176\u4ed6' then f_ssnydstr||','||f_lsydpzwh else null end  sjpdqttkbh,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u7cae\u8fdd\u6cd5' then f_sjrdflwf else null end sjpdflwfmj,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u7cae\u8fdd\u6cd5' then f_sjrdf_n3 else null end sjpdflwfgdmj,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u7cae\u8fdd\u6cd5' then f_sjrdf_n4 else null end sjpdflwfjbntmj,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u7cae\u8fdd\u6cd5' then f_sjejl else null end sjpdflwfejl,                   '' sjshwgjymj,'' sjshwgjygdmj,'' sjshwgjyjbntmj,'' sjshwgjyejl,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u519c\u8fdd\u6cd5' and (f_sjhfxpdx = '\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u5b58\u91cf\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730\uff09') then f_sjrdfnwf else null end sjpdclwfmj,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u519c\u8fdd\u6cd5' and (f_sjhfxpdx = '\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u5b58\u91cf\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730\uff09') then f_sjrdf_n1 else null end sjpdclwfgdmj,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u519c\u8fdd\u6cd5' and (f_sjhfxpdx = '\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u5b58\u91cf\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730\uff09') then f_sjrdf_n2 else null end sjpdclwfjbntmj,                  case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u519c\u8fdd\u6cd5' and (f_sjhfxpdx = '\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u5b58\u91cf\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730\uff09') then f_sjejl else null end sjpdclwfejl,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u519c\u8fdd\u6cd5' and f_sjhfxpdx in ('\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u65b0\u589e\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730-\u4e34\u65f6\u7528\u5730\u672a\u6279\u51c6\uff09','\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u65b0\u589e\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730-\u5176\u4ed6\uff09') then f_sjrdfnwf else null end sjpdxzfnmj,                    case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u519c\u8fdd\u6cd5' and f_sjhfxpdx in ('\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u65b0\u589e\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730-\u4e34\u65f6\u7528\u5730\u672a\u6279\u51c6\uff09','\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u65b0\u589e\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730-\u5176\u4ed6\uff09') then f_sjrdf_n1 else null end sjpdxzfngdmj,                    case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u519c\u8fdd\u6cd5' and f_sjhfxpdx in ('\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u65b0\u589e\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730-\u4e34\u65f6\u7528\u5730\u672a\u6279\u51c6\uff09','\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u65b0\u589e\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730-\u5176\u4ed6\uff09') then f_sjrdf_n2 else null end sjpdxzfnjbntmj,                   case when f_sjhfxpd = '\u8fdd\u6cd5' and f_sjrdwflx = '\u975e\u519c\u8fdd\u6cd5' and f_sjhfxpdx in ('\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u65b0\u589e\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730-\u4e34\u65f6\u7528\u5730\u672a\u6279\u51c6\uff09','\u8fdd\u6cd5\u7528\u5730-\u975e\u519c\u5316\u8fdd\u6cd5\u7528\u5730\uff08\u65b0\u589e\u975e\u519c\u5efa\u8bbe\u8fdd\u6cd5\u7528\u5730-\u5176\u4ed6\uff09') then f_sjejl else null end sjpdxzfnejl,                 f_sjrdccmj,f_sjrdccgd,f_sjrdccjb,f_sjrdbbmj,f_sjrdbbgd,f_sjrdbbjb,f_sjrdbbpw,f_sjrdyzjm,f_sjrdyzjg,f_sjrdyzjj,f_sjrdyzjx,                   case when f_status = 1 then '\u672a\u5904\u7406' when f_status = 2 then '\u672a\u63d0\u4ea4' when f_status=4 and f_review_stage is null then '\u5df2\u63d0\u4ea4' when f_status='10' and f_review_stage is null then '\u5df2\u63d0\u62a5' when f_review_stage='91' and (f_reject_status ='0' or f_reject_status  is null) then '\u6751\u7ea7\u5f85\u5ba1\u6838' when f_review_stage='92' and (f_reject_status ='0' or f_reject_status  is null) then '\u4e61\u7ea7\u5f85\u5ba1\u6838' when f_review_stage='93' and (f_reject_status ='0' or f_reject_status  is null) then '\u53bf\u7ea7\u5f85\u5ba1\u6838' when f_review_stage='95' and (f_reject_status ='0' or f_reject_status  is null) then '\u5e02\u7ea7\u5f85\u5ba1\u6838' when f_review_stage='97' and (f_reject_status ='0' or f_reject_status  is null) then '\u7701\u7ea7\u5f85\u5ba1\u6838' when f_review_stage='101' and (f_reject_status ='0' or f_reject_status  is null) then '\u5ba1\u6838\u5b8c\u6210' when f_review_stage='90' and f_reject_status ='1' then '\u5df2\u6253\u56de' when f_review_stage='91' and f_reject_status ='1' then '\u4e61\u7ea7\u5df2\u6253\u56de' when f_review_stage='92' and f_reject_status ='1' then '\u53bf\u7ea7\u5df2\u6253\u56de' when f_review_stage='93' and f_reject_status ='1' then '\u5e02\u7ea7\u5df2\u6253\u56de' when  f_review_stage='95' and f_reject_status ='1' then '\u7701\u7ea7\u5df2\u6253\u56de'  else '' end as jdzt,                   f_sjrdccmj+f_sjrdbbmj zgmj,                  f_sjrdccgd+f_sjrdbbgd zggdmj,                  f_sjrdccjb+f_sjrdbbjb zgjbntmj,                   f_dkmj-(f_sjrdccmj+f_sjrdbbmj) symj,                   f_gdmj_n1-(f_sjrdccgd+f_sjrdbbgd) sygdmj,                   f_yjjbntmj-(f_sjrdccjb+f_sjrdbbjb) syjbntmj,                  f_id as id,                   f_issplitted as f_issplitted  ";
        return field;
    }

    public List<String> fieldList2List() {
        return Arrays.asList("xh,f_sjxzqdm,f_sjxzqmc,f_xjxzqdm,f_xjxzqmc,f_xzqdm,f_xzqmc,f_jcbh,f_jcpc,f_xfsj,f_tblx,f_tbfl,f_zlwz,f_jcmj_n1,f_gdmj_n1,f_yjjbntmj,f_nydmj_n1,f_jsy_n1,f_wlydmj,f_stbhhxmj,f_gdbhmbmj,f_czkfbjmj,pwth,f_bdcdjzgd,f_bdcdjzyj,sxthbl,sxthwh,f_ydspmjm,f_ydspzb,f_ydspxmmc,f_ydsppzwh,f_tdgymjm,f_tdgyzb,f_tdgyxmmc,f_tdgypzwh,f_zjggjxzs,f_zjggj_n1,f_zjggj_n3,f_zjggj_n6,f_zjggjxdk,f_zjggj_n2,f_zjggj_n4,f_zjggj_n5,f_gkfqdjxm,f_gkfqdjxz,f_gkfqdjxx,f_gkfqdpzw,f_zjggcjqm,f_zjggcjqz,f_zjggcjqx,f_zjggcjqp,f_bdcdjxmm,f_bdcqzh,f_bdcdjmjm,f_bdcdjzgd,f_bdcdjzyj,f_bdcdjzb,f_ssnydxm,f_ssnydstr,f_ssnydmj,f_ssnydzgd,f_ssnydzyj,f_lsydxmmc,f_lsydpzwh,f_lsydmj,f_lsydzgdm,f_lsydz_n1,f_tdzzmj,f_tdzzzb,f_tdzzxmmc,f_tdzzpzwh,f_stxfmj,f_stxfzb,f_stxfxmmc,f_stxfpzwh,f_ckqmj,f_ckqzb,f_ckqxmmc,f_ckqpzwh,f_tkqmj,f_tkqzb,f_tkqxmmc,f_tkqpzwh,f_dkbh,cf,f_dkbs,f_dkmj,f_nydmj_n1,f_gdmj_n1,f_yjjbntmj,f_jsy_n1,f_wlydmj,tbsj,f_jzrq,sfcq,f_sfbgwjsy,f_tbjsqk,f_pdlx,f_hflx,pzwh,f_wflx,f_qtlx,f_yblqthfy,f_fnhwfydl,f_xzfnjswf,f_sdwbhlx,f_clfnjswf,f_pzsj,f_wgjylx,f_flhwfwgy,f_nyssjswf,f_sjfzlgyw,f_wfzdlx,f_wfpzzylx,f_wfgdlx,f_hfydsjyt,f_wfydsjyt,f_sfxzlzgd,f_sfwhzj,f_sfdpf,f_sfyfyhfz,f_sfbzxajz,f_sfjjxm,f_sfgefqc,f_sfwjbs,f_pdyjsm,f_xzwfpdyj,f_xmlx,f_xmmc,f_xmzt,f_lxpzjg,f_lxpzwh,f_clfs,f_labh,f_yjdbm,f_bylalx,f_bylasm,f_zglsqk,f_hftdy_n2,f_fgdwmj,f_ccyjj_n2,f_bbmjm_n1,f_bbgdmj,f_bbjbntmj,bbsxpzwh,f_bbsxlx,xianshjg,xianshyj,xianshsj,xianshry,shishjg,shishyj,shishsj,shishry,f_sjhfxpd,sjpdhfmj,sjpdhfgdmj,sjpdhfjbntmj,sjpdhfejl,sjpdqtmj,sjpdqtgdmj,sjpdqtjbntmj,sjpdqtejl,sjpdqttkbh,sjpdflwfmj,sjpdflwfgdmj,sjpdflwfjbntmj,sjpdflwfejl,sjshwgjymj,sjshwgjygdmj,sjshwgjyjbntmj,sjshwgjyejl,sjpdclwfmj,sjpdclwfgdmj,sjpdclwfjbntmj,sjpdclwfejl,sjpdxzfnmj,sjpdxzfngdmj,sjpdxzfnjbntmj,sjpdxzfnejl,f_sjrdccmj,f_sjrdccgd,f_sjrdccjb,f_sjrdbbmj,f_sjrdbbgd,f_sjrdbbjb,f_sjrdbbpw,f_sjrdyzjm,f_sjrdyzjg,f_sjrdyzjj,f_sjrdyzjx,jdzt,zgmj,zggdmj,zgjbntmj,symj,sygdmj,syjbntmj".split(","));
    }

    public String fieldList() {
        String field = "f_sjxzqdm,f_sjxzqmc,f_xjxzqdm,f_xjxzqmc,f_xzqdm,f_xzqmc,f_jcbh,f_jcpc,f_jcmj_n1,f_xfsj,f_tblx,f_tbfl,f_zlwz,f_ydspmjm,f_ydspzb,f_ydspxmmc,f_tdgymjm,f_tdgyzb,f_tdgyxmmc,f_zjggjxzs,f_zjggj_n1,f_zjggj_n3,f_zjggjxdk,f_zjggj_n2,f_zjggj_n4,f_gkfqdjxm,f_gkfqdjxz,f_gkfqdjxx,f_zjggcjqm,f_zjggcjqz,f_zjggcjqx,f_bdcdjmjm,f_bdcdjzb,f_bdcdjxmm,f_ssnydmj,f_ssnydzb,f_ssnydxm,f_lsydmj,f_lsydzb,f_lsydxmmc,f_gdbhmbmj,f_gdbhmbzb,f_stbhhxmj,f_stbhhxzb,f_czkfbjmj,f_czkfbjzb,f_tdzzmj,f_tdzzzb,f_tdzzxmmc,f_stxfmj,f_stxfzb,f_stxfxmmc,f_ckqmj,f_ckqzb,f_ckqxmmc,f_tkqmj,f_tkqzb,f_tkqxmmc,f_dkbh,'' as cf,f_dkmj,f_nydmj_n1,f_gdmj_n1,f_yjjbntmj,f_jsy_n1,f_wlydmj,f_sfbgwjsy,f_tbjsqk,f_pdlx,f_hflx,f_wflx,f_qtlx,f_yblqthfy,f_fnhwfydl,f_xzfnjswf,f_sdwbhlx,f_clfnjswf,f_pzsj,f_wgjylx,f_flhwfwgy,f_nyssjswf,f_sjfzlgyw,f_wfzdlx,f_wfpzzylx,f_wfgdlx,f_hfydsjyt,f_wfydsjyt,f_sfxzlzgd,f_sfwhzj,f_sfdpf,f_sfyfyhfz,f_sfbzxajz,f_sfjjxm,f_sfgefqc,f_sfwjbs,f_pdyjsm,f_xzwfpdyj,f_xmlx,f_xmmc,f_xmzt,f_lxpzjg,f_lxpzwh,f_clfs,f_labh,f_yjdbm,f_bylalx,f_bylasm,f_zglsqk,f_hftdy_n2,f_fgdwmj,f_ccyjj_n2,f_bbmjm_n1,f_bbgdmj,f_bbjbntmj,f_bbsxlx,f_sjshjl,f_sjshsm,f_sjs_n1,f_sjs_n2,f_sjhfxpdx,f_sjrdhfmj,f_sjrdhfgd,f_sjrdhfjb,f_sjejl,f_sjrdfnwf,f_sjrdf_n1,f_sjrdf_n2,f_sjejl,f_sjrdwgjy,f_sjrdw_n1,f_sjrdw_n2,f_sjejl,f_sjrdflwf,f_sjrdf_n3,f_sjrdf_n4,f_sjejl,f_sjrdqtmj,f_sjrdqtgd,f_sjrdqtjb,f_sjejl,f_sjrdxmmc,f_sjrdyddw,f_sjgsgdrd,f_sjrdccmj,f_sjrdccgd,f_sjrdccjb,f_sjrdbbmj,f_sjrdbbgd,f_sjrdbbjb,f_sjrdbbpw,f_sjrdyzjm,f_sjrdyzjg,f_sjrdyzjj,f_sjrdyzjx,f_sjzgqkpd || ';' || f_sjzgqkpd bz1,coalesce(f_sjrdccmj, 0)+ coalesce(f_sjrdbbmj, 0) mj1,coalesce(f_sjrdccgd, 0)+ coalesce(f_sjrdbbgd, 0) mj2,coalesce(f_sjrdccjb, 0)+ coalesce(f_sjrdbbjb, 0) mj3,coalesce(f_sjrdfnwf, 0)+ coalesce(f_sjrdwgjy, 0)+ coalesce(f_sjrdflwf, 0)-coalesce(f_sjrdccmj, 0)+ coalesce(f_sjrdbbmj, 0) mj4,coalesce(f_sjrdf_n1, 0)+ coalesce(f_sjrdw_n1, 0)+ coalesce(f_sjrdf_n3, 0)-coalesce(f_sjrdccgd, 0)+ coalesce(f_sjrdbbgd, 0) mj5,coalesce(f_sjrdf_n2, 0)+ coalesce(f_sjrdw_n2, 0)+ coalesce(f_sjrdf_n4, 0)-coalesce(f_sjrdccjb, 0)+ coalesce(f_sjrdbbjb, 0) mj6,f_id as id,f_issplitted as f_issplitted  ";
        return field;
    }

    public String fieldList1() {
        String field = "f_sjxzqdm,f_sjxzqmc,f_xjxzqdm,f_xjxzqmc,f_xzqdm,f_xzqmc,f_jcbh,f_jcpc,f_jcmj_n1,f_xfsj,f_tblx,f_tbfl,f_zlwz,f_ydspmjm,f_ydspzb,f_ydspxmmc,f_tdgymjm,f_tdgyzb,f_tdgyxmmc,f_zjggjxzs,f_zjggj_n1,f_zjggj_n3,f_zjggjxdk,f_zjggj_n2,f_zjggj_n4,f_gkfqdjxm,f_gkfqdjxz,f_gkfqdjxx,f_zjggcjqm,f_zjggcjqz,f_zjggcjqx,f_bdcdjmjm,f_bdcdjzb,f_bdcdjxmm,f_ssnydmj,f_ssnydzb,f_ssnydxm,f_lsydmj,f_lsydzb,f_lsydxmmc,f_gdbhmbmj,f_gdbhmbzb,f_stbhhxmj,f_stbhhxzb,f_czkfbjmj,f_czkfbjzb,f_tdzzmj,f_tdzzzb,f_tdzzxmmc,f_stxfmj,f_stxfzb,f_stxfxmmc,f_ckqmj,f_ckqzb,f_ckqxmmc,f_tkqmj,f_tkqzb,f_tkqxmmc,f_dkbh,cf,f_dkmj,f_nydmj_n1,f_gdmj_n1,f_yjjbntmj,f_jsy_n1,f_wlydmj,f_sfbgwjsy,f_tbjsqk,f_pdlx,f_hflx,f_wflx,f_qtlx,f_yblqthfy,f_fnhwfydl,f_xzfnjswf,f_sdwbhlx,f_clfnjswf,f_pzsj,f_wgjylx,f_flhwfwgy,f_nyssjswf,f_sjfzlgyw,f_wfzdlx,f_wfpzzylx,f_wfgdlx,f_hfydsjyt,f_wfydsjyt,f_sfxzlzgd,f_sfwhzj,f_sfdpf,f_sfyfyhfz,f_sfbzxajz,f_sfjjxm,f_sfgefqc,f_sfwjbs,f_pdyjsm,f_xzwfpdyj,f_xmlx,f_xmmc,f_xmzt,f_lxpzjg,f_lxpzwh,f_clfs,f_labh,f_yjdbm,f_bylalx,f_bylasm,f_zglsqk,f_hftdy_n2,f_fgdwmj,f_ccyjj_n2,f_bbmjm_n1,f_bbgdmj,f_bbjbntmj,f_bbsxlx,f_sjshjl,f_sjshsm,f_sjs_n1,f_sjs_n2,f_sjhfxpdx,f_sjrdhfmj,f_sjrdhfgd,f_sjrdhfjb,f_sjejl,f_sjrdfnwf,f_sjrdf_n1,f_sjrdf_n2,f_sjejl,f_sjrdwgjy,f_sjrdw_n1,f_sjrdw_n2,f_sjejl,f_sjrdflwf,f_sjrdf_n3,f_sjrdf_n4,f_sjejl,f_sjrdqtmj,f_sjrdqtgd,f_sjrdqtjb,f_sjejl,f_sjrdxmmc,f_sjrdyddw,f_sjgsgdrd,f_sjrdccmj,f_sjrdccgd,f_sjrdccjb,f_sjrdbbmj,f_sjrdbbgd,f_sjrdbbjb,f_sjrdbbpw,f_sjrdyzjm,f_sjrdyzjg,f_sjrdyzjj,f_sjrdyzjx,bz1,mj1, mj2,mj3,mj4,mj5,mj6";
        return field;
    }

    public void MockRedisRecord(TaskRecord taskRecord) {
        DataDownloadRecord record;
        com.geoway.landteam.customtask.pub.dto.DownloadParameter downloadParameter;
        JSONObject jsonObject;
        String parameter;
        if (taskRecord != null && StringUtils.isNotBlank((CharSequence)(parameter = taskRecord.getParam())) && (jsonObject = JSONObject.parseObject((String)parameter)) != null && (downloadParameter = (com.geoway.landteam.customtask.pub.dto.DownloadParameter)JSONObject.toJavaObject((JSON)jsonObject, com.geoway.landteam.customtask.pub.dto.DownloadParameter.class)) != null && (record = this.dataDownloadRecordService.findeOne(downloadParameter.getRecordId())) != null) {
            record.setBatchOpr(true);
            if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
                this.redisTemplate.delete((Object)record.getId());
            }
            this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)JSONObject.toJSONString((Object)record).toString(), 2L, TimeUnit.DAYS);
        }
    }
}

