/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskNoticeService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;
import com.geoway.landteam.customtask.service.task.thread.TaskAssignThread;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupMemberRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.task.MITaskAssignService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskNoticeService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskSyncService;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTaskAssignServiceImpl
implements MITaskAssignService {
    protected String uploadDir;
    private final GiLoger logger = GwLoger.getLoger(MTaskAssignServiceImpl.class);
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    MTaskNoticeService taskNoticeService;
    @Autowired
    TaskNoticeServiceImpl taskNoticeService1;
    @Autowired
    MTskTaskBizService mtskTaskBizService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    DataBizService dataBizService1;
    @Autowired
    WorkGroupMemberRepository workGroupMemberRepository;
    @Autowired
    MTaskRecordService taskRecordService;
    @Autowired
    TaskRecordService taskRecordService1;
    @Autowired
    MTskTaskSyncService mTskTaskSyncService;
    ExecutorService threadPool = Executors.newFixedThreadPool(20);

    public void assignTask(Long userId, String taskId, JSONArray tbIds, JSONArray groups, JSONArray orgs) {
        String recordId = UUID.randomUUID().toString();
        List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)tbIds), String.class);
        TskTaskBiz tskTaskBiz = this.mtskTaskBizService.getTskTaskBizById(taskId);
        JSONObject additionJson = new JSONObject();
        additionJson.put("count", (Object)tbIds.size());
        additionJson.put("addOrUpdate", (Object)"UPDATE");
        additionJson.put("taskMode", (Object)tskTaskBiz.getMode());
        additionJson.put("curMode", (Object)"assign");
        TaskDataDbParameter parameter = new TaskDataDbParameter();
        parameter.setGroups(groups);
        parameter.setTaskId(taskId);
        parameter.setOrgs(orgs);
        parameter.setUserId(userId);
        parameter.setMode(tskTaskBiz.getMode().toString());
        parameter.setRecordId(recordId);
        parameter.setAddition(additionJson);
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"checkFilter");
        params.put("userId", (Object)userId);
        params.put("TaskDataDbParameter", (Object)parameter);
        params.put("taskId", (Object)taskId);
        TaskRecord record = new TaskRecord();
        record.setId(recordId);
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        this.taskRecordService.save(record);
        ArrayList<TaskRecordTemp> tempList = new ArrayList<TaskRecordTemp>();
        for (int i = 0; i < list.size(); ++i) {
            TaskRecordTemp temp = new TaskRecordTemp();
            temp.setId(UUID.randomUUID().toString());
            temp.setRecordid(recordId);
            temp.setDataid((String)list.get(i));
            tempList.add(temp);
        }
        this.taskRecordService.saveTaskRecordTemp(tempList);
    }

    public void assignTaskByConditionFilter(Long userId, String taskId, JSONArray groups, JSONArray orgs, TaskQueryParameter taskQueryParameter, JSONObject allparams) {
        Date oneHourAgo = new Date(new Date().getTime() - 3600000L);
        int count = this.taskRecordService.findByTypeAndParamAndStarttime(JobConstants.JOB_TYPE_DATA_ASSIGN, JSONObject.toJSONString((Object)allparams), oneHourAgo);
        if (count > 0) {
            throw new GwValidateException("\u6570\u636e\u6b63\u5728\u8fdb\u884c\u4e0b\u53d1\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"conditionFilter");
        params.put("userId", (Object)userId);
        params.put("groups", (Object)groups);
        params.put("orgs", (Object)orgs);
        params.put("taskQueryParameter", (Object)taskQueryParameter);
        params.put("taskId", (Object)taskId);
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setState(Integer.valueOf(1));
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setStarttime(new Date());
        record.setUserid(userId);
        record.setBizId(taskId);
        record.setRemark(JSONObject.toJSONString((Object)allparams));
        this.taskRecordService.save(record);
    }

    public void doAssign(TaskDataDbParameter parameter) {
        if (parameter == null) {
            return;
        }
        TaskRecord one = this.taskRecordService.findOne(parameter.getRecordId());
        this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        TaskAssignThread threadAssign = new TaskAssignThread(this.workGroupMemberRepository, this.tskTaskBizService, (TaskNoticeService)this.taskNoticeService1, this.ossOperatorService, this.dataBizService1, this.taskRecordService1, this.uploadDir, parameter);
        Future<?> future = this.threadPool.submit((Runnable)threadAssign);
        String failReason = null;
        try {
            Object obj = future.get(60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            failReason = "\u4e3b\u7ebf\u7a0b\u5728\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u4e2d\u65ad\uff01";
            one.setState(Integer.valueOf(4));
            one.setRemark(failReason);
            this.taskRecordService.save(one);
        }
        catch (ExecutionException e) {
            failReason = "\u4e3b\u7ebf\u7a0b\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\uff0c\u4f46\u4efb\u52a1\u672c\u8eab\u629b\u51fa\u5f02\u5e38\uff01";
            one.setState(Integer.valueOf(4));
            one.setRemark(failReason);
            this.taskRecordService.save(one);
        }
        catch (TimeoutException e) {
            failReason = "\u4e3b\u7ebf\u7a0b\u7b49\u5f85\u8ba1\u7b97\u7ed3\u679c\u8d85\u65f6\uff0c\u56e0\u6b64\u4e2d\u65ad\u4efb\u52a1\u7ebf\u7a0b\uff01";
            one.setState(Integer.valueOf(4));
            one.setRemark(failReason);
            this.taskRecordService.save(one);
        }
    }

    public Map<String, Object> queryAssignUserRecord(String taskId, String dataId, int page, int rows) {
        if (StringUtils.isBlank((CharSequence)taskId) || StringUtils.isBlank((CharSequence)dataId)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        return this.taskRecordService.queryAssignUserRecord(taskId, dataId, page, rows);
    }

    public Map<String, Object> getAssignRecordList(String taskId, String dataId, int page, int rows) {
        if (StringUtils.isBlank((CharSequence)taskId) || StringUtils.isBlank((CharSequence)dataId)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        return this.taskRecordService.getAssignRecordList(taskId, dataId, page, rows);
    }
}

