/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;
import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskAttachTransformService;
import com.geoway.landteam.landcloud.service.base.impl.AppBasicServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskTransMediaService;
import com.gw.base.Gw;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTaskAttachTransTakeHandImpl
implements MTaskAttachTransformService {
    @Autowired
    AppBasicServiceImpl appBasicService;
    @Autowired
    MTaskTransMediaService taskTransMediaService;
    private final GiLoger logger = GwLoger.getLoger(MTaskAttachTransTakeHandImpl.class);

    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, JSONArray mediaArrary, String xzqdm, String tbid) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            String token = request.getSession().getAttribute("access_token").toString();
            if (this.appBasicService.exist(tbid)) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(tbid);
                List<AppBasic> basicList = this.appBasicService.getBasicListByIds(ids, userId);
                if (basicList != null && basicList.size() > 0 && mediaArrary != null && mediaArrary.size() > 0) {
                    ArrayList<TaskTransformMedia> mediaList = new ArrayList<TaskTransformMedia>();
                    for (Object jsonObj : mediaArrary) {
                        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(jsonObj));
                        if (jsonObject == null) continue;
                        TaskTransformMedia media = ((TaskTransMediaService)Gw.beans.getBean(TaskTransMediaService.class)).convertTaskTransMediaFromJson(jsonObject);
                        media.setAttachId(UUID.randomUUID().toString());
                        mediaList.add(media);
                    }
                    this.taskTransMediaService.saveAttach(userId, tbid, basicList.get(0).getShape(), mediaList, token);
                }
                baseResponse.setStatus("OK");
                baseResponse.setMessage("\u8f6c\u6362\u6210\u529f!");
            } else {
                baseResponse.setStatus("FAILURE");
                baseResponse.setMessage("\u76ee\u6807\u9879\u76ee\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Throwable)e);
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
        }
        return baseResponse;
    }
}

