/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;
import com.geoway.landteam.customtask.service.task.thread.TaskRecieveThread;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.task.MITaskRecieveService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTaskRecieveServiceImpl
implements MITaskRecieveService {
    protected String uploadDir;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TaskNoticeServiceImpl taskNoticeService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TaskRecordService taskRecordService;
    ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private final GiLoger logger = GwLoger.getLoger(MTaskRecieveServiceImpl.class);

    public void recieveTask(Long userId, String taskId, JSONArray tbIds, JSONArray groups) {
        List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)tbIds), String.class);
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.getTskTaskBizById(taskId);
        JSONObject additionJson = new JSONObject();
        additionJson.put("count", (Object)tbIds.size());
        if (Objects.equals(tskTaskBiz.getMode(), 1)) {
            additionJson.put("addOrUpdate", (Object)"ADD");
        } else if (Objects.equals(tskTaskBiz.getMode(), 2)) {
            additionJson.put("addOrUpdate", (Object)"UPDATE");
        }
        additionJson.put("taskMode", (Object)tskTaskBiz.getMode());
        additionJson.put("curMode", (Object)"assign");
        String recordId = UUID.randomUUID().toString();
        TaskDataDbParameter parameter = new TaskDataDbParameter();
        parameter.setGroups(groups);
        parameter.setTaskId(taskId);
        parameter.setUserId(userId);
        parameter.setAddition(additionJson);
        parameter.setMode(tskTaskBiz.getMode().toString());
        parameter.setRecordId(recordId);
        JSONObject params = new JSONObject();
        params.put("filterType", (Object)"checkFilter");
        params.put("userId", (Object)userId);
        params.put("TaskDataDbParameter", (Object)parameter);
        params.put("taskId", (Object)taskId);
        TaskRecord record = new TaskRecord();
        record.setId(recordId);
        record.setParam(JSONObject.toJSONString((Object)params));
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setStarttime(new Date());
        record.setState(Integer.valueOf(1));
        record.setUserid(userId);
        this.taskRecordService.save(record);
        ArrayList<TaskRecordTemp> tempList = new ArrayList<TaskRecordTemp>();
        for (int i = 0; i < list.size(); ++i) {
            TaskRecordTemp temp = new TaskRecordTemp();
            temp.setId(UUID.randomUUID().toString());
            temp.setRecordid(recordId);
            temp.setDataid((String)list.get(i));
            tempList.add(temp);
        }
        this.taskRecordService.saveTaskRecordTemp(tempList);
    }

    public void doRecieve(TaskDataDbParameter parameter) {
        if (parameter == null) {
            return;
        }
        TaskRecord one = this.taskRecordService.findOne(parameter.getRecordId());
        this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        TaskRecieveThread threadRecieve = new TaskRecieveThread(this.tskTaskBizService, this.taskNoticeService, this.ossOperatorService, this.dataBizService, this.uploadDir, parameter, this.taskRecordService);
        Future<?> future = this.threadPool.submit((Runnable)threadRecieve);
        String failReason = null;
        try {
            Object obj = future.get(60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            failReason = "\u4e3b\u7ebf\u7a0b\u5728\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u4e2d\u65ad\uff01";
            one.setState(Integer.valueOf(4));
            one.setRemark(failReason);
            this.taskRecordService.save(one);
        }
        catch (ExecutionException e) {
            failReason = "\u4e3b\u7ebf\u7a0b\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\uff0c\u4f46\u4efb\u52a1\u672c\u8eab\u629b\u51fa\u5f02\u5e38\uff01";
            one.setState(Integer.valueOf(4));
            one.setRemark(failReason);
            this.taskRecordService.save(one);
        }
        catch (TimeoutException e) {
            failReason = "\u4e3b\u7ebf\u7a0b\u7b49\u5f85\u8ba1\u7b97\u7ed3\u679c\u8d85\u65f6\uff0c\u56e0\u6b64\u4e2d\u65ad\u4efb\u52a1\u7ebf\u7a0b\uff01";
            one.setState(Integer.valueOf(4));
            one.setRemark(failReason);
            this.taskRecordService.save(one);
        }
    }
}

