/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformData;
import com.geoway.landteam.customtask.service.pub.ProxyService;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskTransformService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTaskTransOtherImpl
implements MTaskTransformService {
    private final GiLoger logger = GwLoger.getLoger(MTaskTransOtherImpl.class);
    @Autowired
    ProxyService proxyService;

    public boolean checkData(List<TaskTransformData> tbDataList, Map<String, List<String>> errorInfo) {
        return true;
    }

    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, List<TaskTransformData> tbDataList, String xzqdm) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            HashMap<String, List<String>> errorInfo = new HashMap<String, List<String>>();
            if (this.checkData(tbDataList, errorInfo)) {
                String thirdTokenStr = "";
                Object third_token = request.getSession().getAttribute("third_auth");
                thirdTokenStr = third_token == null ? this.proxyService.getThirdToken(request) : (String)third_token;
                Map<String, Object> param = this.getPostParameter(request, userId, sourceTaskCode, sourceTaskName, targetTaskCode, targetTaskName, tbDataList, xzqdm);
                String paramStr = JSONObject.toJSONString(param);
                String url = this.proxyService.thirdHost + "/webapi/gtdcyv2/tasktransform";
                HttpRequest post = HttpUtil.createPost((String)url).contentType("application/json");
                post.header("Authorization", thirdTokenStr);
                post.body(paramStr);
                HttpResponse execute = post.execute();
                if (execute.getStatus() == 200) {
                    JSONObject body = JSONObject.parseObject((String)execute.body());
                    if (body != null) {
                        if (body.containsKey((Object)"code") && body.get((Object)"code").toString().equalsIgnoreCase("500")) {
                            throw new RuntimeException("\u7b2c\u4e09\u65b9\u63a5\u53e3tasktransform\u8bf7\u6c42\u9519\u8bef,\u72b6\u6001\u7801\uff1a500");
                        }
                        Object data = body.get((Object)"data");
                        if (data != null) {
                            baseResponse.setStatus("OK");
                            if (data.toString().equalsIgnoreCase("success")) {
                                data = "\u8f6c\u6362\u6210\u529f";
                            }
                            baseResponse.setMessage(data.toString());
                        }
                    }
                } else {
                    JSONObject body = JSONObject.parseObject((String)execute.body());
                    baseResponse.setStatus("FAILURE");
                    baseResponse.setMessage(body.get((Object)"error").toString());
                }
            } else {
                StringBuilder sb = new StringBuilder();
                if (!errorInfo.isEmpty()) {
                    for (String key : errorInfo.keySet()) {
                        sb.append(errorInfo.get(key));
                        sb.append(";");
                    }
                }
                baseResponse.setStatus("FAILURE");
                baseResponse.setMessage(sb.toString());
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
        }
        return baseResponse;
    }

    private Map<String, Object> getPostParameter(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, List<TaskTransformData> tbDataList, String xzqdm) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("srcTaskCode", sourceTaskCode);
        param.put("srcTaskName", sourceTaskName);
        if (StringUtils.isNotBlank((CharSequence)xzqdm)) {
            if (xzqdm.equalsIgnoreCase("1")) {
                param.put("xzqdm", "000000");
            } else {
                param.put("xzqdm", xzqdm);
            }
        } else {
            param.put("xzqdm", "");
        }
        param.put("tagtTaskCode", targetTaskCode);
        param.put("tagtTaskName", targetTaskName);
        JSONArray jsonArray = this.convertTbDataListToJsonArray(request, userId, tbDataList, xzqdm);
        param.put("datas", jsonArray);
        return param;
    }

    private JSONArray convertTbDataListToJsonArray(HttpServletRequest request, long userId, List<TaskTransformData> tbDataList, String xzqdm) {
        JSONArray jsonArray = new JSONArray();
        if (tbDataList != null && tbDataList.size() > 0) {
            for (TaskTransformData transformData : tbDataList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("tbId", (Object)transformData.getTbId());
                jsonObject.put("prjNum", (Object)transformData.getPrjNum());
                jsonObject.put("prjName", (Object)transformData.getPrjName());
                if (StringUtils.isBlank((CharSequence)transformData.getRegionCode())) {
                    if (StringUtils.isNotBlank((CharSequence)xzqdm)) {
                        if (xzqdm.equalsIgnoreCase("1")) {
                            jsonObject.put("regionCode", (Object)"000000");
                        } else {
                            jsonObject.put("regionCode", (Object)xzqdm);
                        }
                    } else {
                        jsonObject.put("regionCode", (Object)"");
                    }
                } else if (transformData.getRegionCode().equalsIgnoreCase("1")) {
                    jsonObject.put("regionCode", (Object)"000000");
                } else {
                    jsonObject.put("regionCode", (Object)transformData.getRegionCode());
                }
                jsonObject.put("extent", (Object)transformData.getExtent());
                jsonObject.put("md5", (Object)transformData.getMd5());
                jsonObject.put("medias", (Object)transformData.getMedias());
                jsonArray.add((Object)jsonObject);
            }
        }
        return jsonArray;
    }
}

