/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformData;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;
import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskTransformService;
import com.geoway.landteam.landcloud.service.base.impl.AppBasicServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskTransMediaService;
import com.gw.base.Gw;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTaskTransTakeHandImpl
implements MTaskTransformService {
    @Autowired
    AppBasicServiceImpl appBasicService;
    @Autowired
    MTaskTransMediaService taskTransMediaService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    RegionService regionService;
    private final GiLoger logger = GwLoger.getLoger(MTaskTransTakeHandImpl.class);

    public boolean checkData(List<TaskTransformData> tbDataList, Map<String, List<String>> errorInfo) {
        return true;
    }

    private boolean checkFieldAndValue(JSONObject jsonObject, String fieldName) {
        return jsonObject.containsKey((Object)fieldName) && !StringUtils.isBlank((CharSequence)jsonObject.get((Object)fieldName).toString());
    }

    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, List<TaskTransformData> tbDataList, String xzqdm) {
        BaseObjectResponse baseResponse;
        block19: {
            baseResponse = new BaseObjectResponse();
            try {
                String token = request.getSession().getAttribute("access_token").toString();
                HashMap<String, List<String>> errorInfo = new HashMap<String, List<String>>();
                if (this.checkData(tbDataList, errorInfo)) {
                    if (tbDataList != null && tbDataList.size() > 0) {
                        for (TaskTransformData tbData : tbDataList) {
                            JSONArray jsonArray;
                            AppBasic appBasic = new AppBasic();
                            String uuid = UUID.randomUUID().toString();
                            String tbId = "";
                            tbId = uuid;
                            appBasic.setId(tbId);
                            appBasic.setUserid(String.valueOf(userId));
                            appBasic.setHeading(tbData.getTbName());
                            appBasic.setCreatetime(String.valueOf(System.currentTimeMillis()));
                            appBasic.setTime(new Date());
                            appBasic.setIsDeleted(Integer.valueOf(0));
                            if (StringUtils.isNotBlank((CharSequence)tbData.getRegionCode())) {
                                if (tbData.getRegionCode().equalsIgnoreCase("000000")) {
                                    appBasic.setRegion("1");
                                } else {
                                    appBasic.setRegion(tbData.getRegionCode());
                                }
                            } else {
                                appBasic.setRegion("");
                            }
                            appBasic.setShape(tbData.getExtent());
                            try {
                                String regionName = this.getRegionNameByExtent(tbData.getExtent());
                                if (StringUtils.isNotBlank((CharSequence)regionName)) {
                                    appBasic.setName(regionName);
                                }
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            appBasic.setRequestId(tbData.getRequestId());
                            appBasic.setOri("909");
                            appBasic.setType("");
                            appBasic.setMj(Double.valueOf(tbData.getTbmj()));
                            String userName = this.userNameService.getUserNameByUserId(String.valueOf(userId));
                            if (StringUtils.isNotBlank((CharSequence)userName)) {
                                appBasic.setUsername(userName);
                            }
                            if ((jsonArray = tbData.getMedias()) != null && jsonArray.size() > 0) {
                                ArrayList<TaskTransformMedia> mediaList = new ArrayList<TaskTransformMedia>();
                                for (Object obj : jsonArray) {
                                    JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(obj));
                                    if (jsonObject == null) continue;
                                    TaskTransformMedia media = ((TaskTransMediaService)Gw.beans.getBean(TaskTransMediaService.class)).convertTaskTransMediaFromJson(jsonObject);
                                    media.setAttachId(UUID.randomUUID().toString());
                                    mediaList.add(media);
                                }
                                this.taskTransMediaService.saveAttach(userId, tbId, appBasic.getShape(), mediaList, token);
                            }
                            this.appBasicService.save(appBasic);
                            try {
                                this.appBasicService.updateLonLatById(appBasic.getId());
                            }
                            catch (Exception e) {
                                this.logger.error("\u4efb\u52a1\u8f6c\u6362-\u8f6c\u6210\u968f\u624b\u62cd\u540e\uff0c\u6839\u636eshape\u66f4\u65b0\u968f\u624b\u62cd\u7684\u4e2d\u5fc3\u70b9\u5750\u6807\u62a5\u9519", new Object[0]);
                                this.logger.error((Throwable)e);
                            }
                        }
                    }
                    baseResponse.setStatus("OK");
                    baseResponse.setMessage("\u8f6c\u6362\u6210\u529f!");
                    break block19;
                }
                StringBuilder sb = new StringBuilder();
                if (!errorInfo.isEmpty()) {
                    for (String key : errorInfo.keySet()) {
                        sb.append(errorInfo.get(key));
                        sb.append(";");
                    }
                }
                baseResponse.setStatus("FAILURE");
                baseResponse.setMessage(sb.toString());
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
                baseResponse.setStatus("FAILURE");
                baseResponse.setMessage(e.getMessage());
            }
        }
        return baseResponse;
    }

    private String getRegionNameByExtent(String extent) throws Exception {
        if (StringUtils.isBlank((CharSequence)extent)) {
            return "";
        }
        Geometry geometry = WKTUtil.wktToGeom((String)extent);
        if (geometry != null && geometry.getCentroid() != null) {
            Point centroid = geometry.getCentroid();
            String wkt = "POINT(" + centroid.getX() + " " + centroid.getY() + ")";
            RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
            if (region == null) {
                region = this.regionService.queryRegionByGeom(wkt, 4490, 2);
            }
            if (region == null) {
                region = this.regionService.queryRegionByGeom(wkt, 4490, 2, 2000.0);
            }
            if (region != null) {
                String name = region.getName();
                RegionVillage village = this.regionService.queryVillageCotain(wkt, 0);
                if (village != null) {
                    name = name + village.getName();
                }
                return name;
            }
        }
        return "";
    }
}

