/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TbtskUserTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TbtskUserTaskClass;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskTaskClassService;
import com.gw.base.util.GutilStr;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MTbtskTaskClassServiceImpl
implements MTbtskTaskClassService {
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    RegionService regionService;

    public TbtskTaskClass trees(Long parentId) {
        TbtskTaskClass tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(parentId);
        if (tbtskTaskClass != null) {
            List tbtskTaskClasses = this.tbtskTaskClassRepository.queryByParentId(parentId);
            tbtskTaskClasses.forEach(this::completeChildren);
            tbtskTaskClass.setChildren(tbtskTaskClasses);
        }
        return tbtskTaskClass;
    }

    public TbtskTaskClass getTopParent(Long classId) {
        TbtskTaskClass tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(classId);
        if (tbtskTaskClass.getLevel() > 1L) {
            return this.completeParentClass(tbtskTaskClass.getParentId());
        }
        return tbtskTaskClass;
    }

    public List<TbtskTaskClass> treesNew(String branch, String appsId, Long userId) {
        SysConfig sysConfig;
        List<TbtskTaskClass> lists = new ArrayList();
        lists = branch != null ? ((sysConfig = this.sysConfigService.findOne(branch)) != null ? this.tbtskTaskClassRepository.queryByParentIdAndAppkey(Long.valueOf(-1L), sysConfig.getValue()) : (userId != null ? ("XCYW".equals(branch) ? this.tbtskTaskClassRepository.queryByParentIdAndAppkeyAndUserId(Long.valueOf(-1L), branch, userId) : this.tbtskTaskClassRepository.queryByParentIdNOTXCYWAndUserId(Long.valueOf(-1L), userId)) : ("XCYW".equals(branch) ? this.tbtskTaskClassRepository.queryByParentIdAndAppkey(Long.valueOf(-1L), branch) : this.tbtskTaskClassRepository.queryByParentIdNOTXCYW(Long.valueOf(-1L))))) : (StringUtils.isNotBlank((CharSequence)appsId) ? (userId != null ? this.tbtskTaskClassRepository.queryByParentIdAndAppkeyAndUserId(Long.valueOf(-1L), appsId, userId) : this.tbtskTaskClassRepository.queryByParentIdAndAppkey(Long.valueOf(-1L), appsId)) : this.tbtskTaskClassRepository.queryByParentId(Long.valueOf(-1L)));
        for (TbtskTaskClass tbtskTaskClass : lists) {
            List tbtskTaskClasses = this.tbtskTaskClassRepository.queryByParentId(tbtskTaskClass.getId());
            tbtskTaskClasses.forEach(this::completeChildren);
            if (tbtskTaskClasses.size() > 0) {
                tbtskTaskClass.setChildren(tbtskTaskClasses);
                continue;
            }
            tbtskTaskClass.setChildren(null);
        }
        return lists;
    }

    public List<TbtskTaskClass> getTaskClassStatistical(String branch) {
        SysConfig sysConfig;
        List<TbtskTaskClass> lists = new ArrayList();
        lists = branch != null ? ((sysConfig = this.sysConfigService.findOne(branch)) != null ? this.tbtskTaskClassRepository.queryByParentIdAndAppkey(Long.valueOf(-1L), sysConfig.getValue()) : ("XCYW".equals(branch) ? this.tbtskTaskClassRepository.queryByParentIdAndAppkey(Long.valueOf(-1L), branch) : this.tbtskTaskClassRepository.queryByParentIdNOTXCYW(Long.valueOf(-1L)))) : this.tbtskTaskClassRepository.queryByParentId(Long.valueOf(-1L));
        for (TbtskTaskClass tbtskTaskClass : lists) {
            ArrayList<Long> classIds = new ArrayList<Long>();
            classIds.add(tbtskTaskClass.getId());
            List tbtskTaskClasses = this.tbtskTaskClassRepository.queryClassIdByParentId(tbtskTaskClass.getId());
            for (Long id : tbtskTaskClasses) {
                this.queryClassIdByParentId(id, tbtskTaskClasses);
            }
            if (tbtskTaskClasses.size() > 0) {
                classIds.addAll(tbtskTaskClasses);
            }
            if (classIds.size() > 0) {
                String countsql = "select count(1) from tb_app_media media,tbtsk_task_biz biz where biz.f_id = media.f_bizid and biz.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ")";
                Integer count = (Integer)this.jdbcTemplate.queryForObject(countsql, Integer.class);
                tbtskTaskClass.setPhotoNum(count);
                continue;
            }
            tbtskTaskClass.setPhotoNum(Integer.valueOf(0));
        }
        return lists;
    }

    public void queryClassIdByParentId(Long classId, List<Long> classIds) {
        List tbtskTaskClasses = this.tbtskTaskClassRepository.queryClassIdByParentId(classId);
        for (Long id : tbtskTaskClasses) {
            this.queryClassIdByParentId(id, classIds);
        }
        if (tbtskTaskClasses.size() > 0) {
            classIds.addAll(tbtskTaskClasses);
        }
    }

    public TbtskTaskClass getParentTbtskTaskClass(Long classId) {
        TbtskTaskClass tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(classId);
        if (tbtskTaskClass != null && tbtskTaskClass.getParentId() != -1L) {
            tbtskTaskClass = this.getParentTbtskTaskClass(tbtskTaskClass.getParentId());
        }
        return tbtskTaskClass;
    }

    public TbtskTaskClass containTaskTrees(Long parentId, Long userId) {
        TbtskTaskClass tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(parentId);
        List<TskTaskBiz> taskBizs = this.distinct(this.tskTaskBizRepository.getBizListsByTypeAndUserId(parentId, userId));
        List tbtskTaskClasses = this.tbtskTaskClassRepository.queryByParentId(parentId);
        tbtskTaskClasses.forEach(e -> this.completeChildren((TbtskTaskClass)e, userId));
        tbtskTaskClass.setChildren(tbtskTaskClasses);
        tbtskTaskClass.setTaskBizs(taskBizs);
        return tbtskTaskClass;
    }

    public List<TskTaskBiz> distinct(List<TskTaskBiz> deviceTracks) {
        HashSet<TskTaskBiz> set = new HashSet<TskTaskBiz>();
        ArrayList<TskTaskBiz> doubleList = new ArrayList<TskTaskBiz>();
        set.addAll(deviceTracks);
        doubleList.addAll(set);
        return doubleList;
    }

    private void completeChildren(TbtskTaskClass tbtskTaskClass) {
        List tbtskTaskClasses = this.tbtskTaskClassRepository.queryByParentId(tbtskTaskClass.getId());
        tbtskTaskClasses.forEach(this::completeChildren);
        tbtskTaskClass.setChildren(tbtskTaskClasses);
    }

    private TbtskTaskClass completeParentClass(Long classId) {
        TbtskTaskClass tbtskTaskClass = this.tbtskTaskClassRepository.queryByFId(classId);
        if (tbtskTaskClass.getLevel() > 1L) {
            return this.completeParentClass(tbtskTaskClass.getParentId());
        }
        return tbtskTaskClass;
    }

    private void completeChildren(TbtskTaskClass tbtskTaskClass, Long userId) {
        List tbtskTaskClasses = this.tbtskTaskClassRepository.queryByParentId(tbtskTaskClass.getId());
        List<TskTaskBiz> taskBizs = this.distinct(this.tskTaskBizRepository.getBizListsByTypeAndUserId(tbtskTaskClass.getId(), userId));
        tbtskTaskClasses.forEach(e -> this.completeChildren((TbtskTaskClass)e, userId));
        tbtskTaskClass.setChildren(tbtskTaskClasses);
        tbtskTaskClass.setTaskBizs(taskBizs);
    }

    public Object getTaskStatistical(Integer type, String keyWord) {
        String sql;
        TbtskObjectinfo tableInfo;
        TskTaskBiz taskBiz;
        List resultMaps = new ArrayList();
        if (type == 1) {
            ArrayList<Long> classIds = new ArrayList<Long>();
            classIds.add(Long.valueOf(keyWord));
            List tbtskTaskClasses = this.tbtskTaskClassRepository.queryClassIdByParentId(Long.valueOf(keyWord));
            for (Long id : tbtskTaskClasses) {
                this.queryClassIdByParentId(id, tbtskTaskClasses);
            }
            if (tbtskTaskClasses.size() > 0) {
                classIds.addAll(tbtskTaskClasses);
            }
            String sql2 = "select biz.f_id taskid,biz.f_name taskname, count(1)-1 count from tbtsk_task_biz biz left join tb_app_media media on(biz.f_id = media.f_bizid) where   biz.f_classid in (" + GutilStr.join(classIds, (CharSequence)",") + ") GROUP BY biz.f_id,biz.f_name;";
            resultMaps = this.jdbcTemplate.queryForList(sql2);
        } else if (type == 2 && (taskBiz = (TskTaskBiz)this.tskTaskBizRepository.findById((Object)keyWord).orElse(null)).getTableId() != null && (tableInfo = this.tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId())) != null && tableInfo.getfTablename() != null && (resultMaps = this.jdbcTemplate.queryForList(sql = "select  substring(tb.f_xzqdmsys,0,5) xzqdm,count(1) from " + tableInfo.getfTablename() + " tb , tb_app_media media where tb.f_id = media.f_galleryid  group by substring(tb.f_xzqdmsys,0,5)")).size() > 0) {
            for (Map map : resultMaps) {
                String xzqdm = map.get("xzqdm").toString().length() < 6 ? map.get("xzqdm").toString() + "00" : map.get("xzqdm").toString();
                map.put("xzqdm", xzqdm);
                String allFullName = this.regionService.getName(xzqdm);
                map.put("xzqdmName", allFullName);
            }
        }
        return resultMaps;
    }

    public List<TbtskTaskClass> getTbtskTaskClassByName(String name, Long parentId) {
        return this.tbtskTaskClassRepository.queryByName(name, parentId);
    }

    public TbtskTaskClass findById(Long id) {
        return this.tbtskTaskClassRepository.queryByFId(id);
    }

    public TbtskTaskClass save(TbtskTaskClass bean) {
        TbtskTaskClass save = (TbtskTaskClass)this.tbtskTaskClassRepository.save((Object)bean);
        TbtskUserTaskClass tbtskUserTaskClass = new TbtskUserTaskClass();
        tbtskUserTaskClass.setCreateDate(new Date());
        tbtskUserTaskClass.setUserId(save.getUserId());
        tbtskUserTaskClass.setClassId(save.getId());
        this.tbtskUserTaskClassRepository.save((Object)tbtskUserTaskClass);
        return save;
    }

    public List<TbtskTaskClass> queryAll() {
        return this.tbtskTaskClassRepository.findAll((Specification)new QuerySpecification(""));
    }

    public List<TbtskTaskClass> getTaskClassTree() {
        List findAll = this.tbtskTaskClassRepository.findAll(QueryParamUtil.parseSortParams((String)"SORT_id_ASC"));
        List<TbtskTaskClass> collect = findAll.stream().filter(map -> "-1".equals(map.getParentId().toString())).collect(Collectors.toList());
        for (int i = 0; i < collect.size(); ++i) {
            this.completeChildren(collect.get(i), findAll);
        }
        return collect;
    }

    public List<TbtskTaskClass> getAllChildrenByParentId(Long classId, List<TbtskTaskClass> result) {
        TbtskTaskClass tbtskTaskClass1 = this.tbtskTaskClassRepository.queryByFId(classId);
        List tbtskTaskClasses = this.tbtskTaskClassRepository.queryByParentId(classId);
        if (result == null) {
            result = new ArrayList<TbtskTaskClass>();
            result.add(tbtskTaskClass1);
        }
        if (!tbtskTaskClasses.isEmpty()) {
            result.addAll(tbtskTaskClasses);
            for (TbtskTaskClass tbtskTaskClass : tbtskTaskClasses) {
                this.getAllChildrenByParentId(tbtskTaskClass.getId(), result);
            }
        }
        return result;
    }

    private void completeChildren(TbtskTaskClass tbtskTaskClass, List<TbtskTaskClass> findAll) {
        List children = findAll.stream().filter(map -> tbtskTaskClass.getId().equals(map.getParentId())).collect(Collectors.toList());
        if (children.size() > 0) {
            tbtskTaskClass.setChildren(children);
            for (int i = 0; i < children.size(); ++i) {
                this.completeChildren((TbtskTaskClass)children.get(i), findAll);
            }
        }
    }
}

