/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.geoway.landteam.customtask.mapper.task.TbtskUserAuditAreaMapper;
import com.geoway.landteam.customtask.task.entity.TbtskUserAuditArea;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserAuditAreaService;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTbtskUserAuditAreaServiceImpl
implements MTbtskUserAuditAreaService {
    @Autowired
    private TbtskUserAuditAreaMapper tbtskUserAuditAreaMapper;
    @Autowired
    private RegionService regionService;

    public int deleteByPrimaryKey(Long id) {
        return this.tbtskUserAuditAreaMapper.deleteByPrimaryKey((Object)id);
    }

    public int deleteByTaskIdAndUserId(String taskId, String userId) {
        return this.tbtskUserAuditAreaMapper.deleteByTaskIdAndUserId(taskId, userId);
    }

    public int deleteByTaskId(String taskId) {
        return this.tbtskUserAuditAreaMapper.deleteByTaskId(taskId);
    }

    public int insert(TbtskUserAuditArea record) {
        return this.tbtskUserAuditAreaMapper.insert((Object)record);
    }

    public int insertSelective(TbtskUserAuditArea record) {
        return this.tbtskUserAuditAreaMapper.insertSelective((Object)record);
    }

    public TbtskUserAuditArea selectByPrimaryKey(Long id) {
        return (TbtskUserAuditArea)this.tbtskUserAuditAreaMapper.selectByPrimaryKey((Object)id);
    }

    public int updateByPrimaryKeySelective(TbtskUserAuditArea record) {
        return this.tbtskUserAuditAreaMapper.updateByPrimaryKeySelective((Object)record);
    }

    public int updateByPrimaryKey(TbtskUserAuditArea record) {
        return this.tbtskUserAuditAreaMapper.updateByPrimaryKey((Object)record);
    }

    public int updateByTaskIdAndUserId(String taskId, String userId, String regions, String version) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for (String s : tempRegionList) {
            List list = this.tbtskUserAuditAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            if (list.size() > 0) continue;
            TbtskUserAuditArea tbtskUserAuditArea = new TbtskUserAuditArea();
            tbtskUserAuditArea.setLevel(Short.valueOf(this.regionService.getRegionLevel(s, version).shortValue()));
            tbtskUserAuditArea.setRegionCode(s);
            tbtskUserAuditArea.setTaskId(taskId);
            tbtskUserAuditArea.setUserId(userId);
            this.tbtskUserAuditAreaMapper.insertSelective((Object)tbtskUserAuditArea);
        }
        return tempRegionList.size();
    }

    public int delByTaskIdAndUserId(String taskId, String userId, String regions) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for (String s : tempRegionList) {
            List list = this.tbtskUserAuditAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            list.forEach(a -> this.tbtskUserAuditAreaMapper.deleteByPrimaryKey((Object)a.getId()));
        }
        return tempRegionList.size();
    }

    public List<TbtskUserAuditArea> listAuditAreas(String taskId, String userId, Short level) {
        return this.tbtskUserAuditAreaMapper.listAuditAreas(taskId, userId, level);
    }

    public List<TbtskUserAuditArea> listAuditAreas(String taskId, String userId) {
        return this.tbtskUserAuditAreaMapper.queryByTaskIdAndUserId(taskId, userId);
    }

    public List<TbtskUserAuditArea> queryListByTaskId(String taskId) {
        return this.tbtskUserAuditAreaMapper.queryListByTaskId(taskId);
    }

    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userList) {
        List list = this.tbtskUserAuditAreaMapper.queryByTaskIdAndUserIds(sourceTaskId, userList);
        if (!list.isEmpty()) {
            for (TbtskUserAuditArea bean : list) {
                bean.setId(null);
                bean.setTaskId(targetTaskId);
                List tbtskUserAuditAreas = this.tbtskUserAuditAreaMapper.queryByTaskIdAndUserIdAndRegioncode(targetTaskId, bean.getUserId(), bean.getRegionCode());
                if (!tbtskUserAuditAreas.isEmpty()) continue;
                this.tbtskUserAuditAreaMapper.insertSelective((Object)bean);
            }
        }
    }
}

